/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewCRUDService;
import com.dataiku.dip.agentreview.AgentReviewCreateTestsFromDatasetRequest;
import com.dataiku.dip.agentreview.AgentReviewCreateTestsFromDatasetResult;
import com.dataiku.dip.agentreview.AgentReviewExportTestsToDatasetRequest;
import com.dataiku.dip.agentreview.AgentReviewExportTestsToDatasetResult;
import com.dataiku.dip.agentreview.AgentReviewHumanReview;
import com.dataiku.dip.agentreview.AgentReviewPrivileges;
import com.dataiku.dip.agentreview.AgentReviewRawExecutionResult;
import com.dataiku.dip.agentreview.AgentReviewResult;
import com.dataiku.dip.agentreview.AgentReviewResultOverview;
import com.dataiku.dip.agentreview.AgentReviewRun;
import com.dataiku.dip.agentreview.AgentReviewRunHistoryItem;
import com.dataiku.dip.agentreview.AgentReviewService;
import com.dataiku.dip.agentreview.AgentReviewTest;
import com.dataiku.dip.agentreview.AgentReviewTrait;
import com.dataiku.dip.agentreview.AgentReviewTraitOverride;
import com.dataiku.dip.agentreview.ExpectationsResult;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.j2ts.annotations.UIModel;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AgentReviewController
extends DIPInternalControllerBase {
    private final TransactionService transactionService;
    private final PermissionsService permissionsService;
    private final UIAuthService authService;
    private final ProjectsService projectsService;
    private final AgentReviewService agentReviewService;
    private final AgentReviewCRUDService agentReviewCRUDService;
    private final AuditTrailService auditTrailService;
    private final TaggableObjectsService taggableObjectsService;
    private final InterestsService interestsService;
    private final NavigatorService navigatorService;
    private final LicenseEnforcementService licenseEnforcementService;
    private final SavedModelsCRUDService savedModelsCRUDService;

    public AgentReviewController(TransactionService transactionService, PermissionsService permissionsService, UIAuthService authService, ProjectsService projectsService, AgentReviewService agentReviewService, AgentReviewCRUDService agentReviewCRUDService, AuditTrailService auditTrailService, TaggableObjectsService taggableObjectsService, InterestsService interestsService, NavigatorService navigatorService, LicenseEnforcementService licenseEnforcementService, SavedModelsCRUDService savedModelsCRUDService) {
        this.transactionService = transactionService;
        this.permissionsService = permissionsService;
        this.authService = authService;
        this.projectsService = projectsService;
        this.agentReviewService = agentReviewService;
        this.agentReviewCRUDService = agentReviewCRUDService;
        this.auditTrailService = auditTrailService;
        this.taggableObjectsService = taggableObjectsService;
        this.interestsService = interestsService;
        this.navigatorService = navigatorService;
        this.licenseEnforcementService = licenseEnforcementService;
        this.savedModelsCRUDService = savedModelsCRUDService;
    }

    @AuditInline
    @RequestMapping(value={"/api/agent-reviews/reviews/save"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReview save(HttpServletRequest req, @RequestParam AgentReview agentReview, @RequestParam(required=false) String commitMessage, @RequestParam(required=false) String saveInfo) throws Exception {
        AgentReview savedAgentReview;
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), agentReview.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            savedAgentReview = this.agentReviewCRUDService.upsertAgentReview(t.getUser(), agentReview, true);
            if (si.summaryOnly) {
                t.commit("Updated summary for agent review " + agentReview.projectKey + "." + agentReview.name + " (id: " + agentReview.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else if (StringUtils.isNotBlank((String)commitMessage)) {
                t.commit(commitMessage);
            } else {
                t.commit("Saved agent review " + savedAgentReview.projectKey + "." + savedAgentReview.name + " (id: " + savedAgentReview.id + ")");
            }
            this.auditTrailService.generic("agentreview-review-save").with("projectKey", savedAgentReview.projectKey).with("agentReviewId", savedAgentReview.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("agentreview-review-save", (Throwable)e).with("projectKey", agentReview.projectKey).with("agentReviewId", agentReview.id).emit();
            throw e;
        }
        return savedAgentReview;
    }

    @AuditedCall(value={"msgType", "agentreview-review-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/agent-reviews/reviews/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReview> listAgentReviews(HttpServletRequest req, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewCRUDService.list(projectKey);
    }

    @AuditedCall(value={"msgType", "agentreview-review-list-heads", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/agent-reviews/reviews/list-heads"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReview.AgentReviewListItem> listAgentReviewHeads(HttpServletRequest req, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        List<AgentReview> agentReviews;
        AuthCtx authCtx;
        ArrayList<AgentReview.AgentReviewListItem> heads = new ArrayList<AgentReview.AgentReviewListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            agentReviews = this.agentReviewCRUDService.listUnsafe(projectKey);
        }
        for (AgentReview agentReview : agentReviews) {
            AgentReview.AgentReviewListItem item = new AgentReview.AgentReviewListItem(agentReview);
            this.taggableObjectsService.setEditionInfoFromTags(agentReview, item);
            heads.add(item);
        }
        this.agentReviewService.enrichAgentReviewsWithAgentNames(projectKey, heads);
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        return heads;
    }

    @AuditedCall(value={"msgType", "agentreview-review-get", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/reviews/get"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentReview getAgentReview(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId) throws DKUSecurityException, IOException, CodedException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AgentReview agentReview = this.agentReviewCRUDService.getMandatory(projectKey, agentReviewId);
            return agentReview;
        }
    }

    @AuditedCall(value={"msgType", "agentreview-review-get-full-info", "projectKey", "${projectKey}", "agentReviewId", "${id}"})
    @RequestMapping(value={"/api/agent-reviews/reviews/get-full-info"}, method={RequestMethod.GET})
    @ResponseBody
    public NavigatorService.AgentReviewFullInfo getFullInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        NavigatorService.AgentReviewFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, id);
            this.projectsService.failIfNoTaggableObjectReadUseAccess(u, ITaggingService.TaggableType.AGENT_REVIEW, loc, projectKey);
            info = this.navigatorService.getAgentReviewFullInfo(projectKey, id);
        }
        this.navigatorService.addInfo_NT(info, u);
        return info;
    }

    @AuditedCall(value={"msgType", "agentreview-test-create", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/tests/create"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AgentReviewTest> createTests(HttpServletRequest req, @RequestParam List<AgentReviewTest> tests) throws SQLException, IOException, CodedException, DKUSecurityException {
        AuthCtx authCtx;
        Set projectKeys = tests.stream().map(test -> test.projectKey).collect(Collectors.toSet());
        Set agentReviewIds = tests.stream().map(test -> test.agentReviewId).collect(Collectors.toSet());
        if (projectKeys.size() != 1 || agentReviewIds.size() != 1) {
            throw new IllegalStateException("Not all tests share the same projectKey or agentReviewId");
        }
        String projectKey = (String)projectKeys.iterator().next();
        String agentReviewId = (String)agentReviewIds.iterator().next();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
            this.agentReviewCRUDService.getMandatory(projectKey, agentReviewId);
        }
        return this.agentReviewService.createTests(authCtx, tests);
    }

    @AuditedCall(value={"msgType", "agentreview-test-create-from-dataset", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "fullDatasetName", "${fullDatasetName}"})
    @RequestMapping(value={"/api/agent-reviews/tests/createFromDataset"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AgentReviewCreateTestsFromDatasetResult> createTestsFromDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String fullDatasetName, @RequestParam AgentReviewCreateTestsFromDatasetRequest request) throws Exception {
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(projectKey, fullDatasetName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
            this.agentReviewCRUDService.getMandatory(projectKey, agentReviewId);
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, datasetLoc);
        }
        return this.agentReviewService.createTestsFromDataset(authCtx, projectKey, agentReviewId, datasetLoc, request);
    }

    @AuditedCall(value={"msgType", "agentreview-test-export-to-dataset", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "fullDatasetName", "${fullDatasetName}"})
    @RequestMapping(value={"/api/agent-reviews/tests/exportToDataset"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AgentReviewExportTestsToDatasetResult> exportTestsToDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String fullDatasetName, @RequestParam AgentReviewExportTestsToDatasetRequest request) throws Exception {
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(projectKey, fullDatasetName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.agentReviewCRUDService.getMandatory(projectKey, agentReviewId);
            this.projectsService.hasPermissionRegardlessOfContext(authCtx, projectKey, ITaggingService.TaggableType.DATASET, fullDatasetName, SerializedProject.ReaderAuthorization.Mode.WRITE);
        }
        return this.agentReviewService.exportTestsToDataset(authCtx, projectKey, agentReviewId, datasetLoc, request);
    }

    @AuditedCall(value={"msgType", "agentreview-test-list", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/tests/list"}, method={RequestMethod.GET})
    public void listTests(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam(required=false) List<String> testIds) throws DKUSecurityException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AgentReviewController.streamJSONArray((HttpServletResponse)resp, this.agentReviewService.streamTests(projectKey, agentReviewId, testIds));
    }

    @AuditedCall(value={"msgType", "agentreview-test-overview-list", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/tests/list-overview"}, method={RequestMethod.GET})
    public void listTestOverviews(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String agentReviewId) throws DKUSecurityException, IOException, SQLException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AgentReviewController.streamJSONArray((HttpServletResponse)resp, this.agentReviewService.streamTestOverviews(projectKey, agentReviewId));
    }

    @AuditInline
    @RequestMapping(value={"/api/agent-reviews/tests/update"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewTest updateTest(HttpServletRequest req, @RequestParam AgentReviewTest test) throws DKUSecurityException, SQLException, IOException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, test.projectKey);
        }
        this.auditTrailService.generic("agentreview-test-update").with("projectKey", test.projectKey).with("testId", test.id).emit();
        return this.agentReviewService.updateTest(authCtx, test);
    }

    @AuditedCall(value={"msgType", "agentreview-test-delete", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/agent-reviews/tests/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteTests(HttpServletRequest req, @RequestParam String projectKey, @RequestParam List<String> testIds) throws DKUSecurityException, SQLException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        this.agentReviewService.deleteTests(projectKey, testIds);
    }

    @AuditedCall(value={"msgType", "agentreview-run-list", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/runs/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewRun> listRuns(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId) throws DKUSecurityException, SQLException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewService.listRuns(projectKey, agentReviewId);
    }

    @AuditedCall(value={"msgType", "agentreview-run-history", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/runs/history"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewRunHistoryItem> listRunHistory(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId) throws DKUSecurityException, SQLException, IOException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewService.listRunHistory_NT(authCtx, projectKey, agentReviewId);
    }

    @AuditedCall(value={"msgType", "agentreview-run-rename", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}", "newName", "${newName}"})
    @RequestMapping(value={"/api/agent-reviews/runs/rename"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewRun renameRun(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String runId, @RequestParam String newName) throws DKUSecurityException, SQLException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        return this.agentReviewService.renameRun(projectKey, agentReviewId, runId, newName);
    }

    @AuditedCall(value={"msgType", "agentreview-run-delete", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/runs/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteRuns(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam List<String> runIds) throws DKUSecurityException, SQLException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        this.agentReviewService.deleteRuns(projectKey, agentReviewId, runIds);
    }

    @AuditedCall(value={"msgType", "agentreview-run-perform", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/runs/perform"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewRun performRun(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam List<String> testIds) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        return this.agentReviewService.performRun_NT(authCtx, projectKey, agentReviewId, testIds, false, false, null);
    }

    @AuditedCall(value={"msgType", "agentreview-quick-run-perform", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/runs/quick-perform"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AgentReviewRawExecutionResult> performQuickRun(HttpServletRequest req, @RequestParam String projectKey, @RequestParam AgentReviewTest test) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        return this.agentReviewService.performQuickRun_NT(authCtx, projectKey, test);
    }

    @AuditedCall(value={"msgType", "agentreview-rerun", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/runs/rerun"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewRun rerun(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String runId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        return this.agentReviewService.rerun_NT(authCtx, projectKey, agentReviewId, false, false, runId, null);
    }

    @AuditedCall(value={"msgType", "agentreview-run-list-logs", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/api/agent-reviews/runs/list-logs"}, method={RequestMethod.GET})
    @ResponseBody
    public List<LogsService.LogDesc> listRunLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String runId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewService.listLogs(projectKey, agentReviewId, runId);
    }

    @AuditedCall(value={"msgType", "agentreview-run-get-log", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}", "logFileName", "${logFileName}"})
    @RequestMapping(value={"/api/agent-reviews/runs/get-log"}, method={RequestMethod.GET})
    @ResponseBody
    public SmartLogTail getRunLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String runId, @RequestParam String logFileName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewService.getLog(projectKey, agentReviewId, runId, logFileName);
    }

    @AuditedCall(value={"msgType", "agentreview-run-stream-log", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}", "logFileName", "${logFileName}"})
    @RequestMapping(value={"/api/agent-reviews/runs/stream-log"})
    public void streamLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String runId, @RequestParam String logFileName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        this.agentReviewService.streamLog((OutputStream)resp.getOutputStream(), projectKey, agentReviewId, runId, logFileName);
    }

    @AuditedCall(value={"msgType", "agentreview-run-get-logs-zip", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/api/agent-reviews/runs/all-logs-zip"}, method={RequestMethod.GET})
    public void getAllLogsZip(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String runId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        String dlName = String.format("%s-%s-%s-logs.zip", projectKey, agentReviewId, runId);
        String cd = String.format("attachment; filename=\"%s\"", dlName);
        resp.setHeader("Content-Disposition", cd);
        this.agentReviewService.getAllLogsZip((OutputStream)resp.getOutputStream(), projectKey, agentReviewId, runId);
    }

    @AuditedCall(value={"msgType", "agentreview-run-get-previous-finished-run", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/api/agent-reviews/runs/get-previous-finished-run"}, method={RequestMethod.GET})
    @ResponseBody
    @Nullable
    public AgentReviewRunHistoryItem getPreviousFinishedRun(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String runId) throws DKUSecurityException, IOException, SQLException, ExecutionException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewService.getPreviousRunHistoryItem_NT(authCtx, projectKey, agentReviewId, runId);
    }

    @AuditedCall(value={"msgType", "agentreview-result-list", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/api/agent-reviews/results/list"}, method={RequestMethod.GET})
    public void listResults(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String runId) throws DKUSecurityException, SQLException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AgentReviewController.streamJSONArray((HttpServletResponse)resp, this.agentReviewService.streamResults(projectKey, agentReviewId, runId));
    }

    @AuditedCall(value={"msgType", "agentreview-run-list", "projectKey", "${projectKey}", "testId", "${testId}"})
    @RequestMapping(value={"/api/agent-reviews/results/overview-history"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewResultOverview> listTestResultOverviewHistory(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String testId) throws DKUSecurityException, SQLException, IOException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewService.listTestResultOverviewHistory_NT(authCtx, projectKey, testId);
    }

    @AuditedCall(value={"msgType", "agentreview-run-list", "projectKey", "${projectKey}", "testId", "${testId}"})
    @RequestMapping(value={"/api/agent-reviews/results/full-history"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewResult> listTestFullResultHistory(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String testId) throws DKUSecurityException, SQLException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewService.listTestFullResultHistory(projectKey, testId);
    }

    @AuditedCall(value={"msgType", "agentreview-list-traits-definition", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}", "runId", "${runId}"})
    @RequestMapping(value={"/api/agent-reviews/traits/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewTrait> listTraitDefinitions(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String runId) throws DKUSecurityException, SQLException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewService.listTraitsForRun(projectKey, agentReviewId, runId);
    }

    @AuditInline
    @RequestMapping(value={"/api/agent-reviews/human-reviews/upsert"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewResult upsertHumanReview(HttpServletRequest req, @RequestParam AgentReviewHumanReview humanReview) throws IOException, DKUSecurityException, SQLException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(user, humanReview.projectKey);
        }
        if (humanReview.id == null) {
            this.auditTrailService.generic("agentreview-human-reviews-create").with("projectKey", humanReview.projectKey).with("resultId", humanReview.resultId).emit();
            AgentReviewHumanReview createdReview = this.agentReviewService.createHumanReview(user, humanReview, false);
            return this.agentReviewService.getResult(createdReview.projectKey, createdReview.resultId);
        }
        this.auditTrailService.generic("agentreview-human-reviews-update").with("projectKey", humanReview.projectKey).with("resultId", humanReview.resultId).with("humanReviewId", humanReview.id).emit();
        AgentReviewHumanReview updatedReview = this.agentReviewService.updateHumanReview(user, humanReview, false);
        return this.agentReviewService.getResult(updatedReview.projectKey, updatedReview.resultId);
    }

    @AuditedCall(value={"msgType", "agentreview-human-reviews-delete", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/agent-reviews/human-reviews/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewResult deleteHumanReview(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String humanReviewId) throws DKUSecurityException, SQLException, IOException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(user, projectKey);
        }
        return this.agentReviewService.deleteHumanReview(user, projectKey, humanReviewId);
    }

    @AuditedCall(value={"msgType", "agentreview-trait-override-list", "projectKey", "${projectKey}", "resultId", "${resultId}"})
    @RequestMapping(value={"/api/agent-reviews/trait-overrides/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentReviewTraitOverride> listTraitOverrides(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String resultId) throws DKUSecurityException, SQLException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.agentReviewService.listTraitOverrides(projectKey, resultId);
    }

    @AuditInline
    @RequestMapping(value={"/api/agent-reviews/trait-overrides/upsert"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewResult upsertTraitOverride(HttpServletRequest req, @RequestParam AgentReviewTraitOverride traitOverride) throws SQLException, DKUSecurityException, IOException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(user, traitOverride.projectKey);
        }
        if (traitOverride.id == null) {
            this.auditTrailService.generic("agentreview-trait-override-create").with("projectKey", traitOverride.projectKey).with("resultId", traitOverride.resultId).with("traitId", traitOverride.traitId).emit();
            AgentReviewTraitOverride created = this.agentReviewService.createTraitOverride(user, traitOverride, false);
            return this.agentReviewService.getResult(created.projectKey, created.resultId);
        }
        this.auditTrailService.generic("agentreview-trait-override-update").with("projectKey", traitOverride.projectKey).with("traitOverrideId", traitOverride.id).emit();
        AgentReviewTraitOverride updated = this.agentReviewService.updateTraitOverride(user, traitOverride, false);
        return this.agentReviewService.getResult(updated.projectKey, updated.resultId);
    }

    @AuditedCall(value={"msgType", "agentreview-trait-override-delete", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/agent-reviews/trait-overrides/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentReviewResult deleteTraitOverride(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String traitOverrideId) throws DKUSecurityException, SQLException, IOException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(user, projectKey);
        }
        return this.agentReviewService.deleteTraitOverride(user, projectKey, traitOverrideId);
    }

    @AuditedCall(value={"msgType", "agentreview-test-extract-expectations", "projectKey", "${projectKey}", "agentReviewId", "${agentReviewId}"})
    @RequestMapping(value={"/api/agent-reviews/tests/extract-expectations"}, method={RequestMethod.POST})
    @ResponseBody
    public ExpectationsResult extractExpectations(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentReviewId, @RequestParam String query, @RequestParam String answer, @RequestParam String trajectory) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.agentReviewService.checkAgentReviewWritePermission(authCtx, projectKey);
        }
        return new ExpectationsResult(this.agentReviewService.extractExpectationsFromAnswerAndTrajectory(authCtx, projectKey, agentReviewId, query, answer, trajectory));
    }

    @AuditedCall(value={"msgType", "agentreview-default-completion-model-id"})
    @RequestMapping(value={"/api/agent-reviews/default-completion-model-id"}, method={RequestMethod.GET})
    @ResponseBody
    public DefaultLLMCompletionModelId getDefaultLLMCompletionModelId(HttpServletRequest req, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return new DefaultLLMCompletionModelId(ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.defaultEvalLLMCompletionModelId);
    }

    @AuditedCall(value={"msgType", "agentreview-get-user-privileges", "projectKey", "${projectKey"})
    @RequestMapping(value={"/api/agent-reviews/get-user-privileges"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentReviewPrivileges getPrivileges(HttpServletRequest req, @RequestParam String projectKey) throws DKUSecurityException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            LimitsStatusComputer.LicensedProfile profile = this.licenseEnforcementService.getUserProfileByNameOrFallback(authCtx.getUserProfile());
            boolean canReadConf = this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            boolean canPerformActions = this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF) && profile.mayReviewAgent;
            boolean canWriteConf = this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF) && profile.mayWriteProjectContent;
            AgentReviewPrivileges agentReviewPrivileges = new AgentReviewPrivileges(canReadConf, canPerformActions, canWriteConf);
            return agentReviewPrivileges;
        }
    }

    @UIModel
    public static class DefaultLLMCompletionModelId {
        @Nullable
        public String id;

        public DefaultLLMCompletionModelId(@Nullable String id) {
            this.id = id;
        }
    }
}

