/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.ContainerExecUsagesService;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.ContainerNamesWithProjectDefault;
import com.dataiku.dip.containers.exec.ContainerSpecificContext;
import com.dataiku.dip.containers.exec.UsedContainerExec;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionRegistry;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnableMeta;
import com.dataiku.dip.scheduler.runnables.DSSRunnableRegistry;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ContainersController
extends DIPInternalControllerBase {
    @Autowired
    private ContainerExecUsagesService containerExecUsagesService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectsDAO projectsDAO;
    static Logger logger = Logger.getLogger((String)"dip.controllers.containers");

    @AuditedCall(value={"msgType", "containers-list"})
    @RequestMapping(value={"/api/containers/list-names"})
    public void listContainersNames(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String type, @RequestParam(required=false) WorkloadType workloadType) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        List<ContainerExecRuntimeConfig.Container> filteredTypes = StringUtils.isBlank((String)type) ? Arrays.asList(ContainerExecRuntimeConfig.Container.values()) : Collections.singletonList(ContainerExecRuntimeConfig.Container.valueOf(type));
        ContainersController.writeJSON((HttpServletResponse)resp, ContainerExecUtils.getAllowedContainerNames(authCtx, filteredTypes, workloadType));
    }

    @AuditedCall(value={"msgType", "containers-list-usages"})
    @RequestMapping(value={"/api/containers/list-usages"})
    public void listContainersUsages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<UsedContainerExec> usages = this.containerExecUsagesService.listUsages(projectKey);
            HashSet<UsedContainerExec> used = new HashSet<UsedContainerExec>(usages);
            ContainersController.writeJSON((HttpServletResponse)resp, used);
        }
    }

    @AuditedCall(value={"msgType", "containers-list"})
    @RequestMapping(value={"/api/containers/list-spark-names"})
    public void listSparkContainersNames(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        ContainersController.writeJSON((HttpServletResponse)resp, ContainerExecUtils.getAllowedSparkContainerConfNames());
    }

    @AuditedCall(value={"msgType", "containers-list"})
    @RequestMapping(value={"/api/containers/list-names-with-default"})
    public void listContainersNamesWithDefault(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String type, @RequestParam(required=true) WorkloadType workloadType, @RequestParam(required=false) ContainerSpecificContext containerSpecificContext) throws Exception {
        SerializedProject sp = null;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)projectKey)) {
                sp = this.projectsDAO.getMandatory(projectKey);
            }
        }
        ContainerNamesWithProjectDefault ret = new ContainerNamesWithProjectDefault();
        List<ContainerExecRuntimeConfig.Container> filteredTypes = StringUtils.isBlank((String)type) ? Arrays.asList(ContainerExecRuntimeConfig.Container.values()) : Collections.singletonList(ContainerExecRuntimeConfig.Container.valueOf(type));
        ret.containerNames = ContainerExecUtils.getAllowedContainerNames(authCtx, filteredTypes, workloadType);
        switch (workloadType) {
            case USER_CODE: {
                if (null != sp) {
                    ret.projectDefault = sp.settings.container;
                }
                ret.globalDefault = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().containerSettings.defaultExecutionConfig;
                break;
            }
            case VISUAL_RECIPES: {
                if (null != sp) {
                    ret.projectDefault = sp.settings.containerForVisualRecipesWorkloads;
                }
                ret.globalDefault = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().containerSettings.defaultExecutionConfigForVisualRecipesWorkloads;
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        String resolvedProjectConf = null;
        if (null != ret.projectDefault) {
            if (ret.projectDefault.containerMode == ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER) {
                resolvedProjectConf = com.dataiku.dip.utils.StringUtils.nullIfBlank((String)ret.projectDefault.containerConf);
            } else if (ret.projectDefault.containerMode == ContainerExecSelection.ContainerExecMode.INHERIT) {
                resolvedProjectConf = com.dataiku.dip.utils.StringUtils.nullIfBlank((String)ret.globalDefault);
            }
            if (containerSpecificContext == ContainerSpecificContext.RAG) {
                ContainerExecSelection ragSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.defaultRetrievableKnowledgeContainerExecSelection;
                if (ragSettings.containerMode == ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER) {
                    ret.resolvedInheritValue = ragSettings.containerConf;
                } else if (ragSettings.containerMode == ContainerExecSelection.ContainerExecMode.INHERIT) {
                    ret.resolvedInheritValue = resolvedProjectConf;
                }
            } else {
                ret.resolvedInheritValue = resolvedProjectConf;
            }
        } else {
            ret.resolvedInheritValue = ret.globalDefault;
        }
        ContainersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "containers-get"})
    @RequestMapping(value={"/api/containers/get-config-info"})
    public void getConfigInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(value="exposableKind") String exposableKindStr, @RequestParam String expositionUsageContext, @RequestParam(value="containerSelection", required=false) String containerSelectionData, @RequestParam(value="inlineContainerConfig", required=false) String inlineContainerConfigData) throws Exception {
        AuthCtx authCtx = null;
        ContainerExecSelection containerSelection = StringUtils.isNotBlank((String)containerSelectionData) ? (ContainerExecSelection)JSON.parse((String)containerSelectionData, ContainerExecSelection.class) : null;
        ContainerExecRuntimeConfig inlineContainerConfig = StringUtils.isNotBlank((String)inlineContainerConfigData) ? (ContainerExecRuntimeConfig)JSON.parse((String)inlineContainerConfigData, ContainerExecRuntimeConfig.class) : null;
        Exposables.ExposableKind exposableKind = Exposables.ExposableKind.valueOf(exposableKindStr);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        ContainerExecRuntimeConfigInfo ret = new ContainerExecRuntimeConfigInfo();
        try {
            ContainerExecRuntimeConfig selected;
            if (containerSelection != null) {
                selected = new ContainerExecConfigSelector().select_autoTXN(authCtx, projectKey, containerSelection);
            } else if (inlineContainerConfig != null) {
                selected = inlineContainerConfig;
            } else {
                throw new Exception("No runtime config selected");
            }
            if (selected != null) {
                ret.type = selected.type;
                ret.name = selected.name;
                for (ExpositionMeta exposition : ExpositionRegistry.getAllMeta()) {
                    if (!exposition.handles(exposableKind) || !exposition.handles(selected)) continue;
                    ret.expositions.add(exposition.getDesc(ExpositionMeta.ExpositionUsageContext.valueOf(expositionUsageContext)));
                }
                if (selected.type == ContainerExecRuntimeConfig.Container.KUBERNETES) {
                    for (SimpleKeyValue prop : selected.properties) {
                        if (!"kubernetes.version".equals(prop.key)) continue;
                        try {
                            ret.k8sVersion = Float.parseFloat(prop.value);
                        }
                        catch (NumberFormatException e) {
                            logger.warn((Object)"Invalid version number", (Throwable)e);
                        }
                    }
                    this.fillYamlModifierList(ret, selected, expositionUsageContext, exposableKind);
                }
            } else {
                ret.type = null;
                ret.name = "Local";
                for (ExpositionMeta exposition : ExpositionRegistry.getAllMeta()) {
                    if (!exposition.handles(exposableKind) || !exposition.handles((ContainerExecRuntimeConfig.Container)null)) continue;
                    ret.expositions.add(exposition.getDesc(ExpositionMeta.ExpositionUsageContext.valueOf(expositionUsageContext)));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error while getting info of container selection", (Throwable)e);
            ret.error = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        ContainersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    private void fillYamlModifierList(ContainerExecRuntimeConfigInfo ret, ContainerExecRuntimeConfig selected, String expositionUsageContext, Exposables.ExposableKind exposableKind) throws IOException {
        MemTable table = new MemTable();
        MemRow row = new MemRow(table);
        row.put((Column)table.column("purpose"), "yaml-modifier");
        row.put((Column)table.column("exposableKind"), exposableKind == null ? "" : exposableKind.name());
        row.put((Column)table.column("expositionUsageContext"), expositionUsageContext);
        row.put((Column)table.column("containerConfig"), JSON.json((Object)selected));
        for (SimpleKeyValue prop : selected.properties) {
            row.put((Column)table.column("prop:" + prop.key), prop.value);
        }
        for (DSSRunnableMeta meta : DSSRunnableRegistry.getAllMeta()) {
            IElementLoadedDesc loaded = meta.getLoadedDesc();
            Object desc = ((LoadedRunnable)loaded).desc;
            if (((DSSRunnableDesc)desc).macroRoles == null) continue;
            boolean add = false;
            for (DSSRunnableDesc.MacroRoleDef role : ((DSSRunnableDesc)desc).macroRoles) {
                if (role.type != DSSRunnableDesc.MacroRoleDef.Type.FUNCTION || StringUtils.isBlank((String)role.condition)) continue;
                Expression expr = new Expression(role.condition);
                expr.setColumnFactory(table);
                try {
                    if (!expr.isTrueish(row)) continue;
                    add = true;
                    break;
                }
                catch (Throwable e) {
                    logger.warn((Object)"Unable to check if macro function applies to container config", e);
                }
            }
            if (!add) continue;
            ret.yamlModifiers.add((LoadedRunnable<? extends DSSRunnableDesc>)loaded);
        }
    }

    @AuditedCall(value={"msgType", "containers-get"})
    @RequestMapping(value={"/api/containers/get-expositions"})
    public void getExpositions(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="containerType") String containerTypeStr, @RequestParam(value="exposableKind") String exposableKindStr, @RequestParam String expositionUsageContext) throws Exception {
        ContainerExecRuntimeConfig.Container containerType = ContainerExecRuntimeConfig.Container.valueOf(containerTypeStr);
        Exposables.ExposableKind exposableKind = Exposables.ExposableKind.valueOf(exposableKindStr);
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        ContainerExecRuntimeConfigInfo ret = new ContainerExecRuntimeConfigInfo();
        ret.type = containerType;
        for (ExpositionMeta exposition : ExpositionRegistry.getAllMeta()) {
            if (!exposition.handles(exposableKind) || !exposition.handles(containerType)) continue;
            ret.expositions.add(exposition.getDesc(ExpositionMeta.ExpositionUsageContext.valueOf(expositionUsageContext)));
        }
        ContainersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    public static class ContainerExecRuntimeConfigInfo {
        public ContainerExecRuntimeConfig.Container type;
        public String name;
        public String error;
        public List<ExpositionDesc> expositions = Lists.newArrayList();
        public float k8sVersion;
        public List<LoadedRunnable<? extends DSSRunnableDesc>> yamlModifiers = Lists.newArrayList();
    }
}

