/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.datacatalog.UIDataCatalog;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.datacollections.DataCollectionColumnsCustomization;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.datacollections.UIDataCollection;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.DataCollectionPermissionsService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/data-collections"})
public class DataCollectionsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DataCollectionsService dataCollectionsService;
    @Autowired
    private DataCollectionPermissionsService dataCollectionPermissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IInternalDataCatalogService catalogService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.data-collections");

    @AuditedCall(value={"msgType", "data-collection-list-tags"})
    @RequestMapping(value={"/list-all-tags"})
    public void listAllTags(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Set<String> tags;
        try (Transaction t = this.transactionService.beginRead();){
            tags = this.dataCollectionsService.listAllTags();
        }
        DataCollectionsController.writeJSON((HttpServletResponse)resp, tags);
    }

    @AuditInline
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam UIDataCollection.CreationInfo creationInfo) throws Exception {
        DataCollection createdDataCollection;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.dataCollectionPermissionsService.checkMayCreateDataCollections(authCtx);
            createdDataCollection = this.dataCollectionsService.createDataCollection(authCtx, creationInfo);
            t.commit("Created data collection " + createdDataCollection.id);
            this.auditTrailService.generic("data-collection-create").with("id", createdDataCollection.id).emit();
        }
        DataCollectionsController.writeJSON((HttpServletResponse)resp, (Object)new Id(createdDataCollection.id));
    }

    @AuditedCall(value={"msgType", "data-collection-list"})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public void listDataCollections(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="READ") Privileges.DataCollectionLevelPrivilegeType privilege) throws Exception {
        List dataCollections;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            dataCollections = this.dataCollectionsService.listAccessibleUnsafe(authCtx, privilege).stream().map(UIDataCollection.ListItem::new).collect(Collectors.toList());
        }
        DataCollectionsController.writeJSON((HttpServletResponse)resp, dataCollections);
    }

    @AuditedCall(value={"msgType", "data-collection-list-with-details"})
    @RequestMapping(value={"/list-with-details"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIDataCollection.ListItemWithDetails> listWithDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="READ") Privileges.DataCollectionLevelPrivilegeType privilege) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            List<UIDataCollection.ListItemWithDetails> list = this.dataCollectionsService.listAccessibleUnsafe(authCtx, privilege).stream().map(UIDataCollection.ListItemWithDetails::new).collect(Collectors.toList());
            return list;
        }
    }

    @AuditedCall(value={"msgType", "data-collection-get-objects-authorizations"})
    @RequestMapping(value={"/get-objects-authorizations"}, method={RequestMethod.POST})
    @ResponseBody
    public List<UIDataCollection.ObjectAuthorizations> getObjectsAuthorizations(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<TaggableObjectsService.TaggableObjectRef> items) throws Exception {
        ArrayList<UIDataCollection.ObjectAuthorizations> response = new ArrayList<UIDataCollection.ObjectAuthorizations>();
        Map itemsGroupedByProject = items.stream().collect(Collectors.groupingBy(item -> item.projectKey, Collectors.toSet()));
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (Map.Entry entry : itemsGroupedByProject.entrySet()) {
                String projectKey = entry.getKey();
                if (!this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.PUBLISH_TO_DATA_COLLECTIONS)) continue;
                SerializedProject sp = this.projectsService.getMandatory(projectKey);
                SerializedProject.ProjectDashboardAuthorizations dashboardAuthorizationsForProject = sp.dashboardAuthorizations;
                for (TaggableObjectsService.TaggableObjectRef item2 : entry.getValue()) {
                    response.add(new UIDataCollection.ObjectAuthorizations(item2, this.exposedObjectsService.isQuickSharingEnabled(projectKey, item2.type, item2.id), this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS), dashboardAuthorizationsForProject.allAuthorized, dashboardAuthorizationsForProject.getCurrentAuthorizationModes(SmartObjectRef.localRef(item2.type, item2.id))));
                }
            }
        }
        return response;
    }

    @AuditedCall(value={"msgType", "data-collection-list-publishable-objects", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/list-publishable-objects"})
    @ResponseBody
    public List<UIDataCollection.ObjectAuthorizationsWithDisplayName> listPublishableObjects(HttpServletRequest req, HttpServletResponse resp, String projectKey, @RequestParam(required=false) String type) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"projectKey is mandatory");
        ITaggingService.TaggableType taggableType = StringUtils.isNotBlank((String)type) ? ITaggingService.TaggableType.valueOf(type) : null;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.PUBLISH_TO_DATA_COLLECTIONS);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            boolean canManageExposedElements = this.permissionsService.hasProjectPrivilege(user, project, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
            Set<TaggableObjectsService.TaggableObjectRef> quickshared = this.exposedObjectsService.getQuickSharedObjects(project, ITaggingService.TaggableType.DATASET);
            List<UIDataCollection.ObjectAuthorizationsWithDisplayName> list = this.taggableObjectsReadService.listUnsafe(projectKey, taggableType).stream().map(to -> new UIDataCollection.ObjectAuthorizationsWithDisplayName((TaggableObjectsService.TaggableObject)to, quickshared.contains(to.getRef()), canManageExposedElements, project.dashboardAuthorizations.allAuthorized, project.dashboardAuthorizations.getCurrentAuthorizationModes(SmartObjectRef.localRef(to.getTaggableType(), to.getId())))).collect(Collectors.toList());
            return list;
        }
    }

    @AuditedCall(value={"msgType", "data-collection-add-objects", "id", "${dataCollectionId}"})
    @RequestMapping(value={"/add-objects"}, method={RequestMethod.POST})
    public void addObjectsToDataCollection(HttpServletRequest req, HttpServletResponse resp, @RequestParam String dataCollectionId, @RequestParam List<UIDataCollection.AddObject> items) throws Exception {
        UIDataCollection.AddObjectsResponse response;
        boolean haveAuthorizationOrSharingChanged = false;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.dataCollectionPermissionsService.checkMayPublishToDataCollections(authCtx);
            this.dataCollectionsService.checkPerm(authCtx, dataCollectionId, Privileges.DataCollectionLevelPrivilegeType.WRITE);
            Map<String, List<UIDataCollection.AddObject>> itemsByProjects = items.stream().collect(Collectors.groupingBy(item -> item.ref.projectKey));
            for (Map.Entry<String, List<UIDataCollection.AddObject>> entry : itemsByProjects.entrySet()) {
                String projectKey = entry.getKey();
                List<UIDataCollection.AddObject> itemsFromProject = entry.getValue();
                this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.PUBLISH_TO_DATA_COLLECTIONS);
                if (itemsFromProject.stream().anyMatch(item -> item.requestQuickSharing)) {
                    this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
                }
                haveAuthorizationOrSharingChanged |= this.dataCollectionsService.saveDatasetAuthorizationAndSharing_T(projectKey, itemsFromProject);
            }
            List<TaggableObjectsService.TaggableObjectRef> datasetRefs = items.stream().filter(item -> item.ref.type.equals((Object)ITaggingService.TaggableType.DATASET)).map(item -> item.ref).collect(Collectors.toList());
            response = this.dataCollectionsService.addDatasets(dataCollectionId, datasetRefs);
            if (response.modified || haveAuthorizationOrSharingChanged) {
                t.commit("Added objects to data collection " + dataCollectionId);
            }
        }
        DataCollectionsController.writeJSON((HttpServletResponse)resp, (Object)response);
    }

    @AuditedCall(value={"msgType", "data-collection-get-info", "id", "${id}"})
    @RequestMapping(value={"/get-info"}, method={RequestMethod.GET})
    @ResponseBody
    public UIDataCollection.DataCollectionInfo getInfo(HttpServletRequest req, @RequestParam String id) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.dataCollectionsService.checkPerm(authCtx, id, Privileges.DataCollectionLevelPrivilegeType.READ);
        }
        return this.dataCollectionsService.getDataCollectionInfo_NT(authCtx, id);
    }

    @AuditedCall(value={"msgType", "data-collection-update-metadata", "id", "${id}"})
    @RequestMapping(value={"/update-metadata"}, method={RequestMethod.PUT})
    @ResponseBody
    public void updateMetadata(HttpServletRequest req, @RequestParam String id, @RequestParam UIDataCollection.MetadataInfo metadata) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(id);
            this.dataCollectionsService.checkPerm(authCtx, id, Privileges.DataCollectionLevelPrivilegeType.ADMIN);
            this.dataCollectionsService.updateMetadata(dataCollection, metadata);
            t.commit("Updated data collection metadata " + id);
        }
    }

    @AuditedCall(value={"msgType", "data-collection-update-completeness-checks", "id", "${id}"})
    @RequestMapping(value={"/update-metadata-completeness-checks"}, method={RequestMethod.PUT})
    @ResponseBody
    public void updateMetadataCompletenessChecks(HttpServletRequest req, @RequestParam String id, @RequestParam UIDataCollection.MetadataCompletenessChecks metadataCompletenessChecks) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(id);
            this.dataCollectionsService.checkPerm(authCtx, id, Privileges.DataCollectionLevelPrivilegeType.ADMIN);
            this.dataCollectionsService.updateMetadataCompletenessChecks(dataCollection, metadataCompletenessChecks);
            t.commit("Updated data collection quality checks " + id);
        }
    }

    @AuditedCall(value={"msgType", "data-collection-update-columns-customization", "id", "${id}"})
    @RequestMapping(value={"/update-columns-customization"}, method={RequestMethod.PUT})
    @ResponseBody
    public void updateColumnCustomization(HttpServletRequest req, @RequestParam String id, @RequestParam DataCollectionColumnsCustomization columnsCustomizationSettings) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(id);
            this.dataCollectionsService.checkPerm(authCtx, id, Privileges.DataCollectionLevelPrivilegeType.ADMIN);
            this.dataCollectionsService.updateColumnsCustomization(dataCollection, columnsCustomizationSettings);
            t.commit("Updated data collection quality checks " + id);
        }
    }

    @AuditedCall(value={"msgType", "data-collection-update-permissions", "id", "${id}"})
    @RequestMapping(value={"/update-permissions"}, method={RequestMethod.PUT})
    @ResponseBody
    public void updatePermissions(HttpServletRequest req, @RequestParam String id, @RequestParam List<BasePermissions.PermissionItem> permissions) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.dataCollectionsService.checkPerm(authCtx, id, Privileges.DataCollectionLevelPrivilegeType.ADMIN);
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(id);
            this.dataCollectionsService.updatePermissions(dataCollection, permissions);
            t.commit("Updated permissions for data collection: " + id);
        }
    }

    @AuditedCall(value={"msgType", "data-collection-delete", "id", "${id}"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void delete(HttpServletRequest req, @RequestParam String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(id);
            this.dataCollectionsService.checkPerm(authCtx, id, Privileges.DataCollectionLevelPrivilegeType.ADMIN);
            this.dataCollectionsService.delete(dataCollection);
            t.commit("Deleted data collection " + id);
        }
    }

    @AuditedCall(value={"msgType", "data-collection-get-item-details", "itemRef", "${itemRef}"})
    @RequestMapping(value={"/get-item-details"}, method={RequestMethod.GET})
    @ResponseBody
    public UIDataCatalog.AbstractDataCatalogItemDetails getItemDetails(HttpServletRequest req, @RequestParam String dataCollectionId, @RequestParam AbstractDataCollectionItemRef itemRef) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(dataCollectionId);
            this.dataCollectionPermissionsService.checkDataCollectionPrivileges(authCtx, dataCollection, Privileges.DataCollectionLevelPrivilegeType.READ);
            this.dataCollectionPermissionsService.checkDataCollectionActuallyContainsItem(dataCollection, itemRef);
        }
        if (itemRef instanceof AbstractDataCollectionItemRef.DatasetRef) {
            ProjectsService.ObjectVisibility visibility;
            AbstractDataCollectionItemRef.DatasetRef datasetRef = (AbstractDataCollectionItemRef.DatasetRef)itemRef;
            try (Transaction t = this.transactionService.beginRead();){
                visibility = this.projectsService.getDataCollectionObjectVisibility(authCtx, datasetRef.projectKey, ITaggingService.TaggableType.DATASET, datasetRef.id);
            }
            switch (visibility) {
                case DISCOVER: {
                    return this.catalogService.getDiscoverableDatasetItemDetails_NT(authCtx, datasetRef.projectKey, datasetRef.id);
                }
                case READ: {
                    return this.catalogService.getReadableDatasetItemDetails_NT(authCtx, datasetRef.projectKey, datasetRef.id);
                }
                case NONE: {
                    logger.warn((Object)("Requested dataset " + String.valueOf(datasetRef) + " is not visible for user"));
                    throw DataCollectionPermissionsService.notAuthorizedItemException(datasetRef);
                }
            }
        }
        throw new IllegalStateException("Unknown item reference type");
    }

    @AuditedCall(value={"msgType", "data-collection-remove-item", "itemRef", "${itemRef}"})
    @RequestMapping(value={"/remove-item"}, method={RequestMethod.POST})
    @ResponseBody
    public void removeItem(HttpServletRequest req, @RequestParam String dataCollectionId, @RequestParam AbstractDataCollectionItemRef itemRef) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(dataCollectionId);
            this.dataCollectionsService.checkPerm(authCtx, dataCollectionId, Privileges.DataCollectionLevelPrivilegeType.WRITE);
            this.dataCollectionPermissionsService.checkItemVisibility(itemRef);
            this.dataCollectionsService.removeItem(dataCollection, itemRef);
            t.commit("Deleted item " + String.valueOf(itemRef) + "from data collection " + dataCollectionId);
        }
    }

    @AuditedCall(value={"msgType", "data-collection-search", "query", "${query}"})
    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIDataCollection.ListItemWithDetails> search(HttpServletRequest req, @RequestParam String query) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            if (StringUtils.isBlank((String)query)) {
                List<UIDataCollection.ListItemWithDetails> list = this.dataCollectionsService.listReadableUnsafe(authCtx).stream().map(UIDataCollection.ListItemWithDetails::new).collect(Collectors.toList());
                return list;
            }
        }
        return this.catalogService.searchDataCollections(authCtx, query).stream().map(UIDataCollection.ListItemWithDetails::new).collect(Collectors.toList());
    }

    @AuditedCall(value={"msgType", "data-collection-recent-datasets"})
    @RequestMapping(value={"/recent-datasets"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIDataCollection.RecentDatasetInfo> getRecentDatasets(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            List<UIDataCollection.RecentDatasetInfo> list = this.dataCollectionsService.listRecentDatasetsUnsafe(authCtx);
            return list;
        }
    }
}

