/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.BundlePreparator;
import com.dataiku.dip.projects.importexport.DesignBundlesService;
import com.dataiku.dip.projects.importexport.model.BundleExporterSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ProjectBundleDeletedEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.identifiers.DSSBundleIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DesignBundlesController
extends DIPInternalControllerBase {
    private static DKULogger logger = DKULogger.getLogger((String)"dip.controllers.projects");
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DesignBundlesService designBundlesService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private GovernIntegrationService governIntegrationService;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private VariablesService variablesService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/design/prepare-bundle-creation"})
    public void prepareBundleCreation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        logger.infoV("Preparing data for bundle creation in bundle %s", new Object[]{projectKey});
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(liu, projectKey);
        }
        DesignBundlesController.writeJSON((HttpServletResponse)resp, this.designBundlesService.startPrepareBundle_NT(liu, projectKey));
    }

    @AuditedCall(value={"msgType", "design-bundle-create", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/design/create-bundle"}, method={RequestMethod.POST})
    public void createBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId, @RequestParam String preparationResult, @RequestParam(defaultValue="true") boolean evaluateProjectStandardsChecks) throws Exception {
        AuthCtx u;
        BundlePreparator.BundlePreparationResult prepared = (BundlePreparator.BundlePreparationResult)JSON.parse((String)preparationResult, BundlePreparator.BundlePreparationResult.class);
        if (null == prepared) {
            throw new IllegalStateException("No preparation result passed to create bundle %s of project %s".formatted(bundleId, projectKey));
        }
        if (StringUtils.isNotBlank((String)prepared.exportUserInfo.releaseNotes)) {
            VariablesContext context = this.variablesService.getForProject(projectKey);
            prepared.exportUserInfo.releaseNotes = context.expandAllowUnresolved(prepared.exportUserInfo.releaseNotes).trim();
        }
        logger.infoV("Creating bundle %s/%s", new Object[]{projectKey, bundleId});
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
        }
        if (this.designBundlesService.validBundleIdExists(projectKey, bundleId)) {
            throw new Exception("Bundle name " + bundleId + " already exists for project " + projectKey);
        }
        this.designBundlesService.deleteEmptyBundleFolder(projectKey, bundleId);
        DesignBundlesController.writeJSON((HttpServletResponse)resp, this.designBundlesService.startExportBundleWithPreparation_NT(projectKey, bundleId, DKUApp.getInstallId(), DKUApp.getNodeId(), ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().studioExternalUrl, prepared, evaluateProjectStandardsChecks, u));
    }

    @AuditedCall(value={"msgType", "design-bundle-delete", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/design/delete-bundle"}, method={RequestMethod.POST})
    public void deleteBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        logger.infoV("Deleting bundle %s/%s", new Object[]{projectKey, bundleId});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
        }
        this.designBundlesService.deleteBundle(projectKey, bundleId);
        this.pubSub.publish((DSSEvent)new ProjectBundleDeletedEvent(projectKey, bundleId));
    }

    @AuditedCall(value={"msgType", "design-bundle-failed-delete", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/design/delete-failed-bundle"}, method={RequestMethod.POST})
    public void deleteFailedBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        logger.infoV("Deleting failed bundle %s/%s", new Object[]{projectKey, bundleId});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
        }
        this.designBundlesService.deleteFailedBundle(projectKey, bundleId);
    }

    @AuditedCall(value={"msgType", "design-bundles-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/design/list-bundles"})
    public void listBundles(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
        }
        DesignBundlesController.writeJSON((HttpServletResponse)resp, (Object)this.designBundlesService.listAvailable(projectKey));
    }

    @AuditedCall(value={"msgType", "design-bundle-get", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/design/get-bundle-details"})
    public void getBundleDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
        }
        DesignBundlesController.writeJSON((HttpServletResponse)resp, (Object)this.designBundlesService.getBundleDetails(projectKey, bundleId));
    }

    private void checkProjectExportRestrictions() throws Exception {
        Params params = ApplicationConfigurator.getParams();
        if (params.getBoolParam("dku.exports.disableProjectExports", false)) {
            throw new UnauthorizedException("Project exports have been forbidden by your administrator", "project-export-forbidden");
        }
    }

    @AuditedCall(value={"msgType", "design-bundle-governance-status-get", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/design/get-governance-status"})
    public void getGovernanceStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
        }
        DSSBundleIdentifier dssBundleIdentifier = this.governIntegrationService.buildDSSDesignBundleIdentifier(bundleId, projectKey);
        DSSItemIdentifierList dssItemIdentifierList = new DSSItemIdentifierList();
        dssItemIdentifierList.dssItemItentifiers.add(dssBundleIdentifier);
        DSSItemGovernanceStatusList dssItemGovernanceStatusList = this.governIntegrationService.getDSSItemsGovernanceStatus(dssItemIdentifierList);
        if (dssItemGovernanceStatusList.dssItemGovernanceStatuses.isEmpty()) {
            throw new IllegalStateException("Unexpected error: cannot retrieve governance status for bundle:" + bundleId);
        }
        DesignBundlesController.writeJSON((HttpServletResponse)resp, dssItemGovernanceStatusList.dssItemGovernanceStatuses.get(0));
    }

    @AuditedCall(value={"msgType", "design-bundle-download", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/design/download-bundle"})
    public void downloadBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        this.checkProjectExportRestrictions();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
        }
        File f = this.designBundlesService.getBundleArchive(projectKey, bundleId);
        HTTPClientUtils.sendArchiveDownload((File)f, (HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "publish-to-deployer", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/design/publish-to-project-deployer"}, method={RequestMethod.POST})
    public void publishBundleToProjectDeployer(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId, @RequestParam String publishedProjectKey) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(user, projectKey);
            this.publishedProjectsService.checkCreatePermission(user);
        }
        DesignBundlesController.writeJSON((HttpServletResponse)resp, (Object)this.designBundlesService.publishBundle(projectKey, publishedProjectKey, bundleId, user));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/design/get-bundle-exporter-settings"})
    public void getBundleExporterSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
            DesignBundlesController.writeJSON((HttpServletResponse)resp, (Object)this.designBundlesService.getBundleExporterSettings(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "design-bundles-save-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/design/save-bundle-exporter-settings"}, method={RequestMethod.POST})
    public void saveActivationSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String settings) throws Exception {
        BundleExporterSettings bcs = (BundleExporterSettings)JSON.parse((String)settings, BundleExporterSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
            this.designBundlesService.saveBundleExporterSettings(projectKey, bcs);
            t.commit("Updated bundle exporter settings");
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/design/check-bundle-reversion"})
    public void checkBundleReversion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        logger.info((Object)("Checking reversion of bundle " + projectKey + " / " + bundleId));
        AuthCtx user = null;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(user, projectKey);
        }
        DesignBundlesController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.designBundlesService.checkBundleActivation(user, projectKey, bundleId, true)));
    }

    @AuditedCall(value={"msgType", "design-bundle-revert", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/design/revert-bundle"})
    public void revertBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId, @RequestParam String importOptions) throws Exception {
        logger.info((Object)("Reverting bundle " + projectKey + " / " + bundleId));
        AbstractBundleService.BundleActivationOptions options = (AbstractBundleService.BundleActivationOptions)JSON.parse((String)importOptions, AbstractBundleService.BundleActivationOptions.class);
        AuthCtx user = null;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(user, projectKey);
        }
        DesignBundlesController.writeJSON((HttpServletResponse)resp, this.designBundlesService.startActivateBundle_NT(user, projectKey, bundleId, options));
    }
}

