/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.featurestore.FeatureGroupDetails;
import com.dataiku.dip.featurestore.FeatureStoreService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.IndexNotBuiltException;
import com.dataiku.dip.server.services.catalog.IndexingDisabledException;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/feature-store"})
public class FeatureStoreController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private FeatureStoreService featureStoreService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private DatasetsDAO datasetsDAO;

    @AuditedCall(value={"msgType", "set-as-feature-group", "projectKey", "${projectKey}", "name", "${name}", "isFeatureGroup", "${isFeatureGroup}"})
    @RequestMapping(value={"/feature-groups/set"}, method={RequestMethod.POST})
    public void setAsFeatureGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam boolean isFeatureGroup) throws Exception {
        SerializedDataset sds;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!user.getPermissions().mayManageFeatureStore()) {
                throw new SecurityException("You may not (un)set a dataset as a feature group");
            }
            sds = this.datasetAccessService.getMandatory(projectKey, name).getModel();
        }
        t = this.transactionService.beginWriteForUI(req);
        try {
            sds.featureGroup = isFeatureGroup;
            this.datasetSaveService.save(sds.projectKey, sds.name, sds, t.getUser());
            t.commit("Changed featureGroup state for dataset " + sds.getFullName() + "to " + isFeatureGroup);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "list-feature-groups", "query", "${query}", "facets", "${facets}"})
    @RequestMapping(value={"/feature-groups/search"}, method={RequestMethod.POST})
    public void searchFeatureGroups(HttpServletRequest req, HttpServletResponse resp, @RequestParam String query, @RequestParam String facets, @Nullable String explainDocId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        Map facetMap = (Map)JSON.parse((String)facets, (TypeToken)new TypeToken<Map<String, List<String>>>(){});
        if (!facetMap.containsKey("scope")) {
            facetMap.put("scope", Lists.newArrayList((Object[])new String[]{"dss"}));
        }
        facetMap.put("_type", Lists.newArrayList((Object[])new String[]{"feature_group"}));
        try {
            LuceneResponseWrapper resultsLucene = this.featureStoreService.searchFeatureGroups(query, facetMap, user, explainDocId);
            FeatureStoreController.writeJSONString((HttpServletResponse)resp, (String)resultsLucene.serializeHits());
        }
        catch (IndexNotBuiltException inbe) {
            FeatureStoreController.sendErrorExplicit((int)503, (String)"NotReady", (String)"Feature store is not ready yet (indexing)", (HttpServletResponse)resp);
        }
        catch (IndexingDisabledException cde) {
            FeatureStoreController.sendErrorExplicit((int)503, (String)"Disabled", (String)"Indexing is disabled", (HttpServletResponse)resp);
        }
    }

    @AuditedCall(value={"msgType", "list-features", "query", "${query}", "facets", "${facets}"})
    @RequestMapping(value={"/features/search"}, method={RequestMethod.POST})
    public void searchFeatures(HttpServletRequest req, HttpServletResponse resp, @RequestParam String query, @RequestParam String facets, @Nullable String explainDocId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        Map facetMap = (Map)JSON.parse((String)facets, (TypeToken)new TypeToken<Map<String, List<String>>>(){});
        if (!facetMap.containsKey("scope")) {
            facetMap.put("scope", Lists.newArrayList((Object[])new String[]{"dss"}));
        }
        facetMap.put("_type", Lists.newArrayList((Object[])new String[]{"feature"}));
        try {
            LuceneResponseWrapper resultsLucene = this.featureStoreService.searchFeatures(query, facetMap, user, explainDocId);
            FeatureStoreController.writeJSONString((HttpServletResponse)resp, (String)resultsLucene.serializeHits());
        }
        catch (IndexNotBuiltException inbe) {
            FeatureStoreController.sendErrorExplicit((int)503, (String)"NotReady", (String)"Feature store is not ready yet (indexing)", (HttpServletResponse)resp);
        }
        catch (IndexingDisabledException cde) {
            FeatureStoreController.sendErrorExplicit((int)503, (String)"Disabled", (String)"Indexing is disabled", (HttpServletResponse)resp);
        }
    }

    @AuditedCall(value={"msgType", "get-feature-group-details", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/feature-groups/details"}, method={RequestMethod.GET})
    public void getDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        NavigatorService.DatasetFullInfo info;
        SerializedDataset sd;
        FeatureGroupDetails details;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            AnyLoc loc = new AnyLoc(projectKey, datasetName);
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(user, loc);
            details = this.featureStoreService.getDetails(user, projectKey, datasetName);
            sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc);
            info = this.navigatorService.getDatasetFullInfo(loc, projectKey, user, sd);
        }
        this.navigatorService.addDatasetInfo_NT(info, sd);
        this.navigatorService.addInfo_NT(info, user);
        details.setDatasetFullInfo(info);
        FeatureStoreController.writeJSON((HttpServletResponse)resp, (Object)details);
    }
}

