/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.datasets.inline.InlineDatasetConfig;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.FileUploadService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartResolver;

@Controller
public class FileUploadController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private FileUploadService manager;
    @Autowired
    private MultipartResolver resolver;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private AuditTrailService auditTrailService;
    private static Logger logger = Logger.getLogger((String)"dip.controllers.datasets.upload");

    @AuditInline
    @RequestMapping(value={"/api/datasets/upload/create-upload-box"}, method={RequestMethod.POST})
    public void createUploadBox(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            String id = this.manager.newUploadBox();
            logger.info((Object)("Created upload box " + id));
            FileUploadController.writeJSON((HttpServletResponse)resp, (Object)CollectionUtils.appendableSSMap().put("id", id).get());
            this.auditTrailService.generic("dataset-upload-create-uploadbox").with("uploadBoxId", id).emit();
        }
    }

    @AuditedCall(value={"msgType", "dataset-upload-delete-uploadbox", "uploadBoxId", "${uploadBoxId}"})
    @RequestMapping(value={"/api/datasets/upload/delete-upload-box"})
    public void deleteUploadBox(HttpServletRequest req, HttpServletResponse resp, @RequestParam String uploadBoxId) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            FileUploadService.deleteUploadBox(uploadBoxId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "dataset-upload-list-files", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/upload/list-files"})
    public void listFiles(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        List<FileUploadService.UploadedFile> files;
        UploadedFilesDatasetHandler dh;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedDataset sds = (SerializedDataset)this.dao.getMandatoryUnsafe(projectKey, datasetName);
            dh = "UploadedFiles".equals(sds.type) ? (UploadedFilesDatasetHandler)DatasetHandlerFactory.build(authCtx, Dataset.fromSerialized(sds)) : null;
        }
        try {
            files = dh != null ? this.manager.listFilesInDataset(dh) : this.manager.listFilesInDataset(projectKey, datasetName);
        }
        finally {
            if (dh != null) {
                dh.close();
            }
        }
        Collections.sort(files, new Comparator<FileUploadService.UploadedFile>(){

            @Override
            public int compare(FileUploadService.UploadedFile a, FileUploadService.UploadedFile b) {
                return a.path.compareTo(b.path);
            }
        });
        FileUploadController.writeJSON((HttpServletResponse)resp, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/upload/add-file"}, method={RequestMethod.POST})
    public void addFileAuto(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="file") MultipartFile filePart, @RequestParam(value="dataset") String datasetStr) throws Exception {
        Dataset si;
        AuthCtx authCtx;
        String uploadBoxId = null;
        UploadedFilesDatasetHandler dh = null;
        boolean mustClearCache = false;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedDataset sds = (SerializedDataset)JSON.parse((String)datasetStr, SerializedDataset.class);
            this.checkConnection(sds, authCtx);
            if (sds.name == null) {
                si = Dataset.fromSerialized("fake.test-dataset", sds);
                if (!si.getType().equals("UploadedFiles") && !si.getType().equals("Inline")) {
                    throw ErrorContext.iaef((String)"Dataset type (%s) does not allow uploaded files", (Object)si.getType(), (Object[])new Object[0]);
                }
                if (si.getParams() instanceof BuiltinFSDatasets.UploadedFilesConfig) {
                    uploadBoxId = si.getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class).uploadBoxId;
                } else if (si.getParams() instanceof InlineDatasetConfig) {
                    uploadBoxId = si.getParamsAs(InlineDatasetConfig.class).uploadBoxId;
                } else {
                    throw ErrorContext.iaef((String)"Dataset type (%s) does not allow uploaded files", (Object)si.getType(), (Object[])new Object[0]);
                }
                if (uploadBoxId == null) {
                    throw ErrorContext.iae((String)"No 'uploadBoxId' parameter in dataset");
                }
            } else {
                this.dao.getMandatoryUnsafe(projectKey, sds.name);
                si = Dataset.fromSerialized(sds);
                if (!si.getType().equals("UploadedFiles") && !si.getType().equals("Inline")) {
                    throw ErrorContext.iaef((String)"Dataset type (%s) does not allow uploaded files", (Object)si.getType(), (Object[])new Object[0]);
                }
                dh = "UploadedFiles".equals(sds.type) ? (UploadedFilesDatasetHandler)DatasetHandlerFactory.build(authCtx, Dataset.fromSerialized(sds)) : null;
                mustClearCache = true;
            }
        }
        if (mustClearCache) {
            this.datasetDeletionService.clearCache_NT(si);
        }
        try {
            if (uploadBoxId == null && dh == null) {
                logger.info((Object)("Uploading file " + filePart.getOriginalFilename() + " to dataset " + si.getName()));
                FileUploadController.writeJSON((HttpServletResponse)resp, (Object)this.manager.addFileToDataset(projectKey, si.getName(), filePart.getInputStream(), filePart.getOriginalFilename()));
                this.auditTrailService.generic("dataset-upload-add-file").with("projectKey", projectKey).with("datasetName", si.getName()).with("filename", filePart.getOriginalFilename()).emit();
            } else if (uploadBoxId == null && dh != null) {
                logger.info((Object)("Uploading file " + filePart.getOriginalFilename() + " to dataset " + si.getName()));
                FileUploadController.writeJSON((HttpServletResponse)resp, (Object)this.manager.addFileToDataset(authCtx, dh, filePart.getInputStream(), filePart.getOriginalFilename()));
                this.auditTrailService.generic("dataset-upload-add-file").with("projectKey", projectKey).with("datasetName", si.getName()).with("filename", filePart.getOriginalFilename()).emit();
            } else {
                logger.info((Object)("Uploading file " + filePart.getOriginalFilename() + " to upload box " + uploadBoxId));
                FileUploadController.writeJSON((HttpServletResponse)resp, (Object)this.manager.addFileToUploadBox(uploadBoxId, filePart.getInputStream(), filePart.getOriginalFilename()));
                this.auditTrailService.generic("dataset-upload-add-file-uploadbox").with("uploadBoxId", uploadBoxId).with("filename", filePart.getOriginalFilename()).emit();
            }
        }
        finally {
            if (dh != null) {
                dh.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/upload/remove-file"}, method={RequestMethod.POST})
    public void removeFileAuto(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="dataset") String datasetStr, @RequestParam(value="fileName") String fileName) throws Exception {
        Dataset si;
        String uploadBoxId = null;
        UploadedFilesDatasetHandler dh = null;
        boolean mustClearCache = false;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedDataset sds = (SerializedDataset)JSON.parse((String)datasetStr, SerializedDataset.class);
            this.checkConnection(sds, authCtx);
            if (sds.name == null) {
                si = Dataset.fromSerialized("fake.test-dataset", sds);
                if (si.getType().equals("UploadedFiles")) {
                    uploadBoxId = si.getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class).uploadBoxId;
                } else if (si.getType().equals("Inline")) {
                    uploadBoxId = si.getParamsAs(InlineDatasetConfig.class).uploadBoxId;
                } else {
                    throw ErrorContext.iaef((String)"Dataset type (%s) does not allow uploaded files", (Object)si.getType(), (Object[])new Object[0]);
                }
                if (uploadBoxId == null) {
                    throw ErrorContext.iae((String)"No 'uploadBoxId' parameter in dataset");
                }
            } else {
                this.dao.getMandatoryUnsafe(projectKey, sds.name);
                si = Dataset.fromSerialized(sds);
                if (!si.getType().equals("UploadedFiles") && !si.getType().equals("Inline")) {
                    throw ErrorContext.iaef((String)"Dataset type (%s) does not allow uploaded files", (Object)si.getType(), (Object[])new Object[0]);
                }
                dh = "UploadedFiles".equals(sds.type) ? (UploadedFilesDatasetHandler)DatasetHandlerFactory.build(authCtx, Dataset.fromSerialized(sds)) : null;
                mustClearCache = true;
            }
        }
        if (mustClearCache) {
            this.datasetDeletionService.clearCache_NT(si);
        }
        try {
            if (uploadBoxId == null && dh == null) {
                logger.info((Object)("Removing file " + fileName + " from dataset " + si.getName()));
                this.manager.removeFileFromDataset(projectKey, si.getName(), fileName);
                this.auditTrailService.generic("dataset-upload-remove-file").with("projectKey", projectKey).with("datasetName", si.getName()).with("filename", fileName).emit();
            } else if (uploadBoxId == null && dh != null) {
                logger.info((Object)("Removing file " + fileName + " from dataset " + si.getName()));
                this.manager.removeFileFromDataset(dh, fileName);
                this.auditTrailService.generic("dataset-upload-remove-file").with("projectKey", projectKey).with("datasetName", si.getName()).with("filename", fileName).emit();
            } else {
                logger.info((Object)("Removing file " + fileName + " from upload box " + uploadBoxId));
                this.manager.removeFileFromUploadBox(uploadBoxId, fileName);
                this.auditTrailService.generic("dataset-upload-remove-file-uploadbox").with("uploadBoxId", uploadBoxId).with("filename", fileName).emit();
            }
        }
        finally {
            if (dh != null) {
                dh.close();
            }
        }
    }

    private void checkConnection(SerializedDataset sds, AuthCtx authCtx) throws Exception {
        if (sds.getParams().getConnection() != null) {
            this.connectionsService.checkUserForConnection(authCtx, sds.getParams().getConnection());
        }
    }
}

