/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class GlobalTagsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private UIAuthService authService;

    @AuditedCall(value={"msgType", "admin-global-tags-info"})
    @RequestMapping(value={"/api/global-tags/get-global-tags-info"})
    public void getGlobalTagsInfo(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        List<GeneralSettingsDAO.GlobalTagCategory> globalTagsCategories;
        GlobalTagsInfo globalTagsInfo = new GlobalTagsInfo();
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            globalTagsCategories = this.generalSettingsService.read().globalTagsCategories;
        }
        for (GeneralSettingsDAO.GlobalTagCategory category : globalTagsCategories) {
            globalTagsInfo.globalTagsCategories.put(category.name, category.appliesTo);
            for (GeneralSettingsDAO.GlobalTag tagInfo : category.globalTags) {
                String tagFullName = category.name + ":" + tagInfo.name;
                globalTagsInfo.globalTags.put(tagFullName, new GlobalTagInfo(category.name, tagFullName, tagInfo.color));
            }
        }
        GlobalTagsController.writeJSON((HttpServletResponse)resp, (Object)globalTagsInfo);
    }

    @AuditedCall(value={"msgType", "admin-update-global-tags"})
    @RequestMapping(value={"/api/admin/global-tags/update-global-tags"})
    public void updateGlobalTags(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        AuthCtx user;
        List<String> projectKeys;
        try (Transaction t = this.transactionService.beginRead();){
            projectKeys = this.projectsService.listProjectKeys();
            user = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        Map globalTags = (Map)JSON.gson().fromJson(data, new TypeToken<Map<String, TaggingService.GlobalTagUpdate>>(){}.getType());
        for (String projectKey : projectKeys) {
            RWTransaction t = this.transactionService.beginWriteForUI(req);
            try {
                this.taggingService.updateGlobalTags(projectKey, globalTags, user);
                t.commit("Updated global tags for project : " + projectKey);
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
    }

    public static class GlobalTagsInfo {
        public Map<String, List<ITaggingService.TaggableType>> globalTagsCategories = new HashMap<String, List<ITaggingService.TaggableType>>();
        public Map<String, GlobalTagInfo> globalTags = new HashMap<String, GlobalTagInfo>();
    }

    public static class GlobalTagInfo {
        public String globalTagsCategory;
        public String name;
        public String color;

        public GlobalTagInfo(String category, String name, String color) {
            this.globalTagsCategory = category;
            this.name = name;
            this.color = color;
        }
    }
}

