/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.aigenerations.SQLAssistantService;
import com.dataiku.dip.aigenerations.SqlAssistantConversation;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class SQLNotebooksAssistantController {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private SQLAssistantService sqlAssistantService;
    @Autowired
    private DatasetsDAO datasetsDAO;

    @AuditedCall(value={"msgType", "sql-assistant-answer", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/sql-assistant/conversation/{projectKey}/{notebookId}/{cellId}/answer"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<SQLAssistantService.SQLAssistantAnswer> sqlAssistantAnswer(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String notebookId, @PathVariable String cellId, @RequestParam String userMessage, @RequestParam String connectionName, @RequestParam(required=false) String currentQuery, @RequestParam(required=false) SQLAssistantService.SQLErrorContext currentSqlErrorContext, @RequestParam(required=false) String conversationId, @RequestParam(required=false) List<SqlAssistantConversation.SelectedTable> selectedTables, @RequestParam(required=false) SqlAssistantConversation.TableListingMode tableListingMode) throws Exception {
        List<SerializedDataset> datasets;
        AbstractSQLConnection sqlConnection;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(liu, connectionName);
            if (!conn.isFreelyUsableBy(liu)) {
                throw new SecurityException("You may not list tables on connection " + connectionName);
            }
            this.sqlAssistantService.checkUserCanUseSQLAssistant();
            sqlConnection = SQLConnectionProvider.getDSSConnection(liu, connectionName);
            datasets = this.datasetsDAO.list(projectKey);
        }
        return this.sqlAssistantService.computeAnswer(liu, userMessage, currentQuery, currentSqlErrorContext, sqlConnection, SQLAssistantService.RequestOrigin.SQL_NOTEBOOK, projectKey, notebookId, cellId, conversationId, datasets, selectedTables, tableListingMode);
    }

    @AuditedCall(value={"msgType", "sql-assistant-get-conversation", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/sql-assistant/conversation/{projectKey}/{notebookId}/{cellId}"}, method={RequestMethod.GET})
    @ResponseBody
    public SqlAssistantConversation.QueryConversation getSqlAssistantConversation(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String notebookId, @PathVariable String cellId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.sqlAssistantService.checkUserCanUseSQLAssistant();
        }
        return this.sqlAssistantService.getConversation(projectKey, notebookId, cellId, authCtx);
    }

    @AuditedCall(value={"msgType", "sql-assistant-delete-conversation", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/sql-assistant/conversation/{projectKey}/{notebookId}/{cellId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteSqlAssistantConversation(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String notebookId, @PathVariable String cellId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.sqlAssistantService.checkUserCanUseSQLAssistant();
        }
        this.sqlAssistantService.deleteConversation(projectKey, notebookId, cellId, authCtx);
    }
}

