/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SanityCheckDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.sanitycheck.SanityCheckService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SanityCheckController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private SanityCheckService sanityCheckService;
    @Autowired
    private GeneralSettingsService generalSettingsService;

    @AuditedCall(value={"msgType", "admin-sanity-check-run"})
    @RequestMapping(value={"/api/admin/sanity-check/run"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> run(HttpServletRequest req, @RequestParam Set<String> exclusionList) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(user);
        }
        t = this.transactionService.beginWriteAsLoggedInUser(user);
        try {
            GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsService.read();
            gs.sanityCheckExclusionList = exclusionList;
            this.generalSettingsService.save(user, gs);
            t.commit("Save sanity check exclusions");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        return this.sanityCheckService.run(user, exclusionList);
    }

    @AuditedCall(value={"msgType", "admin-sanity-check-get-codes"})
    @RequestMapping(value={"/api/admin/sanity-check/codes"})
    @ResponseBody
    public List<Map<String, String>> getCodes(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
        }
        List codes = this.sanityCheckService.getCodes();
        return codes.stream().map(code -> ImmutableMap.of((Object)"label", (Object)code.getCodeTitle(), (Object)"value", (Object)code.getCode())).collect(Collectors.toList());
    }

    @AuditedCall(value={"msgType", "admin-sanity-check-get-exclusions"})
    @RequestMapping(value={"/api/admin/sanity-check/exclusions"})
    @ResponseBody
    public Set<String> getExclusions(HttpServletRequest req) throws Exception {
        Set<String> exclusions;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
            exclusions = this.generalSettingsService.read().sanityCheckExclusionList;
        }
        return exclusions;
    }

    @AuditedCall(value={"msgType", "admin-sanity-check-get-latest-run"})
    @RequestMapping(value={"/api/admin/sanity-check/latest-run"})
    @ResponseBody
    public Map<String, Object> getLatestRun(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
        }
        SanityCheckDAO.SanityCheckFile latestRun = this.sanityCheckService.getLatestRun();
        return ImmutableMap.of((Object)"analysisResult", (Object)latestRun.report, (Object)"epochTimestamp", (Object)latestRun.lastRunTimestamp);
    }

    @AuditedCall(value={"msgType", "admin-sanity-check-get-running-job"})
    @RequestMapping(value={"/api/admin/sanity-check/running-job"})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> getRunningJob(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
        }
        return this.sanityCheckService.runningJob;
    }
}

