/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.scheduler.scenarios.ProjectRunsSummary;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ScenarioReportsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ScenarioReportsController
extends DIPInternalControllerBase {
    @Autowired
    ProjectsService projectsService;
    @Autowired
    UIAuthService authService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    ScenarioReportsService scenarioReportsService;
    @Autowired
    ScenariosService scenariosService;
    private static final Logger logger = Logger.getLogger((String)"dip.controllers.scenario.reports");

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/get-scenario-report"})
    @ResponseBody
    public ScenarioReportsService.ScenarioGantt getScenarioReport(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam(value="fromDate") String fromDateStr, @RequestParam(value="toDate") String toDateStr) throws Exception {
        DateTime fromDate;
        DateTime toDate;
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SCENARIO, scenarioId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
            DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
            toDate = parser.parseDateTime(toDateStr);
            fromDate = parser.parseDateTime(fromDateStr);
            this.scenariosService.getMandatoryUnsafe(ref.getProjectKey(projectKey), ref.objectId);
        }
        Callable<ScenarioReportsService.ScenarioGantt> reportCallable = this.scenarioReportsService.getRunsReport(ref.objectId, fromDate, toDate, ref.getProjectKey(projectKey));
        try (Transaction t = this.transactionService.beginRead();){
            ScenarioReportsService.ScenarioGantt scenarioGantt = reportCallable.call();
            return scenarioGantt;
        }
    }

    @AuditedCall(value={"msgType", "scenarios-get-history", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/scenarios/get-project-report"})
    @ResponseBody
    public ScenarioReportsService.ScenarioGantt getProjectReport(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(value="fromDate") String fromDateStr, @RequestParam(value="toDate") String toDateStr) throws Exception {
        DateTime fromDate;
        DateTime toDate;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
            toDate = parser.parseDateTime(toDateStr);
            fromDate = parser.parseDateTime(fromDateStr);
            logger.info((Object)("Collecting infos for scenarios in the time range " + fromDateStr + " / " + toDateStr));
        }
        Callable<ScenarioReportsService.ScenarioGantt> reportCallable = this.scenarioReportsService.getRunsReport(null, fromDate, toDate, projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            ScenarioReportsService.ScenarioGantt scenarioGantt = reportCallable.call();
            return scenarioGantt;
        }
    }

    @AuditedCall(value={"msgType", "scenarios-get-history"})
    @RequestMapping(value={"/api/scenarios/get-instance-report"})
    @ResponseBody
    public ScenarioReportsService.ScenarioGantt getInstanceReport(HttpServletRequest req, @RequestParam(value="fromDate") String fromDateStr, @RequestParam(value="toDate") String toDateStr) throws Exception {
        DateTime fromDate;
        DateTime toDate;
        String[] projectKeys;
        try (Transaction t = this.transactionService.beginRead();){
            List<ProjectsService.UIProject> summaries = this.projectsService.listAccessibleUnsafe(this.authService.getMandatoryUser(req), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            projectKeys = new String[summaries.size()];
            int i = 0;
            for (ProjectsService.UIProject summary : summaries) {
                projectKeys[i++] = summary.projectKey;
            }
            DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
            toDate = parser.parseDateTime(toDateStr);
            fromDate = parser.parseDateTime(fromDateStr);
            logger.info((Object)("Collecting infos for scenarios in the time range " + fromDateStr + " / " + toDateStr));
        }
        Callable<ScenarioReportsService.ScenarioGantt> reportCallable = this.scenarioReportsService.getRunsReport(null, fromDate, toDate, projectKeys);
        try (Transaction t = this.transactionService.beginRead();){
            ScenarioReportsService.ScenarioGantt scenarioGantt = reportCallable.call();
            return scenarioGantt;
        }
    }

    @AuditedCall(value={"msgType", "scenarios-get-history", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/scenarios/get-project-activities"})
    @ResponseBody
    public ScenarioReportsService.ScenarioActivity getProjectActivities(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(value="fromDate") String fromDateStr, @RequestParam(value="toDate") String toDateStr) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
            DateTime toDate = parser.parseDateTime(toDateStr);
            DateTime fromDate = parser.parseDateTime(fromDateStr);
            logger.info((Object)("Collecting infos for scenarios in the time range " + fromDateStr + " / " + toDateStr));
            ScenarioReportsService.ScenarioActivity scenarioActivity = this.scenarioReportsService.getActivitiesReport(projectKey, null, fromDate, toDate);
            return scenarioActivity;
        }
    }

    private OutcomesFromTo parseAndLogGetOutcomesParams(String fromDateStr, String toDateStr) {
        logger.info((Object)("Date range sent  " + fromDateStr + " " + toDateStr));
        OutcomesFromTo ret = new OutcomesFromTo();
        DateTimeFormatter parser = ISODateTimeFormat.dateParser();
        ret.from = parser.parseDateTime(fromDateStr);
        ret.to = parser.parseDateTime(toDateStr);
        logger.info((Object)("Date range       " + ret.from.getMillis() + " " + ret.to.getMillis()));
        logger.info((Object)("Date range (utc) " + DKUtils.isoFormatReadableByDateFormat((long)ret.from.getMillis()) + " " + DKUtils.isoFormatReadableByDateFormat((long)ret.to.getMillis())));
        logger.info((Object)("Collecting infos for scenarios in the time range " + fromDateStr + " / " + toDateStr));
        return ret;
    }

    @AuditedCall(value={"msgType", "scenarios-get-history", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/scenarios/get-outcomes-summary"})
    @ResponseBody
    public ProjectRunsSummary getOutcomesSummary(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(value="fromDate") String fromDateStr, @RequestParam(value="toDate") String toDateStr) throws Exception {
        List<Scenario> scenarios;
        OutcomesFromTo oft = this.parseAndLogGetOutcomesParams(fromDateStr, toDateStr);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            scenarios = this.scenariosService.listUnsafe(projectKey);
        }
        return this.scenarioReportsService.getSummaryDayReport_NT(projectKey, oft.from, oft.to, scenarios);
    }

    @AuditedCall(value={"msgType", "scenarios-get-history", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/scenarios/get-outcomes"})
    @ResponseBody
    public ScenarioReportsService.ScenarioDays getOutcomes(HttpServletRequest req, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String scenarioId, @RequestParam(value="fromDate") String fromDateStr, @RequestParam(value="toDate") String toDateStr, @RequestParam(required=false, defaultValue="false") boolean includeOutOfDatesScenarios) throws Exception {
        OutcomesFromTo oft = this.parseAndLogGetOutcomesParams(fromDateStr, toDateStr);
        ArrayList scenarios = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            if (StringUtils.isNotBlank((String)projectKey) && StringUtils.isNotBlank((String)scenarioId)) {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                scenarios.add(this.scenariosService.getMandatoryUnsafe(projectKey, scenarioId));
            } else if (StringUtils.isNotBlank((String)projectKey) && StringUtils.isBlank((String)scenarioId)) {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                scenarios.addAll(this.scenariosService.listUnsafe(projectKey));
            } else {
                List<ProjectsService.UIProject> summaries = this.projectsService.listAccessibleUnsafe(this.authService.getMandatoryUser(req), Privileges.ProjectLevelPrivilegeType.READ_CONF);
                for (ProjectsService.UIProject summary : summaries) {
                    scenarios.addAll(this.scenariosService.listUnsafe(summary.projectKey));
                }
            }
        }
        return this.scenarioReportsService.getDayReport_NT(oft.from, oft.to, scenarios, includeOutOfDatesScenarios);
    }

    @AuditedCall(value={"msgType", "scenarios-get-history", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/scenarios/get-outcomes-details"})
    @ResponseBody
    public ScenarioReportsService.ScenarioDayRuns getOutcomesDetails(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam(value="date") String dateStr) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            logger.info((Object)("Details for date " + dateStr));
            DateTimeFormatter parser = ISODateTimeFormat.dateParser();
            DateTime date = parser.parseDateTime(dateStr);
            logger.info((Object)("Date       " + date.getMillis()));
            logger.info((Object)("Date (utc) " + DKUtils.isoFormatReadableByDateFormat((long)date.getMillis())));
            logger.info((Object)("Collecting details for scenario on day " + dateStr));
            ScenarioReportsService.ScenarioDayRuns scenarioDayRuns = this.scenarioReportsService.getDayReportDetails(projectKey, scenarioId, date);
            return scenarioDayRuns;
        }
    }

    private static class OutcomesFromTo {
        public DateTime from;
        public DateTime to;

        private OutcomesFromTo() {
        }
    }
}

