/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.docgen.ModelDocumentGenerationService;
import com.dataiku.dip.analysis.docgen.helpers.DesignDiffCheckUtil;
import com.dataiku.dip.analysis.docgen.model.DocumentGenerationResponse;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.PredictionKFoldMetricsReader;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesService;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.ResultsReaderBase;
import com.dataiku.dip.analysis.ml.timeseries.TimeseriesInteractiveScoringService;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.SavedModelOriginInfo;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.CoefPath;
import com.dataiku.dip.analysis.model.prediction.ColumnImportance;
import com.dataiku.dip.analysis.model.prediction.DecisionTreeSummary;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PerTimeSeriesMetrics;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanations;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanationsFacts;
import com.dataiku.dip.analysis.model.prediction.PredictionIndividualExplanations;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionModelFeaturesDistribution;
import com.dataiku.dip.analysis.model.prediction.PredictionSubpopulation;
import com.dataiku.dip.analysis.model.prediction.ResolvedCausalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.analysis.model.prediction.TimeseriesInteractiveScoringScenarios;
import com.dataiku.dip.analysis.model.prediction.TimeseriesPredictionPermutationImportance;
import com.dataiku.dip.analysis.model.prediction.TimeseriesResiduals;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsKernelProtocol;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scoring.exports.ExportAndRegisterMLflowModelInFutureThread;
import com.dataiku.dip.scoring.exports.JarScoring;
import com.dataiku.dip.scoring.exports.MLflowScoring;
import com.dataiku.dip.scoring.exports.PMMLScoring;
import com.dataiku.dip.scoring.exports.PythonScoring;
import com.dataiku.dip.scoring.exports.SQLScoring;
import com.dataiku.dip.scoring.exports.ScoringExporter;
import com.dataiku.dip.scoring.exports.ScoringModelExportThread;
import com.dataiku.dip.scoring.exports.snowflake.SnowflakePermanentFunctionExportThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.CallUsedByDashboard;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class MLPredictionController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PredictionRecipesService predictionRecipesService;
    @Autowired
    private PredictionService predictionService;
    @Autowired
    private TimeseriesInteractiveScoringService timeseriesInteractiveScoringService;
    @Autowired
    private GenericRecipesValidationService validationService;
    @Autowired
    private SavedModelsCRUDService smService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ModelDocumentGenerationService modelDocumentGenerationService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private ConnectionsService connectionsService;
    private static Logger logger = Logger.getLogger((String)"dku.prediction.controller");

    private FullModelId unsmartifyAndCheck(HttpServletRequest req, FullModelId fmi) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            if (fmi.getType() == FullModelId.Type.SAVED) {
                SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SAVED_MODEL, fmi.getSavedModelID());
                this.projectsService.failIfNoDashboardReadPermission(req, smartObjectRef, fmi.getProjectKey());
                if (!fmi.isModelPartition()) {
                    FullModelId fullModelId = new FullModelId(smartObjectRef.getProjectKey(fmi.getProjectKey()), smartObjectRef.objectId, fmi.getSavedModelVersionID());
                    return fullModelId;
                }
                FullModelId fullModelId = new FullModelId(smartObjectRef.getProjectKey(fmi.getProjectKey()), smartObjectRef.objectId, fmi.getSavedModelVersionID(), fmi.getPartitionName(), fmi.getPartitionVersion());
                return fullModelId;
            }
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            FullModelId fullModelId = fmi;
            return fullModelId;
        }
    }

    private FullModelId assertTimeseriesInteractiveScoringSupported(HttpServletRequest req, String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        TimeseriesForecastingModelDetails modelDetails = (TimeseriesForecastingModelDetails)PredictionResultsReader.makeModelDetails(fmi);
        if (!modelDetails.supportsExternalFeatures()) {
            throw new IllegalArgumentException("Interactive scoring only supports timeseries models using external features.");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return fmi;
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-kfold-perf-metrics", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-kfold-perf-metrics"})
    public void getPerFoldMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        if (!fmi.exists()) {
            throw new NotFoundException("Model does not exist: " + String.valueOf(fmi));
        }
        try {
            MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)PredictionKFoldMetricsReader.getPerFoldMetrics(fmi));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)"Could not locate per-fold metrics", (Throwable)e);
            resp.setStatus(404);
            resp.getWriter().write("Could not locate per-fold metrics");
        }
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-details", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-model-details"})
    public void getPredictionModelDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam(required=false) String treatment) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        if (!fmi.exists()) {
            throw new NotFoundException("Model does not exist: " + String.valueOf(fmi));
        }
        PredictionModelDetails details = treatment != null ? PredictionResultsReader.makeCausalPredictionDetails(fmi, treatment, (ResolvedCausalPredictionCoreParams)fmi.getResolvedCoreParams()) : PredictionResultsReader.makeModelDetails(fmi);
        if (fmi.getHeadMLTask() instanceof PredictionMLTask.ClassicalPredictionMLTask) {
            PredictionMLTask.ClassicalPredictionMLTask cpmlt = (PredictionMLTask.ClassicalPredictionMLTask)fmi.getHeadMLTask();
            if (fmi.isExternalMLflowModelVersion()) {
                logger.info((Object)("Setting HTC: " + JSON.log((Object)cpmlt.modeling.metrics.costMatrixWeights)));
                ((ClassicalPredictionModelDetails)details).headTaskCMW = ((ClassicalPredictionModelDetails)details).modeling.metrics.costMatrixWeights;
            } else if (cpmlt.modeling != null && cpmlt.modeling.metrics != null) {
                ((ClassicalPredictionModelDetails)details).headTaskCMW = cpmlt.modeling.metrics.costMatrixWeights;
            } else {
                logger.info((Object)"Setting DHTC");
                ((ClassicalPredictionModelDetails)details).headTaskCMW = new MetricParams.CostMatrixWeights();
            }
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)details);
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-forecasts", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-model-forecasts"})
    @ResponseBody
    public TimeseriesEvaluationForecasts getTimeseriesForecasts(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        if (!fmi.exists()) {
            throw new NotFoundException("Model does not exist: " + String.valueOf(fmi));
        }
        if (fmi.getPredictionType() != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Can only fetch forecast data for time series forecasting models");
        }
        return fmi.getTimeseriesEvaluationForecasts();
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-per-timeseries-metrics", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-per-timeseries-metrics"})
    @ResponseBody
    public PerTimeSeriesMetrics getPerTimeseriesMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        if (!fmi.exists()) {
            throw new NotFoundException("Model does not exist: " + String.valueOf(fmi));
        }
        if (fmi.getPredictionType() != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Can only fetch per time series metrics for time series forecasting models");
        }
        TimeseriesForecastingModelPerf modelPerf = fmi.getTimeseriesForecastingPerf(true);
        return new PerTimeSeriesMetrics(modelPerf);
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-information-criteria-start", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/timeseries-information-criteria-start"})
    public void informationCriteriaComputationStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, this.predictionService.retrieveTimeseriesInformationCriteria(user, fmi));
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-per-timeseries-residuals", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-per-timeseries-residuals"})
    @ResponseBody
    public Map<String, TimeseriesResiduals> getPerTimeseriesResiduals(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam List<String> timeseriesIdentifiers) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getUser(req);
        }
        Optional<Map<String, TimeseriesResiduals>> residuals = fmi.parseTimeseriesResiduals(timeseriesIdentifiers);
        if (residuals.isEmpty()) {
            resp.setStatus(404);
            resp.getWriter().write("Residuals not found");
            return null;
        }
        return residuals.get();
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-compute-per-timeseries-residuals", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/compute-per-timeseries-residuals"})
    @ResponseBody
    public void computePerTimeseriesResiduals(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, this.predictionService.computePerTimeseriesResiduals(user, fmi));
    }

    @AuditedCall(value={"msgType", "ml-create-timeseries-interactive-scoring-scenario", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/create-timeseries-interactive-scoring-scenario"})
    @ResponseBody
    public FutureResponse<TimeseriesInteractiveScoringScenarios> createTimeseriesInteractiveScoringScenario(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String timeseriesIdentifier, @RequestParam(required=false) String startDate, @RequestParam(required=false) String scenarioId, @RequestParam(required=false) String scenarioName) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = this.assertTimeseriesInteractiveScoringSupported(req, fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        JsonObject params = new JsonObject();
        params.addProperty("timeseriesIdentifier", timeseriesIdentifier);
        if (StringUtils.isNotBlank((String)startDate)) {
            params.addProperty("startDate", startDate);
        }
        if (StringUtils.isNotBlank((String)scenarioId)) {
            params.addProperty("scenarioId", scenarioId);
        }
        if (StringUtils.isNotBlank((String)scenarioName)) {
            params.addProperty("scenarioName", scenarioName);
        }
        return this.timeseriesInteractiveScoringService.createTimeseriesInteractiveScoring_NT(user, fmi, params);
    }

    @AuditedCall(value={"msgType", "ml-delete-timeseries-interactive-scoring-scenarios", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/delete-timeseries-interactive-scoring-scenario"})
    @ResponseBody
    public void deleteTimeseriesInteractiveScoringScenarios(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String scenarioId, @RequestParam String timeseriesIdentifier) throws Exception {
        FullModelId fmi = this.assertTimeseriesInteractiveScoringSupported(req, fullModelId);
        TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder isf = new TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder(fmi.getMainFolder(), fmi.getResolvedPreprocessingParams());
        isf.deleteScenario(timeseriesIdentifier, scenarioId);
    }

    @AuditedCall(value={"msgType", "ml-rename-timeseries-interactive-scoring-scenarios", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/rename-timeseries-interactive-scoring-scenario"})
    @ResponseBody
    public void renameTimeseriesInteractiveScoringScenario(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String timeseriesIdentifier, @RequestParam String scenarioId, @RequestParam String newName) throws Exception {
        FullModelId fmi = this.assertTimeseriesInteractiveScoringSupported(req, fullModelId);
        TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder isf = new TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder(fmi.getMainFolder(), fmi.getResolvedPreprocessingParams());
        isf.renameScenario(timeseriesIdentifier, scenarioId, newName);
    }

    @AuditedCall(value={"msgType", "ml-get-timeseries-interactive-scoring-scenarios", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-timeseries-interactive-scoring-scenarios"})
    @ResponseBody
    public ResponseEntity<Map<String, TimeseriesInteractiveScoringScenarios>> getTimeseriesInteractiveScoringScenarios(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.assertTimeseriesInteractiveScoringSupported(req, fullModelId);
        Optional<Map<String, TimeseriesInteractiveScoringScenarios>> scenarios = fmi.parseTimeseriesInteractiveScoringScenario();
        return scenarios.map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @AuditedCall(value={"msgType", "ml-get-timeseries-interactive-scoring-scenario", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-timeseries-interactive-scoring-scenario"})
    @ResponseBody
    public ResponseEntity<TimeseriesInteractiveScoringScenarios> getTimeseriesInteractiveScoringScenario(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String timeseriesIdentifier) throws Exception {
        FullModelId fmi = this.assertTimeseriesInteractiveScoringSupported(req, fullModelId);
        Optional<TimeseriesInteractiveScoringScenarios> scenarios = fmi.getTimeseriesInteractiveScoringScenario(timeseriesIdentifier);
        return scenarios.map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @AuditedCall(value={"msgType", "ml-update-timeseries-interactive-scoring-scenarios", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/update-timeseries-interactive-scoring-scenarios"})
    @ResponseBody
    public void updateTimeseriesInteractiveScoringScenarios(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String data) throws Exception {
        FullModelId fmi = this.assertTimeseriesInteractiveScoringSupported(req, fullModelId);
        Map scenariosByIdentifier = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, TimeseriesInteractiveScoringScenarios>>(){});
        fmi.updateTimeseriesInteractiveScoringScenarios(scenariosByIdentifier);
        resp.setStatus(204);
    }

    @AuditedCall(value={"msgType", "ml-compute-timeseries-interactive-scoring-scenarios", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/compute-timeseries-interactive-scoring-scenarios"})
    @ResponseBody
    public FutureResponse<TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts> computeInteractiveScoringScenarios(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String timeseriesIdentifier) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = this.assertTimeseriesInteractiveScoringSupported(req, fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        JsonObject computationParams = new JsonObject();
        computationParams.addProperty("timeseriesIdentifier", timeseriesIdentifier);
        return this.timeseriesInteractiveScoringService.computeTimeseriesInteractiveScoring_NT(user, fmi, computationParams);
    }

    @AuditedCall(value={"msgType", "ml-get-timeseries-interactive-scoring-scenarios-forecasts-by-identifier", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-timeseries-interactive-scoring-forecasts-by-identifier"})
    @ResponseBody
    public TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts getTimeseriesInteractiveScoringForecasts(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String timeseriesIdentifier) throws Exception {
        FullModelId fmi = this.assertTimeseriesInteractiveScoringSupported(req, fullModelId);
        try {
            TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder isf = new TimeseriesInteractiveScoringScenarios.InteractiveScenarioFolder(fmi.getMainFolder(), fmi.getResolvedPreprocessingParams());
            return isf.getScenarioForecasts(timeseriesIdentifier);
        }
        catch (IOException e) {
            logger.info((Object)e);
            return new TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts();
        }
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-features-distribution", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-features-distribution"})
    @ResponseBody
    public PredictionModelFeaturesDistribution getPredictionModelFeaturesDistribution(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        return fmi.getFeaturesDistribution();
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-collector-data", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-collector-data"})
    @ResponseBody
    public JsonObject getPredictionModelCollectorData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        if (!fmi.getCollectorDataFile().canRead()) {
            JsonObject jo = new JsonObject();
            JsonObject pf = new JsonObject();
            jo.add("per_feature", (JsonElement)pf);
            return jo;
        }
        return new JsonParser().parse((Reader)new FileReader(fmi.getCollectorDataFile())).getAsJsonObject();
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-column-importance", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-column-importance"})
    @ResponseBody
    public ColumnImportance getColumnImportance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        return fmi.getColumnImportance();
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-split-desc", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-split-desc"})
    @ResponseBody
    public SplitDesc getSplitDesc(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        if (fmi.isExternalMLflowModelVersion()) {
            MLFlowModelVersionInfo mim = fmi.getMLflowImportedModelMetadata();
            SplitDesc split = new SplitDesc();
            split.schema = new Schema();
            split.schema.columns.addAll(mim.features);
            return split;
        }
        return ResultsReaderBase.readSplitDesc(fmi);
    }

    @CallUsedByDashboard
    @AuditedCall(value={"msgType", "ml-prediction-model-get-details", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-tree-summary"})
    public void getTreeSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        try {
            DecisionTreeSummary tree = fmi.parseModelFile("tree.json", DecisionTreeSummary.class);
            MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)tree);
        }
        catch (FileNotFoundException e) {
            MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)new Object());
        }
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-details", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-ensemble-summary"})
    public void getTreeEnsemble(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        try {
            DecisionTreeSummary.TreeEnsembleSummary tree = fmi.parseModelFile("trees.json", DecisionTreeSummary.TreeEnsembleSummary.class);
            MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)tree);
        }
        catch (FileNotFoundException e) {
            MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)new Object());
        }
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-details", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-coef-path"})
    public void getCoefPath(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        try {
            CoefPath path = fmi.parseModelFile("coef_path.json", CoefPath.class);
            MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)path);
        }
        catch (FileNotFoundException e) {
            MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)new Object());
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/prediction/get-prepared-input-schema"})
    public void getPreparedInputSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData) throws Exception {
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        JobActivity activity = null;
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, sr.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            FlowRecipe fr = new FlowRecipe(sr);
            RecipeRunnableSubgraph sg = this.validationService.getSampleSubgraph(fr);
            activity = new JobActivity(sg);
        }
        this.auditTrailService.generic("ml-prediction-model-get-schema").with("projectKey", sr.projectKey).with("recipeType", sr.type).with("recipeName", sr.name).emit();
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)this.predictionRecipesService.getPreparedSchema_NT(activity, liu));
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/prediction/export-sql"})
    public void exportSql(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData) throws Exception {
        ScoringExporter exporter;
        FullModelId fmi;
        AuthCtx liu;
        ScoringExporter.checkExportLicenced();
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            this.projectsService.checkPerm(liu, sr.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SavedModel sm = this.smService.getRecipeInput(sr);
            fmi = new FullModelId(sm.projectKey, sm.id, sm.activeVersion);
            SingleWriteTransactionTransactionService.DetransactionalizedCallable<String> queryCallable = this.predictionRecipesService.getSqlScoringQuery(liu, fmi, sr, sm);
            SQLScoring scoring = new SQLScoring(fmi, sr.getDisplayName() + ".sql", queryCallable);
            exporter = new ScoringExporter(scoring);
        }
        ScoringModelExportThread thread = new ScoringModelExportThread((DSSAuthCtx)liu, fmi.getProjectKey(), exporter);
        this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", fmi.getProjectKey()).with("fullModelId", fmi.toString()).with("format", "sql").with("exportId", exporter.exportId).emit();
        FutureResponse<ScoringModelExportThread.ScoringExportResponse> future = this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<ScoringModelExportThread.ScoringExportResponse>>(){});
        MLPredictionController.writeJSON((HttpServletResponse)resp, future);
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/prediction/export-pmml"})
    public void exportPmml(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        AuthCtx liu;
        ScoringExporter.checkExportLicenced();
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(liu, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ScoringExporter exporter = new ScoringExporter(new PMMLScoring(fmi));
        ScoringModelExportThread thread = new ScoringModelExportThread((DSSAuthCtx)liu, fmi.getProjectKey(), exporter);
        FutureResponse<ScoringModelExportThread.ScoringExportResponse> future = this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<ScoringModelExportThread.ScoringExportResponse>>(){});
        this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", fmi.getProjectKey()).with("fullModelId", fmi.toString()).with("format", "pmml").with("exportId", exporter.exportId).emit();
        MLPredictionController.writeJSON((HttpServletResponse)resp, future);
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-export-download", "format", "${format}", "exportId", "${exportId}"})
    @RequestMapping(value={"/api/ml/prediction/get-export"})
    public void export(HttpServletRequest req, HttpServletResponse resp, @RequestParam String format, @RequestParam String exportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        ScoringExporter.checkExportLicenced();
        ScoringExporter.download(switch (format) {
            case "pmml" -> "application/xml";
            case "jar-fat", "jar-thin", "jar-lib" -> "application/java-archive";
            case "sql" -> "text/plain";
            case "python", "mlflow" -> "application/zip";
            default -> throw new IllegalArgumentException("unknown export format: " + format);
        }, exportId, resp);
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/prediction/export-jar"})
    public void exportJar(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam(required=false, defaultValue="model.Model") String fullClassName, @RequestParam(required=false, defaultValue="false") Boolean includeLibs) throws Exception {
        AuthCtx liu;
        ScoringExporter.checkExportLicenced();
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(liu, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ScoringExporter exporter = new ScoringExporter(new JarScoring(includeLibs, fmi, fullClassName));
        ScoringModelExportThread thread = new ScoringModelExportThread((DSSAuthCtx)liu, fmi.getProjectKey(), exporter);
        this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", fmi.getProjectKey()).with("fullModelId", fullModelId).with("format", "jar").with("exportId", exporter.exportId).emit();
        FutureResponse<ScoringModelExportThread.ScoringExportResponse> future = this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<ScoringModelExportThread.ScoringExportResponse>>(){});
        MLPredictionController.writeJSON((HttpServletResponse)resp, future);
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/prediction/export-jar-lib"})
    public void exportJarLib(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        DSSAuthCtx user;
        ScoringExporter.checkExportLicenced();
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ScoringExporter exporter = new ScoringExporter(new JarScoring());
        ScoringModelExportThread thread = new ScoringModelExportThread(user, fmi.getProjectKey(), exporter);
        FutureResponse<ScoringModelExportThread.ScoringExportResponse> future = this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<ScoringModelExportThread.ScoringExportResponse>>(){});
        this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", fmi.getProjectKey()).with("fullModelId", fullModelId).with("format", "jar-lib").with("exportId", exporter.exportId).emit();
        MLPredictionController.writeJSON((HttpServletResponse)resp, future);
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/prediction/export-python"})
    public void exportPython(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam(defaultValue="false") boolean exportMlflow, @RequestParam(required=false, defaultValue="false") boolean useOriginalMLflowModel) throws Exception {
        AuthCtx liu;
        ScoringExporter.checkExportLicenced();
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(liu, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ScoringExporter exporter = new ScoringExporter(exportMlflow ? new MLflowScoring(fmi, useOriginalMLflowModel) : new PythonScoring(fmi));
        ScoringModelExportThread thread = new ScoringModelExportThread((DSSAuthCtx)liu, fmi.getProjectKey(), exporter);
        FutureResponse<ScoringModelExportThread.ScoringExportResponse> future = this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<ScoringModelExportThread.ScoringExportResponse>>(){});
        this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", fmi.getProjectKey()).with("fullModelId", fullModelId).with("format", exportMlflow ? "mlflow" : "python").with("exportId", exporter.exportId).emit();
        MLPredictionController.writeJSON((HttpServletResponse)resp, future);
    }

    @AuditedCall(value={"msgType", "ml-model-export-to-snowflake-function", "fullModelId", "${fullModelId}", "functionName", "${functionName}", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/api/ml/prediction/export-to-snowflake-function"})
    @ResponseBody
    public FutureResponse<?> exportToSnowflakeFunction(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String connectionName, @RequestParam String functionName) throws Exception {
        SnowflakeConnection sfConn;
        AuthCtx authCtx;
        ScoringExporter.checkExportLicenced();
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            DSSConnection conn = ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionName);
            if (!(conn instanceof SnowflakeConnection)) {
                throw new IllegalArgumentException("Connection is not a Snowflake connection");
            }
            if (!conn.isFreelyUsableBy(authCtx)) {
                throw new UnauthorizedException("You may not use this connection", "denied");
            }
            sfConn = (SnowflakeConnection)conn;
        }
        SnowflakePermanentFunctionExportThread thread = new SnowflakePermanentFunctionExportThread(authCtx, sfConn, fmi, functionName);
        return this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<Void>>(){});
    }

    @AuditedCall(value={"msgType", "ml-model-export-to-databricks-registry", "fullModelId", "${fullModelId}", "connectionName", "${connectionName}", "useUnityCatalog", "${useUnityCatalog}", "modelName", "${modelName}", "experimentName", "${experimentName}"})
    @ResponseBody
    @RequestMapping(value={"/api/ml/prediction/export-to-databricks-registry"})
    public FutureResponse<DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse> exportToDatabricksRegistry(HttpServletRequest req, @RequestParam String fullModelId, @RequestParam String connectionName, @RequestParam(defaultValue="false") boolean useUnityCatalog, @RequestParam String modelName, @RequestParam String experimentName) throws Exception {
        DSSAuthCtx authCtx;
        ScoringExporter.checkExportLicenced();
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnectionAndCheckDetailsReadable(authCtx, connectionName);
        return this.futureService.runFuture(new ExportAndRegisterMLflowModelInFutureThread(authCtx, fmi, connection, useUnityCatalog, modelName, experimentName, List.of()), 0L, new TypeToken<FutureResponse<DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse>>(){});
    }

    @AuditedCall(value={"msgType", "ml-prediction-subpopulation-computation", "modelId", "${fullModelId}", "features", "${features}"})
    @RequestMapping(value={"/api/ml/prediction/subpopulation-computation-start"})
    public void subpopulationComputationStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam List<String> features, @RequestParam JsonObject computationParams) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, this.predictionService.subpopulationComputationStart(user, fmi, features, computationParams, false));
    }

    @AuditedCall(value={"msgType", "ml-prediction-pdp-computation", "modelId", "${fullModelId}", "features", "${features}"})
    @RequestMapping(value={"/api/ml/prediction/pdp-computation-start"})
    public void pdpComputationStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam List<String> features, @RequestParam JsonObject computationParams) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, this.predictionService.pdpComputationStart(user, fmi, features, computationParams));
    }

    @AuditedCall(value={"msgType", "ml-learning-curve-start-computation", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/learning-curves-start"})
    @ResponseBody
    public FutureResponse<PredictionResultsReader.LearningCurveResults<?>> learningCurvesStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam int numberOfPoints) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        JsonObject computationParams = new JsonObject();
        computationParams.add("learning_curve_number_of_points", (JsonElement)new JsonPrimitive((Number)numberOfPoints));
        return this.predictionService.learningCurvesComputationStart(user, fmi, computationParams);
    }

    @AuditedCall(value={"msgType", "ml-learning-curve-get-computed", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-learning-curves"})
    @ResponseBody
    public PredictionResultsReader.LearningCurveResults<?> getLearningCurves(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        return PredictionResultsReader.makeLearningCurveResults(fmi);
    }

    @AuditedCall(value={"msgType", "ml-prediction-global-explanations-computation", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/global-explanations-computation-start"})
    public void globalExplanationsComputationStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, this.predictionService.globalExplanationsComputationStart(user, fmi));
    }

    @AuditedCall(value={"msgType", "ml-prediction-get-global-explanations"})
    @RequestMapping(value={"/api/ml/prediction/get-global-explanations"})
    public void getGlobalExplanations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        Optional<PredictionGlobalExplanations> globalExplanations = fmi.getGlobalExplanations();
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)(globalExplanations.isPresent() ? globalExplanations.get() : new Object()));
    }

    @AuditedCall(value={"msgType", "ml-prediction-get-global-explanations"})
    @RequestMapping(value={"/api/ml/prediction/get-global-explanations-facts"})
    public void getGlobalExplanationsFactgs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        Optional<PredictionGlobalExplanationsFacts> globalExplanationsFacts = fmi.getGlobalExplanationsFacts();
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)(globalExplanationsFacts.isPresent() ? globalExplanationsFacts.get() : new Object()));
    }

    @AuditedCall(value={"msgType", "ml-prediction-get-permutation-importance"})
    @RequestMapping(value={"/api/ml/prediction/get-permutation-importance"})
    public void getPermutationImportance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        Optional<TimeseriesPredictionPermutationImportance> permutationImportance = fmi.getPermutationImportance();
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)(permutationImportance.isPresent() ? permutationImportance.get() : new Object()));
    }

    @AuditedCall(value={"msgType", "ml-prediction-compute-permutation-importance", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/compute-permutation-importance"})
    public void permutationImportanceComputationStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam JsonObject computationParams) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, this.predictionService.permutationImportanceComputationStart(user, fmi, computationParams));
    }

    @AuditedCall(value={"msgType", "ml-prediction-individual-explanations-computation", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/individual-explanations-computation-start"})
    public void individualExplanationsComputationStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam JsonObject computationParams) throws Exception {
        DSSAuthCtx user;
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = (DSSAuthCtx)this.authService.getUser(req);
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, this.predictionService.individualExplanationsComputationStart(user, fmi, computationParams));
    }

    @AuditedCall(value={"msgType", "ml-prediction-get-individual-explanations"})
    @RequestMapping(value={"/api/ml/prediction/get-individual-explanations"})
    public void getIndividualExplanations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        PredictionIndividualExplanations explanations = PredictionResultsReader.getIndividualExplanations(fmi);
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)(explanations != null ? explanations : new Object()));
    }

    @AuditedCall(value={"msgType", "ml-prediction-get-subpopulation"})
    @RequestMapping(value={"/api/ml/prediction/get-subpopulation"})
    public void getSubpopuplation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam List<String> features) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        for (String feature : features) {
            this.checkNotBlank(feature, "Feature name cannot be empty", new Object[0]);
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)PredictionResultsReader.makeSubpopulationResults(fmi, features, false));
    }

    @AuditedCall(value={"msgType", "ml-prediction-get-subpopulations-info"})
    @RequestMapping(value={"/api/ml/prediction/get-subpopulations-info"})
    public void getSubpopulationsInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        PredictionSubpopulation subpop = PredictionResultsReader.getSubpopulationsInfo(fmi);
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)(subpop != null ? subpop : new Object()));
    }

    @AuditedCall(value={"msgType", "ml-prediction-get-partitions-perf", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-partitions-perf"})
    public void getPartitionsPerf(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)PredictionResultsReader.makePartitionsPerfs(fmi));
    }

    @AuditedCall(value={"msgType", "ml-prediction-render-custom", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/render-custom"}, method={RequestMethod.POST})
    public void renderCustomTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam MultipartFile file, @RequestParam String fullModelId) throws Exception {
        DSSAuthCtx authCtx;
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getProjectKey();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        FutureResponse<DocumentGenerationResponse> future = this.modelDocumentGenerationService.generateDocument(authCtx, projectKey, file.getInputStream(), fmi);
        MLPredictionController.writeJSON((HttpServletResponse)resp, future);
    }

    @AuditedCall(value={"msgType", "ml-prediction-render-default", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/render-default"}, method={RequestMethod.POST})
    public void renderDefaultTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        DSSAuthCtx authCtx;
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getProjectKey();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        File f = this.modelDocumentGenerationService.getDefaultTemplate(fullModelId);
        FutureResponse<DocumentGenerationResponse> future = this.modelDocumentGenerationService.generateDocument(authCtx, projectKey, Files.newInputStream(f.toPath(), new OpenOption[0]), fmi);
        MLPredictionController.writeJSON((HttpServletResponse)resp, future);
    }

    @AuditedCall(value={"msgType", "ml-prediction-get-pre-docgen-info-messages", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-pre-docgen-info-messages"}, method={RequestMethod.POST})
    public void getPreDocGenInfoMessages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getProjectKey();
        boolean isMLflowImport = false;
        boolean analysisDeleted = false;
        boolean designChangesDetected = false;
        boolean pluginModelDetected = false;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            try {
                isMLflowImport = fmi.isExternalMLflowModelVersion();
                if (!isMLflowImport) {
                    boolean bl = analysisDeleted = !DesignDiffCheckUtil.hasOriginalAnalysis(fmi);
                    if (!analysisDeleted && !(pluginModelDetected = DesignDiffCheckUtil.hasPlugins(fmi))) {
                        designChangesDetected = DesignDiffCheckUtil.hasChangesOccurred(fmi);
                    }
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to retrieve original analysis to check for compatibility with document generation", (Throwable)e);
                analysisDeleted = true;
            }
        }
        if (!isMLflowImport) {
            if (analysisDeleted) {
                infoMessages.addMessage(DesignDiffCheckUtil.getAnalysisDeletedWarningMessage());
            } else if (pluginModelDetected) {
                infoMessages.addMessage(DesignDiffCheckUtil.getPluginAlgorithmErrorMessage());
            } else if (designChangesDetected) {
                infoMessages.addMessage(DesignDiffCheckUtil.getDesignChangedWarningMessage());
            }
        }
        MLPredictionController.writeJSON((HttpServletResponse)resp, (Object)infoMessages);
    }

    @AuditedCall(value={"msgType", "ml-prediction-get-preparation-script", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-preparation-script"})
    @ResponseBody
    public SerializedShakerScript getPreparationScript(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws IOException, DKUSecurityException {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        File scriptFile = fmi.getSessionFile("script.json");
        if (scriptFile.exists()) {
            return (SerializedShakerScript)JSON.parseFile((File)scriptFile, SerializedShakerScript.class);
        }
        return new SerializedShakerScript();
    }

    @AuditedCall(value={"msgType", "ml-prediction-model-get-input-dataset-schema", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/prediction/get-input-dataset-schema"})
    @ResponseBody
    public Schema getInputDatasetSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        String anaylisFmi;
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        File datasetSchemaFile = fmi.getSessionFile("input_dataset_schema.json");
        if (datasetSchemaFile.exists()) {
            return (Schema)JSON.parseFile((File)datasetSchemaFile, Schema.class);
        }
        if (fmi.type == FullModelId.Type.SAVED) {
            SavedModelOriginInfo versionOrigin = fmi.getSmOrigin();
            anaylisFmi = versionOrigin.fullModelId;
        } else {
            anaylisFmi = fullModelId;
        }
        try (Transaction t = this.transactionService.beginRead();){
            String analysisId = FullModelId.extractAnalysisId(anaylisFmi);
            AnalysisCoreParams acp = this.analysisCRUDService.getCoreMandatory(fmi.getProjectKey(), analysisId);
            String datasetSmartName = acp.inputDatasetSmartName;
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(fmi.getProjectKey(), datasetSmartName);
            this.projectsService.checkPerm(req, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Schema schema = this.datasetAccessService.getMandatory(loc).getSchema();
            return schema;
        }
    }
}

