/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.code.CodeEnvPermissionsService;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.JdbcConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ParamsWithEncryptedFields;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.datasets.sample.SampleDatasetHandler;
import com.dataiku.dip.datasets.sample.SampleDatasetMeta;
import com.dataiku.dip.datasets.sample.SampleDatasetParams;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.IFormatConfig;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.LineFormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.probes.BasicProbeType;
import com.dataiku.dip.metrics.probes.PartitioningProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.metrics.probes.RecordsProbeType;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.MaybeDone;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.utils.WithMessages;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetSaveService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ManagedDatasetsCreationService managedDatasetsCreationService;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private LicenseEnforcementService enforcementService;
    @Autowired
    private ITaggingService taggingService;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    private CodeEnvPermissionsService codeEnvPermissionsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private PasswordEncryptionService cryptoService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.server.datasets");

    private void addDefaultMetricsStuff(SerializedDataset sds) {
        ProbeConfiguration conf;
        ProbesSet metrics = new ProbesSet();
        if (sds.partitioning != null && !sds.partitioning.getDimensionNames().isEmpty()) {
            Probe partitioningProbe = new Probe("partitioning");
            conf = new PartitioningProbeType.PartitioningProbeConfiguration();
            partitioningProbe.withConfiguration(conf).withEnabled(true);
            partitioningProbe.meta = new PartitioningProbeType().getMeta();
            partitioningProbe.computeOnBuildMode = Probe.ComputeMode.WHOLE_DATASET;
            metrics.probes.add(partitioningProbe);
        }
        Probe probe = new Probe("basic");
        conf = new BasicProbeType.BasicProbeConfiguration();
        probe.withConfiguration(conf).withEnabled(true);
        probe.meta = new BasicProbeType().getMeta();
        probe.computeOnBuildMode = Probe.ComputeMode.PARTITION;
        metrics.probes.add(probe);
        metrics.displayedState.metrics.add("basic:COUNT_COLUMNS");
        if (DatasetInspector.isFSLike(sds)) {
            metrics.displayedState.metrics.add("basic:COUNT_FILES");
            metrics.displayedState.metrics.add("basic:SIZE");
        }
        probe = new Probe("records");
        conf = new RecordsProbeType.RecordsProbeConfiguration();
        probe.withConfiguration(conf).withEnabled(true);
        probe.meta = new RecordsProbeType().getMeta();
        probe.computeOnBuildMode = Probe.ComputeMode.NO;
        metrics.probes.add(probe);
        metrics.displayedState.metrics.add("records:COUNT_RECORDS");
        sds.setMetrics(metrics);
    }

    private void addDefaultMetricsStuffForPartitioned(SerializedDataset sds) {
        ProbesSet metrics = sds.getMetrics() != null ? sds.getMetrics() : new ProbesSet();
        logger.info((Object)"Attempt to add partitioning probe on newly partitioned dataset");
        if (sds.partitioning != null && !sds.partitioning.getDimensionNames().isEmpty()) {
            Probe partitioningProbe = null;
            if (sds.getMetrics() != null) {
                for (Probe p : sds.getMetrics().probes) {
                    if (!p.getType().equals("partitioning")) continue;
                    partitioningProbe = p;
                }
            }
            if (partitioningProbe == null) {
                logger.info((Object)"Create new probe");
                partitioningProbe = new Probe("partitioning");
                PartitioningProbeType.PartitioningProbeConfiguration conf = new PartitioningProbeType.PartitioningProbeConfiguration();
                partitioningProbe.withConfiguration(conf).withEnabled(true);
                partitioningProbe.meta = new PartitioningProbeType().getMeta();
                partitioningProbe.computeOnBuildMode = Probe.ComputeMode.WHOLE_DATASET;
                metrics.probes.add(partitioningProbe);
            } else if (!partitioningProbe.isEnabled()) {
                logger.info((Object)"Activate existing probe");
                partitioningProbe.withEnabled(true);
            }
        }
        sds.setMetrics(metrics);
    }

    private void setDefaultFormatParamsOnCreate(SerializedDataset sds) {
        FormatParams params = sds.getFormatParams();
        if (params instanceof CSVFormatConfig && ((CSVFormatConfig)params).getMaxRowChars() == null) {
            ((CSVFormatConfig)params).setMaxRowChars(DKUApp.getParams().getIntParam("dku.input.formats.csv.maxRowChars", Integer.valueOf(100000000)));
        }
        if (params instanceof LineFormatExtractor.Config && ((LineFormatExtractor.Config)params).getMaxLineChars() == null) {
            ((LineFormatExtractor.Config)params).setMaxLineChars(DKUApp.getParams().getIntParam("dku.input.formats.line.maxLineChars", Integer.valueOf(500000000)));
        }
    }

    private void setDefaultAttributesOnCreate(SerializedDataset sds) {
        this.addDefaultMetricsStuff(sds);
        this.setDefaultFormatParamsOnCreate(sds);
    }

    @CheckReturnValue
    public WithMessages<SerializedDataset> create(String projectKey, SerializedDataset sds, DatasetCreationContext creationContext, AuthCtx liu) throws Exception {
        boolean isSchemaEmpty;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"ProjectKey is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)sds.name), (Object)"Dataset name is not specified");
        this.enforcementService.checkCanCreateDataset(sds.type);
        this.enforcementService.checkUsersOverQuota("create dataset");
        if (StringUtils.isBlank((String)sds.name)) {
            throw new IllegalArgumentException("Can't create a dataset with no name");
        }
        if (StringUtils.isBlank((String)sds.type)) {
            throw new IllegalArgumentException("Can't create a dataset with no type");
        }
        RWTransactionRef transactionRef = TransactionContext.retrieveWrite();
        if (this.datasetsDAO.getOrNullUnsafe(projectKey, sds.name) != null) {
            throw ErrorContext.iaef((String)"Dataset %s.%s already exists", (Object)projectKey, (Object[])new Object[]{sds.name});
        }
        if (this.datasetsDAO.datasetExistsCaseInsensitive(projectKey, sds.name)) {
            throw ErrorContext.iaef((String)"Dataset %s.%s must have a unique case-insensitive name", (Object)projectKey, (Object[])new Object[]{sds.name});
        }
        if (this.streamingEndpointsDAO.exists(projectKey, sds.name)) {
            throw ErrorContext.iaef((String)"Name %s.%s is already used by a streaming endpoint", (Object)projectKey, (Object[])new Object[]{sds.name});
        }
        if (sds.type.startsWith("Sample_")) {
            SampleDatasetParams sampleDatasetParams = sds.getParamsAs(SampleDatasetParams.class);
            if (sampleDatasetParams.version == null) {
                sampleDatasetParams.version = ((SampleDatasetMeta)DatasetHandlerFactory.getMeta(sds.type)).getActiveVersion();
                sds.setParams(sampleDatasetParams);
            }
            try (SampleDatasetHandler dh = (SampleDatasetHandler)DatasetHandlerFactory.build(liu, Dataset.fromSerialized(sds));){
                ((SampleDatasetMeta)DatasetHandlerFactory.getMeta(sds.type)).checkVersionExists(sampleDatasetParams.version);
                sds.setSchema(dh.getSchemaForSampleDataset());
                Dataset realDataset = dh.getRealDataset();
                if (sds.getFormatParams() == null) {
                    sds.setFormatParams(realDataset.getFormatParams());
                }
                if (sds.formatType == null) {
                    sds.formatType = realDataset.getFormatType();
                }
                if (sds.shortDesc == null) {
                    sds.shortDesc = realDataset.getModel().shortDesc;
                }
            }
        }
        boolean isInternalDatasetRequiringTestForSchema = Sets.newHashSet((Object[])new String[]{"StatsDB", "JobsDB", "ExperimentsDB"}).contains(sds.type);
        boolean bl = isSchemaEmpty = sds.getSchema() == null || sds.getSchema().columns == null || sds.getSchema().columns.isEmpty();
        if (isSchemaEmpty && isInternalDatasetRequiringTestForSchema) {
            try (DatasetTestHandler testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, Dataset.fromSerialized(sds), DatasetTestHandler.class);){
                sds.setSchema(testHandler.testSchemaConsistency().result.detectedSchema);
            }
        }
        if (sds.getSchema() != null && sds.getSchema().columns != null) {
            List columns = sds.getSchema().columns;
            for (int i = 0; i < columns.size(); ++i) {
                String nameI = ((SchemaColumn)columns.get(i)).getName();
                if (nameI == null || nameI.isEmpty()) {
                    throw ErrorContext.iaef((String)"Cannot create a dataset with an empty column name (Column index: %d)", (Object)i, (Object[])new Object[0]);
                }
                for (int j = i + 1; j < columns.size(); ++j) {
                    if (!((SchemaColumn)columns.get(i)).getName().equals(((SchemaColumn)columns.get(j)).getName())) continue;
                    throw ErrorContext.iaef((String)"Cannot create a dataset with duplicate column names (%s)", (Object)((SchemaColumn)columns.get(i)).getName(), (Object[])new Object[0]);
                }
            }
            sds.getSchema().userModified = true;
        }
        if (sds.getFormatParams() instanceof IFormatConfig) {
            ((IFormatConfig)((Object)sds.getFormatParams())).validate();
        }
        if (sds.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = sds.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
            if ("table".equals(config.mode) && StringUtils.isNotBlank((String)config.catalog)) {
                try (AbstractSQLTableDatasetHandler dh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(liu, Dataset.fromSerialized(sds));){
                    if (!this.isCatalogAware(dh)) {
                        throw new IllegalArgumentException("SQL connection " + config.connection + " of type " + sds.type + " cannot use catalogs");
                    }
                }
            }
            config.noDropOnSchemaMismatch = true;
        }
        if (sds.getParams() instanceof BuiltinFSDatasets.UploadedFilesConfig) {
            String uploadConnection = sds.getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class).uploadConnection;
            if (!this.managedDatasetsCreationService.allowUploadsWithoutConnection()) {
                if (StringUtils.isBlank((String)uploadConnection)) {
                    throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_UPLOAD_WITHOUT_CONNECTION, String.format("Cannot create dataset %s without a target connection", sds.getFullName()));
                }
                DSSConnection connection = this.connectionsDAO.getConnection(liu, uploadConnection);
                if (connection == null || !connection.allowWrite) {
                    throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_UPLOAD_WITHOUT_CONNECTION, String.format("Cannot create dataset %s on target connection '%s'", sds.getFullName(), uploadConnection));
                }
            }
        }
        logger.infoV("Creating dataset %s.%s", new Object[]{projectKey, sds.name});
        this.setDefaultAttributesOnCreate(sds);
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(sds);
        WithMessages<SerializedDataset> ret = new WithMessages<SerializedDataset>();
        Dataset newDS = Dataset.fromSerialized(projectKey + "." + sds.name, sds);
        DatasetInspector.checkType(newDS.getType());
        if (newDS.getSchema() != null && !newDS.getSchema().getColumns().isEmpty()) {
            ret.addMessages(newDS.fixupSchemaPerDatasetConstraint(liu, newDS.getSchema()));
        }
        ret.addMessages(newDS.fixupManagedDatasetPartitioning(null));
        if ("StatsDB".equals(sds.type) && liu != null && !this.permissionsService.isAdmin(liu)) {
            throw new SecurityException("You may not create a StatsDB dataset");
        }
        if ("JobsDB".equals(newDS.getType()) && liu != null && !this.permissionsService.isAdmin(liu)) {
            JobsdbDatasetParams params = newDS.getParamsAs(JobsdbDatasetParams.class);
            if (params.scope == JobsdbDatasetParams.RetrievalScope.INSTANCE) {
                throw new SecurityException("You may not save a metrics dataset with INSTANCE scope");
            }
        }
        DatasetInspector.checkDatasetConnectionPermission(sds, liu, "create a dataset on");
        newDS.getModel().versionTag = new VersionTag(transactionRef.getUser().getIdentifier());
        newDS.getModel().creationTag = new VersionTag(transactionRef.getUser().getIdentifier());
        SerializedDataset serializedDataset = newDS.serialize();
        if (serializedDataset.getFormatParams() instanceof ParamsWithEncryptedFields) {
            ((ParamsWithEncryptedFields)((Object)serializedDataset.getFormatParams())).encryptFields(this.cryptoService);
        }
        this.customPolicyHooksRegistry.onPreDatasetCreation(transactionRef.getUser(), serializedDataset, creationContext);
        this.saveInternal(projectKey, newDS.getName(), serializedDataset);
        try (DatasetHandler dh = DatasetHandlerFactory.build(liu, newDS);){
            if (dh.executeFastPostCreateOperations()) {
                this.saveInternal(projectKey, newDS.getName(), serializedDataset);
            }
        }
        this.flowZonesService.attachObjectToZone(this.guessZoneToUse(creationContext, serializedDataset), projectKey, serializedDataset);
        this.flowGraphService.invalidateCache();
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.DATASET, projectKey, sds.name, liu, TaggableObjectChangedEvent.ActionType.DATASET_CREATE));
        if (this.neverBuiltComputablesCacheService.canBeAdded(newDS)) {
            this.neverBuiltComputablesCacheService.add(new TaggableObjectsService.TaggableObjectRef(serializedDataset));
        }
        return ret.withValue(serializedDataset);
    }

    private boolean isCatalogAware(AbstractSQLTableDatasetHandler dh) throws DKUSecurityException {
        if (dh.getDialect().isCatalogAware()) {
            return true;
        }
        AbstractSQLConnection connection = dh.getDSSConnection();
        if (connection instanceof JdbcConnection) {
            return ((JdbcConnection)connection).params.supportsBrowsingCatalogs;
        }
        return false;
    }

    private String guessZoneToUse(DatasetCreationContext creationContext, SerializedDataset serializedDataset) throws IOException {
        String zoneId = creationContext.getZoneId();
        if (StringUtils.isBlank((String)zoneId) && Objects.equals("FilesInFolder", serializedDataset.getSubtype())) {
            BuiltinFSDatasets.FilesInFolderConfig params = serializedDataset.getParamsAs(BuiltinFSDatasets.FilesInFolderConfig.class);
            return this.flowZonesService.retrieveZone(serializedDataset.projectKey, SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MANAGED_FOLDER, params.getFolderSmartId()));
        }
        return zoneId;
    }

    private void saveInternal(String projectKey, String name, SerializedDataset dataset) throws Exception {
        PartitioningScheme ps2;
        logger.info((Object)("Saving dataset " + projectKey + "." + name));
        if (this.licenseService.getLicensingStatus().community && dataset.partitioning != null && (ps2 = dataset.partitioning).isPartitioned()) {
            throw new LicenseRestrictionException("Partitioning is not available in DSS free edition");
        }
        DatasetUtils.checkName(name);
        SerializedDataset ds = (SerializedDataset)JSON.deepCopy((Object)dataset);
        ds.projectKey = projectKey;
        ds.name = name;
        this.customPolicyHooksRegistry.onPreObjectSave(TransactionContext.retrieveWrite().getUser(), (TaggableObjectsService.TaggableObject)this.datasetsDAO.getOrNull(ds.projectKey, ds.getId()), ds);
        this.taggingService.onObjectSaved(projectKey, dataset.tags);
        this.datasetsDAO.save(ds);
    }

    public WithMessages<SerializedDataset> saveWithoutEvents(String projectKey, String name, SerializedDataset dataset, AuthCtx liu) throws Exception {
        SerializedDataset preExisting = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, name);
        WithMessages<SerializedDataset> copy = this.prepareForSave(projectKey, name, dataset, liu, preExisting);
        this.saveInternal(projectKey, name, (SerializedDataset)copy.value);
        return copy;
    }

    public WithMessages<SerializedDataset> save(DatasetLocUtils.DatasetLoc loc, SerializedDataset dataset, AuthCtx liu) throws Exception {
        return this.save(loc.getProjectKey(), loc.getName(), dataset, liu);
    }

    public WithMessages<SerializedDataset> save(String projectKey, String name, SerializedDataset dataset, AuthCtx liu) throws Exception {
        return this.saveWithCustomEvent(projectKey, name, dataset, liu, new TaggableObjectChangedEvent(ITaggingService.TaggableType.DATASET, projectKey, name, liu, TaggableObjectChangedEvent.ActionType.DATASET_EDIT));
    }

    public WithMessages<SerializedDataset> saveWithCustomEvent(String projectKey, String name, SerializedDataset dataset, AuthCtx liu, TaggableObjectChangedEvent event) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SerializedDataset preExisting = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, name);
        if (preExisting != null && preExisting.featureGroup != dataset.featureGroup) {
            this.permissionsService.checkManageFeatureStorePrivilege(t.getUser());
        }
        WithMessages<SerializedDataset> copy = this.prepareForSave(projectKey, name, dataset, liu, preExisting);
        DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(dataset.type);
        if (meta instanceof MetaWithSelectableCodeEnv) {
            this.codeEnvPermissionsService.failIfCodeEnvNotUsable(projectKey, meta, dataset.getParams(), preExisting == null ? null : preExisting.getParams(), t.getUser());
        }
        for (Probe probe : dataset.getMetrics().probes) {
            this.codeEnvPermissionsService.failIfCodeEnvNotUsable(projectKey, ProbeType.getProbeType(probe.getType()), probe.getConfiguration(), null, t.getUser());
        }
        for (DataQualityRule rule : dataset.getDataQualityRuleSet().getRules()) {
            this.codeEnvPermissionsService.failIfCodeEnvNotUsable(projectKey, rule, rule, null, t.getUser());
        }
        TaggableObjectDiffService.TaggableObjectsDiff diff = this.colaborativeMetadataDiffService.diff(preExisting, (TaggableObjectsService.TaggableObject)copy.value, t.getUser().getIdentifier());
        this.saveInternal(projectKey, name, (SerializedDataset)copy.value);
        if (preExisting != null && DatasetHandler.SoftLinkGeneratingDatasetParams.class.isAssignableFrom(meta.paramsClass()) && ((DatasetHandler.SoftLinkGeneratingDatasetParams)((Object)dataset.getParams())).linksChanged(preExisting)) {
            this.flowGraphService.invalidateCache();
        }
        this.invalidateFlowCacheIfNeededForVELoop(dataset, preExisting);
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        } else {
            this.pubSub.publishAfterTransaction(event);
        }
        return copy;
    }

    public MaybeDone<SerializedDataset> saveWithRecipesFixup(String projectKey, String name, SerializedDataset dataset, boolean force, boolean shouldFixAllAvailablePartitioning) throws Exception {
        TaggableObjectDiffService.TaggableObjectsDiff diff;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SerializedDataset preExisting = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, name);
        WithMessages<SerializedDataset> copy = this.prepareForSave(projectKey, name, dataset, t.getUser(), preExisting);
        this.saveInternal(projectKey, name, (SerializedDataset)copy.value);
        DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(dataset.type);
        if (preExisting != null && DatasetHandler.SoftLinkGeneratingDatasetParams.class.isAssignableFrom(meta.paramsClass()) && ((DatasetHandler.SoftLinkGeneratingDatasetParams)((Object)dataset.getParams())).linksChanged(preExisting)) {
            this.flowGraphService.invalidateCache();
        }
        this.invalidateFlowCacheIfNeededForVELoop(dataset, preExisting);
        InfoMessage.InfoMessages fixupMessages = new InfoMessage.InfoMessages();
        this.maybeFixupPdepsOnRelatedRecipes((SerializedDataset)copy.value, fixupMessages, false, false);
        fixupMessages.mergeFrom(copy.messages);
        if (fixupMessages.anyMessage && !force) {
            logger.info((Object)("Not doing the save: " + JSON.prettyLog((Object)fixupMessages)));
            return MaybeDone.notDone((InfoMessage.InfoMessages)fixupMessages);
        }
        if (fixupMessages.anyMessage) {
            this.maybeFixupPdepsOnRelatedRecipes((SerializedDataset)copy.value, fixupMessages, true, shouldFixAllAvailablePartitioning);
        }
        if ((diff = this.colaborativeMetadataDiffService.diff(preExisting, (TaggableObjectsService.TaggableObject)copy.value, t.getUser().getIdentifier())).metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        } else {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.DATASET, projectKey, name, t.getUser(), TaggableObjectChangedEvent.ActionType.DATASET_EDIT));
        }
        return MaybeDone.done((Object)((SerializedDataset)copy.value));
    }

    private void invalidateFlowCacheIfNeededForVELoop(SerializedDataset dataset, SerializedDataset preExisting) {
        try {
            logger.info((Object)"save hook");
            if (preExisting != null) {
                logger.info((Object)"have pre-existing");
                if (DatasetInspector.isFS(dataset)) {
                    AbstractFSDatasetHandler.AbstractFSConfig configBefore = dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class);
                    AbstractFSDatasetHandler.AbstractFSConfig configAfter = preExisting.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class);
                    if (configAfter.variablesExpansionLoopConfig.isEnabled() || configBefore.variablesExpansionLoopConfig.isEnabled()) {
                        this.flowGraphService.invalidateCache();
                    }
                } else if (DatasetInspector.isSQL(dataset)) {
                    AbstractSQLDatasetHandler.AbstractSQLConfig configBefore = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
                    AbstractSQLDatasetHandler.AbstractSQLConfig configAfter = preExisting.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
                    logger.info((Object)"Save pre-existing SQL dataset:");
                    logger.info((Object)("cA=" + JSON.log((Object)configAfter.variablesExpansionLoopConfig)));
                    logger.info((Object)("cB=" + JSON.log((Object)configBefore.variablesExpansionLoopConfig)));
                    if (configAfter.variablesExpansionLoopConfig.isEnabled() || configBefore.variablesExpansionLoopConfig.isEnabled()) {
                        this.flowGraphService.invalidateCache();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to decide whether to invalidate cache for dataset save", (Throwable)e);
        }
    }

    private WithMessages<SerializedDataset> prepareForSave(String projectKey, String name, SerializedDataset dataset, AuthCtx liu, SerializedDataset preExisting) throws Exception {
        WithMessages<SerializedDataset> ret = new WithMessages<SerializedDataset>();
        if (dataset.getSchema() != null) {
            Dataset d = Dataset.fromSerialized(projectKey + "." + name, dataset);
            ret.addMessages(d.fixupSchemaPerDatasetConstraint(liu, d.getSchema()));
            ret.addMessages(d.fixupManagedDatasetPartitioning(preExisting));
            dataset = d.serialize();
        }
        if (liu != null && !this.permissionsService.isAdmin(liu) && "StatsDB".equals(dataset.type)) {
            throw new SecurityException("You may not save a StatsDB dataset");
        }
        if (liu != null && !this.permissionsService.isAdmin(liu) && "JobsDB".equals(dataset.type)) {
            JobsdbDatasetParams params = dataset.getParamsAs(JobsdbDatasetParams.class);
            if (params.scope == JobsdbDatasetParams.RetrievalScope.INSTANCE) {
                throw new SecurityException("You may not save a metrics dataset with INSTANCE scope");
            }
        }
        DatasetInspector.checkDatasetConnectionPermission(dataset, liu, "modify a dataset on");
        SerializedDataset copy = (SerializedDataset)JSON.deepCopy((Object)dataset);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(copy, preExisting);
        if (copy.getSchema() != null && !copy.getSchema().columns.isEmpty()) {
            copy.getSchema().userModified = true;
        }
        if (dataset.partitioning != null && dataset.partitioning.getDimensionNames() != null && !dataset.partitioning.getDimensionNames().isEmpty() && preExisting != null && (preExisting.partitioning == null || preExisting.partitioning.getDimensionNames() == null || preExisting.partitioning.getDimensionNames().isEmpty())) {
            this.addDefaultMetricsStuffForPartitioned(copy);
        }
        if (dataset.managed && dataset.getParams() instanceof AbstractFSDatasetHandler.AbstractFSConfig) {
            AbstractFSDatasetHandler.AbstractFSConfig params = (AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParams();
            String path = params.path;
            if (StringUtils.isBlank((String)path) || "/".equals(path)) {
                String connectionName = StringUtils.defaultIfBlank((String)params.connection, (String)"no_connection");
                boolean allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.managed." + connectionName + ".allowClearRoot", false);
                if (!allowed) {
                    throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Placing a managed dataset at the root of a connection is not permitted");
                }
            }
        }
        if (copy.getFormatParams() instanceof ParamsWithEncryptedFields) {
            ((ParamsWithEncryptedFields)((Object)copy.getFormatParams())).encryptFields(this.cryptoService);
        }
        copy.getDataQualityRuleSet().getRules().forEach(DataQualityRule::ensureId);
        copy.getDataQualityRuleSet().getRules().forEach(DataQualityRule::updateDisplayName);
        return ret.withValue(copy);
    }

    void maybeFixupPdepsOnRelatedRecipes(SerializedDataset sd, InfoMessage.InfoMessages messages, boolean doIt, boolean shouldFixAllAvailablePartitioning) throws IOException, DKUSecurityException, CodedException {
        ProjectFlowGraph globalGraph = this.flowGraphService.getProjectGraphUnsafe(sd.projectKey);
        FlowDataset fds = globalGraph.getDataset(sd.projectKey, sd.name);
        if (fds != null) {
            List<SerializedRecipe.SDep> matchedDeps;
            for (GraphNode graphNode : fds.getSuccessors()) {
                if (!(graphNode instanceof FlowRecipe)) continue;
                logger.info((Object)("Maybe updating recipe: " + graphNode.getFullId()));
                if (sd.isPartitioned()) {
                    matchedDeps = this.getAllAvailableDeps(((FlowRecipe)graphNode).getModel());
                    if (matchedDeps.isEmpty()) continue;
                    for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                        boolean isActionable;
                        FlowDataset outputDatasetNode;
                        Dataset outputDataset;
                        if (!(graphNode2 instanceof FlowDataset) || !(outputDataset = (outputDatasetNode = (FlowDataset)graphNode2).getMandatoryUnsafe(this.datasetsDAO)).getPartitioningSchema().isPartitioned()) continue;
                        List datasetDimensionNames = outputDataset.serialize().partitioning.getDimensionNames();
                        boolean bl = isActionable = !Collections.disjoint(datasetDimensionNames, matchedDeps.stream().map(dep -> dep.idim).collect(Collectors.toSet()));
                        if (shouldFixAllAvailablePartitioning && isActionable) {
                            this.fixAllAvailablePartitioning(((FlowRecipe)graphNode).getModel(), matchedDeps, datasetDimensionNames);
                            continue;
                        }
                        if (shouldFixAllAvailablePartitioning) continue;
                        this.warnAllAvailableDependency((FlowRecipe)graphNode, isActionable, true, messages);
                    }
                }
                this.maybeFixupAndSaveRecipe(((FlowRecipe)graphNode).getModel(), messages, doIt);
            }
            for (GraphNode graphNode : fds.getPredecessors()) {
                if (!(graphNode instanceof FlowRecipe)) continue;
                logger.info((Object)("Maybe updating recipe: " + graphNode.getFullId()));
                if (sd.isPartitioned()) {
                    boolean bl;
                    matchedDeps = this.getAllAvailableDeps(((FlowRecipe)graphNode).getModel());
                    if (matchedDeps.isEmpty()) continue;
                    List datasetDimensionNames = sd.partitioning.getDimensionNames();
                    boolean bl2 = bl = !Collections.disjoint(datasetDimensionNames, matchedDeps.stream().map(dep -> dep.idim).collect(Collectors.toSet()));
                    if (shouldFixAllAvailablePartitioning && bl) {
                        this.fixAllAvailablePartitioning(((FlowRecipe)graphNode).getModel(), matchedDeps, datasetDimensionNames);
                    } else if (!shouldFixAllAvailablePartitioning) {
                        this.warnAllAvailableDependency((FlowRecipe)graphNode, bl, false, messages);
                    }
                }
                this.maybeFixupAndSaveRecipe(((FlowRecipe)graphNode).getModel(), messages, doIt);
            }
        }
    }

    private void maybeFixupAndSaveRecipe(SerializedRecipe recipe, InfoMessage.InfoMessages messages, boolean doIt) throws IOException, DKUSecurityException, CodedException {
        SerializedRecipe copy = (SerializedRecipe)JSON.deepCopy((Object)recipe);
        boolean wasModified = new PDepsFixuper().fixupInPlace(copy);
        if (!wasModified) {
            return;
        }
        if (doIt) {
            logger.info((Object)("Saving (pdep fixup) recipe: " + copy.projectKey + "." + copy.name));
            String payload = this.recipesDAO.getPayloadOrNull(copy.projectKey, copy.name);
            this.recipeSaveService.save(copy.projectKey, copy, payload);
        } else {
            messages.withInfo((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PDEP_UPDATE_REQUIRED, "Inconsistent or outdated partition dependencies were found in recipe " + copy.projectKey + "." + copy.name + ". They will be automatically fixed.");
        }
    }

    public void delete(String projectKey, String name) throws Exception {
        this.delete(projectKey, name, true);
    }

    public void delete(String projectKey, String name, boolean updateFlowZones) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        JsonObject details = new JsonObject();
        try {
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNull(projectKey, name);
            this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), sd);
            if (updateFlowZones) {
                this.flowZonesService.cleanupObjectFromZones(projectKey, sd);
            }
            details.addProperty("datasetType", sd.type);
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.datasetsDAO.delete(projectKey, name);
        this.neverBuiltComputablesCacheService.remove(new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.DATASET, name));
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.DATASET, projectKey, name, t.getUser(), TaggableObjectChangedEvent.ActionType.DATASET_DELETE).withDetails(details));
    }

    public String transmogrifyName(String projectKey, String name) throws IOException {
        StringTransmogrifier st2 = new StringTransmogrifier();
        for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
            st2.addAlreadyTransmogrified(sd.name);
        }
        Matcher matcher = DatasetUtils.DATASET_NAME_UNAUTHORIZED_CHARACTERS_PATTERN.matcher(name);
        String validName = matcher.replaceAll("_");
        DatasetUtils.checkName(validName);
        return st2.transmogrify(validName);
    }

    private void warnAllAvailableDependency(FlowRecipe recipe, boolean isActionable, boolean upstreamDependency, InfoMessage.InfoMessages messages) {
        String recipeName = recipe.getName();
        String direction = upstreamDependency ? " upstream" : " downstream";
        String warningMessage = "One of the input partition dependency of the " + direction + " recipe " + recipeName + " is set to \"All available\". You can choose to automatically fix this, the dependency will be set to \"Equals\".";
        if (isActionable) {
            messages.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_DANGEROUS_PARTITIONING_ACTIONABLE, warningMessage);
        } else {
            messages.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_DANGEROUS_PARTITIONING, warningMessage);
        }
    }

    private List<SerializedRecipe.SDep> getAllAvailableDeps(SerializedRecipe recipe) {
        return recipe.getInputsForRole("main").stream().flatMap(input -> input.deps.stream()).filter(dep -> "all_available".equals(dep.func)).toList();
    }

    private void fixAllAvailablePartitioning(SerializedRecipe recipe, List<SerializedRecipe.SDep> allAvailablePartitioningDependencies, List<String> datasetDimensionNames) throws IOException, DKUSecurityException, CodedException {
        List<SerializedRecipe.SDep> matchedDeps = this.getAllAvailableDeps(recipe);
        boolean toSave = false;
        if (!matchedDeps.isEmpty()) {
            for (SerializedRecipe.SDep matchedDep : matchedDeps) {
                if (!datasetDimensionNames.contains(matchedDep.idim)) continue;
                matchedDep.func = "equals";
                toSave = true;
            }
        }
        if (toSave) {
            logger.info((Object)("Fixing dangerous all_available partitioning in recipe " + String.valueOf(recipe.getRef()) + " by setting it to equals"));
            String payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
            this.recipeSaveService.save(recipe.projectKey, recipe, payload);
        }
    }

    public static class DatasetCreationContext {
        public final DatasetCreationType type;
        public final String recipeType;
        public final List<SerializedRecipe.RecipeInput> recipeInputs;
        public final String originProjectKey;
        public final String originDatasetName;
        private String zoneId;

        public DatasetCreationContext(DatasetCreationType type, String recipeType, List<SerializedRecipe.RecipeInput> recipeInputs, String originProjectKey, String originDatasetName) {
            this.type = type;
            this.recipeType = recipeType;
            this.recipeInputs = recipeInputs;
            this.originProjectKey = originProjectKey;
            this.originDatasetName = originDatasetName;
        }

        public String getZoneId() {
            return this.zoneId;
        }

        public void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        public static DatasetCreationContext buildDefault() {
            return new DatasetCreationContext(DatasetCreationType.DEFAULT, null, null, null, null);
        }

        public static DatasetCreationContext buildFromRecipe(String recipeType, List<SerializedRecipe.RecipeInput> recipeInputs) {
            return new DatasetCreationContext(DatasetCreationType.FROM_RECIPE, recipeType, recipeInputs, null, null);
        }

        public static DatasetCreationContext buildFromRecipe(SerializedRecipe recipe) {
            return new DatasetCreationContext(DatasetCreationType.FROM_RECIPE, recipe.type, recipe.getFlatInputs(), null, null);
        }

        public static DatasetCreationContext buildCopyFromAnotherProject(String originProjectKey, String originDatasetName) {
            return new DatasetCreationContext(DatasetCreationType.COPY_FROM_ANOTHER_PROJECT, null, null, originProjectKey, originDatasetName);
        }

        public static enum DatasetCreationType {
            DEFAULT,
            FROM_RECIPE,
            COPY_FROM_ANOTHER_PROJECT;

        }
    }
}

