/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.enterpriseassetlibrary;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetCollection;
import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetLibraryCodes;
import com.dataiku.dip.enterpriseassetlibrary.UIEnterpriseAssetCollection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseAssetLibraryService;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseProject;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseProjectsService;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterprisePrompt;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterprisePromptTemplate;
import com.dataiku.dip.server.enterpriseassetlibrary.UIEnterpriseProject;
import com.dataiku.dip.server.enterpriseassetlibrary.UIEnterprisePrompt;
import com.dataiku.dip.server.enterpriseassetlibrary.UIEnterprisePromptTemplate;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.j2ts.annotations.UIModel;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class EnterpriseAssetLibraryController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private EnterpriseAssetLibraryService enterpriseAssetLibraryService;
    @Autowired
    private EnterpriseProjectsService enterpriseProjectsService;

    @AuditedCall(value={"msgType", "enterprise-asset-library-get-all-projects", "collectionIdsToIgnore", "${collectionIdsToIgnore}"})
    @RequestMapping(value={"/api/enterprise-asset-library/get-all-projects"}, method={RequestMethod.GET})
    public void getAllProjects(HttpServletRequest req, HttpServletResponse resp, String collectionIdsToIgnore) throws Exception {
        ArrayList<UIEnterpriseProject> projects = new ArrayList<UIEnterpriseProject>();
        try (Transaction tr = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            Set collectionIdsToIgnoreSet = Arrays.stream(collectionIdsToIgnore.split(",")).collect(Collectors.toSet());
            for (EnterpriseAssetCollection collection : this.enterpriseAssetLibraryService.listCollections()) {
                if (collectionIdsToIgnoreSet.contains(collection.id) || !this.enterpriseAssetLibraryService.hasReadPermissionOnEnterpriseAssetCollection(collection.id, user)) continue;
                projects.addAll(this.enterpriseAssetLibraryService.getProjects(collection.getId()).values().stream().map(project -> new UIEnterpriseProject(collection.getId(), collection.displayName, (EnterpriseProject)project)).toList());
            }
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, projects);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-get-all-prompts"})
    @RequestMapping(value={"/api/enterprise-asset-library/get-all-prompts"}, method={RequestMethod.GET})
    public void getAllPrompts(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ArrayList<UIEnterprisePrompt> prompts = new ArrayList<UIEnterprisePrompt>();
        try (Transaction tr = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            for (EnterpriseAssetCollection collection : this.enterpriseAssetLibraryService.listCollections()) {
                if (!this.enterpriseAssetLibraryService.hasReadPermissionOnEnterpriseAssetCollection(collection.id, user)) continue;
                prompts.addAll(this.enterpriseAssetLibraryService.getPrompts(collection.id).values().stream().map(prompt -> new UIEnterprisePrompt(collection, (EnterprisePrompt)prompt)).toList());
            }
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, prompts);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-get-all-prompt-templates"})
    @RequestMapping(value={"/api/enterprise-asset-library/get-all-prompt-templates"}, method={RequestMethod.GET})
    public void getAllPromptTemplates(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ArrayList<UIEnterprisePromptTemplate> prompts = new ArrayList<UIEnterprisePromptTemplate>();
        try (Transaction tr = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            for (EnterpriseAssetCollection collection : this.enterpriseAssetLibraryService.listCollections()) {
                if (!this.enterpriseAssetLibraryService.hasReadPermissionOnEnterpriseAssetCollection(collection.id, user)) continue;
                prompts.addAll(this.enterpriseAssetLibraryService.getPromptTemplates(collection.id).values().stream().map(prompt -> new UIEnterprisePromptTemplate(collection, (EnterprisePromptTemplate)prompt)).toList());
            }
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, prompts);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-get-projects", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/projects-from-collection-homepage"}, method={RequestMethod.GET})
    public void getProjectsFromCollectionHomepage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String collectionId) throws Exception {
        List<EnterpriseProject> projects;
        try (Transaction tr = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            this.enterpriseAssetLibraryService.checkReadPermissionOnEnterpriseAssetCollection(collectionId, user);
            projects = this.enterpriseAssetLibraryService.getProjects(collectionId).values().stream().toList();
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, projects);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-get-prompts", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/prompts-from-collection-homepage"}, method={RequestMethod.GET})
    public void getPromptsFromCollectionHomepage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String collectionId) throws Exception {
        List<EnterprisePrompt> prompts;
        try (Transaction tr = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            this.enterpriseAssetLibraryService.checkReadPermissionOnEnterpriseAssetCollection(collectionId, user);
            prompts = this.enterpriseAssetLibraryService.getPrompts(collectionId).values().stream().toList();
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, prompts);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-get-prompt-templates", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/prompt-templates-from-collection-homepage"}, method={RequestMethod.GET})
    public void getPromptTemplatesFromCollectionHomepage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String collectionId) throws Exception {
        List<EnterprisePromptTemplate> prompts;
        try (Transaction tr = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            this.enterpriseAssetLibraryService.checkReadPermissionOnEnterpriseAssetCollection(collectionId, user);
            prompts = this.enterpriseAssetLibraryService.getPromptTemplates(collectionId).values().stream().toList();
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, prompts);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-publish-project", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/publish-project"}, method={RequestMethod.POST})
    public void publishProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String importId, @RequestParam String collectionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            this.enterpriseAssetLibraryService.checkWritePermissionOnEnterpriseAssetCollection(collectionId, user);
            this.enterpriseAssetLibraryService.checkCollectionAllowsUpdate(collectionId);
            EnterpriseProject project = this.enterpriseAssetLibraryService.moveProjectArchive(importId, collectionId);
            this.enterpriseAssetLibraryService.publishProject(collectionId, project);
            t.commit(String.format("Added project %s to the Enterprise Asset Collection %s", project.id, collectionId));
            EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, (Object)new Id(project.id));
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-publish-prompt", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/publish-prompt"}, method={RequestMethod.POST})
    public void publishPrompt(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam String collectionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            this.enterpriseAssetLibraryService.checkWritePermissionOnEnterpriseAssetCollection(collectionId, user);
            this.enterpriseAssetLibraryService.checkCollectionAllowsUpdate(collectionId);
            EnterprisePrompt prompt = (EnterprisePrompt)JSON.parse((String)data, EnterprisePrompt.class);
            if (StringUtils.isBlank((String)prompt.id)) {
                prompt.id = SecretKeyGenerator.generate((int)16);
                this.enterpriseAssetLibraryService.publishPrompt(collectionId, prompt);
                t.commit(String.format("Added prompt %s to the Enterprise Asset Collection %s", prompt.id, collectionId));
            } else {
                this.enterpriseAssetLibraryService.updatePrompt(collectionId, prompt);
                t.commit(String.format("Updated prompt %s in the Enterprise Asset Collection %s", prompt.id, collectionId));
            }
            EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, (Object)new Id(prompt.id));
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-publish-prompt-template", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/publish-prompt-template"}, method={RequestMethod.POST})
    public void publishPromptTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam String collectionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            this.enterpriseAssetLibraryService.checkWritePermissionOnEnterpriseAssetCollection(collectionId, user);
            this.enterpriseAssetLibraryService.checkCollectionAllowsUpdate(collectionId);
            EnterprisePromptTemplate promptTemplate = (EnterprisePromptTemplate)JSON.parse((String)data, EnterprisePromptTemplate.class);
            if (StringUtils.isBlank((String)promptTemplate.id)) {
                promptTemplate.id = SecretKeyGenerator.generate((int)16);
                this.enterpriseAssetLibraryService.publishPromptTemplate(collectionId, promptTemplate);
                t.commit(String.format("Added prompt template %s to the Enterprise Asset Collection %s", promptTemplate.id, collectionId));
            } else {
                this.enterpriseAssetLibraryService.updatePromptTemplate(collectionId, promptTemplate);
                t.commit(String.format("Updated prompt template %s in the Enterprise Asset Collection %s", promptTemplate.id, collectionId));
            }
            EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, (Object)new Id(promptTemplate.id));
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-upload-project", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/project/upload"}, method={RequestMethod.POST})
    public void uploadProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart, @RequestParam String collectionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            this.enterpriseAssetLibraryService.checkWritePermissionOnEnterpriseAssetCollection(collectionId, user);
            this.enterpriseAssetLibraryService.checkCollectionAllowsUpdate(collectionId);
        }
        String importId = SecretKeyGenerator.generate((int)16);
        logger.info((Object)("Uploading Enterprise project " + filePart.getOriginalFilename()));
        try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"enterprise_asset_library", (String)"upload", (String)"zip");){
            EnterpriseProject existingMetadata;
            try (FileOutputStream fos = new FileOutputStream((File)tmpFile);){
                IOUtils.copyLarge((InputStream)filePart.getInputStream(), (OutputStream)fos);
            }
            EnterpriseProject metadata = this.enterpriseAssetLibraryService.getProjectMetadataWithSanityChecks((File)tmpFile);
            File archiveFile = this.enterpriseAssetLibraryService.getTemporaryArchiveFile(importId);
            FileUtils.moveFile((File)tmpFile, (File)archiveFile);
            String readme = null;
            try (ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();){
                this.enterpriseAssetLibraryService.writeProjectReadMeToOutputStream(this.enterpriseAssetLibraryService.getTemporaryArchiveFile(importId), outputStream2);
                readme = ((Object)outputStream2).toString();
            }
            catch (CodedException | IOException outputStream2) {
                // empty catch block
            }
            try (Transaction t = this.transactionService.beginRead();){
                existingMetadata = this.enterpriseAssetLibraryService.getProjects(collectionId).values().stream().filter(project -> Objects.equals(project.id, metadata.id)).max(Comparator.comparing(p -> p.version)).orElse(null);
            }
            EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, (Object)new ProjectImportDetails(metadata, readme, importId, existingMetadata));
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-delete-project", "projectId", "${projectId}", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/project/delete"}, method={RequestMethod.POST})
    public void deleteProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectId, @RequestParam String collectionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            this.enterpriseAssetLibraryService.checkWritePermissionOnEnterpriseAssetCollection(collectionId, authCtx);
            this.enterpriseAssetLibraryService.checkCollectionAllowsUpdate(collectionId);
            this.enterpriseAssetLibraryService.deleteProject(collectionId, projectId);
            t.commit(String.format("Deleted Enterprise project %s from collection %s", projectId, collectionId));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/enterprise-asset-library/project/get-image"}, method={RequestMethod.GET})
    public void getProjectDefaultImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String importId, @RequestParam boolean isImported, @RequestParam String version, @RequestParam String collectionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getUserNoXSRF(req);
            this.enterpriseAssetLibraryService.checkReadPermissionOnEnterpriseAssetCollection(collectionId, authCtx);
        }
        File archiveFile = isImported ? this.enterpriseAssetLibraryService.getProjectArchiveFile(collectionId, importId, version) : this.enterpriseAssetLibraryService.getTemporaryArchiveFile(importId);
        this.enterpriseAssetLibraryService.writeProjectImageToOutputStream(archiveFile, (OutputStream)resp.getOutputStream());
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/enterprise-asset-library/project/get-readme"}, method={RequestMethod.GET})
    public void getProjectReadMe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String version, @RequestParam String collectionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkReadPermissionOnEnterpriseAssetCollection(collectionId, authCtx);
        }
        this.enterpriseAssetLibraryService.writeProjectReadMeToOutputStream(this.enterpriseAssetLibraryService.getProjectArchiveFile(collectionId, projectKey, version), (OutputStream)resp.getOutputStream());
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-create-project", "projectId", "${id}", "projectFolderId", "${projectFolderId}", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/create-project"}, method={RequestMethod.POST})
    public void createProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id, @RequestParam(required=false) String projectFolderId, @RequestParam String collectionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!authCtx.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects from the Enterprise Asset Library");
            }
            if (!this.enterpriseAssetLibraryService.hasReadPermissionOnEnterpriseAssetCollection(collectionId, authCtx)) {
                throw new SecurityException("You don't have read permission on the Enterprise Asset Collection " + collectionId);
            }
            EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, this.enterpriseProjectsService.createProject(authCtx, collectionId, id, projectFolderId));
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-prompts-list-all-tags"})
    @RequestMapping(value={"/api/enterprise-asset-library/prompts/list-all-tags"}, method={RequestMethod.GET})
    public void listAllPromptTags(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Set<String> tags;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            tags = this.enterpriseAssetLibraryService.listAllPromptsTags(authCtx);
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, tags);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-prompt-templates-list-all-tags"})
    @RequestMapping(value={"/api/enterprise-asset-library/prompt-templates/list-all-tags"}, method={RequestMethod.GET})
    public void listAllPromptTemplateTags(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Set<String> tags;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            tags = this.enterpriseAssetLibraryService.listAllPromptTemplatesTags(authCtx);
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, tags);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-get-prompt", "promptId", "${promptId}", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/prompt-from-collection-homepage"}, method={RequestMethod.GET})
    public void getPromptFromCollectionHomepage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String promptId, @RequestParam String collectionId) throws Exception {
        EnterprisePrompt prompt;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            this.enterpriseAssetLibraryService.checkReadPermissionOnEnterpriseAssetCollection(collectionId, user);
            prompt = this.enterpriseAssetLibraryService.getPrompt(collectionId, promptId);
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, (Object)prompt);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-get-prompt-template", "promptTemplateId", "${promptTemplateId}", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/prompt-template-from-collection-homepage"}, method={RequestMethod.GET})
    public void getPromptTemplateFromCollectionHomepage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String promptTemplateId, @RequestParam String collectionId) throws Exception {
        EnterprisePromptTemplate prompt;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            this.enterpriseAssetLibraryService.checkReadPermissionOnEnterpriseAssetCollection(collectionId, user);
            prompt = this.enterpriseAssetLibraryService.getPromptTemplate(collectionId, promptTemplateId);
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, (Object)prompt);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-delete-prompt", "promptId", "${promptId}", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/prompts/delete"}, method={RequestMethod.POST})
    public void deletePrompt(HttpServletRequest req, HttpServletResponse resp, @RequestParam String promptId, @RequestParam String collectionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            this.enterpriseAssetLibraryService.checkWritePermissionOnEnterpriseAssetCollection(collectionId, authCtx);
            this.enterpriseAssetLibraryService.checkCollectionAllowsUpdate(collectionId);
            this.enterpriseAssetLibraryService.deletePrompt(collectionId, promptId);
            t.commit(String.format("Deleted Enterprise prompt %s from collection %s", promptId, collectionId));
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-delete-prompt-template", "promptTemplateId", "${promptTemplateId}", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/prompt-templates/delete"}, method={RequestMethod.POST})
    public void deletePromptTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String promptTemplateId, @RequestParam String collectionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            this.enterpriseAssetLibraryService.checkWritePermissionOnEnterpriseAssetCollection(collectionId, authCtx);
            this.enterpriseAssetLibraryService.checkCollectionAllowsUpdate(collectionId);
            this.enterpriseAssetLibraryService.deletePromptTemplate(collectionId, promptTemplateId);
            t.commit(String.format("Deleted Enterprise prompt template %s from collection %s", promptTemplateId, collectionId));
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-create-collection"})
    @RequestMapping(value={"/api/enterprise-asset-library/collections/create"}, method={RequestMethod.POST})
    public void createCollection(HttpServletRequest req, HttpServletResponse resp, @RequestParam UIEnterpriseAssetCollection.CreationInfo creationInfo) throws Exception {
        EnterpriseAssetCollection createdCollection;
        DSSAuthCtx user;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(user);
            createdCollection = this.enterpriseAssetLibraryService.createCollection(user, creationInfo);
            t.commit(String.format("Added collection %s to the Enterprise Asset Library ", createdCollection.getId()));
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, (Object)new UIEnterpriseAssetCollection.CollectionInfo(createdCollection, createdCollection.permissions, createdCollection.permissions.stream().filter(p -> Objects.equals(user.getIdentifier(), p.user)).findFirst().orElse(null), createdCollection.allowCollectionDeletion, createdCollection.allowCollectionUpdate, this.enterpriseAssetLibraryService.isEnterpriseProjectsAllowed(), 0, 0, 0));
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-list-collections"})
    @RequestMapping(value={"/api/enterprise-asset-library/collections/list"}, method={RequestMethod.GET})
    public void listCollections(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ArrayList<UIEnterpriseAssetCollection.ListItem> collections;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            collections = new ArrayList<UIEnterpriseAssetCollection.ListItem>();
            for (EnterpriseAssetCollection collection : this.enterpriseAssetLibraryService.listCollections()) {
                if (!this.enterpriseAssetLibraryService.hasReadPermissionOnEnterpriseAssetCollection(collection.id, authCtx)) continue;
                int projectsCount = 0;
                boolean projectsAllowed = this.enterpriseAssetLibraryService.isEnterpriseProjectsAllowed();
                if (projectsAllowed) {
                    try {
                        projectsCount = this.enterpriseAssetLibraryService.getProjects(collection.getId()).size();
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to get projects on collection " + collection.id));
                    }
                }
                int promptsCount = 0;
                try {
                    promptsCount = this.enterpriseAssetLibraryService.getPrompts(collection.getId()).size();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to get prompts on collection " + collection.id));
                }
                int promptTemplatesCount = 0;
                try {
                    promptTemplatesCount = this.enterpriseAssetLibraryService.getPromptTemplates(collection.getId()).size();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to get prompt templates on collection " + collection.id));
                }
                collections.add(new UIEnterpriseAssetCollection.ListItem(collection, projectsAllowed, projectsCount, promptsCount, promptTemplatesCount));
            }
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, collections);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-collection-get-info", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/collections/get-info"}, method={RequestMethod.GET})
    public void getCollectionInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String collectionId) throws Exception {
        UIEnterpriseAssetCollection.CollectionInfo collectionInfo;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            this.enterpriseAssetLibraryService.checkReadPermissionOnEnterpriseAssetCollection(collectionId, authCtx);
            collectionInfo = this.enterpriseAssetLibraryService.getCollectionInfo(authCtx, collectionId);
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, (Object)collectionInfo);
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-collection-update-metadata", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/collections/update-metadata"}, method={RequestMethod.PUT})
    @ResponseBody
    public void updateCollectionMetadata(HttpServletRequest req, @RequestParam String collectionId, @RequestParam UIEnterpriseAssetCollection.MetadataInfo metadata) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            EnterpriseAssetCollection collection = this.getEnterpriseAssetCollection(collectionId);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            this.enterpriseAssetLibraryService.checkWritePermissionOnEnterpriseAssetCollection(collectionId, authCtx);
            this.enterpriseAssetLibraryService.checkCollectionAllowsUpdate(collectionId);
            this.enterpriseAssetLibraryService.updateCollectionMetadata(collection, metadata);
            t.commit("Updated Enterprise Asset Collection " + collectionId + " metadata");
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-collection-update-permissions", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/collections/update-permissions"}, method={RequestMethod.PUT})
    @ResponseBody
    public void updateCollectionPermissions(HttpServletRequest req, @RequestParam String collectionId, @RequestParam List<BasePermissions.PermissionItem> permissions) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            EnterpriseAssetCollection collection = this.getEnterpriseAssetCollection(collectionId);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            this.enterpriseAssetLibraryService.checkAdminPermissionOnEnterpriseAssetCollection(collectionId, authCtx);
            this.enterpriseAssetLibraryService.checkCollectionAllowsUpdate(collectionId);
            this.enterpriseAssetLibraryService.updateCollectionPermissions(collection, permissions);
            t.commit("Updated Enterprise Asset Collection " + collectionId + " permissions");
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-delete-collection", "collectionId", "${collectionId}"})
    @RequestMapping(value={"/api/enterprise-asset-library/collections/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteCollection(HttpServletRequest req, @RequestParam String collectionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            EnterpriseAssetCollection collection = this.getEnterpriseAssetCollection(collectionId);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            this.enterpriseAssetLibraryService.checkAdminPermissionOnEnterpriseAssetCollection(collection, authCtx);
            this.enterpriseAssetLibraryService.checkCollectionAllowsDeletion(collectionId);
            this.enterpriseAssetLibraryService.deleteCollection(collectionId);
            t.commit("Deleted Enterprise Asset Collection " + collectionId);
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-collections-list-all-tags"})
    @RequestMapping(value={"/api/enterprise-asset-library/collections/list-all-tags"}, method={RequestMethod.GET})
    public void listAllCollectionsTags(HttpServletRequest req, HttpServletResponse resp) throws IOException, DKUSecurityException {
        Set<String> tags;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.enterpriseAssetLibraryService.checkMayUserAccessEnterpriseAssetLibrary(authCtx);
            tags = this.enterpriseAssetLibraryService.listAllCollectionsTags(authCtx);
        }
        EnterpriseAssetLibraryController.writeJSON((HttpServletResponse)resp, tags);
    }

    @Nonnull
    private EnterpriseAssetCollection getEnterpriseAssetCollection(String collectionId) throws IOException, CodedException {
        Optional<EnterpriseAssetCollection> collection = this.enterpriseAssetLibraryService.getCollection(collectionId);
        if (collection.isEmpty()) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_COLLECTION_NOT_FOUND, "Enterprise Asset Collection " + collectionId + " does not exist");
        }
        return collection.get();
    }

    @UIModel
    private static class ProjectImportDetails {
        public final EnterpriseProject metadata;
        public final String readme;
        public final String importId;
        public final EnterpriseProject existingMetadata;

        ProjectImportDetails(EnterpriseProject metadata, String readme, String importId, EnterpriseProject existingMetadata) {
            this.metadata = metadata;
            this.readme = readme;
            this.importId = importId;
            this.existingMetadata = existingMetadata;
        }
    }
}

