/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.enterpriseassetlibrary;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetCollection;
import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetLibraryCodes;
import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetLibraryDAO;
import com.dataiku.dip.enterpriseassetlibrary.UIEnterpriseAssetCollection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.projects.TutorialsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseAsset;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseProject;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterprisePrompt;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterprisePromptTemplate;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseAssetLibraryService {
    public static final String DKU_PROJECTS_EXCLUDES_CONFIG = "dku.enterpriseassetlibrary.projects.excludes";
    public static final String DKU_PROMPTS_EXCLUDES_CONFIG = "dku.enterpriseassetlibrary.prompts.excludes";
    public static final String DKU_PROMPT_TEMPLATES_EXCLUDES_CONFIG = "dku.enterpriseassetlibrary.prompt-templates.excludes";
    @Autowired
    private EnterpriseAssetLibraryDAO dao;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private TutorialsService tutorialsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ImageService imageService;
    private static final File enterpriseAssetLibraryUploadDir = DKUApp.getFile((String)"enterprise_asset_library");
    private EnterpriseAssetCollection dataikuCollection;
    private Map<String, EnterpriseProject> dataikuCollectionProjectsById = null;
    private Map<String, EnterprisePrompt> dataikuCollectionPromptsById = null;
    private Map<String, EnterprisePromptTemplate> dataikuCollectionPromptTemplatesById = null;
    public static final Pattern PROJECT_VERSION_UNAUTHORIZED_CHARACTERS_PATTERN = Pattern.compile("[^\\w-.]");
    private static final Logger logger = Logger.getLogger((String)"dku.enterpriseassetlibrary");

    @PostConstruct
    public void init() {
        this.tutorialsService.init();
        UIEnterpriseAssetCollection.CreationInfo creationInfo = new UIEnterpriseAssetCollection.CreationInfo();
        creationInfo.displayName = "Dataiku Collection";
        creationInfo.description = "This collection contains assets pre-built by Dataiku that can solve a variety of use cases across industries and business functions";
        creationInfo.permissions = List.of(BasePermissions.PermissionItem.ofGroup("$$ALL_USERS$$", true, false, false));
        this.dataikuCollection = new EnterpriseAssetCollection(creationInfo, "DATAIKU");
        this.dataikuCollection.tags.add("Built-in");
    }

    public Map<String, EnterpriseProject> getProjects(String collectionId) throws Exception {
        Map<String, EnterpriseProject> projectsById;
        this.checkCanUseProjectsOrThrow();
        if (Strings.equals((String)collectionId, (String)this.dataikuCollection.id)) {
            projectsById = this.getDataikuCollectionProjects();
        } else {
            if (this.dao.getCollectionOrNull(collectionId, true) == null) {
                throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_NOT_FOUND, String.format("Collection %s not found", collectionId));
            }
            projectsById = this.dao.listProjects(collectionId, true);
        }
        return projectsById;
    }

    private void checkCanUseProjectsOrThrow() throws LicenseRestrictionException {
        if (!this.isEnterpriseProjectsAllowed()) {
            throw new LicenseRestrictionException("Your license does not allow to use projects in the Enterprise Asset Library");
        }
    }

    public boolean isEnterpriseProjectsAllowed() {
        return this.licenseEnforcementService.getFeaturesStatus().enterpriseProjectsAllowed;
    }

    private Map<String, EnterpriseProject> getDataikuCollectionProjects() throws Exception {
        if (this.dataikuCollectionProjectsById == null) {
            TutorialsService.GlobalList tutorialsGlobalList = this.tutorialsService.getList();
            if (!tutorialsGlobalList.couldFetch) {
                throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_DATAIKU_COLLECTION_PROJECTS_NOT_LOADED, tutorialsGlobalList.fetchError.detailedMessage);
            }
            this.dataikuCollectionProjectsById = tutorialsGlobalList.items.stream().map(EnterpriseProject::new).collect(Collectors.toMap(EnterpriseProject::getId, proj -> proj));
            this.filterAssets(this.dataikuCollectionProjectsById, DKU_PROJECTS_EXCLUDES_CONFIG);
        }
        return this.dataikuCollectionProjectsById;
    }

    public Map<String, EnterprisePrompt> getPrompts(String collectionId) throws IOException, CodedException {
        Map<String, EnterprisePrompt> promptsById;
        if (Strings.equals((String)collectionId, (String)this.dataikuCollection.id)) {
            promptsById = this.getDataikuCollectionPrompts();
        } else {
            if (this.dao.getCollectionOrNull(collectionId, true) == null) {
                throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_NOT_FOUND, String.format("Collection %s not found", collectionId));
            }
            promptsById = this.dao.listPrompts(collectionId, true);
        }
        return promptsById;
    }

    public Map<String, EnterprisePromptTemplate> getPromptTemplates(String collectionId) throws IOException, CodedException {
        Map<String, EnterprisePromptTemplate> promptsById;
        if (Strings.equals((String)collectionId, (String)this.dataikuCollection.id)) {
            promptsById = this.getDataikuCollectionPromptTemplates();
        } else {
            if (this.dao.getCollectionOrNull(collectionId, true) == null) {
                throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_NOT_FOUND, String.format("Collection %s not found", collectionId));
            }
            promptsById = this.dao.listPromptTemplates(collectionId, true);
        }
        return promptsById;
    }

    public void filterAssets(Map<String, ? extends EnterpriseAsset> assetsById, String dipExcludeProperty) {
        String excludes = DKUApp.getProperty((String)dipExcludeProperty, null);
        if (StringUtils.isBlank((String)excludes)) {
            return;
        }
        Set<String> excludedAssetIds = Set.of(excludes.split(","));
        assetsById.keySet().removeIf(excludedAssetIds::contains);
    }

    private Map<String, EnterprisePrompt> getDataikuCollectionPrompts() throws CodedException {
        if (this.dataikuCollectionPromptsById == null) {
            this.dataikuCollectionPromptsById = Map.of();
            File f = DKUApp.getResourceFile((String[])new String[]{"enterprise-asset-library", "builtin-prompts", "prompt_library_dku_v1.json"});
            if (!f.exists()) {
                logger.error((Object)"Builtin prompts resource file does not exist");
                throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_DATAIKU_COLLECTION_PROMPTS_NOT_LOADED, "Builtin prompts resource file does not exist");
            }
            try {
                this.dataikuCollectionPromptsById = (Map)JSON.parseFile((File)f, (TypeToken)new TypeToken<Map<String, EnterprisePrompt>>(){});
            }
            catch (Exception e) {
                logger.error((Object)"Failed to parse builtin prompts resource file", (Throwable)e);
                throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_DATAIKU_COLLECTION_PROMPTS_NOT_LOADED, "Failed to parse builtin prompts resource file", (Throwable)e);
            }
            this.filterAssets(this.dataikuCollectionPromptsById, DKU_PROMPTS_EXCLUDES_CONFIG);
        }
        return this.dataikuCollectionPromptsById;
    }

    private Map<String, EnterprisePromptTemplate> getDataikuCollectionPromptTemplates() throws CodedException {
        if (this.dataikuCollectionPromptTemplatesById == null) {
            this.dataikuCollectionPromptTemplatesById = Map.of();
            File f = DKUApp.getResourceFile((String[])new String[]{"enterprise-asset-library", "builtin-prompt-templates", "prompt_template_library_dku_v1.json"});
            if (!f.exists()) {
                logger.error((Object)"Builtin prompt templates resource file does not exist");
                throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_DATAIKU_COLLECTION_PROMPT_TEMPLATES_NOT_LOADED, "Builtin prompt templates resource file does not exist");
            }
            try {
                this.dataikuCollectionPromptTemplatesById = (Map)JSON.parseFile((File)f, (TypeToken)new TypeToken<Map<String, EnterprisePromptTemplate>>(){});
            }
            catch (Exception e) {
                logger.error((Object)"Failed to parse builtin prompt templates resource file", (Throwable)e);
                throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_DATAIKU_COLLECTION_PROMPT_TEMPLATES_NOT_LOADED, "Failed to parse builtin prompt templates resource file", (Throwable)e);
            }
            this.filterAssets(this.dataikuCollectionPromptTemplatesById, DKU_PROMPT_TEMPLATES_EXCLUDES_CONFIG);
        }
        return this.dataikuCollectionPromptTemplatesById;
    }

    public UIEnterpriseAssetCollection.CollectionInfo getCollectionInfo(DSSAuthCtx authCtx, String collectionId) throws Exception {
        TransactionContext.retrieveRead();
        Optional<EnterpriseAssetCollection> optionalCollection = this.getCollection(collectionId);
        if (optionalCollection.isEmpty()) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_COLLECTION_NOT_FOUND, "Enterprise Asset Collection " + collectionId + " does not exist");
        }
        BasePermissions.PermissionItem userPermission = this.getUserPermissionOnCollection(optionalCollection.get(), (AuthCtx)authCtx);
        EnterpriseAssetCollection collection = optionalCollection.get();
        boolean projectsAllowed = this.isEnterpriseProjectsAllowed();
        int projectsCount = 0;
        int promptsCount = 0;
        int promptTemplatesCount = 0;
        if (projectsAllowed) {
            try {
                projectsCount = this.getProjects(collection.getId()).size();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get projects counts on collection " + collection.id));
            }
        }
        try {
            promptsCount = this.getPrompts(collection.getId()).size();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get prompts counts on collection " + collection.id));
        }
        try {
            promptTemplatesCount = this.getPromptTemplates(collection.getId()).size();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get prompt templates counts on collection " + collection.id));
        }
        return new UIEnterpriseAssetCollection.CollectionInfo(collection, collection.permissions, userPermission, collection.allowCollectionDeletion, collection.allowCollectionUpdate, projectsAllowed, projectsCount, promptsCount, promptTemplatesCount);
    }

    public void publishProject(String collectionId, EnterpriseProject tutorial) throws IOException, LicenseRestrictionException {
        this.checkCanUseProjectsOrThrow();
        this.dao.publishProject(collectionId, tutorial);
    }

    public void deleteProject(String collectionId, String projectId) throws IOException, CodedException, LicenseRestrictionException {
        this.checkCanUseProjectsOrThrow();
        this.dao.deleteProject(collectionId, projectId);
        DKUFileUtils.deleteDirectory((File)DKUApp.getFile((File)enterpriseAssetLibraryUploadDir, (String[])new String[]{collectionId, "projects", projectId}));
    }

    public void publishPrompt(String collectionId, EnterprisePrompt prompt) throws IOException, CodedException {
        EnterpriseAssetLibraryService.checkMandatoryPromptFields(prompt);
        this.dao.publishPrompt(collectionId, prompt);
    }

    public void publishPromptTemplate(String collectionId, EnterprisePromptTemplate promptTemplate) throws IOException, CodedException {
        EnterpriseAssetLibraryService.checkMandatoryPromptTemplateFields(promptTemplate);
        this.dao.publishPromptTemplate(collectionId, promptTemplate);
    }

    public void updatePrompt(String collectionId, EnterprisePrompt prompt) throws IOException, CodedException {
        this.getPrompt(collectionId, prompt.id);
        this.dao.publishPrompt(collectionId, prompt);
    }

    public void updatePromptTemplate(String collectionId, EnterprisePromptTemplate promptTemplate) throws IOException, CodedException {
        this.getPromptTemplate(collectionId, promptTemplate.id);
        this.dao.publishPromptTemplate(collectionId, promptTemplate);
    }

    public EnterprisePrompt getPrompt(String collectionId, String promptId) throws IOException, CodedException {
        EnterprisePrompt prompt = this.getPrompts(collectionId).get(promptId);
        if (prompt == null) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_NOT_FOUND, String.format("Prompt %s not found", promptId));
        }
        return prompt;
    }

    public EnterprisePromptTemplate getPromptTemplate(String collectionId, String promptTemplateId) throws IOException, CodedException {
        EnterprisePromptTemplate promptTemplate = this.getPromptTemplates(collectionId).get(promptTemplateId);
        if (promptTemplate == null) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_NOT_FOUND, String.format("Prompt template %s not found", promptTemplateId));
        }
        return promptTemplate;
    }

    public void deletePrompt(String collectionId, String promptId) throws IOException, CodedException {
        this.dao.deletePrompt(collectionId, promptId);
    }

    public void deletePromptTemplate(String collectionId, String promptTemplateId) throws IOException, CodedException {
        this.dao.deletePromptTemplate(collectionId, promptTemplateId);
    }

    public void checkMayUserAccessEnterpriseAssetLibrary(DSSAuthCtx user) throws DKUSecurityException {
        if (!user.getPermissions().mayManageEnterpriseAssetLibrary() && !user.getPermissions().mayCreateEnterpriseAssetCollections()) {
            throw new DKUSecurityException("Please make sure you have the \"Manage Enterprise Asset Library\" or \"Create Enterprise Asset Collections\" permission").withCode((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_LIBRARY_ACCESS_UNAUTHORIZED);
        }
    }

    public void checkReadPermissionOnEnterpriseAssetCollection(String collectionId, DSSAuthCtx user) throws DKUSecurityException, IOException, CodedException {
        if (!this.hasReadPermissionOnEnterpriseAssetCollection(collectionId, user)) {
            throw new DKUSecurityException("You don't have read permission on the Enterprise Asset Collection " + collectionId);
        }
    }

    public boolean hasReadPermissionOnEnterpriseAssetCollection(String collectionId, DSSAuthCtx user) throws DKUSecurityException, IOException, CodedException {
        BasePermissions.PermissionItem userPermissionOnCollection = this.getUserPermissionOnCollection(collectionId, (AuthCtx)user);
        return userPermissionOnCollection.read;
    }

    public void checkWritePermissionOnEnterpriseAssetCollection(String collectionId, DSSAuthCtx user) throws DKUSecurityException, IOException, CodedException {
        if (!this.hasWritePermissionOnEnterpriseAssetCollection(collectionId, user)) {
            throw new DKUSecurityException("You don't have write permission on the Enterprise Asset Collection " + collectionId);
        }
    }

    public boolean hasWritePermissionOnEnterpriseAssetCollection(String collectionId, DSSAuthCtx user) throws DKUSecurityException, IOException, CodedException {
        BasePermissions.PermissionItem userPermissionOnCollection = this.getUserPermissionOnCollection(collectionId, (AuthCtx)user);
        return userPermissionOnCollection.write;
    }

    public void checkAdminPermissionOnEnterpriseAssetCollection(String collectionId, DSSAuthCtx user) throws DKUSecurityException, IOException, CodedException {
        Optional<EnterpriseAssetCollection> collection = this.getCollection(collectionId);
        if (collection.isEmpty()) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_COLLECTION_NOT_FOUND, "Enterprise Asset Collection " + collectionId + " does not exist");
        }
        this.checkAdminPermissionOnEnterpriseAssetCollection(collection.get(), user);
    }

    public void checkAdminPermissionOnEnterpriseAssetCollection(EnterpriseAssetCollection collection, DSSAuthCtx user) throws DKUSecurityException {
        BasePermissions.PermissionItem userPermissionOnCollection = this.getUserPermissionOnCollection(collection, (AuthCtx)user);
        if (!userPermissionOnCollection.admin) {
            throw new DKUSecurityException("You don't have admin permission on the Enterprise Asset Collection " + collection.id);
        }
    }

    public EnterpriseProject getProjectMetadataWithSanityChecks(@Nonnull File projectZipFile) throws IOException, CodedException, LicenseRestrictionException {
        EnterpriseProject metadata;
        this.checkCanUseProjectsOrThrow();
        String metadataPath = "project-resources/metadata/project.json";
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.writeProjectZipEntryToOutputStream(out, projectZipFile, metadataPath, true);
            try (ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());){
                metadata = (EnterpriseProject)JSON.parse((InputStream)in, EnterpriseProject.class);
            }
        }
        try {
            EnterpriseAssetLibraryService.checkMandatoryProjectFields(metadata);
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FILE_INVALID, "File " + metadataPath + " is invalid: " + e.getMessage());
        }
        return metadata;
    }

    public void writeProjectImageToOutputStream(File archivePath, OutputStream outputStream) throws IOException, CodedException, LicenseRestrictionException {
        this.checkCanUseProjectsOrThrow();
        boolean done = this.writeProjectZipEntryToOutputStream(outputStream, archivePath, "project_config/pictures/project-original.png", false);
        if (!done) {
            EnterpriseProject metadata = this.getProjectMetadataWithSanityChecks(archivePath);
            String id = metadata.id;
            if (id == null) {
                id = SecretKeyGenerator.generate((int)16);
            }
            try (InputStream inputStream = this.imageService.getDefaultPicture(id, "PROJECT", null, null, null, null);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
    }

    public void writeProjectReadMeToOutputStream(File archivePath, OutputStream outputStream) throws IOException, CodedException, LicenseRestrictionException {
        this.checkCanUseProjectsOrThrow();
        this.writeProjectZipEntryToOutputStream(outputStream, archivePath, "project-resources/metadata/README.md", false);
    }

    private boolean writeProjectZipEntryToOutputStream(OutputStream outputStream, @Nonnull File projectZipFile, @Nonnull String zipEntryPath, boolean zipEntryMandatory) throws CodedException, IOException {
        if (!projectZipFile.isFile()) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_PROJECT_ARCHIVE_NOT_FOUND, "Project archive not found, try reuploading your project");
        }
        try (ZipFile zipFile = new ZipFile(projectZipFile);){
            ZipEntry entry = zipFile.getEntry(zipEntryPath);
            if (entry == null) {
                if (zipEntryMandatory) {
                    throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FILE_NOT_FOUND, zipEntryPath + " not found in archive");
                }
                boolean bl = false;
                return bl;
            }
            try (InputStream inputStream = zipFile.getInputStream(entry);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            boolean bl = true;
            return bl;
        }
    }

    public EnterpriseAssetCollection createCollection(DSSAuthCtx authCtx, UIEnterpriseAssetCollection.CreationInfo creationInfo) throws IOException, CodedException, LicenseRestrictionException {
        Integer maxNumCollections = this.licenseEnforcementService.getFeaturesStatus().enterpriseAssetLibraryMaxNumCollections;
        if (maxNumCollections != null && maxNumCollections >= 0 && this.listCustomCollections().size() >= maxNumCollections) {
            throw new LicenseRestrictionException(String.format("Your license is limited to %d Enterprise Asset Collection(s)", maxNumCollections));
        }
        EnterpriseAssetCollection collection = new EnterpriseAssetCollection(creationInfo);
        if (StringUtils.isBlank((String)collection.getDisplayName())) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_INVALID_FIELD, "Collection name cannot be empty");
        }
        String userId = authCtx.getIdentifier();
        collection.permissions.add(BasePermissions.PermissionItem.ofUser(userId, true, true, true));
        return this.saveCollection(collection);
    }

    @Nonnull
    private EnterpriseAssetCollection saveCollection(EnterpriseAssetCollection collection) throws IOException {
        EnterpriseAssetCollection preExisting = this.dao.getCollectionOrNull(collection.getId(), true);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(collection, preExisting);
        this.dao.saveCollection(collection);
        return collection;
    }

    public Optional<EnterpriseAssetCollection> getCollection(String collectionId) throws IOException {
        if (Strings.equals((String)collectionId, (String)this.dataikuCollection.id)) {
            return Optional.of(this.dataikuCollection);
        }
        return Optional.ofNullable(this.dao.getCollectionOrNull(collectionId, true));
    }

    public void deleteCollection(String collectionId) throws IOException {
        TransactionContext.retrieveWrite();
        this.dao.deleteCollection(collectionId);
    }

    public List<EnterpriseAssetCollection> listCollections() throws IOException {
        List<EnterpriseAssetCollection> collections = this.listCustomCollections();
        collections.add(this.dataikuCollection);
        return collections;
    }

    public List<EnterpriseAssetCollection> listCustomCollections() throws IOException {
        return this.dao.listCollections(true);
    }

    public void updateCollectionMetadata(EnterpriseAssetCollection collection, UIEnterpriseAssetCollection.MetadataInfo metadataInfo) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)metadataInfo.displayName), (Object)"Collection name cannot be empty");
        Preconditions.checkNotNull((Object)metadataInfo.description, (Object)"Collection description cannot be null");
        Preconditions.checkNotNull((Object)metadataInfo.color, (Object)"Collection color cannot be null");
        Preconditions.checkNotNull(metadataInfo.tags, (Object)"Collection tags cannot be null");
        collection.displayName = metadataInfo.displayName;
        collection.color = metadataInfo.color;
        collection.description = metadataInfo.description;
        collection.tags = metadataInfo.tags;
        this.saveCollection(collection);
    }

    public void updateCollectionPermissions(EnterpriseAssetCollection collection, List<BasePermissions.PermissionItem> permissions) throws IOException, DKUSecurityException {
        if (permissions.stream().noneMatch(permission -> (permission.user != null || permission.group != null) && permission.admin)) {
            throw new ApplicativeException("Configuration error", "A Collection must have at least one administrator.");
        }
        GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsDAO.getUnsafe();
        if (gs.security.restrictUsersAndGroupsVisibility && permissions.stream().anyMatch(p -> "$$ALL_USERS$$".equals(p.group))) {
            throw new DKUSecurityException("You cannot add the 'All users' group due to the general settings of your instance.");
        }
        collection.permissions = permissions;
        this.saveCollection(collection);
    }

    public Set<String> listAllCollectionsTags(DSSAuthCtx authCtx) throws IOException, DKUSecurityException {
        HashSet<String> tags = new HashSet<String>();
        for (EnterpriseAssetCollection collection : this.dao.listCollections(true)) {
            BasePermissions.PermissionItem userPermissionOnCollection = this.getUserPermissionOnCollection(collection, (AuthCtx)authCtx);
            if (!userPermissionOnCollection.read || collection == null || collection.getMetadata() == null || collection.getMetadata().tags == null) continue;
            tags.addAll(collection.getMetadata().tags);
        }
        return tags;
    }

    public Set<String> listAllPromptsTags(AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        HashSet<String> tags = new HashSet<String>();
        for (EnterpriseAssetCollection collection : this.dao.listCollections(true)) {
            if (collection == null || collection.getMetadata() == null) continue;
            BasePermissions.PermissionItem userPermissionOnCollection = this.getUserPermissionOnCollection(collection, authCtx);
            if (!userPermissionOnCollection.read) continue;
            for (EnterprisePrompt prompt : this.getPrompts(collection.getId()).values()) {
                if (prompt == null) continue;
                tags.addAll(prompt.tags);
            }
        }
        return tags;
    }

    public Set<String> listAllPromptTemplatesTags(AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        HashSet<String> tags = new HashSet<String>();
        for (EnterpriseAssetCollection collection : this.dao.listCollections(true)) {
            if (collection == null || collection.getMetadata() == null) continue;
            BasePermissions.PermissionItem userPermissionOnCollection = this.getUserPermissionOnCollection(collection, authCtx);
            if (!userPermissionOnCollection.read) continue;
            for (EnterprisePromptTemplate prompt : this.getPromptTemplates(collection.getId()).values()) {
                if (prompt == null) continue;
                tags.addAll(prompt.tags);
            }
        }
        return tags;
    }

    public EnterpriseProject moveProjectArchive(String importId, String collectionId) throws IOException, CodedException, LicenseRestrictionException {
        this.checkCanUseProjectsOrThrow();
        EnterpriseProject project = this.getProjectMetadataWithSanityChecks(this.getTemporaryArchiveFile(importId));
        DKUFileUtils.mkdirs((File)DKUApp.getFile((File)enterpriseAssetLibraryUploadDir, (String[])new String[]{collectionId, "projects", project.id}));
        Path projectArchivePath = Path.of(enterpriseAssetLibraryUploadDir.getPath(), collectionId, "projects", project.id, project.version + ".zip");
        Files.move(this.getTemporaryArchiveFile(importId).toPath(), projectArchivePath, StandardCopyOption.REPLACE_EXISTING);
        return project;
    }

    @Nonnull
    public File getProjectArchiveFile(String collectionId, String projectKey, String version) throws CodedException, LicenseRestrictionException {
        this.checkCanUseProjectsOrThrow();
        if (StringUtils.isBlank((String)projectKey)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_ID_NULL, "Project ID cannot be empty");
        }
        if (StringUtils.isBlank((String)version)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_VERSION_NULL, "Project version cannot be empty");
        }
        return Path.of(enterpriseAssetLibraryUploadDir.getPath(), collectionId, "projects", projectKey, version + ".zip").toFile();
    }

    public File getTemporaryArchiveFile(String importId) throws IOException {
        return DSSTempUtils.getTempFileWithSpecificName((String)"enterprise_asset_library", (String)importId, (String)"zip");
    }

    public void checkCollectionAllowsUpdate(String collectionId) throws IOException, CodedException {
        Optional<EnterpriseAssetCollection> collection = this.getCollection(collectionId);
        if (collection.isEmpty()) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_COLLECTION_NOT_FOUND, "Enterprise Asset Collection " + collectionId + " does not exist");
        }
        if (!collection.get().allowCollectionUpdate) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_COLLECTION_MODIFICATION_FORBIDDEN, "Enterprise Asset Collection " + collectionId + " can't be updated");
        }
    }

    public void checkCollectionAllowsDeletion(String collectionId) throws IOException, CodedException {
        Optional<EnterpriseAssetCollection> collection = this.getCollection(collectionId);
        if (collection.isEmpty()) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_COLLECTION_NOT_FOUND, "Enterprise Asset Collection " + collectionId + " does not exist");
        }
        if (!collection.get().allowCollectionDeletion) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_COLLECTION_MODIFICATION_FORBIDDEN, "Enterprise Asset Collection " + collectionId + " can't be deleted");
        }
    }

    static void checkMandatoryProjectFields(EnterpriseProject metadata) throws CodedException {
        String errorMessage = "Project is missing the required field %s";
        if (StringUtils.isBlank((String)metadata.id)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "id"));
        }
        if (StringUtils.isBlank((String)metadata.name)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "name"));
        }
        if (StringUtils.isBlank((String)metadata.version)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "version"));
        }
        if (!ProjectsService.isValidProjectKey(metadata.id)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_INVALID_FIELD, "Invalid project id, allowed characters are a-z, A-Z, 0-9 and '_' but project id was: '" + metadata.id + "'.");
        }
        if (PROJECT_VERSION_UNAUTHORIZED_CHARACTERS_PATTERN.matcher(metadata.version).find()) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_INVALID_FIELD, "Invalid project version, allowed characters are a-z, A-Z, 0-9, '.', '_' and '-' but version was: '" + metadata.version + "'.");
        }
    }

    private static void checkMandatoryPromptFields(EnterprisePrompt prompt) throws CodedException {
        String errorMessage = "Prompt is missing the required field %s";
        if (StringUtils.isBlank((String)prompt.id)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "id"));
        }
        if (StringUtils.isBlank((String)prompt.name)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "name"));
        }
        if (StringUtils.isBlank((String)prompt.content)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "content"));
        }
    }

    private static void checkMandatoryPromptTemplateFields(EnterprisePromptTemplate promptTemplate) throws CodedException {
        String errorMessage = "Prompt template is missing the required field %s";
        if (StringUtils.isBlank((String)promptTemplate.id)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "id"));
        }
        if (StringUtils.isBlank((String)promptTemplate.name)) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "name"));
        }
        if (promptTemplate.promptPrefix == null) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "promptPrefix"));
        }
        if (promptTemplate.inputs == null) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "inputs"));
        }
        if (promptTemplate.examples == null) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_METADATA_FIELD_MISSING, String.format(errorMessage, "examples"));
        }
    }

    private BasePermissions.PermissionItem getUserPermissionOnCollection(String collectionId, AuthCtx user) throws DKUSecurityException, IOException, CodedException {
        Optional<EnterpriseAssetCollection> collection = this.getCollection(collectionId);
        if (collection.isEmpty()) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_COLLECTION_NOT_FOUND, "Enterprise Asset Collection " + collectionId + " does not exist");
        }
        return this.getUserPermissionOnCollection(collection.get(), user);
    }

    BasePermissions.PermissionItem getUserPermissionOnCollection(EnterpriseAssetCollection collection, AuthCtx user) throws DKUSecurityException {
        BasePermissions.PermissionItem userPermission = BasePermissions.PermissionItem.ofUser(user.getIdentifier(), false, false, false);
        if (user.isAdmin() || ((DSSAuthCtx)user).getPermissions().mayManageEnterpriseAssetLibrary()) {
            EnterpriseAssetLibraryService.setPermissions(userPermission, true, true, true);
        } else {
            EnterpriseAssetLibraryService.setDominantUserPermission(collection, user, userPermission);
            EnterpriseAssetLibraryService.setDominantGroupPermission(collection, user, userPermission);
        }
        return userPermission;
    }

    static void setDominantUserPermission(EnterpriseAssetCollection collection, AuthCtx user, BasePermissions.PermissionItem userPermission) {
        for (BasePermissions.PermissionItem permission : collection.permissions) {
            if (permission == null || !Objects.equals(permission.user, user.getIdentifier())) continue;
            EnterpriseAssetLibraryService.setPermissions(userPermission, permission.admin, permission.write, permission.read);
            if (!permission.admin) continue;
            break;
        }
    }

    static void setDominantGroupPermission(EnterpriseAssetCollection collection, AuthCtx user, BasePermissions.PermissionItem userPermission) throws DKUSecurityException {
        if (user.isGroupsAware()) {
            HashSet<String> groups = new HashSet<String>(user.getGroups());
            groups.add("$$ALL_USERS$$");
            for (BasePermissions.PermissionItem permission : collection.permissions) {
                if (!groups.contains(permission.group)) continue;
                EnterpriseAssetLibraryService.setPermissions(userPermission, permission.admin, permission.write, permission.read);
                if (!permission.admin) continue;
                break;
            }
        }
    }

    private static void setPermissions(BasePermissions.PermissionItem userPermission, boolean isAdmin, boolean canWrite, boolean canRead) {
        userPermission.admin = userPermission.admin || isAdmin;
        userPermission.write = userPermission.write || canWrite;
        userPermission.read = userPermission.read || canRead;
    }
}

