/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureKernelHandle;
import com.dataiku.dip.futures.FutureKernelsManager;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class FuturesIntercomPrivilegedController
extends DIPInternalControllerBase {
    @Autowired
    private SharedSecretAuthService authService;
    @Autowired
    private FutureKernelsManager futureKernelsManager;
    @Autowired
    private APITicketService apiTicketService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/futures/kernel-register"})
    public void registerKernel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String kernelId, @RequestParam int port) throws IOException {
        this.authService.failIfNoSharedSecret(req);
        this.futureKernelsManager.onRegister(kernelId, port);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/futures/acquire-api-ticket"})
    public void acquireAPITicket(HttpServletRequest req, HttpServletResponse resp, @RequestParam String kernelId, @RequestParam String kernelAPITicket, @RequestParam String description) throws IOException, DKUSecurityException {
        this.authService.failIfNoSharedSecret(req);
        FutureKernelHandle kernel = (FutureKernelHandle)this.futureKernelsManager.getUsedKernel(kernelId);
        if (kernel == null) {
            throw new IllegalArgumentException("Unable to find kernel");
        }
        APITicketService.Ticket kernelTicket = this.apiTicketService.getTicket(kernelAPITicket);
        APITicketService.Ticket ticket = this.apiTicketService.createTicket(kernelTicket.getOriginalUser(), description, null);
        kernel.addOnShutdown(() -> {
            logger.info((Object)("Removing ticket for " + description));
            this.apiTicketService.expireTicket(ticket);
        });
        FuturesIntercomPrivilegedController.writeJSON((HttpServletResponse)resp, (Object)ticket.getSecret());
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/futures/release-api-ticket"})
    public void releaseAPITicket(HttpServletRequest req, HttpServletResponse resp, @RequestParam String kernelAPITicket, @RequestParam String apiTicket) throws IOException, DKUSecurityException {
        this.authService.failIfNoSharedSecret(req);
        this.apiTicketService.getTicketAuthCtx(kernelAPITicket);
        APITicketService.Ticket ticket = this.apiTicketService.getTicket(apiTicket);
        this.apiTicketService.expireTicket(ticket);
    }
}

