/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.aiexplanations.chart.AIChartExplanationService;
import com.dataiku.dip.aigenerations.AIImageGenerationService;
import com.dataiku.dip.aigenerations.AISpeechToTextGenerationService;
import com.dataiku.dip.aigenerations.AITextGenerationService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class AIServicesIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private AITextGenerationService aiTextGenerationService;
    @Autowired
    private AIImageGenerationService aiImageGenerationService;
    @Autowired
    private AIChartExplanationService aiChartExplanationService;
    @Autowired
    private AISpeechToTextGenerationService aiSpeechToTextService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.intercom.aiservices");

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/aiservices/text2story"}, method={RequestMethod.GET})
    @ResponseBody
    public AIText2StoryResponse getText2StoryConfig(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)authCtxUsage.getAuthCtx();
        }
        logger.infoV("Get text2story request", new Object[0]);
        AIText2StoryResponse response = new AIText2StoryResponse();
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        LicenseStatusService.LicensingStatus ls = this.licenseStatusService.getLicensingStatus();
        if (ls.community) {
            throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
        }
        String aiServerUrl = AIFeaturesUtil.getAIServerUrl(generalSettings);
        response.isLocalAIServer = generalSettings.localAIServerSettings.isUsingLocalServer();
        response.storiesAIEnabled = generalSettings.aiDrivenAnalyticsSettings.isAssistantEnabled(GeneralSettingsDAO.AiAssistant.STORIES_ASSISTANT);
        response.storiesVocalEnabled = generalSettings.aiDrivenAnalyticsSettings.isAssistantEnabled(GeneralSettingsDAO.AiAssistant.STORIES_ASSISTANT) && FeatureFlags.isEnabled((String)"storiesVocal");
        response.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
        response.telemetryEnabled = generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled;
        response.dssExternalUrl = generalSettings.studioExternalUrl;
        response.aiServerUrl = aiServerUrl + (aiServerUrl.endsWith("/") ? "" : "/");
        response.proxySettings = ApplicationConfigurator.getProxySettings();
        return response;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/aiservices/text2text/transform"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AITextGenerationService.AITextGenerationFrontendResponse> startTextTransformation(HttpServletRequest req, @RequestBody AITextTransformQuery query) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = (DSSAuthCtx)authCtxUsage.getAuthCtx();
        }
        logger.infoV("Get text transform request %s %s", new Object[]{query.transform, query.text});
        return this.aiTextGenerationService.startTextTransformation(authCtx, query.text, query.transform);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/aiservices/text2text/generate"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AITextGenerationService.AITextGenerationFrontendResponse> startTextGeneration(HttpServletRequest req, @RequestBody AITextGenerationQuery query) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = (DSSAuthCtx)authCtxUsage.getAuthCtx();
        }
        logger.infoV("Get text generation request %s", new Object[]{query.text});
        return this.aiTextGenerationService.startTextGeneration(authCtx, query.text, query.maxLines);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/aiservices/text2image"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AIImageGenerationService.AIImageGenerationFrontendResponse> startImageGeneration(HttpServletRequest req, @RequestBody AIImageGenerationQuery query) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = (DSSAuthCtx)authCtxUsage.getAuthCtx();
        }
        logger.infoV("Get image generation request %s", new Object[]{query.prompt});
        return this.aiImageGenerationService.startImageGeneration(authCtx, query.prompt, AIImageGenerationService.ImageFormat.fromString(query.size), query.response_type);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/aiservices/explain-chart"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AIChartExplanationService.AIExplainChartFrontendResponse> startExplainChart(HttpServletRequest req, @RequestBody AIExplainChartQuery query) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = (DSSAuthCtx)authCtxUsage.getAuthCtx();
        }
        logger.infoV("Get explain chart request %s", new Object[]{query.data});
        return this.aiChartExplanationService.startExplain(authCtx, query.data);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/aiservices/speech2text"}, method={RequestMethod.POST})
    @ResponseBody
    public AISpeechToTextGenerationService.AISpeechToTextFrontendResponse getSpeechToText(HttpServletRequest req, @RequestParam(value="file") MultipartFile file) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = (DSSAuthCtx)authCtxUsage.getAuthCtx();
        }
        logger.infoV("Get speech to text request", new Object[0]);
        return this.aiSpeechToTextService.startSpeechToText(authCtx, file);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/aiservices/log-user-rating"}, method={RequestMethod.POST})
    @ResponseBody
    public AIStoriesFeedbackResponse sendRating(HttpServletRequest req, @RequestBody AIFeedbackQuery query) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)authCtxUsage.getAuthCtx();
        }
        logger.infoV("Get log user rating request %s", new Object[]{query.request_id});
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        LicenseStatusService.LicensingStatus ls = this.licenseStatusService.getLicensingStatus();
        String requestId = query.request_id;
        Boolean isSuccess = query.is_success;
        String feedback = query.feedback;
        String featureName = query.feature_name;
        AIStoriesFeedbackResponse res = new AIStoriesFeedbackResponse();
        res.status = AIFeaturesUtil.sendRating(isSuccess, feedback, requestId, featureName, ls);
        return res;
    }

    public static class AIText2StoryResponse {
        boolean storiesAIEnabled;
        boolean telemetryEnabled;
        String licenseId;
        String dssExternalUrl;
        String aiServerUrl;
        ProxySettings proxySettings;
        boolean isLocalAIServer;
        boolean storiesVocalEnabled;
    }

    public static class AITextTransformQuery {
        String text;
        String transform;
    }

    public static class AITextGenerationQuery {
        String text;
        @Nullable
        Integer maxLines;
    }

    public static class AIImageGenerationQuery {
        String prompt;
        @Nullable
        String size;
        @Nullable
        String response_type;
    }

    public static class AIExplainChartQuery {
        JsonObject data;
    }

    public static class AIFeedbackQuery {
        String request_id;
        Boolean is_success;
        String feedback;
        String feature_name;
    }

    public static class AIStoriesFeedbackResponse {
        boolean status;
    }

    public static class AISpeechToTextGenerationQuery {
        String licenseId;
        MultipartFile file;
    }
}

