/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.jobrunner.JobBackendLoggingContext;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.JobRunner;
import com.dataiku.dip.dataflow.jobrunner.SerializedJobActivity;
import com.dataiku.dip.dataflow.jobrunner.status.CoreJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.master.BuildService;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsLaunchService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.AbstractCheckReport;
import com.dataiku.dip.server.services.dataquality.AbstractValuedCheck;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class JobsIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TicketAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private BuildService buildService;
    @Autowired
    private MetricsLaunchService metricsLaunchService;
    @Autowired
    private ScenarioRunContext scenarioRunContext;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jobs/activity-started"})
    public void activityStarted(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobDef, @RequestParam String activity) throws Exception {
        this.authService.failIfNoTicket(req);
        this.buildService.onActivityStarted((JobDef)JSON.parse((String)jobDef, JobDef.class), (SerializedJobActivityStatus)JSON.parse((String)activity, SerializedJobActivityStatus.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jobs/activity-done"})
    public void activityDone(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobDef, @RequestParam String activity, @RequestParam String scenarioCtx) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            Callable<String> startMetricsActions;
            JobDef jd = (JobDef)JSON.parse((String)jobDef, JobDef.class);
            SerializedJobActivityStatus sja = (SerializedJobActivityStatus)JSON.parse((String)activity, SerializedJobActivityStatus.class);
            JobRunner.ActivityDoneContext adsc = (JobRunner.ActivityDoneContext)JSON.parse((String)scenarioCtx, JobRunner.ActivityDoneContext.class);
            this.scenarioRunContext.setScenarioRun(adsc.scenarioRun);
            this.scenarioRunContext.setStepRun(adsc.stepRun);
            JobContext.setJob(adsc.jobProjectKey, adsc.jobId, null);
            try {
                JobContext.getCurrentJobContext().activity = sja.activityId;
                this.registerTargetsBuiltInJobsDB(sja);
                this.registerTargetsBuiltInNeverBuiltCache(sja);
            }
            finally {
                JobContext.resetJob();
                this.scenarioRunContext.clearScenarioRun();
                this.scenarioRunContext.clearStepRun();
            }
            this.buildService.onActivityDone(jd, sja);
            try (Transaction t = this.transactionService.beginRead();){
                startMetricsActions = this.metricsLaunchService.onActivityDone(tu.getAuthCtx(), jd.projectKey, jd.id, sja);
            }
            startMetricsActions.call();
        }
    }

    private void registerTargetsBuiltInNeverBuiltCache(SerializedJobActivityStatus jas) {
        String jobProjectKey;
        JobContext jobContext = JobContext.getCurrentJobContext();
        String string = jobProjectKey = jobContext == null ? null : jobContext.projectKey;
        if (jas.state == ActivityState.DONE) {
            for (SerializedJobActivityStatus.SerializedTargetDS target : jas.targets) {
                AnyLoc resolved = AnyLoc.resolveSmart(jobProjectKey, target.id).resolved();
                ITaggingService.TaggableType type = target.type.toTaggableType();
                TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(resolved.getProjectKey(), type, resolved.getId());
                this.neverBuiltComputablesCacheService.remove(ref);
            }
        }
    }

    private void registerTargetsBuiltInJobsDB(SerializedJobActivityStatus serializedJobActivityStatus) {
        ReportItem.Outcome outcome = null;
        int warningsCount = serializedJobActivityStatus.getWarningsTotalCount();
        if (serializedJobActivityStatus.state == ActivityState.DONE && warningsCount == 0) {
            outcome = ReportItem.Outcome.SUCCESS;
        } else if (serializedJobActivityStatus.state == ActivityState.DONE && warningsCount > 0) {
            outcome = ReportItem.Outcome.WARNING;
        } else if (serializedJobActivityStatus.state == ActivityState.FAILED) {
            outcome = ReportItem.Outcome.FAILED;
        } else if (serializedJobActivityStatus.state == ActivityState.ABORTED) {
            outcome = ReportItem.Outcome.ABORTED;
        }
        JobContext jobContext = JobContext.getCurrentJobContext();
        String jobProjectKey = jobContext == null ? null : jobContext.projectKey;
        for (SerializedJobActivityStatus.SerializedTargetDS target : serializedJobActivityStatus.targets) {
            AnyLoc loc = AnyLoc.resolveSmart(jobProjectKey, target.id);
            ReportItem reportItem = null;
            switch (target.type) {
                case DATASET: {
                    ReportTargetItem.DatasetPartitionItem datasetItem = new ReportTargetItem.DatasetPartitionItem(loc.getProjectKey(), loc.getId(), target.partition.id);
                    reportItem = new ReportItem.BuiltDataset(datasetItem);
                    break;
                }
                case MANAGED_FOLDER: {
                    ReportTargetItem.ManagedFolderPartitionItem folderItem = new ReportTargetItem.ManagedFolderPartitionItem(loc.getProjectKey(), loc.getId(), target.partition.id);
                    reportItem = new ReportItem.BuiltManagedFolder(folderItem);
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    ReportTargetItem.ModelEvaluationStorePartitionItem evaluationStoreItem = new ReportTargetItem.ModelEvaluationStorePartitionItem(loc.getProjectKey(), loc.getId(), target.partition.id);
                    ReportItem.BuiltEvaluationStore bes = new ReportItem.BuiltEvaluationStore(evaluationStoreItem);
                    bes.evaluationId = target.evaluationId;
                    reportItem = bes;
                    break;
                }
                case RETRIEVABLE_KNOWLEDGE: {
                    ReportTargetItem.RetrievableKnowledgeItem rkItem = new ReportTargetItem.RetrievableKnowledgeItem(loc.getProjectKey(), loc.getId());
                    ReportItem.BuiltRetrievableKnowledge brk = new ReportItem.BuiltRetrievableKnowledge(rkItem);
                    reportItem = brk;
                    break;
                }
                case SAVED_MODEL: {
                    ReportTargetItem.SavedModelPartitionItem modelItem = new ReportTargetItem.SavedModelPartitionItem(loc.getProjectKey(), loc.getId(), target.partition.id);
                    ReportItem.BuiltSavedModel bsm = new ReportItem.BuiltSavedModel(modelItem);
                    bsm.versionId = target.modelVersionId;
                    reportItem = bsm;
                    break;
                }
                case STREAMING_ENDPOINT: {
                    ReportTargetItem.StreamingEndpointItem streamingEndpointItem = new ReportTargetItem.StreamingEndpointItem(loc.getProjectKey(), loc.getId());
                    ReportItem.BuiltStreamingEndpoint bse = new ReportItem.BuiltStreamingEndpoint(streamingEndpointItem);
                    reportItem = bse;
                }
            }
            assert (reportItem != null);
            reportItem.withStart(serializedJobActivityStatus.startTime).withEnd(serializedJobActivityStatus.endTime).withWarnings(serializedJobActivityStatus.warnings).withOutcome(outcome);
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(loc, target.partition.id, jobContext, this.scenarioRunContext.getScenarioRun(), this.scenarioRunContext.getStepRun(), reportItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jobs/run-checks-for-activity"})
    public void runChecksForActivity(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobDef, @RequestParam String activity) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            JobDef jd = (JobDef)JSON.parse((String)jobDef, JobDef.class);
            SerializedJobActivityStatus sja = (SerializedJobActivityStatus)JSON.parse((String)activity, SerializedJobActivityStatus.class);
            JobBackendLoggingContext.setJobContext(JobBackendLoggingContext.Topic.METRICS, jd.id, jd.projectKey, sja.activityId);
            try {
                Callable<List<AbstractCheckReport>> startMetricsActions;
                try (Transaction t = this.transactionService.beginRead();){
                    startMetricsActions = this.metricsLaunchService.startRunChecksForActivitySynchronously(tu.getAuthCtx(), jd.projectKey, jd.id, sja);
                }
                List<AbstractCheckReport> reports = startMetricsActions.call();
                ActivityChecksResults ret = new ActivityChecksResults(reports);
                JobsIntercomController.writeJSON((HttpServletResponse)resp, (Object)ret);
            }
            finally {
                JobBackendLoggingContext.resetJobContext();
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jobs/status-update"})
    public void statusUpdate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String jobId, @RequestParam String status) throws Exception {
        this.authService.failIfNoTicket(req);
        this.buildService.onStatusUpdate(jobProjectKey, jobId, (CoreJobStatus)JSON.parse((String)status, CoreJobStatus.class));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jobs/ask-build-permit"})
    public void askBuildPermit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String jobId, @RequestParam String activity) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNoTicket(req);
            JobsIntercomController.writeJSON((HttpServletResponse)resp, (Object)this.buildService.onAskBuildPermit(jobProjectKey, jobId, (SerializedJobActivity)JSON.parse((String)activity, SerializedJobActivity.class)));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jobs/wait-build-permit"})
    public void waitBuildPermit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String jobId, @RequestParam String permitIdentifier, @RequestParam int timeoutMs) throws Exception {
        this.authService.failIfNoTicket(req);
        JobsIntercomController.writeJSON((HttpServletResponse)resp, (Object)this.buildService.onWaitBuildPermit(jobProjectKey, jobId, permitIdentifier, timeoutMs));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jobs/release-build-permit"})
    public void releaseBuildPermit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String jobId, @RequestParam String permitIdentifier) throws Exception {
        this.authService.failIfNoTicket(req);
        this.buildService.onReleaseBuildPermit(jobProjectKey, jobId, permitIdentifier);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jobs/emit-audit"})
    public void getJobStatusIntercom(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String jobId, @RequestParam String obj) throws Exception {
        this.authService.failIfNoTicket(req);
        JsonObject jobj = (JsonObject)JSON.parse((String)obj, JsonObject.class);
        jobj.addProperty("jobProjectKey", jobProjectKey);
        jobj.addProperty("jobId", jobId);
        this.auditTrailService.emit(new AuditObj("generic").withAll(jobj));
    }

    public static class ActivityChecksResults {
        public boolean success;
        public int count;
        public int warningCount;
        public int errorCount;
        public int ignoredErrorCount;
        public int okCount;
        public int noValueCount;
        public List<String> errors = new LinkedList<String>();
        public List<String> warnings = new LinkedList<String>();
        public Map<String, List<ErrorDetails>> computationFailuresDetails = new HashMap<String, List<ErrorDetails>>();

        public ActivityChecksResults(List<? extends AbstractCheckReport> reports) {
            for (AbstractCheckReport abstractCheckReport : reports) {
                boolean isAboutDataQualityRules = abstractCheckReport instanceof AbstractCheckReport.DataQualityRulesComputationReport;
                boolean ignoreError = false;
                if (isAboutDataQualityRules) {
                    AbstractCheckReport.DataQualityRulesComputationReport castedReport = (AbstractCheckReport.DataQualityRulesComputationReport)abstractCheckReport;
                    ignoreError = castedReport.ignoreError;
                    for (MetricsComputationService.MetricsEngineRunReport mReport : castedReport.metricsRuns) {
                        if (mReport.error == null) continue;
                        ErrorDetails details = new ErrorDetails(null, mReport.error.clazz, mReport.error.message, mReport.error.stack, mReport.logTail != null ? mReport.logTail.lines : new ArrayList(), false);
                        this.computationFailuresDetails.computeIfAbsent(castedReport.partition, k -> new ArrayList()).add(details);
                    }
                }
                for (MetricsComputationService.MetricsCheckRunReport mcReport : abstractCheckReport.runs) {
                    if (mcReport.error == null) continue;
                    ErrorDetails details = new ErrorDetails(mcReport.name, mcReport.error.clazz, mcReport.error.message, mcReport.error.stack, mcReport.logTail != null ? mcReport.logTail.lines : new ArrayList(), isAboutDataQualityRules);
                    this.computationFailuresDetails.computeIfAbsent(mcReport.partition, k -> new ArrayList()).add(details);
                }
                for (AbstractValuedCheck result : abstractCheckReport.getResults()) {
                    ++this.count;
                    if (result.value.outcome == AbstractCheckContext.CheckOutcome.ERROR) {
                        if (ignoreError) {
                            ++this.ignoredErrorCount;
                        } else {
                            ++this.errorCount;
                        }
                        this.errors.add(String.format("Error for %s %s : %s", isAboutDataQualityRules ? "rule" : "check", result.getCheck().getId(), result.value.message));
                        continue;
                    }
                    if (result.value.outcome == AbstractCheckContext.CheckOutcome.WARNING) {
                        ++this.warningCount;
                        this.warnings.add(String.format("Warning for %s %s : %s", isAboutDataQualityRules ? "rule" : "check", result.getCheck().getId(), result.value.message));
                        continue;
                    }
                    if (result.value.outcome == AbstractCheckContext.CheckOutcome.OK) {
                        ++this.okCount;
                        continue;
                    }
                    if (result.value.outcome != AbstractCheckContext.CheckOutcome.EMPTY) continue;
                    ++this.noValueCount;
                }
            }
            this.success = this.errorCount == 0;
        }

        public static class ErrorDetails {
            public boolean isAboutDataQualityRules = false;
            @Nullable
            public String ruleName;
            public String clazz;
            public String message;
            public String stacktrace;
            public List<String> logs;

            public ErrorDetails(@Nullable String ruleName, String clazz, String message, String stacktrace, List<String> logs, boolean isAboutDataQualityRule) {
                this.ruleName = ruleName;
                this.clazz = clazz;
                this.message = message;
                this.stacktrace = stacktrace;
                this.logs = logs;
                this.isAboutDataQualityRules = isAboutDataQualityRule;
            }
        }
    }

    public static class CheckFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CheckFailedException(String message) {
            super(message);
        }
    }
}

