/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class NotebooksIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private SQLNotebooksService sqlNotebooksService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TicketAuthService authService;

    @AuditedCall(value={"msgType", "sql-notebooks-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/sql-notebooks/read-config/"})
    public void readNotebookConfig(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId) throws Exception {
        Validate.notEmpty((String)projectKey);
        Validate.notEmpty((String)notebookId);
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            SQLNotebook nb = this.sqlNotebooksService.getOrNull(projectKey, notebookId);
            if (nb == null) {
                throw new IllegalArgumentException("Notebook not found (" + projectKey + " . " + notebookId + ")");
            }
            NotebooksIntercomController.writeJSON((HttpServletResponse)resp, (Object)nb);
        }
    }

    @AuditedCall(value={"msgType", "sql-notebooks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/sql-notebooks/list/"})
    public void listNotebooks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        Validate.notEmpty((String)projectKey);
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            NotebooksIntercomController.writeJSON((HttpServletResponse)resp, this.sqlNotebooksService.listWithoutTimeline(projectKey));
        }
    }
}

