/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.recipes.shaker.ShakerStandaloneResourceCollector;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.ExceptionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RecipesIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSchemaService recipeSchemaService;
    private static Logger logger = Logger.getLogger((String)"dip.intercom.recipe");

    @AuditedCall(value={"msgType", "project-resolved-variables-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/recipes/get-shaker-resources"})
    public void getShakerResources(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ShakerStandaloneResourceCollector collector = new ShakerStandaloneResourceCollector(authCtxUsage.getAuthCtx(), projectKey, recipeName);
            try (AutoDelete tmpDir = collector.collectResources();){
                resp.setContentType("application/zip");
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + recipeName + ".zip\"");
                resp.setStatus(200);
                ZipUnzipDir.zipDirectoryToStream((File)tmpDir, new BufferedOutputStream((OutputStream)resp.getOutputStream()));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to gather resources for shaker", (Throwable)e);
                resp.setStatus(204);
                resp.getWriter().write("Failed to gather resources for shaker: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/recipes/get-schema-update-result"})
    @ResponseBody
    public RecipeSchemaService.RecipeSchemaAutoupdateResult getSchemaUpdateResult(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName, @RequestParam boolean autoUpdate) throws Exception {
        SerializedRecipe sr = null;
        String payload = null;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            sr = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, recipeName);
            payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
        }
        if (autoUpdate) {
            return this.recipeSchemaService.checkRecipe(authCtx, projectKey, recipeName, true, null);
        }
        return this.recipeSchemaService.computeSaveImpact_NT(authCtx, sr, payload);
    }
}

