/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.metrics;

import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.metrics.Model;
import com.dataiku.dip.metrics.probes.PartitioningProbeType;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStoreMetricsStatusService {
    @Autowired
    private ReadOnlyJobsInternalDB jobsDatabaseAccessService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.partitionable.status.service");
    private LongMeaning longMeaning = new LongMeaning();

    public DataStoreSummaryStatus getCachedSummaryStatus(Partitionable dataStore, Set<String> metricIdSet) throws Exception {
        logger.traceV("getCachedSummaryStatus dataStore=%s", new Object[]{dataStore.getFullName()});
        CachedPartitionsList partitionsList = this.getCachedPartitionsList(dataStore);
        logger.traceV("getCachedSummaryStatus dataStore=%s nb_partitions=%d", new Object[]{dataStore.getFullName(), partitionsList.partitionIds.size()});
        try {
            Map<String, Model.SummedDatasetMetricValue> metricIdToValueMap = metricIdSet.stream().collect(Collectors.toMap(Function.identity(), ExceptionUtils.checkedFunction(metricId -> this.getCachedValues(dataStore, (String)metricId, partitionsList.partitionIds, false))));
            logger.traceV("getCachedSummaryStatus done dataStore=%s", new Object[]{dataStore.getFullName()});
            return new DataStoreSummaryStatus(metricIdToValueMap, partitionsList.lastCompute, partitionsList.partitionIds().size());
        }
        catch (RuntimeException e) {
            throw (Exception)e.getCause();
        }
    }

    private Model.SummedDatasetMetricValue getCachedValues(Partitionable dataStore, String metricId, Set<String> partitionIdSet, boolean withDetails) throws Exception {
        AnyLoc loc = dataStore.getLoc();
        Model.SummedDatasetMetricValue ret = withDetails ? new Model.DetailedSummedDatasetMetricValue() : new Model.SummedDatasetMetricValue();
        List<ReadOnlyJobsInternalDB.MetricDataPoint> values = this.jobsDatabaseAccessService.getLastMetricValues(loc, metricId);
        long totalValue = 0L;
        HashMap partitionValues = Maps.newHashMap();
        boolean hasData = false;
        for (ReadOnlyJobsInternalDB.MetricDataPoint point : values) {
            if (point.partition.equals("ALL") || !partitionIdSet.contains(point.partition)) continue;
            ret.updateTimeRange(point.time);
            try {
                long partitionValue = this.longMeaning.permissiveLongValue(point.value);
                partitionValues.put(point.partition, partitionValue);
                totalValue += partitionValue;
                hasData = true;
            }
            catch (Exception ex) {
                logger.warn((Object)("Metric value " + point.value + " is not a record count. Ignoring partition " + point.partition));
            }
        }
        boolean hasMissing = false;
        for (String partitionId : partitionIdSet) {
            if (partitionId.equals("ALL")) continue;
            Long partitionValue = (Long)partitionValues.get(partitionId);
            if (partitionValue == null) {
                hasMissing = true;
                if (!withDetails) continue;
                ((Model.DetailedSummedDatasetMetricValue)ret).partitions.add(new Model.LongMetricPartitionValue(partitionId, -1L));
                continue;
            }
            if (!withDetails) continue;
            ((Model.DetailedSummedDatasetMetricValue)ret).partitions.add(new Model.LongMetricPartitionValue(partitionId, partitionValue));
        }
        ret.totalValue = hasData ? totalValue : -1L;
        ret.incomplete = hasMissing;
        ret.hasData = hasData;
        return ret;
    }

    private CachedPartitionsList getCachedPartitionsList(Partitionable dataStore) throws Exception {
        AnyLoc loc = dataStore.getLoc();
        if (dataStore.getPartitioningSchema().isPartitioned()) {
            long lastCompute = 0L;
            HashSet<String> partitionIds = new HashSet<String>();
            List<ReadOnlyJobsInternalDB.MetricDataPoint> partitionList = this.jobsDatabaseAccessService.getLastMetricValues(loc, new PartitioningProbeType.PartitioningMetric(PartitioningProbeType.PartitioningMetrics.PARTITIONS_LIST).getId());
            for (ReadOnlyJobsInternalDB.MetricDataPoint point : partitionList) {
                if (!point.partition.equals("ALL") && !point.partition.equals("NP")) continue;
                lastCompute = point.time;
                try {
                    partitionIds.addAll((Collection)JSON.parse((String)point.value, (TypeToken)new TypeToken<List<String>>(){}));
                }
                catch (Exception exception) {}
            }
            return new CachedPartitionsList(lastCompute, partitionIds);
        }
        return new CachedPartitionsList(System.currentTimeMillis(), Set.of("NP"));
    }

    private record CachedPartitionsList(long lastCompute, Set<String> partitionIds) {
    }

    public record DataStoreSummaryStatus(Map<String, Model.SummedDatasetMetricValue> metricIdToValueMap, long partitionsLastCompute, int partitionCount) {
    }
}

