/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.export.DashboardsExportService;
import com.dataiku.dip.dashboards.export.model.DashboardExport;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.model.ExportResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.backend.ProjectInvitationEmailSentEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.emails.AbstractInviteEmailSendService;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.DkuPubSubService;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dss.shadelib.com.google.common.io.BaseEncoding;
import com.dataiku.dss.shadelib.com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardSharedEmailBuilder {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private DkuPubSubService dkuPubSubService;
    @Autowired
    private DashboardsExportService dashboardsExportService;
    @Autowired
    protected FutureService futureService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private ProjectsService projectsService;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.dashboard.shared");

    public DashboardSharedEmailBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public FutureResponse<AbstractInviteEmailSendService.InvitationEmailSendResult> shareDashboardAsync(AuthCtx user, String projectKey, String dashboardId, List<String> invitedEmails, List<String> invitedUsers, String personalMessage) throws Exception {
        ShareDashboardFutureThread futureThread = new ShareDashboardFutureThread(user, projectKey, dashboardId, invitedEmails, invitedUsers, personalMessage);
        FutureResponse result = this.futureService.safeRunFuture(futureThread, 0L);
        return result;
    }

    public void sendToUser(String email, String triggeredByUser, String projectKey, String dashboardId, String personalMessage, @Nullable String screenshotString, AbstractInviteEmailSendService.InvitationEmailSendResult result) throws Exception {
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        params.subject = "Dataiku \u2022 A dashboard has been shared with you";
        logger.info((Object)("Sending grant email to " + email));
        String body = this.makeBody(triggeredByUser, projectKey, dashboardId, personalMessage, screenshotString);
        EmailNotificationsSender sender = new EmailNotificationsSender();
        try {
            Future<InfoMessage.InfoMessages> emailSendingFuture = sender.sendToUser(email, params, body);
            InfoMessage.InfoMessages infoMessages = emailSendingFuture.get();
            if (!infoMessages.anyMessage) {
                result.sentEmails.add(email);
            } else {
                result.failedEmails.add(email);
                result.infoMessages.messages.addAll(infoMessages.messages);
            }
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Failed to send invitation email to '%s'", email), (Throwable)e);
            result.failedEmails.add(email);
            result.infoMessages.addMessage(InfoMessage.error((String)String.format("Failed to send invitation email to '%s'", email), (String)e.getMessage()));
        }
    }

    public String makeBody(String triggeredByUser, String projectKey, String dashboardId, String personalMessage, @Nullable String screenshotString) throws Exception {
        HrefContext href;
        Dashboard dashboard;
        VariableLookup lookup = new VariableLookup();
        try (Transaction ignored = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            lookup.addVariable("emailPreferencesLink", settings.studioExternalUrl + "/profile/");
            dashboard = this.dashboardsService.getMandatory(projectKey, dashboardId);
            href = new HrefContext(settings.studioExternalUrl);
            lookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)settings.studioExternalUrl) ? null : settings.studioExternalUrl);
            if (StringUtils.isNotBlank((String)screenshotString)) {
                lookup.addVariable("dashboardThumbnail", screenshotString);
            }
        }
        lookup.addVariable("objectType", "DASHBOARD");
        lookup.addVariable("title", "A dashboard has been shared with you");
        lookup.addVariable("requestAction", triggeredByUser + " has shared a dashboard with you");
        lookup.addVariable("dashboardLink", href.dashboard(projectKey, dashboardId));
        lookup.addVariable("dashboardName", dashboard.name);
        if (!StringUtils.isBlank((String)personalMessage)) {
            lookup.addVariable("personalMessage", personalMessage);
        }
        lookup.addVariable("openButtonLabel", "DASHBOARD");
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "access-granted-email.ftl"});
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(new TemplatedContent(), templateFile);
        return expandedTemplate.message;
    }

    public FutureResponse<ExportResult> generateDashboardThumbnail(AuthCtx user, String projectKey, String dashboardId) throws Exception {
        ExportFormat exportFormat = new ExportFormat();
        exportFormat.paperSize = ExportFormat.PaperSize.SCREEN_16_9;
        exportFormat.fileType = ExportFormat.FileType.PNG;
        exportFormat.width = 960;
        DashboardExport.Target target = new DashboardExport.Target(dashboardId, 0, exportFormat);
        DashboardExport export = new DashboardExport(projectKey, exportFormat, target);
        return this.dashboardsExportService.export(user, export);
    }

    private class ShareDashboardFutureThread
    extends SimpleFutureThread<AbstractInviteEmailSendService.InvitationEmailSendResult> {
        private final String projectKey;
        private final String dashboardId;
        private final List<String> invitedEmails;
        private final List<String> invitedUsers;
        private final String personalMessage;

        public ShareDashboardFutureThread(AuthCtx user, String projectKey, String dashboardId, List<String> invitedEmails, List<String> invitedUsers, String personalMessage) {
            super(user);
            this.projectKey = projectKey;
            this.dashboardId = dashboardId;
            this.invitedEmails = invitedEmails;
            this.invitedUsers = invitedUsers;
            this.personalMessage = personalMessage;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "share_dashboard";
            fp.targets.add(new FuturePayload.FuturePayloadTarget(this.projectKey, "dashboard"));
            fp.displayName = String.format("Sharing dashboard %s", this.dashboardId);
            return fp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Loose catch block
         */
        @Override
        public AbstractInviteEmailSendService.InvitationEmailSendResult compute() throws Exception {
            AbstractInviteEmailSendService.InvitationEmailSendResult invitationEmailSendResult2;
            AbstractInviteEmailSendService.InvitationEmailSendResult result;
            block62: {
                String screenshotString;
                HashSet<String> targetEmails;
                block60: {
                    block58: {
                        Object t;
                        block59: {
                            Map<String, UserSettingsService.UserSettings> usersSettings;
                            block55: {
                                AbstractInviteEmailSendService.InvitationEmailSendResult invitationEmailSendResult2;
                                block56: {
                                    result = new AbstractInviteEmailSendService.InvitationEmailSendResult();
                                    targetEmails = new HashSet<String>();
                                    this.invitedEmails.stream().filter(StringUtils::isNotBlank).forEach(targetEmails::add);
                                    GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
                                    if (!StringUtils.isBlank((String)generalSettings.notifications.emailChannelId)) break block55;
                                    logger.warn((Object)"Email channel is disabled or not configured, no email was sent");
                                    result.failedEmails.addAll(targetEmails);
                                    invitationEmailSendResult2 = result;
                                    if (result.failedEmails.isEmpty()) break block56;
                                    try (RWTransaction t2 = DashboardSharedEmailBuilder.this.transactionService.beginWriteAsDSS();){
                                        SerializedProject sp = DashboardSharedEmailBuilder.this.projectsService.getMandatory(this.projectKey);
                                        for (SerializedProject.PermissionItem permission : sp.permissions) {
                                            if (!result.failedEmails.stream().anyMatch(failedEmail -> failedEmail.equalsIgnoreCase(permission.pendingUserEmail))) continue;
                                            permission.invitationEmailStatus = AbstractInviteEmailSendService.InvitationEmailStatus.FAILED;
                                        }
                                        DashboardSharedEmailBuilder.this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
                                        t2.commitV("Failed to send invitations for dashboards %s", new Object[]{this.dashboardId});
                                    }
                                }
                                return invitationEmailSendResult2;
                            }
                            t = DashboardSharedEmailBuilder.this.transactionService.beginRead();
                            try {
                                usersSettings = DashboardSharedEmailBuilder.this.userSettingsService.getForUsers(this.invitedUsers);
                            }
                            finally {
                                if (t != null) {
                                    t.close();
                                }
                            }
                            for (Map.Entry userSettings : usersSettings.entrySet()) {
                                String email = DashboardSharedEmailBuilder.this.usersService.getPublicUser((String)((String)userSettings.getKey())).email;
                                if (StringUtils.isNotBlank((String)email)) {
                                    if (((UserSettingsService.UserSettings)userSettings.getValue()).grantedAccessEmails.enabled) {
                                        targetEmails.add(email);
                                        continue;
                                    }
                                    logger.info((Object)("User " + (String)userSettings.getKey() + " has disabled granted access emails, not sending dashboard share notification"));
                                    continue;
                                }
                                logger.warn((Object)("User " + (String)userSettings.getKey() + " has no email, cannot send dashboard share notification"));
                            }
                            if (!targetEmails.isEmpty()) break block58;
                            t = result;
                            if (result.failedEmails.isEmpty()) break block59;
                            try (RWTransaction t3 = DashboardSharedEmailBuilder.this.transactionService.beginWriteAsDSS();){
                                SerializedProject sp = DashboardSharedEmailBuilder.this.projectsService.getMandatory(this.projectKey);
                                for (SerializedProject.PermissionItem permission : sp.permissions) {
                                    if (!result.failedEmails.stream().anyMatch(failedEmail -> failedEmail.equalsIgnoreCase(permission.pendingUserEmail))) continue;
                                    permission.invitationEmailStatus = AbstractInviteEmailSendService.InvitationEmailStatus.FAILED;
                                }
                                DashboardSharedEmailBuilder.this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
                                t3.commitV("Failed to send invitations for dashboards %s", new Object[]{this.dashboardId});
                            }
                        }
                        return t;
                    }
                    screenshotString = null;
                    try {
                        FutureResponse exportResponse = DashboardSharedEmailBuilder.this.generateDashboardThumbnail(this.getOwner(), this.projectKey, this.dashboardId);
                        exportResponse = DashboardSharedEmailBuilder.this.futureService.waitForFinalResponse(exportResponse);
                        if (exportResponse.aborted || !exportResponse.hasResult) break block60;
                        File screenshotFile = null;
                        if (((ExportResult)exportResponse.result).exportFile.getName().endsWith(".zip")) {
                            ZipUnzipDir.extractFolder(((ExportResult)exportResponse.result).exportFile, ((ExportResult)exportResponse.result).exportFile.getParentFile());
                            String[] part1found = ((ExportResult)exportResponse.result).exportFile.getParentFile().list((dir, name) -> name.endsWith("_Part-1.png"));
                            if (part1found != null && part1found.length > 0) {
                                screenshotFile = Paths.get(((ExportResult)exportResponse.result).exportFile.getParentFile().getPath(), part1found[0]).toFile();
                            } else {
                                logger.warn((Object)("Cannot find screenshot part1 for dashboard" + this.dashboardId));
                            }
                        } else {
                            screenshotFile = ((ExportResult)exportResponse.result).exportFile;
                        }
                        if (screenshotFile != null) {
                            try (FileInputStream screenshotStream = new FileInputStream(screenshotFile);){
                                screenshotString = "data:image/png;base64,\n" + BaseEncoding.base64().encode(ByteStreams.toByteArray((InputStream)screenshotStream));
                            }
                        }
                        DashboardSharedEmailBuilder.this.dashboardsExportService.clean(this.projectKey, ((ExportResult)exportResponse.result).exportId);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not generate dashboard thumbnail for sharing email", (Throwable)e);
                    }
                }
                for (String email : targetEmails) {
                    DashboardSharedEmailBuilder.this.sendToUser(email, this.getOwner().getIdentifier(), this.projectKey, this.dashboardId, this.personalMessage, screenshotString, result);
                }
                DashboardSharedEmailBuilder.this.dkuPubSubService.publish((DSSEvent)new ProjectInvitationEmailSentEvent(this.getOwner().getIdentifier(), this.projectKey, result));
                invitationEmailSendResult2 = result;
                if (result.failedEmails.isEmpty()) break block62;
                try (RWTransaction t = DashboardSharedEmailBuilder.this.transactionService.beginWriteAsDSS();){
                    SerializedProject sp = DashboardSharedEmailBuilder.this.projectsService.getMandatory(this.projectKey);
                    for (SerializedProject.PermissionItem permission : sp.permissions) {
                        if (!result.failedEmails.stream().anyMatch(failedEmail -> failedEmail.equalsIgnoreCase(permission.pendingUserEmail))) continue;
                        permission.invitationEmailStatus = AbstractInviteEmailSendService.InvitationEmailStatus.FAILED;
                    }
                    DashboardSharedEmailBuilder.this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
                    t.commitV("Failed to send invitations for dashboards %s", new Object[]{this.dashboardId});
                }
            }
            return invitationEmailSendResult2;
            catch (Throwable throwable) {
                if (!result.failedEmails.isEmpty()) {
                    try (RWTransaction t = DashboardSharedEmailBuilder.this.transactionService.beginWriteAsDSS();){
                        SerializedProject sp = DashboardSharedEmailBuilder.this.projectsService.getMandatory(this.projectKey);
                        for (SerializedProject.PermissionItem permission : sp.permissions) {
                            if (!result.failedEmails.stream().anyMatch(failedEmail -> failedEmail.equalsIgnoreCase(permission.pendingUserEmail))) continue;
                            permission.invitationEmailStatus = AbstractInviteEmailSendService.InvitationEmailStatus.FAILED;
                        }
                        DashboardSharedEmailBuilder.this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
                        t.commitV("Failed to send invitations for dashboards %s", new Object[]{this.dashboardId});
                    }
                }
                throw throwable;
            }
        }
    }
}

