/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.mail.AbstractMailSender;
import com.dataiku.dip.integrations.mail.Mail;
import com.dataiku.dip.integrations.mail.MailChannelConfiguration;
import com.dataiku.dip.integrations.mail.factory.MailSenderFactory;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.emails.IEmailService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EmailService
implements IEmailService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IntegrationChannelsDAO integrationChannelsDAO;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private MailSenderFactory mailSenderFactory;
    private static final Logger logger = Logger.getLogger((String)"dataiku.dip.server.notifications.emails");

    @Override
    public void send(AuthCtx authCtx, String channelId, Mail mail, List<MultipartFile> attachments) throws Exception {
        String dssEmail;
        IntegrationChannel channel;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            channel = this.integrationChannelsDAO.getMandatory(channelId);
            dssEmail = this.generalSettingsDAO.getUnsafe().studioMailAddress;
        }
        IntegrationChannelParams integrationChannelParams = channel.getConfiguration();
        if (!(integrationChannelParams instanceof MailChannelConfiguration)) {
            throw new IllegalArgumentException(String.format("Cannot send mails with channel '%s' because it is of type '%s'", channelId, channel.getType()));
        }
        MailChannelConfiguration config = (MailChannelConfiguration)integrationChannelParams;
        AbstractMailSender mailSender = this.mailSenderFactory.createMailSender(authCtx, channel);
        String from = config.computeFromField(authCtx, mail.from, dssEmail);
        Session mailSession = mailSender.newSession();
        for (String to : mail.to) {
            Message message = this.makeMessage(mailSession, from, to, mail.cc, mail.bcc, mail.subject, mail.body, attachments, mail.plainText);
            mailSender.send(mailSession, message, new InfoMessage.InfoMessages());
        }
    }

    private Message makeMessage(Session session, String from, String to, List<String> ccList, List<String> bccList, String subject, String body, List<MultipartFile> attachments, boolean plainText) throws MessagingException, IOException {
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)EmailService.createAndValidateAddress(from, "sender"));
        message.setRecipient(Message.RecipientType.TO, (Address)EmailService.createAndValidateAddress(to, "to"));
        if (ccList != null) {
            for (String cc : ccList) {
                message.addRecipient(Message.RecipientType.CC, (Address)EmailService.createAndValidateAddress(cc, "cc"));
            }
        }
        if (bccList != null) {
            for (String bcc : bccList) {
                message.addRecipient(Message.RecipientType.BCC, (Address)EmailService.createAndValidateAddress(bcc, "bcc"));
            }
        }
        message.setSubject(subject);
        MimeMultipart messageContent = this.makeMessageContent(body, attachments, plainText);
        message.setContent((Multipart)messageContent);
        return message;
    }

    private MimeMultipart makeMessageContent(String body, List<MultipartFile> attachments, boolean plainText) throws IOException, MessagingException {
        MimeMultipart messageContent = this.makeMessageContent(body, plainText);
        if (attachments != null) {
            for (MultipartFile attachment : attachments) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                ByteArrayDataSource ds = new ByteArrayDataSource(attachment.getBytes(), attachment.getContentType());
                attachmentPart.setDataHandler(new DataHandler((DataSource)ds));
                attachmentPart.setFileName(attachment.getOriginalFilename());
                messageContent.addBodyPart((BodyPart)attachmentPart);
            }
        }
        return messageContent;
    }

    private MimeMultipart makeMessageContent(String body, boolean plainText) throws MessagingException {
        MimeMultipart messageContent = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(body, "utf-8", plainText ? "plain" : "html");
        messageContent.addBodyPart((BodyPart)messageBodyPart);
        return messageContent;
    }

    private static InternetAddress createAndValidateAddress(String address, String field) throws AddressException {
        if (address == null) {
            throw new RuntimeException("Invalid or missing address in " + field);
        }
        try {
            InternetAddress emailAddress = new InternetAddress(address);
            emailAddress.validate();
            return emailAddress;
        }
        catch (RuntimeException | AddressException e) {
            throw new IllegalArgumentException("Invalid or missing address in field: " + field, e);
        }
    }
}

