/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.backend.ProjectInvitationEmailSentEvent;
import com.dataiku.dip.server.notifications.backend.ProjectsPermissionsChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.emails.AbstractInviteEmailSendService;
import com.dataiku.dip.server.notifications.emails.ProjectInvitationEmailBuilder;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectInviteEmailSendService
extends AbstractInviteEmailSendService {
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.access.invited");

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init project invitation email service");
        this.pubSubService.subscribe("project-permissions-changed", this::handleProjectPermissionsChangedEvent);
        logger.debug((Object)"Done init project invitation email service");
    }

    @VisibleForTesting
    void handleProjectPermissionsChangedEvent(ProjectsPermissionsChangedEvent evt) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException {
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        HashMap<String, AbstractInviteEmailSendService.InvitationEmailSendResult> results = new HashMap<String, AbstractInviteEmailSendService.InvitationEmailSendResult>();
        for (PermissionsWatcher.ProjectPermissionChange change : evt.diff.pendingUserEmailChanges) {
            if (!PermissionsService.permissionChangeAddsGrant(change, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS)) continue;
            results.computeIfAbsent(change.projectKey, projectKey -> new AbstractInviteEmailSendService.InvitationEmailSendResult());
            if (change.after != null && AbstractInviteEmailSendService.InvitationEmailStatus.SENT.equals((Object)change.after.invitationEmailStatus)) continue;
            this.sendInviteEmails((AbstractInviteEmailSendService.InvitationEmailSendResult)results.get(change.projectKey), change.projectKey, change.user, change.triggeredByUser, generalSettings);
        }
        if (!results.isEmpty()) {
            String triggeredByUser = evt.diff.pendingUserEmailChanges.get((int)0).triggeredByUser;
            for (String projectKey2 : results.keySet()) {
                try (RWTransaction rwt = this.transactionService.beginWriteAsDSS();){
                    this.updateEmailStatusesAndSaveProject(projectKey2, triggeredByUser, (AbstractInviteEmailSendService.InvitationEmailSendResult)results.get(projectKey2));
                    rwt.commit("Sent project invitation emails");
                }
            }
        }
    }

    public void updateEmailStatusesAndSaveProject(String projectKey, String triggeredByUser, AbstractInviteEmailSendService.InvitationEmailSendResult result) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException {
        boolean anyChange = false;
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        for (SerializedProject.PermissionItem permission : sp.permissions) {
            if (permission == null || permission.pendingUserEmail == null) continue;
            if (result.sentEmails.stream().anyMatch(sentEmail -> sentEmail != null && sentEmail.equalsIgnoreCase(permission.pendingUserEmail))) {
                anyChange |= !AbstractInviteEmailSendService.InvitationEmailStatus.SENT.equals((Object)permission.invitationEmailStatus);
                permission.invitationEmailStatus = AbstractInviteEmailSendService.InvitationEmailStatus.SENT;
                continue;
            }
            if (!result.failedEmails.stream().anyMatch(failedEmail -> failedEmail != null && failedEmail.equalsIgnoreCase(permission.pendingUserEmail))) continue;
            anyChange |= !AbstractInviteEmailSendService.InvitationEmailStatus.FAILED.equals((Object)permission.invitationEmailStatus);
            permission.invitationEmailStatus = AbstractInviteEmailSendService.InvitationEmailStatus.FAILED;
        }
        if (anyChange) {
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
        }
        this.pubSubService.publishAfterTransaction(new ProjectInvitationEmailSentEvent(triggeredByUser, projectKey, result));
    }

    @Override
    public Future<InfoMessage.InfoMessages> sendInviteEmail(GeneralSettingsDAO.GeneralSettings generalSettings, String email, String projectKey, @Nullable String senderLogin) throws Exception {
        ProjectInvitationEmailBuilder emailBuilder = new ProjectInvitationEmailBuilder(projectKey);
        logger.info((Object)("Sending project invitation email to " + email));
        return emailBuilder.sendToUser(generalSettings, email, senderLogin);
    }
}

