/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.download.DownloadRecipeParams;
import com.dataiku.dip.recipes.download.DownloadRecipeSource;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.recipes.KernelsDownloadRecipeService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DownloadRecipeController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private KernelsDownloadRecipeService kernelsDownloadRecipeService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.download.interactioncontroller");

    @AuditedCall(value={"msgType", "download-check-url", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/recipes/download/check-url"})
    public void checkDownloadURL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String url) throws Exception {
        KernelsDownloadRecipeService.AutoCloseableFSProviderAndPath fsProviderAndPath;
        DownloadRecipeSource source = new DownloadRecipeSource();
        source.providerType = "URL";
        AbstractFSDatasetHandler.AbstractFSConfig params = new AbstractFSDatasetHandler.AbstractFSConfig();
        params.path = url;
        source.setParams(params);
        source.useGlobalProxy = true;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            fsProviderAndPath = this.kernelsDownloadRecipeService.getFSProviderForSource(projectKey, authCtx, source, new HashMap<String, String>());
        }
        try {
            EnumerateSouceThread ft = new EnumerateSouceThread(projectKey, source, authCtx, fsProviderAndPath, this.kernelsDownloadRecipeService);
            FutureResponse fr = this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<KernelsDownloadRecipeService.FSEnumerationResultAndPrefix>>(){});
            fr = this.futureService.waitForFinalResponse(fr);
            KernelsDownloadRecipeService.FSEnumerationResultAndPrefix enumerateResultAndPrefix = (KernelsDownloadRecipeService.FSEnumerationResultAndPrefix)fr.result;
            if (enumerateResultAndPrefix.enumerationResult.getError() != null) {
                logger.error((Object)"Failed to enumerate", enumerateResultAndPrefix.enumerationResult.getError());
            }
            DownloadRecipeController.writeJSON((HttpServletResponse)resp, (Object)new DownloadRecipeSourceCheck(enumerateResultAndPrefix));
            this.auditTrailService.generic("download-check-url").with("projectKey", projectKey).with("providerType", source.providerType).with("browsePath", params.path).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("download-check-url", (Throwable)e).with("projectKey", projectKey).with("providerType", source.providerType).with("browsePath", params.path).emit();
            throw e;
        }
        finally {
            fsProviderAndPath.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "download-check-source", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/recipes/download/check-source"})
    public void checkDownloadSource(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipe, @RequestParam String source, @RequestParam(required=false) String partitionId) throws Exception {
        AbstractFSDatasetHandler.AbstractFSConfig sourceDefParams;
        DownloadRecipeSource sourceDef;
        SerializedRecipe sr;
        AuthCtx authCtx = null;
        KernelsDownloadRecipeService.AutoCloseableFSProviderAndPath fsProviderAndPath = null;
        HashMap flowVariables = Maps.newHashMap();
        try (Transaction t = this.transactionService.beginRead();){
            PartitioningScheme scheme;
            ManagedFolder folder;
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            sr = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
            sourceDef = (DownloadRecipeSource)JSON.parse((String)source, DownloadRecipeSource.class);
            logger.info((Object)("Check source " + JSON.prettyLog((Object)sourceDef)));
            sourceDefParams = sourceDef.getParams(authCtx, this.connectionsDAO);
            List<SerializedRecipe.RecipeOutput> outputs = sr.getOutputsForRole("main");
            if (outputs == null || outputs.size() != 1) {
                logger.warn((Object)"Not output defined, cannot deduce partitioning variables");
                folder = null;
                scheme = null;
            } else {
                folder = (ManagedFolder)this.managedFolderDAO.getMandatory(DatasetLocUtils.resolveSmart(projectKey, outputs.get((int)0).ref));
                scheme = folder.getPartitioningSchema();
            }
            if (scheme != null && scheme.isPartitioned() && folder != null) {
                Partition partition = PartitionFactory.fromIdentifier(scheme, partitionId);
                FlowVariables.addVariablesForDstDataset(authCtx, flowVariables, folder, partition, "DKU_DST_");
            }
        }
        Iterator<JsonObject> iterator = new VariablesExpansionLoopItemsIterable(authCtx, projectKey, sr.getParamsAs(DownloadRecipeParams.class).variablesExpansionLoopConfig).iterator();
        try (Transaction ignored = this.transactionService.beginRead();){
            while (iterator.hasNext()) {
                JsonObject jo = iterator.next();
                try {
                    logger.info((Object)("Loop on " + JSON.log((Object)jo)));
                    DynamicLevelsStack.pushLevel(jo);
                    fsProviderAndPath = this.kernelsDownloadRecipeService.getFSProviderForSource(projectKey, authCtx, sourceDef, flowVariables);
                }
                finally {
                    DynamicLevelsStack.popLevel();
                }
            }
        }
        try {
            EnumerateSouceThread ft = new EnumerateSouceThread(projectKey, sourceDef, authCtx, fsProviderAndPath, this.kernelsDownloadRecipeService);
            FutureResponse fr = this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<KernelsDownloadRecipeService.FSEnumerationResultAndPrefix>>(){});
            fr = this.futureService.waitForFinalResponse(fr);
            KernelsDownloadRecipeService.FSEnumerationResultAndPrefix enumerateResultAndPrefix = (KernelsDownloadRecipeService.FSEnumerationResultAndPrefix)fr.result;
            if (enumerateResultAndPrefix.enumerationResult.getError() != null) {
                logger.error((Object)"Failed to enumerate", enumerateResultAndPrefix.enumerationResult.getError());
            }
            DownloadRecipeController.writeJSON((HttpServletResponse)resp, (Object)new DownloadRecipeSourceCheck(enumerateResultAndPrefix));
            this.auditTrailService.generic("download-check-source").with("projectKey", projectKey).with("recipeName", sr.name).with("connection", sourceDefParams.getConnection()).with("providerType", sourceDef.providerType).with("browsePath", sourceDefParams.path).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("download-check-source", (Throwable)e).with("projectKey", projectKey).with("recipeName", sr.name).with("connection", sourceDefParams.getConnection()).with("providerType", sourceDef.providerType).with("browsePath", sourceDefParams.path).emit();
            throw e;
        }
        finally {
            fsProviderAndPath.close();
        }
    }

    public static FuturePayload buildFuturePayload(String projectKey, String sourceType) {
        FuturePayload fp = new FuturePayload();
        fp.action = "check_source";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, ITaggingService.TaggableType.PROJECT.name()));
        fp.displayName = "Check source of type " + sourceType + " in " + projectKey;
        return fp;
    }

    private static class EnumerateSouceThread
    extends SimpleFutureThread<KernelsDownloadRecipeService.FSEnumerationResultAndPrefix> {
        private final KernelsDownloadRecipeService.AutoCloseableFSProviderAndPath fsProviderAndPath;
        private final KernelsDownloadRecipeService kernelsDownloadRecipeService;
        private FuturePayload futurePayload;

        public EnumerateSouceThread(String projectKey, DownloadRecipeSource sourceDef, AuthCtx authCtx, KernelsDownloadRecipeService.AutoCloseableFSProviderAndPath fsProviderAndPath, KernelsDownloadRecipeService kernelsDownloadRecipeService) {
            super(authCtx);
            this.fsProviderAndPath = fsProviderAndPath;
            this.kernelsDownloadRecipeService = kernelsDownloadRecipeService;
            this.futurePayload = DownloadRecipeController.buildFuturePayload(projectKey, sourceDef.providerType);
        }

        @Override
        protected KernelsDownloadRecipeService.FSEnumerationResultAndPrefix compute() throws Exception {
            return this.kernelsDownloadRecipeService.enumerateSource(this.fsProviderAndPath.provider, this.fsProviderAndPath.path, this.fsProviderAndPath.identifyingPath, this.fsProviderAndPath.canGlob);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }

    public static class DownloadRecipeSourceCheck {
        public boolean successful;
        public SerializedError error;
        public boolean enumerationPrefixExists;
        public List<FSPath> paths;
        public int totalFileCount;
        public long totalFileSize;

        DownloadRecipeSourceCheck(KernelsDownloadRecipeService.FSEnumerationResultAndPrefix enumerationResultAndPrefix) {
            FSEnumerationResult enumerationResult = enumerationResultAndPrefix.enumerationResult;
            this.successful = enumerationResult.isSuccessful();
            this.enumerationPrefixExists = enumerationResult.enumerationPrefixExists();
            if (this.successful) {
                if (enumerationResult.getPaths() != null) {
                    this.paths = Lists.newArrayList();
                    int prefixLength = enumerationResultAndPrefix.prefix.length();
                    for (FSPath path : enumerationResult.getPaths()) {
                        Object cleanPath = path.path().substring(prefixLength);
                        if (StringUtils.isBlank((String)cleanPath)) {
                            cleanPath = "/" + (String)PathUtils.splitBasename((String)enumerationResultAndPrefix.identifyingPrefix).second;
                        } else if (((String)cleanPath).charAt(0) != '/') {
                            cleanPath = "/" + (String)cleanPath;
                        }
                        this.paths.add(new FSPath((String)cleanPath, path.getSize(), path.getLastModified()));
                    }
                } else {
                    this.paths = null;
                }
            } else {
                SerializedError serializedError = this.error = enumerationResult.getError() != null ? new SerializedError(enumerationResult.getError(), true) : null;
            }
            if (this.paths != null) {
                this.totalFileCount = this.paths.size();
                this.totalFileSize = 0L;
                for (FSPath path : this.paths) {
                    this.totalFileSize += path.getSize();
                }
            }
        }
    }
}

