/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeStatusComputer;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.server.recipes.GroupingQueryGenerator;
import com.dataiku.dip.server.recipes.GroupingSchemaGenerator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupingRecipeService {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.group");

    private void expandParams(GroupingRecipePayloadParams params, String projectKey, GroupingRecipeStatusComputer.GroupingRecipeStatus status) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        if (params.preFilter.enabled) {
            try {
                FilterDescUtils.expand(params.preFilter, vc);
            }
            catch (Exception e) {
                logger.error((Object)"Exception caught while expanding the recipe preFilter parameters", (Throwable)e);
                status.preFilter = new RecipeStatus.StepStatus();
                status.preFilter.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        try {
            FilterDescUtils.expand(params.computedColumns, vc);
        }
        catch (Exception e) {
            logger.error((Object)"Exception caught while expanding the recipe computedColumns parameters", (Throwable)e);
            status.computedColumns = new RecipeStatus.StepStatus();
            status.computedColumns.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        if (params.postFilter.enabled) {
            try {
                FilterDescUtils.expand(params.postFilter, vc);
            }
            catch (Exception e) {
                logger.error((Object)"Exception caught while expanding the recipe postFilter parameters", (Throwable)e);
                status.postFilter = new RecipeStatus.StepStatus();
                status.postFilter.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        for (GroupingRecipePayloadParams.GroupingValue val : params.values) {
            if (val == null || val.column != null || val.customExpr == null) continue;
            val.customExpr = vc.expand(val.customExpr);
        }
    }

    public GroupingRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        GroupingRecipeStatusComputer.GroupingRecipeStatus status = new GroupingRecipeStatusComputer.GroupingRecipeStatus();
        GroupingRecipePayloadParams payloadParams = this.loadParams(payload, sr, status);
        if (status.isInvalid()) {
            throw new IllegalStateException("One or several errors have been encountered while loading the recipe parameters. Please check your recipe.");
        }
        return payloadParams;
    }

    public GroupingRecipePayloadParams loadParams(String payload, SerializedRecipe sr, GroupingRecipeStatusComputer.GroupingRecipeStatus status) {
        GroupingRecipePayloadParams params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        this.expandParams(params, sr.projectKey, status);
        return params;
    }

    public String generateSQL(JobActivity activity, SQLDialect dialect, boolean isH2Mode, GroupingRecipePayloadParams params, boolean forceOutputColumnNameOverride) throws IOException {
        Partition part;
        Dataset outputDS;
        List<Partition> parts;
        Dataset source = activity.getSubgraph().getSingleSourceDataset().getMandatory(this.datasetsDAO);
        List<Partition> sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        PartitioningScheme targetPartitionScheme = null;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams) && (parts = activity.getSubgraph().getSourcePartitions(activity.getSubgraph().getSingleSourceDataset())) != null && parts.size() > 0 && !parts.get(0).isAll() && !parts.get(0).isNP() && source.getPartitioningSchema().isPartitioned()) {
            sourcePartitions = parts;
            sourcePartitionScheme = source.getPartitioningSchema();
        }
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDS = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO)) && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = outputDS.getPartitioningSchema();
        }
        return this.generateSQL(dialect, isH2Mode, params, source, outputDS, sourcePartitionScheme, sourcePartitions, targetPartitionScheme, forceOutputColumnNameOverride);
    }

    public String generateSQLIgnorePartitions(SQLDialect dialect, boolean isH2Mode, GroupingRecipePayloadParams params, Dataset source, Dataset target, boolean forceOutputColumnNameOverride) throws IOException {
        return this.generateSQL(dialect, isH2Mode, params, source, target, null, null, null, forceOutputColumnNameOverride);
    }

    private String generateSQL(SQLDialect dialect, boolean isH2Mode, GroupingRecipePayloadParams params, Dataset source, Dataset target, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme, boolean forceOutputColumnNameOverride) throws IOException {
        SQLUtils.SQLTable table = isH2Mode ? new SQLUtils.SQLTable(null, null, source.getFullName(), false) : DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
        GroupingQueryGenerator sqlGenerator = new GroupingQueryGenerator(params, source, source.getParams(), table, target);
        sqlGenerator.setPartitioning(sourcePartitionScheme, sourcePartitions, targetPartitionScheme);
        return sqlGenerator.generateSQL(dialect, forceOutputColumnNameOverride);
    }

    public Schema getOutputSchemaBeforeOverride(Dataset inputDS, GroupingRecipePayloadParams params, boolean lowerCaseColumnsNames, Integer identifierMaxLength) {
        Schema schema = this.getBaseOutputSchema(inputDS, params, identifierMaxLength);
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    public Schema getOutputSchemaAfterOverride(Dataset inputDS, GroupingRecipePayloadParams params, boolean lowerCaseColumnsNames, Integer identifierMaxLength) {
        Schema schema = this.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames, identifierMaxLength);
        SchemaUtils.applyOverrides(schema, params.outputColumnNameOverrides, lowerCaseColumnsNames);
        return schema;
    }

    private Schema getBaseOutputSchema(Dataset inputDS, GroupingRecipePayloadParams params, Integer identifierMaxLength) {
        return new GroupingSchemaGenerator(inputDS.getSchema()).getBaseOutputSchema(params, identifierMaxLength);
    }
}

