/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.ComplexType;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.utils.SchemaComparator;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecipeSchemaService {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private GenericRecipesValidationService recipesValidationService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private GenericRecipesValidationService validationService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    protected NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipeschema");

    public RecipeSchemaAutoupdateResult computeSaveImpact_NT(AuthCtx authCtx, SerializedRecipe sr, String payload) throws Exception {
        RecipeSchemaComputer computer;
        RecipeDesc desc;
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, sr);
            JobActivity activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(sr)));
            RecipeMeta rm2 = RecipeRegistry.getMeta(activity);
            desc = rm2.getRecipeDesc();
            switch (rm2.getOutputSchemasComputability()) {
                case NONE: {
                    throw new IllegalArgumentException("Cannot compute schema on recipe " + sr.type);
                }
            }
            computer = rm2.buildSchemaComputer(authCtx, activity);
            if (computer instanceof RecipeSchemaComputer.RecipeSchemaComputerWithPayload) {
                ((RecipeSchemaComputer.RecipeSchemaComputerWithPayload)((Object)computer)).setPayload(payload);
            }
        }
        try {
            if (computer.computesDiffItself()) {
                return computer.getAutoupdateResult_NT();
            }
            RecipeSchemaAutoupdateResult ret = new RecipeSchemaAutoupdateResult();
            for (RecipeDesc.IORoleDef role : desc.outputRoles) {
                List<Schema> computedSchemas = computer.getSchemasForOutputRole_NT(role.name);
                Transaction t = this.transactionService.beginRead();
                try {
                    if (!role.hasSchema()) continue;
                    ret.merge(this.getSchemaUpdateResult(authCtx, sr, computedSchemas, role.name));
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            return ret;
        }
        catch (RecipeSchemaComputer.DontWantToCompute e) {
            throw new IllegalArgumentException("Cannot compute schema on this recipe " + sr.type + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public RecipeSchemaAutoupdateResult getSchemaUpdateResult(AuthCtx authCtx, SerializedRecipe recipe, List<Schema> newComputedSchemas, String role) throws Exception {
        assert (recipe.getOutputsForRole(role).size() == newComputedSchemas.size());
        logger.info((Object)("Checking schema compatibility for " + recipe.name));
        RecipeSchemaAutoupdateResult ret = new RecipeSchemaAutoupdateResult();
        for (int outputIdx = 0; outputIdx < recipe.getOutputsForRole(role).size(); ++outputIdx) {
            Schema schemaBefore;
            SerializedRecipe.RecipeOutput ro = recipe.getOutputsForRole(role).get(outputIdx);
            Schema newComputedSchema = newComputedSchemas.get(outputIdx);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(recipe.projectKey, ro.ref);
            Dataset _ds = this.datasetAccessService.getOrNullUnsafe(loc);
            if (_ds == null) {
                ComputableSchemaAutoupdateResult seRet = ComputableSchemaAutoupdateResult.forStreamingEnpdoint();
                seRet.id = ro.ref;
                StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(loc);
                schemaBefore = se.schema;
                this.fillComputableSchemaUpdateResultStep1(seRet, schemaBefore, newComputedSchema);
                seRet.newSchema = seRet.newSchema.fixup();
                logger.trace(() -> "Find differences with " + JSON.log((Object)seRet.newSchema));
                seRet.incompatibilities = SchemaComparator.findDifferences(schemaBefore, seRet.newSchema, true);
                logger.info((Object)("Differences: " + JSON.log(seRet.incompatibilities)));
                if (schemaBefore.columns.isEmpty()) {
                    seRet.previousSchemaWasEmpty = true;
                }
                ret.computables.add(seRet);
                ret.totalIncompatibilities += seRet.incompatibilities.size();
                continue;
            }
            ComputableSchemaAutoupdateResult dsRet = ComputableSchemaAutoupdateResult.forDataset();
            dsRet.datasetName = ro.ref;
            Dataset dataset = this.datasetAccessService.getMandatory(loc.getProjectKey(), loc.getName());
            if (newComputedSchema != null && dataset.getTypeSystemVersion() == SerializedDataset.TypeSystemVersion.V1) {
                newComputedSchema.rewindTypesToV1FromRecipe(recipe.getType());
            }
            schemaBefore = dataset.getSchema();
            dsRet.newSchema.userModified = schemaBefore.userModified;
            JsonObject jsonObject = dsRet.newSchema.metadata = schemaBefore.metadata != null ? (JsonObject)JSON.deepCopy((Object)schemaBefore.metadata) : null;
            if (null != newComputedSchema) {
                for (SchemaColumn colInComputed : newComputedSchema.getColumns()) {
                    SchemaColumn colInOld = schemaBefore.getColumn(colInComputed.getName());
                    logger.trace(() -> "Column in computed: " + colInComputed.getName() + " old  =" + String.valueOf(colInOld));
                    if (colInOld != null) {
                        SchemaColumn newCol = (SchemaColumn)JSON.deepCopy((Object)colInOld);
                        ComplexType complexType = ComplexType.fromColumn((SchemaColumn)colInComputed);
                        complexType.updateColumnWithType(newCol);
                        if (StringUtils.isNotBlank((String)colInComputed.comment)) {
                            newCol.withComment(colInComputed.comment);
                        }
                        dsRet.newSchema.addColumn(newCol);
                        continue;
                    }
                    dsRet.newSchema.addColumn(colInComputed);
                }
            }
            for (SchemaColumn oldCol : schemaBefore.columns) {
                if (null != newComputedSchema && newComputedSchema.getColumn(oldCol.getName()) != null || oldCol.getType().isPrimitive()) continue;
                logger.infoV("Complex Column %s has disappeared, will specifically warn", new Object[]{oldCol.getName()});
                dsRet.lostComplexTypes.add(oldCol.getName());
            }
            this.fillDatasetSchemaUpdateResultStep2(authCtx, dsRet, dataset, schemaBefore);
            ret.computables.add(dsRet);
            ret.totalIncompatibilities += dsRet.incompatibilities.size();
        }
        return ret;
    }

    private void fillComputableSchemaUpdateResultStep1(ComputableSchemaAutoupdateResult csRet, Schema schemaBefore, Schema newComputedSchema) {
        csRet.newSchema.userModified = schemaBefore.userModified;
        JsonObject jsonObject = csRet.newSchema.metadata = schemaBefore.metadata != null ? (JsonObject)JSON.deepCopy((Object)schemaBefore.metadata) : null;
        if (null != newComputedSchema) {
            for (SchemaColumn colInComputed : newComputedSchema.getColumns()) {
                SchemaColumn colInOld = schemaBefore.getColumn(colInComputed.getName());
                logger.trace(() -> "Column in computed: " + colInComputed.getName() + " old  =" + String.valueOf(colInOld));
                if (colInOld != null) {
                    SchemaColumn newCol = (SchemaColumn)JSON.deepCopy((Object)colInOld);
                    ComplexType complexType = ComplexType.fromColumn((SchemaColumn)colInComputed);
                    complexType.updateColumnWithType(newCol);
                    if (StringUtils.isNotBlank((String)colInComputed.comment)) {
                        newCol.withComment(colInComputed.comment);
                    }
                    csRet.newSchema.addColumn(newCol);
                    continue;
                }
                csRet.newSchema.addColumn(colInComputed);
            }
        }
        for (SchemaColumn oldCol : schemaBefore.columns) {
            if (null != newComputedSchema && newComputedSchema.getColumn(oldCol.getName()) != null || oldCol.getType().isPrimitive()) continue;
            logger.infoV("Complex Column %s has disappeared, will specifically warn", new Object[]{oldCol.getName()});
            csRet.lostComplexTypes.add(oldCol.getName());
        }
    }

    public void fillDatasetSchemaUpdateResultStep2(AuthCtx authCtx, ComputableSchemaAutoupdateResult dsRet, Dataset dataset, Schema schemaBefore) throws IOException, DKUSecurityException {
        this.fillDatasetSchemaUpdateResultStep2(authCtx, dsRet, dataset, schemaBefore, false);
    }

    public void fillDatasetSchemaUpdateResultStep2(AuthCtx authCtx, ComputableSchemaAutoupdateResult dsRet, Dataset dataset, Schema schemaBefore, boolean datasetIsFake) throws IOException, DKUSecurityException {
        dsRet.newSchema = dsRet.newSchema.fixup();
        ManagedDatasetsHelper.doTheUglyPartitioningDance(dataset, dsRet.newSchema, schemaBefore);
        InfoMessage.InfoMessages fixupMessages = dataset.fixupSchemaPerDatasetConstraint(authCtx, dsRet.newSchema);
        dsRet.messages.mergeFrom(fixupMessages);
        logger.trace(() -> "Find differences with " + JSON.log((Object)dsRet.newSchema));
        dsRet.incompatibilities = SchemaComparator.findDifferences(schemaBefore, dsRet.newSchema, true);
        logger.info((Object)("Differences: " + JSON.log(dsRet.incompatibilities)));
        if (schemaBefore.columns.isEmpty()) {
            dsRet.previousSchemaWasEmpty = true;
        }
        dsRet.isPartitioned = dataset.getPartitioningSchema().isPartitioned();
        dsRet.isHDFS = DatasetInspector.canHDFS(dataset);
        if (datasetIsFake) {
            dsRet.isLastInFlow = true;
        } else {
            try (Transaction t = this.transactionService.retrieveOrBeginRead();){
                dsRet.isLastInFlow = this.flowGraphService.getSuccessorRecipesAccrossProjectsUnsafe(dataset.getLoc()).isEmpty();
            }
        }
    }

    public Callable<RecipeSaveService.RecipeSchemaUpdatedWarnings> updateComputableOutputSchemaForRecipe(final AuthCtx authCtx, String recipeProjectKey, FlowComputable.FCType computableType, AnyLoc computableLoc, Schema newSchema, final boolean dropAndRecreate, boolean synchronizeMetastore, JsonObject extraOptions) throws Exception {
        final RecipeSaveService.RecipeSchemaUpdatedWarnings ret = new RecipeSaveService.RecipeSchemaUpdatedWarnings();
        if (computableType == FlowComputable.FCType.DATASET) {
            Dataset dataset = this.datasetAccessService.getMandatory(computableLoc);
            final DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);
            Schema schemaBefore = dataset.getSchema();
            if (schemaBefore == null) {
                schemaBefore = new Schema();
            }
            if (!JSON.pretty((Object)schemaBefore).equals(JSON.pretty((Object)newSchema))) {
                if (dropAndRecreate && this.neverBuiltComputablesCacheService.canBeAdded(dataset)) {
                    SerializedDataset serializedDataset = dataset.serialize();
                    this.neverBuiltComputablesCacheService.add(new TaggableObjectsService.TaggableObjectRef(serializedDataset));
                }
                logger.info((Object)("Saving update of schema for dataset " + dataset.getName()));
                dataset.setSchema(newSchema);
                WithMessages<SerializedDataset> actuallyWritten = this.datasetSaveService.save(dataset.getProjectKey(), dataset.getName(), dataset.serialize(), authCtx);
                dataset = Dataset.fromSerialized((SerializedDataset)actuallyWritten.value);
            } else {
                logger.info((Object)"Schema was not modified");
            }
            final Dataset datasetFinal = dataset;
            final Callable<RecipeSaveService.RecipeSchemaUpdatedWarnings> dr = new Callable<RecipeSaveService.RecipeSchemaUpdatedWarnings>(){

                @Override
                public RecipeSaveService.RecipeSchemaUpdatedWarnings call() throws Exception {
                    if (dropAndRecreate) {
                        logger.info((Object)("Dropping previous data for " + datasetFinal.getFullName()));
                        try {
                            dh.clearAllDataAndStructure();
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Failed to drop previous data", (Throwable)e);
                        }
                        finally {
                            dh.close();
                        }
                        logger.infoV("Will re-create managed data for %s", new Object[]{datasetFinal.getFullName()});
                        try (DatasetHandler dh2 = DatasetHandlerFactory.build(authCtx, datasetFinal);){
                            dh2.createManaged();
                        }
                    }
                    return ret;
                }
            };
            if (synchronizeMetastore && DatasetInspector.canHDFS(dataset) && this.metastoreInspectionService.metastoreSupportEnabled(authCtx, recipeProjectKey)) {
                return new Callable<RecipeSaveService.RecipeSchemaUpdatedWarnings>(){

                    @Override
                    public RecipeSaveService.RecipeSchemaUpdatedWarnings call() throws Exception {
                        dr.call();
                        logger.infoV("Will metastore-synchronize for %s", new Object[]{datasetFinal.getFullName()});
                        try (HiveMetastoreSynchronizer synchronizer = HiveMetastoreSynchronizerFactory.getSynchronizer(authCtx);){
                            synchronizer.synchronizeOneDataset(datasetFinal, false, true, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.OTHER, null, true);
                        }
                        return ret;
                    }
                };
            }
            return new Callable<RecipeSaveService.RecipeSchemaUpdatedWarnings>(){

                @Override
                public RecipeSaveService.RecipeSchemaUpdatedWarnings call() throws Exception {
                    dr.call();
                    return ret;
                }
            };
        }
        if (computableType == FlowComputable.FCType.STREAMING_ENDPOINT) {
            StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(computableLoc);
            Schema schemaBefore = se.schema;
            if (schemaBefore == null) {
                schemaBefore = new Schema();
            }
            boolean extraChange = false;
            if (extraOptions != null && extraOptions.has("ksqlParams") && "kafka".equals(se.type)) {
                KafkaStreamingEndpointParams.KsqlParamsChanges detected = (KafkaStreamingEndpointParams.KsqlParamsChanges)JSON.parse((JsonElement)extraOptions.get("ksqlParams").getAsJsonObject(), KafkaStreamingEndpointParams.KsqlParamsChanges.class);
                KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
                extraChange = params.mergeDetectedSettings(detected);
            }
            if (!JSON.pretty((Object)schemaBefore).equals(JSON.pretty((Object)newSchema)) || extraChange) {
                logger.info((Object)("Saving update of schema for streaming endpoint " + String.valueOf(computableLoc)));
                se.schema = newSchema;
                this.streamingEndpointsDAO.save(se);
            } else {
                logger.info((Object)"Schema was not modified");
            }
            return new Callable<RecipeSaveService.RecipeSchemaUpdatedWarnings>(){

                @Override
                public RecipeSaveService.RecipeSchemaUpdatedWarnings call() throws Exception {
                    return ret;
                }
            };
        }
        throw new Error("unreachable");
    }

    public void fillAutoupdateFlags(ComputableSchemaAutoupdateResult dsRet, Dataset dataset) {
        dsRet.isPartitioned = dataset.getPartitioningSchema().isPartitioned();
        dsRet.isHDFS = DatasetInspector.canHDFS(dataset);
    }

    public RecipeSchemaAutoupdateResult checkRecipe(AuthCtx authCtx, String projectKey, String recipeName, boolean performExpensive, JsonObject recipeUpdateOptions) throws Exception {
        RecipeDesc desc;
        RecipeSchemaComputer computer = null;
        SerializedRecipe sr = null;
        try (Transaction t = this.transactionService.beginRead();){
            sr = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, recipeName);
            logger.info((Object)("Checking recipe " + recipeName + " of type " + sr.type));
            JobActivity activity = new JobActivity(this.validationService.getSampleSubgraph(new FlowRecipe(sr)));
            RecipeMeta rm2 = RecipeRegistry.getMeta(activity);
            desc = rm2.getRecipeDesc();
            if (sr.getOutputsForRole("main").size() == 0) {
                Optional<RecipeDesc.IORoleDef> mainRole = desc.outputRoles.stream().filter(r -> "main".equals(r.name)).findFirst();
                if (!mainRole.isPresent()) {
                    throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "No main output role ?");
                }
                if (mainRole.get().required) {
                    throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY, "No main output ?");
                }
            }
            switch (rm2.getOutputSchemasComputability()) {
                case NONE: {
                    logger.warn((Object)("Cannot compute schema on " + rm2.getType()));
                    throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_ON_RECIPE_TYPE, "Output schema can't be automatically computed on '" + rm2.getType() + "' recipes");
                }
                case RELIABLE_DYNAMIC: 
                case RELIABLE_STATIC: {
                    break;
                }
                case EXPENSIVE: {
                    if (performExpensive) break;
                    throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_EXPENSIVE, "'Expensive' checks are disabled");
                }
            }
            computer = rm2.buildSchemaComputer(authCtx, activity);
            if (computer instanceof RecipeSchemaComputer.RecipeSchemaComputerWithPayload) {
                String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
                ((RecipeSchemaComputer.RecipeSchemaComputerWithPayload)((Object)computer)).setPayload(payload);
            }
        }
        try {
            RecipeSchemaAutoupdateResult ret = new RecipeSchemaAutoupdateResult();
            logger.info((Object)("Computer can update: " + computer.canUpdateRecipe()));
            if (computer.canUpdateRecipe()) {
                try {
                    ret = computer.updateRecipe_NT(recipeUpdateOptions);
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to auto-update recipe, proceeding with old version", (Throwable)e);
                }
            } else {
                ret = new RecipeSchemaAutoupdateResult();
            }
            if (computer.computesDiffItself()) {
                ret.merge(computer.getAutoupdateResult_NT());
            } else {
                for (RecipeDesc.IORoleDef role : desc.outputRoles) {
                    if (!role.hasSchema()) continue;
                    List<Schema> computedSchemas = computer.getSchemasForOutputRole_NT(role.name);
                    Transaction t = this.transactionService.beginRead();
                    try {
                        ret.merge(this.getSchemaUpdateResult(authCtx, sr, computedSchemas, role.name));
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                    }
                }
            }
            return ret;
        }
        catch (RecipeSchemaComputer.DontWantToCompute e) {
            logger.info((Object)("Schema computer decided it did not want to compute: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            throw e;
        }
    }

    public static class RecipeSchemaAutoupdateResult {
        public int totalIncompatibilities = 0;
        public List<ComputableSchemaAutoupdateResult> computables = new ArrayList<ComputableSchemaAutoupdateResult>();
        public List<String> recipeChanges = Lists.newArrayList();
        public SerializedRecipe updatedRecipe;
        public String updatedPayload;

        public void merge(RecipeSchemaAutoupdateResult other) {
            this.totalIncompatibilities += other.totalIncompatibilities;
            this.computables.addAll(other.computables);
            if (this.updatedRecipe == null && other.updatedRecipe != null) {
                this.updatedRecipe = other.updatedRecipe;
                this.updatedPayload = other.updatedPayload;
            }
        }
    }

    public static class ComputableSchemaAutoupdateResult {
        public FlowComputable.FCType type;
        public boolean previousSchemaWasEmpty;
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public List<String> incompatibilities = new ArrayList<String>();
        public Schema newSchema = new Schema();
        public Set<String> lostComplexTypes = new HashSet<String>();
        public boolean isHDFS;
        public String datasetName;
        public boolean isPartitioned;
        public boolean isLastInFlow;
        public String id;
        public KafkaStreamingEndpointParams.KsqlParamsChanges ksqlParams;

        public static ComputableSchemaAutoupdateResult forDataset() {
            ComputableSchemaAutoupdateResult ret = new ComputableSchemaAutoupdateResult();
            ret.type = FlowComputable.FCType.DATASET;
            return ret;
        }

        public static ComputableSchemaAutoupdateResult forDataset(String datasetName, List<String> reasons, Schema newSchema) {
            ComputableSchemaAutoupdateResult ret = new ComputableSchemaAutoupdateResult();
            ret.type = FlowComputable.FCType.DATASET;
            ret.datasetName = datasetName;
            ret.incompatibilities = reasons;
            ret.newSchema = newSchema;
            return ret;
        }

        public static ComputableSchemaAutoupdateResult forStreamingEnpdoint() {
            ComputableSchemaAutoupdateResult ret = new ComputableSchemaAutoupdateResult();
            ret.type = FlowComputable.FCType.STREAMING_ENDPOINT;
            return ret;
        }

        public KafkaStreamingEndpointParams.KsqlParamsChanges getKsqlParams() {
            if (this.ksqlParams == null) {
                this.ksqlParams = new KafkaStreamingEndpointParams.KsqlParamsChanges();
            }
            return this.ksqlParams;
        }
    }
}

