/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.PreprocessedQueryForSubstitution;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecipeVariablesHelper {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private TransactionService transactionService;
    private static final Logger logger = Logger.getLogger((String)"dku.recipe.variables");

    public RecipeVariablesHelper() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private static void checkVariableSubstitutions(InfoMessage.InfoMessages messages, String substitutedCode) {
        if (substitutedCode.contains("${DKU_")) {
            int from = substitutedCode.indexOf("${DKU_");
            int to = substitutedCode.indexOf("}", from);
            if (to == -1) {
                to = substitutedCode.length();
            }
            String offendingVariable = substitutedCode.substring(from, to);
            messages.withWarningV((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_UNKNOWN_VARIABLE_SUBSTITUTION, "Unrecognized substitution variable: %s", new Object[]{offendingVariable});
        }
    }

    public VariablesContext getVariablesContext(AuthCtx authCtx) {
        return this.getVariablesContext(authCtx, null, null);
    }

    public VariablesContext getVariablesContext(AuthCtx authCtx, String recipeProjectKey) {
        return this.getVariablesContext(authCtx, recipeProjectKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariablesContext getVariablesContext(AuthCtx authCtx, String recipeProjectKey, VariablesExpansionLoopConfig veLoopConfig) {
        boolean pushedADynamicLevel = this.pushDynamicLevelIfAny(authCtx, recipeProjectKey, veLoopConfig);
        try {
            if (recipeProjectKey != null) {
                VariablesContext variablesContext = this.variablesService.getForProject(recipeProjectKey);
                return variablesContext;
            }
            VariablesContext variablesContext = this.variablesService.getForGlobal();
            return variablesContext;
        }
        finally {
            if (pushedADynamicLevel) {
                this.popDynamicLevel();
            }
        }
    }

    public RecipeSubstitutionVariablesResult getRecipeVariablesNoPartition(AuthCtx authCtx, String recipeProjectKey, VariablesExpansionLoopConfig veLoopConfig) {
        if (StringUtils.isBlank((String)recipeProjectKey)) {
            throw new IllegalArgumentException("recipeProjectKey is empty");
        }
        VariablesContext vc = this.getVariablesContext(authCtx, recipeProjectKey, veLoopConfig);
        HashMap<String, AvailableVariable> map = new HashMap<String, AvailableVariable>();
        for (Map.Entry e : vc.getAllVariables().entrySet()) {
            map.put((String)e.getKey(), new AvailableVariable((String)e.getValue(), VariableType.USER));
        }
        RecipeSubstitutionVariablesResult ret = new RecipeSubstitutionVariablesResult();
        ret.setVariables(map);
        return ret;
    }

    public RecipeSubstitutionVariablesResult getRecipeVariables(AuthCtx authCtx, String recipeProjectKey, RecipeRunnableSubgraph testSubgraph, SQLDialect dialect) throws IOException, CodedException, DKUSecurityException {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        FlowVariables.addPartitioningVariables(authCtx, substitutions, testSubgraph, this.datasetsDAO);
        if (dialect != null) {
            FlowVariables.addWhereClauseVariables(substitutions, testSubgraph, this.datasetsDAO, dialect);
        }
        substitutions.putAll(FlowVariables.getSQLTableVariables(authCtx, testSubgraph.getRecipe().getModel()));
        Map userVariables = this.variablesService.getForProject(recipeProjectKey).getAllVariables();
        HashMap<String, AvailableVariable> map = new HashMap<String, AvailableVariable>();
        for (Map.Entry e : substitutions.entrySet()) {
            map.put((String)e.getKey(), new AvailableVariable((String)e.getValue(), VariableType.FLOW));
        }
        for (Map.Entry e : userVariables.entrySet()) {
            map.put((String)e.getKey(), new AvailableVariable((String)e.getValue(), VariableType.USER));
        }
        RecipeSubstitutionVariablesResult ret = new RecipeSubstitutionVariablesResult();
        ret.setVariables(map);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeSubstitutionVariablesResult getRecipeVariablesAndSubstitute(AuthCtx authCtx, String recipeProjectKey, RecipeRunnableSubgraph testSubgraph, PreprocessedQueryForSubstitution preprocessedQuery, VariablesExpansionLoopConfig veLoopConfig) throws IOException, CodedException, DKUSecurityException {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            FlowVariables.addPartitioningVariables(authCtx, substitutions, testSubgraph, this.datasetsDAO);
            if (preprocessedQuery.dialect != null) {
                FlowVariables.addWhereClauseVariables(substitutions, testSubgraph, this.datasetsDAO, preprocessedQuery.dialect);
            }
            substitutions.putAll(FlowVariables.getSQLTableVariables(authCtx, testSubgraph.getRecipe().getModel()));
        }
        RecipeSubstitutionVariablesResult ret = new RecipeSubstitutionVariablesResult();
        String flowSubstituted = FlowVariables.substitute(substitutions, preprocessedQuery.query);
        RecipeVariablesHelper.checkVariableSubstitutions(ret.messages, flowSubstituted);
        Map userVariables = this.variablesService.getForProject(recipeProjectKey).getAllVariables();
        HashMap<String, AvailableVariable> map = new HashMap<String, AvailableVariable>();
        for (Map.Entry e : substitutions.entrySet()) {
            map.put((String)e.getKey(), new AvailableVariable((String)e.getValue(), VariableType.FLOW));
        }
        for (Map.Entry e : userVariables.entrySet()) {
            map.put((String)e.getKey(), new AvailableVariable((String)e.getValue(), VariableType.USER));
        }
        ret.setVariables(map);
        boolean pushedADynamicLevel = this.pushDynamicLevelIfAny(authCtx, recipeProjectKey, veLoopConfig);
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            ret.substituted = this.variablesService.getForProject(recipeProjectKey).expand(flowSubstituted);
            ret.substitutionOK = true;
            if (preprocessedQuery.dialect != null) {
                Pair<String[], Integer[]> splitWithLineOffsets = preprocessedQuery.splitWithLineOffsets;
                for (int i = 0; i < ((String[])splitWithLineOffsets.first).length; ++i) {
                    ((String[])splitWithLineOffsets.first)[i] = SQLQueryRecipeUtils.substituteAllAndStripComments(authCtx, recipeProjectKey, testSubgraph, ((String[])splitWithLineOffsets.first)[i], preprocessedQuery.dialect, false);
                }
                ret.substitutedAndSplit = splitWithLineOffsets;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to substitute variables in '" + flowSubstituted + "'"), (Throwable)e);
            ret.substitutionError = e;
        }
        finally {
            if (pushedADynamicLevel) {
                this.popDynamicLevel();
            }
        }
        return ret;
    }

    private boolean pushDynamicLevelIfAny(AuthCtx authCtx, String recipeProjectKey, VariablesExpansionLoopConfig veLoopConfig) {
        VariablesExpansionLoopItemsIterable iterable;
        Iterator<JsonObject> it;
        if (recipeProjectKey != null && veLoopConfig != null && veLoopConfig.isEnabled() && (it = (iterable = new VariablesExpansionLoopItemsIterable(authCtx, recipeProjectKey, veLoopConfig)).iterator()).hasNext()) {
            DynamicLevelsStack.pushLevel(it.next());
            return true;
        }
        return false;
    }

    private void popDynamicLevel() {
        DynamicLevelsStack.popLevel();
    }

    public static class AvailableVariable {
        public String value;
        public VariableType type;

        public AvailableVariable() {
        }

        public AvailableVariable(String value, VariableType type) {
            this.value = value;
            this.type = type;
        }
    }

    public static enum VariableType {
        FLOW,
        USER;

    }

    public static class RecipeSubstitutionVariablesResult {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public String substituted;
        public Pair<String[], Integer[]> substitutedAndSplit;
        public LinkedHashMap<String, AvailableVariable> substitutionVariables;
        public boolean substitutionOK;
        public Exception substitutionError;

        public void setVariables(Map<String, AvailableVariable> variables) {
            this.substitutionVariables = new LinkedHashMap();
            for (Map.Entry entry : Ordering.natural().onResultOf((Function)new Function<Map.Entry<String, AvailableVariable>, String>(){

                public String apply(@Nullable Map.Entry<String, AvailableVariable> arg0) {
                    return arg0.getKey();
                }
            }).sortedCopy(variables.entrySet())) {
                this.substitutionVariables.put((String)entry.getKey(), (AvailableVariable)entry.getValue());
            }
        }

        public void throwIfSubstitutionError() throws Exception {
            if (!this.substitutionOK) {
                if (this.substitutionError != null) {
                    throw this.substitutionError;
                }
                throw new Exception("Variable substitution failed");
            }
        }

        public boolean checkSubstitutionError(InfoMessage.InfoMessages messages) throws Exception {
            if (!this.substitutionOK) {
                if (this.substitutionError != null) {
                    messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Variable substitution error: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)this.substitutionError)});
                } else {
                    messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Variable substitution error", new Object[0]);
                }
            }
            return this.substitutionOK;
        }
    }
}

