/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.sort.SortRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.PrestoSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLServerSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SortRecipeService {
    private static final String ORIGINAL_TABLE_ALIAS = "__origin_table";
    private static final String SORTED_QUERY_ALIAS = "__sorted_query";
    public static final String ROW_NUMBER_FINAL_COLUMN_NAME = "_row_number";
    public static final String RANK_FINAL_COLUMN_NAME = "_rank";
    public static final String DENSE_RANK_FINAL_COLUMN_NAME = "_dense_rank";
    private static final ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;

    private void expandParams(SortRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        FilterDescUtils.expand(params.preFilter, vc);
        FilterDescUtils.expand(params.computedColumns, vc);
    }

    public SortRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        SortRecipePayloadParams params = (SortRecipePayloadParams)JSON.parse((String)payload, SortRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        this.expandParams(params, sr.projectKey);
        return params;
    }

    public String generateSQL(JobActivity activity, SQLDialect dialect, SortRecipePayloadParams params, boolean forceOutputColumnNameOverride) throws IOException {
        Partition part;
        Dataset outputDS;
        List<Partition> parts;
        Dataset source = activity.getSubgraph().getSingleSourceDataset().getMandatory(this.datasetsDAO);
        List<Partition> sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        PartitioningScheme targetPartitionScheme = null;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams) && (parts = activity.getSubgraph().getSourcePartitions(activity.getSubgraph().getSingleSourceDataset())) != null && !parts.isEmpty() && !parts.get(0).isAll() && !parts.get(0).isNP() && source.getPartitioningSchema().isPartitioned()) {
            sourcePartitions = parts;
            sourcePartitionScheme = source.getPartitioningSchema();
        }
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDS = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO)) && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = outputDS.getPartitioningSchema();
        }
        HashSet excludedFromInput = Sets.newHashSet();
        if (DatasetInspector.arePartitioningColumnsForbiddenInSchema(outputDS) && outputDS.getPartitioningSchema() != null && outputDS.getPartitioningSchema().isPartitioned()) {
            excludedFromInput.addAll(outputDS.getPartitioningSchema().getDimensionNames());
        }
        return this.generateSQL(dialect, params, source, sourcePartitionScheme, sourcePartitions, targetPartitionScheme, outputDS, excludedFromInput, forceOutputColumnNameOverride);
    }

    private SelectQueryBuilder makeSourceQuery(SQLDialect dialect, SortRecipePayloadParams params, Dataset source, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions) throws IOException {
        SelectQueryBuilder query = new SelectQueryBuilder();
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
        query.from(table, ORIGINAL_TABLE_ALIAS);
        if (sourcePartitionScheme != null && table.isTrueTable()) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(sourcePartitionScheme, source, sourcePartitions, dialect);
            query.where(partitionFilterExpression);
        }
        QueryGenerationUtils.preFilter(query, params.preFilter, dialect, source, false);
        for (SchemaColumn col : source.getSchema().getColumns()) {
            ExpressionBuilder colExpr = ExpressionUtils.getAdjustedColumn(ef.col(ORIGINAL_TABLE_ALIAS, col.getName()), col.getName(), source, dialect);
            query.select(colExpr, col.getName());
        }
        query = QueryGenerationUtils.computedColumns(query, params.computedColumns, dialect, source.getSchema());
        return query;
    }

    private SelectQueryBuilder makeSortedQuery(SelectQueryBuilder sourceQuery, SortRecipePayloadParams params, Dataset source, SQLDialect dialect) {
        ExpressionBuilder col;
        SelectQueryBuilder query = new SelectQueryBuilder();
        query.from(sourceQuery, ORIGINAL_TABLE_ALIAS);
        for (SchemaColumn col2 : source.getSchema().getColumns()) {
            Iterator<ComputedColumn> colExpr = ef.col(ORIGINAL_TABLE_ALIAS, col2.getName());
            query.select((ExpressionBuilder)((Object)colExpr), col2.getName());
        }
        ArrayList<ExpressionBuilder> orderExpressions = new ArrayList<ExpressionBuilder>();
        ArrayList<QueryAst.OrderType> orderTypes = new ArrayList<QueryAst.OrderType>();
        for (SortRecipePayloadParams.Order order : params.orders) {
            col = ef.col(ORIGINAL_TABLE_ALIAS, order.column);
            orderExpressions.add(col);
            orderTypes.add(order.desc ? QueryAst.OrderType.DESC : QueryAst.OrderType.ASC);
        }
        for (ComputedColumn cc : params.computedColumns) {
            col = ef.col(ORIGINAL_TABLE_ALIAS, cc.name);
            query.select(col, cc.name);
        }
        QueryAst.Window window = SelectQueryBuilder.window(null, orderExpressions, orderTypes);
        if (params.rowNumber) {
            query.select(ef.rowNumber().over(window), ROW_NUMBER_FINAL_COLUMN_NAME);
        }
        if (params.rank) {
            query.select(ef.rank().over(window), RANK_FINAL_COLUMN_NAME);
        }
        if (params.denseRank) {
            query.select(ef.denseRank().over(window), DENSE_RANK_FINAL_COLUMN_NAME);
        }
        for (SortRecipePayloadParams.Order order : params.orders) {
            query.order(ef.col(order.column), order.desc ? QueryAst.OrderType.DESC : QueryAst.OrderType.ASC);
        }
        return query;
    }

    private SelectQueryBuilder makeMainQuery(SelectQueryBuilder sortedQuery, SortRecipePayloadParams params, Dataset source, PartitioningScheme targetPartitionScheme, Schema outputSchema, Set<String> excludedFromInput, SQLDialect dialect) {
        ExpressionBuilder colExpr;
        SchemaColumn scOutput;
        HashSet partitionColumnNames = Sets.newHashSet();
        if (targetPartitionScheme != null) {
            for (Object col : targetPartitionScheme.getDimensionNames()) {
                if (excludedFromInput.contains(col)) continue;
                partitionColumnNames.add(col);
            }
        }
        SelectQueryBuilder query = new SelectQueryBuilder();
        query.from(sortedQuery, SORTED_QUERY_ALIAS);
        for (Object col : source.getSchema().getColumns()) {
            if (excludedFromInput.contains(col.getName())) continue;
            if (partitionColumnNames.contains(col.getName())) {
                scOutput = outputSchema.getColumnOrDefault(col.getName(), Type.STRING);
                query.select(ef.dstPartitionId(scOutput, targetPartitionScheme.getDimension(col.getName())), col.getName());
                partitionColumnNames.remove(col.getName());
                continue;
            }
            ExpressionBuilder colExpr2 = ef.col(SORTED_QUERY_ALIAS, col.getName());
            query.select(colExpr2, col.getName());
        }
        for (ComputedColumn cc : params.computedColumns) {
            if (partitionColumnNames.contains(cc.name)) {
                scOutput = outputSchema.getColumnOrDefault(cc.name, Type.STRING);
                query.select(ef.dstPartitionId(scOutput, targetPartitionScheme.getDimension(cc.name)), cc.name);
                partitionColumnNames.remove(cc.name);
                continue;
            }
            ExpressionBuilder col = ef.col(SORTED_QUERY_ALIAS, cc.name);
            query.select(col, cc.name);
        }
        if (params.rowNumber) {
            colExpr = ef.col(SORTED_QUERY_ALIAS, ROW_NUMBER_FINAL_COLUMN_NAME);
            query.select(colExpr, ROW_NUMBER_FINAL_COLUMN_NAME);
        }
        if (params.rank) {
            colExpr = ef.col(SORTED_QUERY_ALIAS, RANK_FINAL_COLUMN_NAME);
            query.select(colExpr, RANK_FINAL_COLUMN_NAME);
        }
        if (params.denseRank) {
            colExpr = ef.col(SORTED_QUERY_ALIAS, DENSE_RANK_FINAL_COLUMN_NAME);
            query.select(colExpr, DENSE_RANK_FINAL_COLUMN_NAME);
        }
        if (targetPartitionScheme != null) {
            for (Object col : targetPartitionScheme.getDimensionNames()) {
                if (!partitionColumnNames.contains(col)) continue;
                scOutput = outputSchema.getColumnOrDefault((String)col, Type.STRING);
                query.select(ef.dstPartitionId(scOutput, targetPartitionScheme.getDimension((String)col)), (String)col);
            }
        }
        return query;
    }

    private String generateSQL(SQLDialect dialect, SortRecipePayloadParams params, Dataset source, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme, Dataset outputDataset, Set<String> excludedFromInput, boolean forceOutputColumnNameOverride) throws IOException {
        SelectQueryBuilder sourceQuery = this.makeSourceQuery(dialect, params, source, sourcePartitionScheme, sourcePartitions);
        SelectQueryBuilder sortedQuery = this.makeSortedQuery(sourceQuery, params, source, dialect);
        List<QueryAst.OrderClause> orderBy = dialect instanceof HiveSQLDialect && !(dialect instanceof PrestoSQLDialect) && HadoopFlavorUtils.isHive3() ? sortedQuery.getOrderBy() : null;
        if (CollectionUtils.isNotEmpty(sortedQuery.getOrderBy())) {
            if (dialect instanceof SQLServerSQLDialect) {
                sortedQuery.limit(Long.MAX_VALUE);
            } else if (dialect instanceof TeradataSQLDialect) {
                sortedQuery.limit((Long)Integer.MAX_VALUE);
            }
        }
        SelectQueryBuilder mainQuery = this.makeMainQuery(sortedQuery, params, source, targetPartitionScheme, outputDataset.getSchema(), excludedFromInput, dialect);
        mainQuery = QueryGenerationUtils.applyOverrides(mainQuery, params.outputColumnNameOverrides, dialect, forceOutputColumnNameOverride);
        mainQuery = QueryGenerationUtils.applyInsertIntoCasts(mainQuery, dialect, outputDataset);
        if (orderBy != null && !orderBy.isEmpty()) {
            for (QueryAst.OrderClause o : orderBy) {
                mainQuery.order(o);
            }
        }
        return mainQuery.toSQL(dialect);
    }

    public Schema getOutputSchemaBeforeOverride(Dataset inputDS, SortRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        Schema schema = this.getBaseOutputSchema(inputDS, params);
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    public Schema getOutputSchemaAfterOverride(Dataset inputDS, SortRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        Schema schema = this.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames);
        if (params.outputColumnNameOverrides != null) {
            for (SchemaColumn sc : schema.columns) {
                String override = params.outputColumnNameOverrides.get(sc.getName());
                if (!StringUtils.isNotBlank((String)override)) continue;
                sc.setName(override);
            }
        }
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    private Schema getBaseOutputSchema(Dataset inputDataset, SortRecipePayloadParams params) {
        Schema outputSchema = new Schema(inputDataset.getSchema());
        for (ComputedColumn cc : params.computedColumns) {
            ComputedColumnUtils.addToSchema(outputSchema, cc);
        }
        if (params.rowNumber) {
            outputSchema.addColumn(outputSchema.transmogrify(ROW_NUMBER_FINAL_COLUMN_NAME), Type.BIGINT);
        }
        if (params.rank) {
            outputSchema.addColumn(outputSchema.transmogrify(RANK_FINAL_COLUMN_NAME), Type.BIGINT);
        }
        if (params.denseRank) {
            outputSchema.addColumn(outputSchema.transmogrify(DENSE_RANK_FINAL_COLUMN_NAME), Type.BIGINT);
        }
        return outputSchema;
    }
}

