/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeHelper;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeService;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeService;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeService;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.shaker.ShakerRecipeStatusComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.recipes.VisualSQLRecipesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.StepInitException;
import com.dataiku.dip.sql.DummySQLDialect;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VisualRecipesController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private JoinRecipeService joinRecipeService;
    @Autowired
    private FuzzyJoinRecipeService fuzzyjoinRecipeService;
    @Autowired
    private GeoJoinRecipeService geojoinRecipeService;
    @Autowired
    private VisualSQLRecipesService visualRecipesService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private UIAuthService authService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.crud");

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/visual/convert"})
    public void convertRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData, @RequestParam String payload, @RequestParam String target) throws Exception {
        VisualSQLRecipeStatus status;
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        AuthCtx authCtx = null;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, sr.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        RecipeStatusComputer computer = RecipeRegistry.getMeta(sr).buildStatusComputer(sr, payload);
        if (computer == null || !(computer instanceof VisualSQLRecipeStatusComputer) && !(computer instanceof ShakerRecipeStatusComputer)) {
            throw new Error("Recipes of type " + sr.type + " cannot be converted");
        }
        if (computer instanceof VisualSQLRecipeStatusComputer) {
            visualSQLStatusComputer = (VisualSQLRecipeStatusComputer)computer;
            status = ((VisualSQLRecipeStatusComputer)visualSQLStatusComputer).getStatusForConversion_NT(authCtx);
        } else if (computer instanceof ShakerRecipeStatusComputer) {
            visualSQLStatusComputer = (ShakerRecipeStatusComputer)computer;
            status = ((ShakerRecipeStatusComputer)visualSQLStatusComputer).getStatusForConversion_NT(authCtx);
        } else {
            throw new Error("Unreachable");
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.visualRecipesService.convert(sr, status, status.sql, target, status.engineParams);
            t.commit("Convert " + sr.type + " recipe to " + target + " recipe: " + sr.getFullId());
            this.auditTrailService.generic("recipe-save").with("saveType", "convert-from-visual").with("oldRecipeType", sr.type).with("projectKey", sr.projectKey).with("recipeName", sr.name).with("newRecipeType", target).emit();
        }
    }

    @AuditedCall(value={"msgType", "convert-sampling-to-split", "projectKey", "${projectKey}", "recipeName", "${recipeName}", "secondOutputDataset", "${secondOutputDataset}"})
    @RequestMapping(value={"/api/flow/recipes/visual/convert-sampling-to-split"})
    public void convertSamplingRecipeToSplitRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName, @RequestParam String secondOutputDataset) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, recipeName);
            String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
            this.datasetsDAO.getMandatoryUnsafe(projectKey, secondOutputDataset);
            if (recipe == null || !"sampling".equals(recipe.type)) {
                throw new IllegalArgumentException("Only Filter recipes can be converted to Split recipes automatically.");
            }
            this.visualRecipesService.convertSamplingRecipeToSplitRecipe(recipe, payload, secondOutputDataset);
            t.commit("Convert Filter to Split recipe recipe: " + recipe.getFullId());
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/join/get-suggestions"})
    public void getJoinSuggestions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeData, @RequestParam String payloadData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            VisualRecipesController.writeJSON((HttpServletResponse)resp, this.joinRecipeService.suggestJoinConditions(sr, payloadData));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/visual/test-input-replacement"})
    public void testVisualRecipeInputReplacement(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeData, @RequestParam String payloadData, @RequestParam String inputIndex, @RequestParam String newInputName) throws Exception {
        SerializedDataset newInput;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, newInputName);
            if (!loc.getProjectKey().equals(projectKey) && !this.projectsService.isObjectAvailableInProject(new SmartObjectRef(loc.getProjectKey(), ITaggingService.TaggableType.DATASET, loc.getId()), projectKey)) {
                throw new SecurityException(String.format("Dataset %s is not shared with project %s", loc, projectKey));
            }
            newInput = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc);
        }
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        int index = Integer.parseInt(inputIndex);
        switch (sr.type) {
            case "join": {
                VisualRecipesController.writeJSON((HttpServletResponse)resp, (Object)this.joinRecipeService.testVirtualInputReplacement(sr, payloadData, index, newInput));
                break;
            }
            case "fuzzyjoin": {
                VisualRecipesController.writeJSON((HttpServletResponse)resp, (Object)this.fuzzyjoinRecipeService.testVirtualInputReplacement(sr, payloadData, index, newInput));
                break;
            }
            case "geojoin": {
                VisualRecipesController.writeJSON((HttpServletResponse)resp, (Object)this.geojoinRecipeService.testVirtualInputReplacement(sr, payloadData, index, newInput));
                break;
            }
            case "generate_features": {
                VisualRecipesController.writeJSON((HttpServletResponse)resp, (Object)AutoFeatureGenerationRecipeHelper.testVirtualInputReplacement(sr, payloadData, index, newInput));
                break;
            }
            default: {
                throw ErrorContext.iaef((String)"Cannot test input change for recipes type %s", (Object)sr.type, (Object[])new Object[0]);
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/fuzzyjoin/get-suggestions"})
    public void getFuzzyJoinSuggestions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeData, @RequestParam String payloadData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            VisualRecipesController.writeJSON((HttpServletResponse)resp, this.fuzzyjoinRecipeService.suggestJoinConditions(sr, payloadData));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/geojoin/get-suggestions"})
    public void getGeoJoinSuggestions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeData, @RequestParam String payloadData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            VisualRecipesController.writeJSON((HttpServletResponse)resp, this.geojoinRecipeService.suggestJoinConditions(sr, payloadData));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/autofeaturegeneration/get-default-columns"})
    public void getAutoFeatureDefaultColumns(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String newInputName, @RequestParam String recipeData, @RequestParam String payloadData) throws Exception {
        Dataset dataset;
        SerializedRecipe sr;
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, newInputName);
            this.projectsService.checkPerm(req, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatoryUnsafe(loc.getProjectKey(), loc.getName());
        }
        AutoFeatureGenerationRecipeHelper helper = new AutoFeatureGenerationRecipeHelper();
        VisualRecipesController.writeJSON((HttpServletResponse)resp, helper.suggestDefaultColumnsForComputation_NT(dataset, sr, payloadData, authCtx, projectKey));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/autofeaturegeneration/get-suggestions"})
    public void getAutoFeatureRelationshipSuggestions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeData, @RequestParam String payloadData) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            AutoFeatureGenerationRecipeHelper helper = new AutoFeatureGenerationRecipeHelper();
            VisualRecipesController.writeJSON((HttpServletResponse)resp, helper.suggestRelationshipConditions_T(sr, payloadData));
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/recipes/validate-expression"})
    public void validateGREL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String schemaData, @RequestParam String expression, @RequestParam(required=false) String recipeData, @RequestParam(required=false) String projectKey) throws DKUSecurityException, IOException {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)recipeData) || StringUtils.isNotBlank((String)projectKey) ? 1 : 0) != 0, (Object)"recipeData or projectKey is mandatory");
        if (StringUtils.isNotBlank((String)recipeData)) {
            SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            VariablesExpansionLoopConfig veLoopConfig = null;
            if (sr.params instanceof ParamsWithVariablesExpansionLoopConfig) {
                veLoopConfig = ((ParamsWithVariablesExpansionLoopConfig)((Object)sr.params)).getVariablesExpansionLoopConfig();
            }
            this.validateGRELInternal(req, resp, schemaData, expression, sr.projectKey, veLoopConfig);
            this.auditTrailService.generic("recipe-validate-expression").with("projectKey", sr.projectKey).with("veLoopConfigDatasetRef", veLoopConfig != null && veLoopConfig.isEnabled() ? veLoopConfig.datasetRef : null).emit();
        } else {
            this.validateGRELInternal(req, resp, schemaData, expression, projectKey, null);
        }
    }

    private void validateGRELInternal(HttpServletRequest req, HttpServletResponse resp, String schemaData, String expression, String projectKey, VariablesExpansionLoopConfig veLoopConfig) throws DKUSecurityException, IOException {
        AuthCtx authCtx;
        RecipeVariablesHelper helper = new RecipeVariablesHelper();
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)projectKey)) {
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        VariablesContext vc = StringUtils.isNotBlank((String)projectKey) ? helper.getVariablesContext(authCtx, projectKey, veLoopConfig) : helper.getVariablesContext(authCtx);
        ValidateGRELResponse vgr = new ValidateGRELResponse();
        try {
            if (StringUtils.isBlank((String)expression)) {
                throw new Exception("Filter expression is invalid");
            }
            expression = vc.expand(expression);
            Schema schema = (Schema)JSON.parse((String)schemaData, Schema.class);
            Expression expr = new Expression(expression, schema);
            expr.setVariablesContext(vc);
            DummySQLDialect dialect = new DummySQLDialect();
            GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(dialect), schema);
            GrelTranslator.TranslationResult<String> tr = translator.translateToString(expr, false);
            vgr.sql = (String)tr.result;
            vgr.fullyTranslated = tr.isFullyTranslated;
            vgr.ok = true;
        }
        catch (Exception e) {
            logger.info((Object)"Validate GREL failed.", (Throwable)e);
            vgr.ok = false;
            vgr.fullyTranslated = false;
            vgr.message = e instanceof StepInitException ? e.getCause().getMessage() : e.getMessage();
        }
        VisualRecipesController.writeJSON((HttpServletResponse)resp, (Object)vgr);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/recipes/validate-ast"})
    public void validateAST(HttpServletRequest req, HttpServletResponse resp, @RequestParam String astData, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        VariablesContext vc;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)projectKey)) {
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                vc = this.variablesService.getForProject(projectKey);
            } else {
                vc = this.variablesService.getForGlobal();
            }
        }
        ValidateASTResponse vgr = new ValidateASTResponse();
        try {
            FilterDesc filterDesc = (FilterDesc)JSON.parse((String)astData, FilterDesc.class);
            FilterDescUtils.expand(filterDesc, vc);
            vgr.grel = FilterDescUtils.translateAstToGrel(filterDesc);
            vgr.sql = FilterDescUtils.translateAstToSql(filterDesc, null, true, new DummySQLDialect()).toSQL(new DummySQLDialect());
            vgr.fullyTranslated = true;
            vgr.ok = true;
        }
        catch (Exception e) {
            logger.info((Object)("Validate AST failed: " + e.getMessage()));
            vgr.ok = false;
            vgr.fullyTranslated = false;
            vgr.message = e instanceof StepInitException ? e.getCause().getMessage() : e.getMessage();
        }
        VisualRecipesController.writeJSON((HttpServletResponse)resp, (Object)vgr);
    }

    static class ValidateGRELResponse {
        boolean ok;
        String message;
        String sql;
        boolean fullyTranslated;

        ValidateGRELResponse() {
        }
    }

    static class ValidateASTResponse {
        boolean ok;
        String message;
        String sql;
        String grel;
        boolean fullyTranslated;

        ValidateASTResponse() {
        }
    }
}

