/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.dataflow.graphtools.ColumnUsageView;
import com.dataiku.dip.dataflow.graphtools.ConnectionsView;
import com.dataiku.dip.dataflow.graphtools.ConsistencyTool;
import com.dataiku.dip.dataflow.graphtools.CopyTool;
import com.dataiku.dip.dataflow.graphtools.CountOfRecordsView;
import com.dataiku.dip.dataflow.graphtools.CreationView;
import com.dataiku.dip.dataflow.graphtools.CustomFieldsView;
import com.dataiku.dip.dataflow.graphtools.DataQualityView;
import com.dataiku.dip.dataflow.graphtools.FileformatsView;
import com.dataiku.dip.dataflow.graphtools.FilesizeView;
import com.dataiku.dip.dataflow.graphtools.FlowZonesView;
import com.dataiku.dip.dataflow.graphtools.HiveModeView;
import com.dataiku.dip.dataflow.graphtools.ImpalaWriteView;
import com.dataiku.dip.dataflow.graphtools.InterestsView;
import com.dataiku.dip.dataflow.graphtools.LastBuildDurationView;
import com.dataiku.dip.dataflow.graphtools.LastBuildView;
import com.dataiku.dip.dataflow.graphtools.LastModificationView;
import com.dataiku.dip.dataflow.graphtools.PartitioningView;
import com.dataiku.dip.dataflow.graphtools.PartitionsView;
import com.dataiku.dip.dataflow.graphtools.PipelinesView;
import com.dataiku.dip.dataflow.graphtools.PropagateSchemaTool;
import com.dataiku.dip.dataflow.graphtools.RecentActivityView;
import com.dataiku.dip.dataflow.graphtools.RecipesCodeEnvsView;
import com.dataiku.dip.dataflow.graphtools.RecipesEnginesView;
import com.dataiku.dip.dataflow.graphtools.ScenariosView;
import com.dataiku.dip.dataflow.graphtools.SparkConfigView;
import com.dataiku.dip.dataflow.graphtools.TagsView;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowToolsService {
    @Autowired
    AchievementsService achievementsService;
    private Map<String, AbstractFlowTool.UserSessions> users = new HashMap<String, AbstractFlowTool.UserSessions>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools");

    private void closeUseless(AbstractFlowTool.UserSessionsInProject ups) {
        HashSet<String> toClose = new HashSet<String>();
        AbstractFlowTool.ActiveFlowTool currentlyActive = null;
        if (ups.currentId != null) {
            currentlyActive = ups.active.get(ups.currentId);
        }
        block3: for (AbstractFlowTool.ActiveFlowTool at : ups.active.values()) {
            if (at.id.equals(ups.currentId)) continue;
            switch (at.type) {
                case PROPAGATE_SCHEMA: {
                    if (currentlyActive == null || currentlyActive.type == at.type) continue block3;
                    toClose.add(at.id);
                    continue block3;
                }
            }
            toClose.add(at.id);
        }
        for (String tc : toClose) {
            logger.infoV("Closing not-useful tool : %s", new Object[]{tc});
            this.stopAndRemove(ups, tc);
        }
    }

    private void stopAndRemove(AbstractFlowTool.UserSessionsInProject ups, String toolId) {
        AbstractFlowTool.ActiveFlowTool at = ups.active.get(toolId);
        if (at == null) {
            throw ErrorContext.iaef((String)"Tool not active: %s", (Object)toolId, (Object[])new Object[0]);
        }
        ups.active.remove(toolId);
        at.handler.stop();
    }

    public synchronized AbstractFlowTool.UserSessionsInProject switchTo(AuthCtx user, String projectKey, String toolId) {
        AbstractFlowTool.UserSessionsInProject ups = this.getUserSessions(user, projectKey);
        if (!ups.active.containsKey(toolId)) {
            throw ErrorContext.iaef((String)"Tool not active: %s", (Object)toolId, (Object[])new Object[0]);
        }
        ups.currentId = toolId;
        this.closeUseless(ups);
        return ups;
    }

    public synchronized AbstractFlowTool.UserSessionsInProject setDefaultActive(AuthCtx user, String projectKey) {
        AbstractFlowTool.UserSessionsInProject ups = this.getUserSessions(user, projectKey);
        ups.currentId = null;
        this.closeUseless(ups);
        return ups;
    }

    public synchronized AbstractFlowTool.UserSessionsInProject startTool(AuthCtx authCtx, String projectKey, String type, JsonObject toolInitialData) throws IOException {
        AbstractFlowTool.FlowToolType toolType = AbstractFlowTool.FlowToolType.valueOf(type);
        AbstractFlowTool newTool = this.getFlowToolHandler(toolType, authCtx, projectKey, toolInitialData);
        return this.makeToolActive(authCtx, projectKey, type, toolInitialData, newTool);
    }

    public synchronized AbstractFlowTool.UserSessionsInProject makeToolActive(AuthCtx authCtx, String projectKey, String type, JsonObject toolInitialData, AbstractFlowTool tool) throws IOException {
        AbstractFlowTool.UserSessionsInProject ups = this.getUserSessions(authCtx, projectKey);
        logger.infoV("Making tool into active one type=%s for user=%s project=%s", new Object[]{type, authCtx.getIdentifier(), projectKey});
        AbstractFlowTool.ActiveFlowTool newTool = new AbstractFlowTool.ActiveFlowTool();
        newTool.type = AbstractFlowTool.FlowToolType.valueOf(type);
        newTool.toolInitialData = toolInitialData;
        newTool.handler = tool;
        if (newTool.handler instanceof AbstractFlowTool.FlowView) {
            this.achievementsService.win(authCtx, AchievementsService.AchievementId.COLORS_OF_THE_WIND);
        }
        newTool.id = type + "-" + System.currentTimeMillis();
        ups.active.put(newTool.id, newTool);
        ups.currentId = newTool.id;
        this.closeUseless(ups);
        return ups;
    }

    public synchronized AbstractFlowTool getTool(AuthCtx authCtx, String projectKey, String type, JsonObject toolInitialData) throws IOException {
        AbstractFlowTool.FlowToolType toolType = AbstractFlowTool.FlowToolType.valueOf(type);
        return this.getFlowToolHandler(toolType, authCtx, projectKey, toolInitialData);
    }

    private AbstractFlowTool getFlowToolHandler(AbstractFlowTool.FlowToolType type, AuthCtx authCtx, String projectKey, JsonObject toolInitialData) throws IOException {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Flow tool type not specified");
        switch (type) {
            case FLOW_ZONES: {
                return new FlowZonesView(authCtx, projectKey);
            }
            case TAGS: {
                return new TagsView(authCtx, projectKey, toolInitialData);
            }
            case CUSTOM_FIELDS: {
                return new CustomFieldsView(authCtx, projectKey);
            }
            case CONNECTIONS: {
                return new ConnectionsView(authCtx, projectKey, toolInitialData);
            }
            case COUNT_OF_RECORDS: {
                return new CountOfRecordsView(authCtx, projectKey, toolInitialData);
            }
            case FILESIZE: {
                return new FilesizeView(authCtx, projectKey, toolInitialData);
            }
            case FILEFORMATS: {
                return new FileformatsView(authCtx, projectKey, toolInitialData);
            }
            case RECIPES_ENGINES: {
                return new RecipesEnginesView(authCtx, projectKey, toolInitialData);
            }
            case RECIPES_CODE_ENVS: {
                return new RecipesCodeEnvsView(authCtx, projectKey, toolInitialData);
            }
            case IMPALA_WRITE_MODE: {
                return new ImpalaWriteView(authCtx, projectKey, toolInitialData);
            }
            case HIVE_MODE: {
                return new HiveModeView(authCtx, projectKey, toolInitialData);
            }
            case SPARK_CONFIG: {
                return new SparkConfigView(authCtx, projectKey, toolInitialData);
            }
            case SPARK_PIPELINES: {
                return new PipelinesView(authCtx, projectKey, RecipePipelineHelper.PipelineType.SPARK);
            }
            case SQL_PIPELINES: {
                return new PipelinesView(authCtx, projectKey, RecipePipelineHelper.PipelineType.SQL);
            }
            case PARTITIONING: {
                return new PartitioningView(authCtx, projectKey, toolInitialData);
            }
            case PARTITIONS: {
                return new PartitionsView(authCtx, projectKey, toolInitialData);
            }
            case SCENARIOS: {
                return new ScenariosView(authCtx, projectKey, toolInitialData);
            }
            case CREATION: {
                return new CreationView(authCtx, projectKey, toolInitialData);
            }
            case LAST_MODIFICATION: {
                return new LastModificationView(authCtx, projectKey, toolInitialData);
            }
            case LAST_BUILD: {
                return new LastBuildView(authCtx, projectKey, toolInitialData);
            }
            case LAST_BUILD_DURATION: {
                return new LastBuildDurationView(authCtx, projectKey);
            }
            case RECENT_ACTIVITY: {
                return new RecentActivityView(authCtx, projectKey, toolInitialData);
            }
            case WATCH: {
                return new InterestsView(authCtx, projectKey, toolInitialData);
            }
            case COPY: {
                return new CopyTool(authCtx, projectKey, toolInitialData);
            }
            case CHECK_CONSISTENCY: {
                return new ConsistencyTool(authCtx, projectKey);
            }
            case PROPAGATE_SCHEMA: {
                return new PropagateSchemaTool(authCtx, projectKey, toolInitialData);
            }
            case DATA_QUALITY: {
                return new DataQualityView(authCtx, projectKey);
            }
            case COLUMN_USAGE: {
                return new ColumnUsageView(authCtx, projectKey);
            }
        }
        throw new Error("No flow tool for " + String.valueOf((Object)type));
    }

    public synchronized AbstractFlowTool.UserSessionsInProject stopTool(AuthCtx user, String projectKey, String toolId) {
        Validate.notNull((Object)toolId);
        logger.infoV("Stopping tool %s for user=%s project=%s", new Object[]{toolId, user.getIdentifier(), projectKey});
        AbstractFlowTool.UserSessionsInProject ups = this.getUserSessions(user, projectKey);
        this.stopAndRemove(ups, toolId);
        if (toolId.equals(ups.currentId)) {
            ups.currentId = null;
        }
        return ups;
    }

    public Boolean isActiveHandler(AuthCtx user, String projectKey) {
        AbstractFlowTool.UserSessionsInProject ups = this.getUserSessions(user, projectKey);
        return ups.currentId != null;
    }

    public synchronized AbstractFlowTool getActiveHandler(AuthCtx user, String projectKey) {
        AbstractFlowTool.UserSessionsInProject ups = this.getUserSessions(user, projectKey);
        if (ups.currentId == null) {
            throw new IllegalArgumentException("No active flow view, please refresh the page");
        }
        AbstractFlowTool.ActiveFlowTool at = ups.active.get(ups.currentId);
        assert (at != null);
        assert (at.handler != null);
        return at.handler;
    }

    public synchronized AbstractFlowTool getHandler(AuthCtx user, String projectKey, String toolId) {
        AbstractFlowTool.UserSessionsInProject ups = this.getUserSessions(user, projectKey);
        AbstractFlowTool.ActiveFlowTool at = ups.active.get(toolId);
        assert (at != null);
        assert (at.handler != null);
        return at.handler;
    }

    public AbstractFlowTool.UserSessionsInProject getUserSessions(AuthCtx user, String projectKey) {
        AbstractFlowTool.UserSessions us = this.getForUser(user);
        if (us.projects.get(projectKey) == null) {
            us.projects.put(projectKey, new AbstractFlowTool.UserSessionsInProject());
        }
        return us.projects.get(projectKey);
    }

    private AbstractFlowTool.UserSessions getForUser(AuthCtx user) {
        if (this.users.get(user.getIdentifier()) == null) {
            this.users.put(user.getIdentifier(), new AbstractFlowTool.UserSessions());
        }
        return this.users.get(user.getIdentifier());
    }
}

