/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.sql.queries.UpdateQueryBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.log4j.Logger;

public class JobsDatabaseIntegrationTypesMigrationTool {
    private final ReadOnlyJobsInternalDB jobsDb;
    private final Map<String, String> mapping = Maps.newHashMap();
    private static Logger logger = Logger.getLogger((String)"dip.jobsdb.migration");

    public JobsDatabaseIntegrationTypesMigrationTool(ReadOnlyJobsInternalDB jobsDb) {
        this.jobsDb = jobsDb;
        this.mapping.put("smtp", "mail-scenario");
        this.mapping.put("aws", "mail-scenario");
        this.mapping.put("slack", "slack-scenario");
        this.mapping.put("webhook", "webhook-scenario");
        this.mapping.put("twilio", "twilio-scenario");
        this.mapping.put("shell", "shell-scenario");
        this.mapping.put("dataset", "dataset-scenario");
    }

    public void runMigration() throws Exception {
        try {
            logger.info((Object)"Updating scenario runs");
            final ArrayList scenarioUpdates = Lists.newArrayList();
            this.jobsDb.readAllScenarioRunsRaw(new ReadOnlyJobsInternalDB.RawScenarioRunConsumer(){

                @Override
                public void handle(String projectKey, String scenarioId, String scenarioRunId, String scenarioJsonStr) throws Exception {
                    String updatedScenarioJsonStr = JobsDatabaseIntegrationTypesMigrationTool.this.updateScenarioDefinition(scenarioJsonStr);
                    if (StringUtils.isNotBlank((String)updatedScenarioJsonStr)) {
                        scenarioUpdates.add(new ScenarioRunToUpdate(projectKey, scenarioId, scenarioRunId, updatedScenarioJsonStr));
                    }
                }
            });
            logger.info((Object)("Found " + scenarioUpdates.size() + " scenario runs to update"));
            final MutableInt scenarioPos = new MutableInt(0);
            this.jobsDb.updateJobsDatabaseObjectsRaw(UpdateQueryBuilder.update(this.jobsDb.resolveTable("SCENARIO_RUNS")).columns("SCENARIO").withParameterizedEqualWheres("SCENARIO_PROJECT_KEY", "SCENARIO_ID", "SCENARIO_RUN_ID").toSql(this.jobsDb.getDialect()), new ReadOnlyJobsInternalDB.RawJobDatabaseObjectProducer(){

                @Override
                public boolean handle(PreparedStatement stmt) throws Exception {
                    if (scenarioPos.intValue() < scenarioUpdates.size()) {
                        ScenarioRunToUpdate update = (ScenarioRunToUpdate)scenarioUpdates.get(scenarioPos.intValue());
                        stmt.setString(1, update.scenarioJsonStr);
                        stmt.setString(2, update.projectKey);
                        stmt.setString(3, update.scenarioId);
                        stmt.setString(4, update.scenarioRunId);
                        scenarioPos.increment();
                        return true;
                    }
                    return false;
                }
            });
            logger.info((Object)"Updating step runs");
            final ArrayList updates = Lists.newArrayList();
            this.jobsDb.readAllStepRunsRaw(new ReadOnlyJobsInternalDB.RawStepRunConsumer(){

                @Override
                public void handle(String projectKey, String scenarioId, String scenarioRunId, String stepRunId, String stepJsonStr) throws Exception {
                    String updatedStepJsonStr = JobsDatabaseIntegrationTypesMigrationTool.this.updateStepDefinition(stepJsonStr);
                    if (StringUtils.isNotBlank((String)updatedStepJsonStr)) {
                        updates.add(new StepRunToUpdate(projectKey, scenarioId, scenarioRunId, stepRunId, updatedStepJsonStr));
                    }
                }
            });
            logger.info((Object)("Found " + updates.size() + " step runs to update"));
            final MutableInt stepPos = new MutableInt(0);
            this.jobsDb.updateJobsDatabaseObjectsRaw(UpdateQueryBuilder.update(this.jobsDb.resolveTable("STEP_RUNS")).columns("STEP").withParameterizedEqualWheres("SCENARIO_PROJECT_KEY", "SCENARIO_ID", "SCENARIO_RUN_ID", "STEP_RUN_ID").toSql(this.jobsDb.getDialect()), new ReadOnlyJobsInternalDB.RawJobDatabaseObjectProducer(){

                @Override
                public boolean handle(PreparedStatement stmt) throws Exception {
                    if (stepPos.intValue() < updates.size()) {
                        StepRunToUpdate update = (StepRunToUpdate)updates.get(stepPos.intValue());
                        stmt.setString(1, update.stepJsonStr);
                        stmt.setString(2, update.projectKey);
                        stmt.setString(3, update.scenarioId);
                        stmt.setString(4, update.scenarioRunId);
                        stmt.setString(5, update.stepRunId);
                        stepPos.increment();
                        return true;
                    }
                    return false;
                }
            });
            logger.info((Object)"Updating flow object actions");
            final ArrayList actionUpdates = Lists.newArrayList();
            this.jobsDb.readObjectActionsForType("INSIGHT_REFRESHED", new ReadOnlyJobsInternalDB.FlowObjectActionConsumer(){

                @Override
                public void handle(String projectKey, String objectId, String partition, String type, long timeStart, String resultJsonStr) throws Exception {
                    actionUpdates.add(new FlowObjectActionToUpdate(projectKey, objectId, partition, type, timeStart, JobsDatabaseIntegrationTypesMigrationTool.this.updateFlowObjectAction(resultJsonStr), "CREATED_JUPYTER_EXPORT"));
                }
            });
            logger.info((Object)("Found " + actionUpdates.size() + " object actions to update"));
            final MutableInt actionPos = new MutableInt(0);
            this.jobsDb.updateJobsDatabaseObjectsRaw(UpdateQueryBuilder.update(this.jobsDb.resolveTable("FLOW_OBJECT_ACTION")).columns("TYPE", "RESULT").withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID", "PARTITION", "TYPE", "TIME_START").toSql(this.jobsDb.getDialect()), new ReadOnlyJobsInternalDB.RawJobDatabaseObjectProducer(){

                @Override
                public boolean handle(PreparedStatement stmt) throws Exception {
                    if (actionPos.intValue() < actionUpdates.size()) {
                        FlowObjectActionToUpdate update = (FlowObjectActionToUpdate)actionUpdates.get(actionPos.intValue());
                        stmt.setString(1, update.newType);
                        stmt.setString(2, update.resultJsonStr);
                        stmt.setString(3, update.projectKey);
                        stmt.setString(4, update.objectId);
                        stmt.setString(5, update.partition);
                        stmt.setString(6, update.type);
                        stmt.setLong(7, update.timeStart);
                        actionPos.increment();
                        return true;
                    }
                    return false;
                }
            });
            logger.info((Object)"Updating flow object action history");
            final ArrayList actionHistoryUpdates = Lists.newArrayList();
            this.jobsDb.readObjectActionHistoryForType("INSIGHT_REFRESHED", new ReadOnlyJobsInternalDB.FlowObjectActionConsumer(){

                @Override
                public void handle(String projectKey, String objectId, String partition, String type, long timeStart, String resultJsonStr) throws Exception {
                    actionHistoryUpdates.add(new FlowObjectActionToUpdate(projectKey, objectId, partition, type, timeStart, JobsDatabaseIntegrationTypesMigrationTool.this.updateFlowObjectAction(resultJsonStr), "CREATED_JUPYTER_EXPORT"));
                }
            });
            logger.info((Object)("Found " + actionHistoryUpdates.size() + " object action history entries to update"));
            final MutableInt historyPos = new MutableInt(0);
            this.jobsDb.updateJobsDatabaseObjectsRaw(UpdateQueryBuilder.update(this.jobsDb.resolveTable("FLOW_OBJECT_ACTION_HISTORY")).columns("TYPE", "RESULT").withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID", "PARTITION", "TYPE", "TIME_START").toSql(this.jobsDb.getDialect()), new ReadOnlyJobsInternalDB.RawJobDatabaseObjectProducer(){

                @Override
                public boolean handle(PreparedStatement stmt) throws Exception {
                    if (historyPos.intValue() < actionHistoryUpdates.size()) {
                        FlowObjectActionToUpdate update = (FlowObjectActionToUpdate)actionHistoryUpdates.get(historyPos.intValue());
                        stmt.setString(1, update.newType);
                        stmt.setString(2, update.resultJsonStr);
                        stmt.setString(3, update.projectKey);
                        stmt.setString(4, update.objectId);
                        stmt.setString(5, update.partition);
                        stmt.setString(6, update.type);
                        stmt.setLong(7, update.timeStart);
                        historyPos.increment();
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"failed to update scenario and step runs", (Throwable)e);
            throw e;
        }
    }

    private String updateScenarioDefinition(String scenarioJsonStr) {
        int i;
        int changesCount = 0;
        JsonObject scenarioJson = (JsonObject)JSON.parse((String)scenarioJsonStr, JsonObject.class);
        JsonArray reporters = this.getAsJsonArray(scenarioJson, "reporters", new JsonArray());
        JsonArray steps = this.getAsJsonArray(this.getAsJsonObject(scenarioJson, "params", new JsonObject()), "steps", new JsonArray());
        for (i = 0; i < reporters.size(); ++i) {
            JsonObject reporter = reporters.get(i).getAsJsonObject();
            JsonObject messaging = this.getAsJsonObject(reporter, "messaging", new JsonObject());
            String messagingType = this.getAsString(messaging, "type", "");
            if (!this.mapping.containsKey(messagingType)) continue;
            ++changesCount;
            messaging.remove("type");
            messaging.addProperty("type", this.mapping.get(messagingType));
        }
        for (i = 0; i < steps.size(); ++i) {
            JsonObject step = steps.get(i).getAsJsonObject();
            String stepType = this.getAsString(step, "type", "");
            if (stepType.equals("send_report")) {
                JsonObject messaging = this.getAsJsonObject(this.getAsJsonObject(step, "params", new JsonObject()), "messaging", new JsonObject());
                String messagingType = this.getAsString(messaging, "type", "");
                if (!this.mapping.containsKey(messagingType)) continue;
                ++changesCount;
                messaging.remove("type");
                messaging.addProperty("type", this.mapping.get(messagingType));
                continue;
            }
            if (!stepType.equals("refresh_notebook_insight")) continue;
            step.addProperty("type", "create_jupyter_export");
            ++changesCount;
        }
        return changesCount > 0 ? JSON.json((Object)scenarioJson) : null;
    }

    private String updateStepDefinition(String stepJsonStr) {
        int changesCount = 0;
        JsonObject stepJson = (JsonObject)JSON.parse((String)stepJsonStr, JsonObject.class);
        String stepType = this.getAsString(stepJson, "type", "");
        if (stepType.equals("send_report")) {
            JsonObject messaging = this.getAsJsonObject(this.getAsJsonObject(stepJson, "params", new JsonObject()), "messaging", new JsonObject());
            String messagingType = this.getAsString(messaging, "type", "");
            if (this.mapping.containsKey(messagingType)) {
                ++changesCount;
                messaging.remove("type");
                messaging.addProperty("type", this.mapping.get(messagingType));
            }
        } else if (stepType.equals("refresh_notebook_insight")) {
            stepJson.addProperty("type", "create_jupyter_export");
            ++changesCount;
        }
        return changesCount > 0 ? JSON.json((Object)stepJson) : null;
    }

    private String updateFlowObjectAction(String stepJsonStr) {
        if (StringUtils.isBlank((String)stepJsonStr)) {
            return null;
        }
        int changesCount = 0;
        JsonObject stepJson = (JsonObject)JSON.parse((String)stepJsonStr, JsonObject.class);
        String stepType = this.getAsString(stepJson, "type", "");
        if (stepType.equals("INSIGHT_REFRESHED")) {
            stepJson.addProperty("type", "CREATED_JUPYTER_EXPORT");
            ++changesCount;
        }
        return changesCount > 0 ? JSON.json((Object)stepJson) : null;
    }

    private JsonArray getAsJsonArray(JsonObject o, String p, JsonArray d) {
        if (o.has(p)) {
            return o.getAsJsonArray(p);
        }
        return d;
    }

    private JsonObject getAsJsonObject(JsonObject o, String p, JsonObject d) {
        if (o.has(p)) {
            return o.getAsJsonObject(p);
        }
        return d;
    }

    private String getAsString(JsonObject o, String p, String d) {
        if (o.has(p)) {
            return o.getAsJsonPrimitive(p).getAsString();
        }
        return d;
    }

    private static class FlowObjectActionToUpdate {
        private final String projectKey;
        private final String objectId;
        private final String partition;
        private final String resultJsonStr;
        private final String type;
        private final long timeStart;
        private final String newType;

        FlowObjectActionToUpdate(String projectKey, String objectId, String partition, String type, long timeStart, String resultJsonStr, String newType) {
            this.projectKey = projectKey;
            this.objectId = objectId;
            this.partition = partition;
            this.type = type;
            this.timeStart = timeStart;
            this.resultJsonStr = resultJsonStr;
            this.newType = newType;
        }
    }

    private static class StepRunToUpdate {
        private final String projectKey;
        private final String scenarioId;
        private final String scenarioRunId;
        private final String stepJsonStr;
        private final String stepRunId;

        StepRunToUpdate(String projectKey, String scenarioId, String scenarioRunId, String stepRunId, String stepJsonStr) {
            this.projectKey = projectKey;
            this.scenarioId = scenarioId;
            this.scenarioRunId = scenarioRunId;
            this.stepRunId = stepRunId;
            this.stepJsonStr = stepJsonStr;
        }
    }

    private static class ScenarioRunToUpdate {
        private final String projectKey;
        private final String scenarioId;
        private final String scenarioRunId;
        private final String scenarioJsonStr;

        ScenarioRunToUpdate(String projectKey, String scenarioId, String scenarioRunId, String scenarioJsonStr) {
            this.projectKey = projectKey;
            this.scenarioId = scenarioId;
            this.scenarioRunId = scenarioRunId;
            this.scenarioJsonStr = scenarioJsonStr;
        }
    }
}

