/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KernelGeneralSettingsService {
    @Autowired
    GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    PasswordEncryptionService symetricCryptoService;
    @Autowired
    private LicenseStatusService licenseService;

    public FeatureConfig getFeatureConfig() throws IOException {
        FeatureConfig c2 = new FeatureConfig();
        c2.dipInstanceId = ApplicationConfigurator.dipInstanceId();
        c2.version = ApplicationConfigurator.getDSSVersion();
        c2.debug = ApplicationConfigurator.debugEnabled();
        boolean bl = c2.devInstance = System.getenv("DSS_DEV") != null;
        if (System.getenv("DKUDISTRIB") != null) {
            String str = System.getenv("DKUDISTRIB");
            c2.distrib = StringUtils.split((String)str, (char)' ')[0];
            c2.distribVersion = str.substring(c2.distrib.length() + 1);
        } else {
            c2.distrib = "unknown";
            c2.distribVersion = "unknown";
        }
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile f = RelFile.global((String)"general-settings.json");
        GeneralSettingsDAO.GeneralSettings generalSettings = (GeneralSettingsDAO.GeneralSettings)t.readObjectDefault(f, GeneralSettingsDAO.GeneralSettings.class);
        if (generalSettings.security.hideVersionStringsWhenNotLogged) {
            c2.distrib = null;
            c2.distribVersion = null;
            c2.version = null;
        }
        LicenseStatusService.LicensingStatus licensing = this.licenseService.getLicensingStatus();
        c2.features.put(FeatureConfig.Feature.OPENAI, new Object());
        c2.features.put(FeatureConfig.Feature.AZURE_OPENAI, new Object());
        c2.features.put(FeatureConfig.Feature.COHERE, new Object());
        c2.features.put(FeatureConfig.Feature.ANTHROPIC, new Object());
        c2.features.put(FeatureConfig.Feature.VERTEX, new Object());
        c2.features.put(FeatureConfig.Feature.HUGGING_FACE, new Object());
        if (!licensing.community) {
            c2.features.put(FeatureConfig.Feature.TWITTER, new Object());
        }
        c2.features.put(FeatureConfig.Feature.R, new Object());
        if (HadoopLoader.hadoopEnabled()) {
            c2.features.put(FeatureConfig.Feature.HADOOP, new Object());
        }
        if ("true".equals(System.getenv("DKU_PIG_ENABLED"))) {
            c2.features.put(FeatureConfig.Feature.PIG, new Object());
        }
        if (HiveConfigurator.hiveAvailableBase()) {
            c2.features.put(FeatureConfig.Feature.HIVE, new Object());
        }
        if (ImpalaConfigurator.impalaAvailableBase()) {
            c2.features.put(FeatureConfig.Feature.IMPALA, new Object());
        }
        if (!StringUtils.isBlank((String)generalSettings.h2o_url)) {
            c2.features.put(FeatureConfig.Feature.H2O, new Object());
        }
        if (SparkConfigurator.sparkAvailableBase()) {
            c2.features.put(FeatureConfig.Feature.SPARK, new Object());
        }
        c2.globalProxy = generalSettings.proxySettings;
        c2.globalProxy.decryptFields(this.symetricCryptoService);
        return c2;
    }

    public static class FeatureConfig {
        ProxySettings globalProxy;
        String distrib;
        String distribVersion;
        String dipInstanceId;
        DKUApp.DSSVersion version;
        boolean debug;
        boolean devInstance;
        Map<Feature, Object> features = Maps.newHashMap();

        public static enum Feature {
            HADOOP,
            IMPALA,
            HIVE,
            PIG,
            SPARK,
            R,
            H2O,
            TWITTER,
            OPENAI,
            AZURE_OPENAI,
            COHERE,
            ANTHROPIC,
            VERTEX,
            HUGGING_FACE;

        }
    }
}

