/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PagesSettingsSearchService {
    @Autowired
    private PluginStoreService pluginStoreService;
    private PageSettingsFile settingsFile;

    public void refreshSettingsFile() throws IOException {
        this.settingsFile = (PageSettingsFile)JSON.parseFile((File)DKUApp.getResourceFile((String)"navigation/index.json"), PageSettingsFile.class);
        PluginStoreService.PluginsStateList stateList = this.pluginStoreService.getStateListNoCheck();
        for (PluginStoreService.PluginStateInfo plugin : stateList.plugins) {
            Object url = String.format("/plugins/%s/summary/", plugin.id);
            String path = "Plugins > Installed";
            String label = plugin.id;
            String permission = null;
            if (!plugin.inStore && plugin.installed) {
                label = plugin.installedDesc.desc.meta.label;
                if (plugin.installedDesc.origin == InstalledPluginDesc.PluginOrigin.DEV) {
                    url = String.format("/plugins/development/%s/definition/", plugin.id);
                    path = "Plugins > Development";
                    permission = "user.mayDevelopPlugins";
                }
            } else if (plugin.inStore) {
                label = plugin.storeDesc.meta.label;
                if (!plugin.installed) {
                    url = "/plugins-explore/store/" + plugin.id;
                    path = "Plugins > Store";
                }
            }
            this.settingsFile.pages.add(new PageSettings(label + " plugin", (String)url, path, "Instance", permission));
        }
    }

    public List<PageSettings> list() {
        return this.settingsFile.pages;
    }

    public static class PageSettingsFile {
        public List<PageSettings> pages;
    }

    public static class PageSettings {
        public String label;
        public String url;
        public String path;
        public String scope;
        public String permission;

        public PageSettings(String label, String url, String path, String scope) {
            this(label, url, path, scope, null);
        }

        public PageSettings(String label, String url, String path, String scope, String permission) {
            this.label = label;
            this.url = url;
            this.path = path;
            this.scope = scope;
            this.permission = permission;
        }
    }
}

