/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecipesEnginesService {
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipesSaveService;
    @Autowired
    private ExecutionPlanService executionPlanService;
    @Autowired
    private TransactionService transactionService;
    public static final String DEFAULT_ENGINE = "__AUTO__";
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.engines");

    public EnginesChangeStartResponse startChangeEngines(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx) throws Exception {
        EnginesChangeStartResponse ret = new EnginesChangeStartResponse();
        HashMap<String, String> allEngineTypes = new HashMap<String, String>();
        HashMap<String, List<RecipeEngineStatus>> allEngineStatuses = new HashMap<String, List<RecipeEngineStatus>>();
        boolean allSameEngine = true;
        String commonEngine = null;
        for (TaggableObjectsService.TaggableObjectRef taggableObjectRef : refs) {
            AnyLoc loc = taggableObjectRef.getLoc().resolved();
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(loc);
            RecipeMeta meta = RecipeRegistry.getMeta(sr);
            if (!meta.getRecipeDesc().isMultiEngine) {
                ret.withWarning(RecipeCodes.ERR_RECIPE_CANNOT_CHANGE_ENGINE, "Cannot change the engine of " + sr.type + " recipes");
                continue;
            }
            String payload = this.recipesDAO.getPayloadOrNull(loc.getProjectKey(), loc.getId());
            RecipeStatusComputer computer = meta.buildStatusComputer(sr, payload);
            RecipeStatus recipeStatus = computer.fastStatusIgnorePartitions(authCtx);
            for (RecipeEngineStatus eng : recipeStatus.engines) {
                allEngineTypes.put(eng.type, eng.typeLabel);
            }
            allEngineStatuses.put(loc.getFullName(), recipeStatus.engines);
            if (!(commonEngine == null || recipeStatus.selectedEngine != null && commonEngine.equals(recipeStatus.selectedEngine.type))) {
                allSameEngine = false;
                continue;
            }
            if (recipeStatus.selectedEngine == null) continue;
            commonEngine = recipeStatus.selectedEngine.type;
        }
        if (allSameEngine) {
            ret.currentEngine = commonEngine;
        }
        for (Map.Entry entry : allEngineTypes.entrySet()) {
            MultiRecipeEngineStatus engineStatus = new MultiRecipeEngineStatus();
            engineStatus.type = (String)entry.getKey();
            engineStatus.typeLabel = (String)entry.getValue();
            engineStatus.recommended = true;
            engineStatus.isSelectable = true;
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                String recipeFullId = ref.getLoc().resolved().getFullName();
                List recipeStatuses = (List)allEngineStatuses.get(recipeFullId);
                if (recipeStatuses == null) continue;
                this.mergeEngineStatus(engineStatus, recipeFullId, recipeStatuses);
            }
            ret.engines.add(engineStatus);
        }
        return ret;
    }

    private void mergeEngineStatus(MultiRecipeEngineStatus mainStatus, String recipeFullId, List<RecipeEngineStatus> recipeStatuses) {
        boolean found = false;
        for (RecipeEngineStatus es : recipeStatuses) {
            if (!es.type.equals(mainStatus.type)) continue;
            if (!es.recommended) {
                mainStatus.recommended = false;
            }
            if (!es.isSelectable) {
                mainStatus.isSelectable = false;
            }
            if (es.statusWarnLevel == RecipeEngineStatus.WarningLevel.ERROR) {
                mainStatus.messages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, es.statusMessage);
            }
            if (es.statusWarnLevel == RecipeEngineStatus.WarningLevel.WARN) {
                mainStatus.messages.withWarning((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, es.statusMessage);
            }
            found = true;
            break;
        }
        if (!found) {
            mainStatus.isSelectable = false;
            mainStatus.messages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_CHANGE_ENGINE, "Some recipes don't support this engine");
        }
    }

    public InfoMessage.InfoMessages testChangeEngines(List<TaggableObjectsService.TaggableObjectRef> refs, String engine, AuthCtx authCtx) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)engine), (Object)"Engine not specified");
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        return messages;
    }

    public void changeEngines(List<TaggableObjectsService.TaggableObjectRef> refs, String engine, AuthCtx authCtx) throws Exception {
        String e = DEFAULT_ENGINE.equals(engine) ? null : engine;
        this.doChangeEngines(refs, e, authCtx);
    }

    public void doChangeEngines(List<TaggableObjectsService.TaggableObjectRef> refs, String engine, AuthCtx authCtx) throws Exception {
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            AnyLoc loc = ref.getLoc().resolved();
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
            RecipeMeta meta = RecipeRegistry.getMeta(sr);
            if (!meta.getRecipeDesc().isMultiEngine) {
                logger.info((Object)("Cannot change engine for " + sr.getFullId() + ". Skiping."));
                return;
            }
            logger.info((Object)("Change engine for " + sr.getFullId()));
            String payload = this.recipesDAO.getPayloadOrNull(loc.getProjectKey(), loc.getId());
            String updatedPayload = meta.setEngine(sr, payload, engine);
            this.recipesSaveService.save(ref.projectKey, sr, updatedPayload);
        }
    }

    public InfoMessage.InfoMessages testConvertToImpala_NT(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx, boolean checkRecipesRunOnImpala) throws IOException {
        InfoMessage.InfoMessages results = new InfoMessage.InfoMessages();
        if (!ImpalaConfigurator.impalaAvailableBase()) {
            results.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_IMPALA_NOT_ENABLED, "");
            return results;
        }
        HashMap<String, SerializedRecipe> recipes = new HashMap<String, SerializedRecipe>(refs.size());
        HashMap<String, String> scripts = new HashMap<String, String>(refs.size());
        try (Transaction t = this.transactionService.beginRead();){
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                AnyLoc loc = ref.getLoc().resolved();
                SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
                if (!HiveRecipeMeta.META.getType().equals(sr.type)) {
                    throw ErrorContext.iaef((String)"Only Hive recipes can be converted to Impala. %s is of type %s", (Object)loc.getId(), (Object[])new Object[]{sr.type});
                }
                if (!checkRecipesRunOnImpala) continue;
                sr.type = "impala";
                String script = this.recipesDAO.getPayloadOrNull(loc.getProjectKey(), loc.getId());
                recipes.put(loc.getFullName(), sr);
                scripts.put(loc.getFullName(), script);
            }
        }
        if (checkRecipesRunOnImpala) {
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                AnyLoc loc = ref.getLoc().resolved();
                try {
                    SerializedRecipe sr = (SerializedRecipe)recipes.get(loc.getFullName());
                    String script = (String)scripts.get(loc.getFullName());
                    this.executionPlanService.getImpalaExecutionPlan(sr, script, authCtx);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to validate recipe on Impala", (Throwable)e);
                    results.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Validation failed for recipe " + loc.getId() + ":\n" + e.getMessage());
                }
            }
        } else {
            logger.info((Object)"Don't check if recipes run on Impala");
        }
        return results;
    }

    public void convertToImpala_NT(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx, boolean checkRecipesRunOnImpala) throws IOException, UnauthorizedException, DKUSecurityException, CodedException {
        InfoMessage.InfoMessages messages;
        if (!ImpalaConfigurator.impalaAvailableBase()) {
            throw new IllegalArgumentException("Impala is not enabled");
        }
        if (checkRecipesRunOnImpala && (messages = this.testConvertToImpala_NT(refs, authCtx, true)).anyFatal()) {
            throw new IllegalArgumentException(messages.firstFatal().toString());
        }
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                AnyLoc loc = ref.getLoc().resolved();
                SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
                if (!HiveRecipeMeta.META.getType().equals(sr.type)) {
                    throw ErrorContext.iaef((String)"Only Hive recipes can be converted to impala. %s is of type %s", (Object)loc.getId(), (Object[])new Object[]{sr.type});
                }
                this.recipesSaveService.changeType(loc.getProjectKey(), loc.getId(), ImpalaRecipeMeta.META.getType());
            }
            t.commit("Converted recipes to Impala");
        }
    }

    public InfoMessage.InfoMessages testConvertToHive_NT(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx, boolean checkRecipesRunOnHive) throws IOException {
        InfoMessage.InfoMessages results = new InfoMessage.InfoMessages();
        HashMap<String, SerializedRecipe> recipes = new HashMap<String, SerializedRecipe>(refs.size());
        HashMap<String, String> scripts = new HashMap<String, String>(refs.size());
        try (Transaction t = this.transactionService.beginRead();){
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                AnyLoc loc = ref.getLoc().resolved();
                SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
                if (!ImpalaRecipeMeta.META.getType().equals(sr.type)) {
                    throw ErrorContext.iaef((String)"Only impala recipes can be converted to hive. %s is of type %s", (Object)loc.getId(), (Object[])new Object[]{sr.type});
                }
                if (!checkRecipesRunOnHive) continue;
                sr.type = "hive";
                String script = this.recipesDAO.getPayloadOrNull(loc.getProjectKey(), loc.getId());
                recipes.put(loc.getFullName(), sr);
                scripts.put(loc.getFullName(), script);
            }
        }
        if (checkRecipesRunOnHive) {
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                AnyLoc loc = ref.getLoc().resolved();
                try {
                    SerializedRecipe sr = (SerializedRecipe)recipes.get(loc.getFullName());
                    String script = (String)scripts.get(loc.getFullName());
                    this.executionPlanService.getHiveExecutionPlan(sr, script, authCtx, new HiveRecipeMeta.HiveRecipeParams());
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to validate recipe on Hive", (Throwable)e);
                    results.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Validation failed for recipe " + loc.getId() + ":\n" + e.getMessage());
                }
            }
        } else {
            logger.info((Object)"Don't check if recipes run on Hive");
        }
        return results;
    }

    public void convertToHive_NT(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx, boolean checkRecipesRunOnHive) throws IOException, UnauthorizedException, DKUSecurityException, CodedException {
        InfoMessage.InfoMessages messages;
        if (checkRecipesRunOnHive && (messages = this.testConvertToHive_NT(refs, authCtx, true)).anyFatal()) {
            throw new IllegalArgumentException(messages.firstFatal().toString());
        }
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                AnyLoc loc = ref.getLoc().resolved();
                SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
                if (!ImpalaRecipeMeta.META.getType().equals(sr.type)) {
                    throw ErrorContext.iaef((String)"Only Impala recipes can be converted to Hive. %s is of type %s", (Object)loc.getId(), (Object[])new Object[]{sr.type});
                }
                this.recipesSaveService.changeType(loc.getProjectKey(), sr.name, HiveRecipeMeta.META.getType());
            }
            t.commit("Converted recipes to Hive");
        }
    }

    public static class EnginesChangeStartResponse
    extends InfoMessage.InfoMessages {
        public String currentEngine;
        public List<MultiRecipeEngineStatus> engines = new ArrayList<MultiRecipeEngineStatus>();
    }

    static class MultiRecipeEngineStatus {
        public String type;
        public String typeLabel;
        public boolean isSelectable = true;
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public boolean recommended;

        MultiRecipeEngineStatus() {
        }
    }
}

