/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dashboards.model.DashboardPageSectionSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.UserSettingsChangedEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserSettingsService {
    private static final RelFile USER_SETTINGS_FILE = RelFile.global((String)"user-settings.json");
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private ProjectsService projectsService;
    static Logger logger = Logger.getLogger((String)"dip.services.userSettings");

    public UserSettingsService() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private UserSettingsFile read(boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        if (unsafe) {
            return (UserSettingsFile)t.readObjectDefaultUnsafe(USER_SETTINGS_FILE, UserSettingsFile.class);
        }
        return (UserSettingsFile)t.readObjectDefault(USER_SETTINGS_FILE, UserSettingsFile.class);
    }

    private void write(RWTransactionRef tr, UserSettingsFile file) throws IOException {
        tr.writeObject(USER_SETTINGS_FILE, (Object)file);
    }

    public void setUserSettings(String userIdentifier, UserSettings userSettings) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        UserSettingsFile file = this.read(false);
        file.userSettings.put(userIdentifier, userSettings);
        this.write(tr, file);
        this.pubSub.publishAfterTransaction(new UserSettingsChangedEvent(userIdentifier));
    }

    public void setUserSettings(AuthCtx user, UserSettings userSettings) throws IOException {
        this.setUserSettings(user.getIdentifier(), userSettings);
    }

    public UserSettings getForUser(String login) throws IOException {
        UserSettings userSettings = this.getForUserUnsafe(login);
        return (UserSettings)JSON.deepCopy((Object)userSettings);
    }

    public UserSettings getForUserUnsafe(String login) throws IOException {
        UserSettingsFile file = this.read(true);
        if (!StringUtils.isBlank((String)login)) {
            return file.userSettings.get(login) != null ? file.userSettings.get(login) : new UserSettings();
        }
        return null;
    }

    public String getLangForUser(String login) {
        String lang = UserSettings.DEFAULT_LANG;
        try {
            UserSettings userSettings = this.getForUserUnsafe(login);
            if (userSettings != null && !Strings.isNullOrEmpty((String)userSettings.uiLanguage)) {
                lang = userSettings.uiLanguage;
            }
        }
        catch (IOException e) {
            logger.error((Object)("Cannot retrieve lang preference for user " + login));
        }
        return lang;
    }

    public boolean hasUserSettings(String login) throws IOException {
        if (!StringUtils.isBlank((String)login)) {
            UserSettingsFile file = this.read(false);
            return file.userSettings.get(login) != null;
        }
        return false;
    }

    public Map<String, UserSettings> getForAllUsers() throws IOException {
        UserSettingsFile file = this.read(false);
        if (file.userSettings != null) {
            return file.userSettings;
        }
        return new HashMap<String, UserSettings>();
    }

    public Map<String, UserSettings> getForUsers(Collection<String> logins) throws IOException {
        if (logins.isEmpty()) {
            return new HashMap<String, UserSettings>();
        }
        UserSettingsFile file = this.read(false);
        return logins.stream().collect(Collectors.toMap(Function.identity(), l -> file.userSettings != null && file.userSettings.containsKey(l) ? file.userSettings.get(l) : new UserSettings()));
    }

    public void deleteUser(String login) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        UserSettingsFile file = this.read(false);
        file.userSettings.remove(login);
        this.write(tr, file);
    }

    public void setSmartHomePage(UserPersonalHomePagesSettings homePagesSettings, LimitsStatusComputer.LicensedProfile profile, AuthCtx authCtx) throws Exception {
        boolean hasProjectReadAccess;
        boolean isDesigner;
        boolean isNone = "NONE".equals(profile.profile);
        boolean bl = isDesigner = profile.mayAdmin || profile.mayWriteProjectContent;
        homePagesSettings.page = isNone || isDesigner ? "home" : ((hasProjectReadAccess = this.projectsService.anyAccessibleUnsafe(authCtx, Privileges.ProjectLevelPrivilegeType.READ_CONF)) ? "home" : "workspaces.home");
    }

    public void dismissWhatsNewPopover(AuthCtx user, String popoverId) throws IOException {
        if (user.getIdentifier() == null) {
            return;
        }
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        UserSettingsFile file = this.read(false);
        UserSettings userSettings = file.userSettings.computeIfAbsent(user.getIdentifier(), k -> new UserSettings());
        userSettings.customDisplaySettings.dismissedPopovers.add(popoverId);
        this.write(tr, file);
    }

    public List<String> toggleUserPinnedConnectionType(AuthCtx user, String connectionType) throws IOException {
        if (user.getIdentifier() == null) {
            return new ArrayList<String>();
        }
        UserSettingsFile file = this.read(false);
        UserSettings userSettings = file.userSettings.computeIfAbsent(user.getIdentifier(), k -> new UserSettings());
        Object commitText = "";
        if (userSettings.pinnedConnectionTypes.contains(connectionType)) {
            userSettings.pinnedConnectionTypes.remove(connectionType);
            commitText = "Removed pinned connection type " + connectionType;
        } else {
            userSettings.pinnedConnectionTypes.add(connectionType);
            commitText = "Added pinned connection type " + connectionType;
        }
        RWTransaction tr = (RWTransaction)TransactionContext.retrieveWrite();
        this.write((RWTransactionRef)tr, file);
        tr.commit((String)commitText);
        return userSettings.pinnedConnectionTypes;
    }

    public List<String> getUserPinnedConnectionTypes(AuthCtx user) throws IOException {
        if (user.getIdentifier() == null) {
            return new ArrayList<String>();
        }
        UserSettings settings = this.getForUser(user.getIdentifier());
        return settings.pinnedConnectionTypes;
    }

    public static class UserSettingsFile {
        Map<String, UserSettings> userSettings = new HashMap<String, UserSettings>();
    }

    @UIModel
    public static class UserSettings {
        public static String DEFAULT_LANG = "en";
        public MentionEmailsSettings mentionEmails = new MentionEmailsSettings();
        public MentionEmailsSettings discussionEmails = new MentionEmailsSettings();
        public RequestAccessSettings accessRequestEmails = new RequestAccessSettings();
        public GrantedAccessSettings grantedAccessEmails = new GrantedAccessSettings();
        public GrantedPluginRequestSettings grantedPluginRequestEmails = new GrantedPluginRequestSettings();
        public PluginRequestSettings pluginRequestEmails = new PluginRequestSettings();
        public EmailNotificationsSettings instanceAccessRequestsEmails = new EmailNotificationsSettings(true, "Instance access request");
        public EmailNotificationsSettings profileUpgradeRequestsEmails = new EmailNotificationsSettings(true, "Profile upgrade request");
        public CodeEnvCreationRequestSettings codeEnvCreationRequestEmails = new CodeEnvCreationRequestSettings();
        public GrantedCodeEnvCreationRequestSettings grantedCodeEnvCreationRequestEmails = new GrantedCodeEnvCreationRequestSettings();
        public ProjectManagerViewFilters projectManagerViewFilters = new ProjectManagerViewFilters();
        public FrontendNotificationsSettings frontendNotifications = new FrontendNotificationsSettings();
        public OfflineQueuesSettings offlineQueue = new OfflineQueuesSettings();
        public DigestSettings digests = new DigestSettings();
        public CodeEditorSettings codeEditor = new CodeEditorSettings();
        public DashboardSettings dashboards = new DashboardSettings();
        public FlowFilteringSettings flowFilteringSettings = new FlowFilteringSettings();
        public boolean disableFlowZoomTracking = false;
        public UserPersonalHomePagesSettings home = new UserPersonalHomePagesSettings();
        public boolean showAppInstances = false;
        public boolean alwaysShowProjectSummary = false;
        public String uiLanguage;
        public CustomDisplaySettings customDisplaySettings = new CustomDisplaySettings();
        public List<String> pinnedConnectionTypes = new ArrayList<String>();
    }

    private static class UserPersonalHomePagesSettings {
        public String page = "home";
        public String behavior = "root";
        public List<RowDescription> rows;

        private UserPersonalHomePagesSettings() {
        }
    }

    public static class CustomDisplaySettings {
        public Set<String> dismissedPopovers = new HashSet<String>();
    }

    public static class ProjectManagerViewFilters {
        public Filter filter = new Filter();
        public Display display = new Display();
        public Sort sort = new Sort();
    }

    static class Filter {
        public List<String> tags = new ArrayList<String>();
        public List<String> projectStatus = new ArrayList<String>();
        public boolean accessibleProjectsEnabled = false;
        public boolean limitedVisibilityProjectsEnabled = false;
        public List<String> contributors = new ArrayList<String>();

        Filter() {
        }
    }

    static class Display {
        String mode = ApplicationConfigurator.isAutomation() ? "list" : "mosaic";
        String listMode = ApplicationConfigurator.isAutomation() ? "scenarios" : "contributions";
        String flowLayoutEngine = "dot";
        boolean recursive = false;

        Display() {
        }
    }

    static class Sort {
        public String mode = "name";
        public boolean isReversedSort;

        Sort() {
        }
    }

    private static class RowDescription {
        public boolean visible;
        public String tileType;

        private RowDescription() {
        }
    }

    public static class MentionEmailsSettings
    extends EmailNotificationsSettings {
        public MentionEmailsSettings() {
            this.enabled = true;
        }
    }

    public static class CodeEditorSettings {
        public boolean autoCloseBrackets = true;
        public boolean autoCloseTags = true;
        public int fontSize = 13;
        public int indentUnit = 4;
        public int tabSize = 4;
        public boolean indentWithTabs = false;
        public String theme = "default";
        public String keyMap = "default";
    }

    public static class DashboardSettings {
        public boolean autoStackUp = true;
        public DashboardPageSectionSettings pageSectionSettings = DashboardPageSectionSettings.defaultSettings();
    }

    public static class GrantedCodeEnvCreationRequestSettings
    extends EmailNotificationsSettings {
        public GrantedCodeEnvCreationRequestSettings() {
            this.enabled = true;
            this.subject = "Granted code env creation request";
        }
    }

    public static class CodeEnvCreationRequestSettings
    extends EmailNotificationsSettings {
        public CodeEnvCreationRequestSettings() {
            this.enabled = true;
            this.subject = "Code env creation request";
        }
    }

    public static class PluginRequestSettings
    extends EmailNotificationsSettings {
        public PluginRequestSettings() {
            this.enabled = true;
            this.subject = "Plugin request";
        }
    }

    public static class GrantedPluginRequestSettings
    extends EmailNotificationsSettings {
        public GrantedPluginRequestSettings() {
            this.enabled = true;
            this.subject = "Granted plugin request";
        }
    }

    public static class GrantedAccessSettings
    extends EmailNotificationsSettings {
        public GrantedAccessSettings() {
            this.enabled = true;
            this.subject = "Granted access";
        }
    }

    public static class RequestAccessSettings
    extends EmailNotificationsSettings {
        public RequestAccessSettings() {
            this.enabled = true;
            this.subject = "Access request on your project";
        }
    }

    public static class DigestSettings
    extends EmailNotificationsSettings {
        public DigestSettings() {
            this.enabled = true;
            this.subject = "Dataiku DSS daily digest";
        }
    }

    public static class OfflineQueuesSettings
    extends EmailNotificationsSettings {
        public OfflineQueuesSettings() {
            this.enabled = true;
            this.subject = "Dataiku DSS activity while you are offline";
        }
    }

    public static class EmailNotificationsSettings {
        public boolean enabled = false;
        public String subject;
        public boolean sendAsHTML = true;
        public boolean isTemplatedContent = false;

        public EmailNotificationsSettings() {
        }

        private EmailNotificationsSettings(boolean enabled, String subject) {
            this.enabled = enabled;
            this.subject = subject;
        }
    }

    public static class FrontendNotificationsSettings {
        public boolean loginLogout = false;
        public boolean watchedObjectsEditions = false;
        public boolean objectOnProjectCreatedDeleted = true;
        public boolean anyObjectOnProjectEdited = false;
        public boolean watchStar = false;
        public boolean otherUsersTasks = false;
        public boolean requestAccess = true;
        public boolean scenarioRun = false;
        public boolean playSoundOnJobCompletion = false;
    }

    public static class FlowFilteringSettings {
        public Set<String> projectsWithDisabledFiltering = new HashSet<String>();
        public Map<String, String> activeFilterByProject = new HashMap<String, String>();
    }
}

