/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.analysis.model.prediction.DeepHubColumnFormat;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.shaker.filter.DisplayFilterColumn;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class BoundingBoxValueFilter
extends DisplayFilterColumn {
    private final Set<String> values;

    public BoundingBoxValueFilter(String column, String[] values) {
        this.column = column;
        this.values = Arrays.stream(values).collect(Collectors.toSet());
    }

    @Override
    public boolean filterRow(MemRow row, Column cd) {
        DeepHubColumnFormat.ObjectDetectionTargetParser parser = new DeepHubColumnFormat.ObjectDetectionTargetParser();
        String v = row.get(cd);
        List<DeepHubColumnFormat.ObjectDetectionTargetItem> boundingBoxes = parser.parse(v);
        if (CollectionUtils.isEmpty(boundingBoxes)) {
            return false;
        }
        return !boundingBoxes.stream().noneMatch(e -> this.values.contains(e.category));
    }
}

