/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.processors.cleansing.FilterAndFlagOnBadType;
import com.dataiku.dip.shaker.processors.cleansing.RemoveRowsOnEmpty;
import com.dataiku.dip.shaker.processors.expr.FilterAndFlagOnCustomFormulaResult;
import com.dataiku.dip.shaker.processors.filtering.ColumnsSelector;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnDate;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnExplicitConditions;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnNumericalRange;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnValue;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ExplorationFilterToStepsConverter {
    public List<ScriptStep> convert(ExportParams.ExplorationFiltersAndSearchQuery exportFilters) {
        ArrayList<ScriptStep> steps = new ArrayList<ScriptStep>();
        if (exportFilters != null && exportFilters.explorationFilters != null) {
            for (JsonElement filter : exportFilters.explorationFilters) {
                List<ScriptStep> validityFilterSteps;
                JsonObject validityFilter;
                String currentMode;
                JsonObject jsonFilter = filter.getAsJsonObject();
                if (!this.getPropertyAsBoolean(jsonFilter, "active", false)) continue;
                switch (currentMode = this.getMandatoryPropertyAsString(jsonFilter, "currentMode")) {
                    case "FACET": {
                        ScriptStep facetStep = this.createFacetStep(jsonFilter.getAsJsonObject("facet"));
                        if (facetStep == null) break;
                        steps.add(facetStep);
                        break;
                    }
                    case "SIMPLE_ALPHANUM": {
                        JsonObject jsonAlphanumFilter = jsonFilter.getAsJsonObject("alphanumFilter");
                        String column = this.getMandatoryPropertyAsString(jsonAlphanumFilter, "column");
                        ScriptStep alphanumStep = this.createAlphanumFilterStep(jsonAlphanumFilter, column);
                        if (alphanumStep == null) break;
                        steps.add(alphanumStep);
                    }
                }
                if ((validityFilter = jsonFilter.getAsJsonObject("validityFilter")) == null || (validityFilterSteps = this.createValidityFilterStep(validityFilter)) == null) continue;
                steps.addAll(validityFilterSteps);
            }
        }
        if (exportFilters != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)exportFilters.globalSearchQuery)) {
            steps.addAll(this.createGlobalSearchQuerySteps(exportFilters.globalSearchQuery));
        }
        return steps;
    }

    private List<ScriptStep> createGlobalSearchQuerySteps(String globalSearchQuery) {
        ArrayList<ScriptStep> result = new ArrayList<ScriptStep>();
        String query = StringNormalizationMode.LOWERCASE.apply(globalSearchQuery);
        List<Object> tokens = query.contains("\"") ? Arrays.asList(query.replace("\"", "")) : Arrays.stream(StringUtils.split((String)query, (String)" \t")).map(String::trim).collect(Collectors.toList());
        for (String string : tokens) {
            FilterAndFlagOnValue.Parameter stepParams = new FilterAndFlagOnValue.Parameter();
            stepParams.appliesTo = AppliesToProcessor.AppliesTo.ALL;
            stepParams.booleanMode = FilterAndFlagProcessor.BooleanMode.OR;
            stepParams.values = Arrays.asList(string);
            stepParams.matchingMode = StringMatchingMode.SUBSTRING;
            stepParams.normalizationMode = StringNormalizationMode.LOWERCASE;
            result.add(ProcessorScriptStep.ofType(FilterAndFlagOnValue.META_FILTER).withParams(stepParams));
        }
        return result;
    }

    private ScriptStep createFacetStep(JsonObject facetJson) {
        String currentMode = this.getPropertyAsString(facetJson, "currentMode");
        if (currentMode != null) {
            String column = this.getMandatoryPropertyAsString(facetJson, "column");
            switch (currentMode) {
                case "NUMERICAL": {
                    return this.createNumericalFilterStep(facetJson, column);
                }
                case "ALPHANUM": {
                    return this.createAlphanumFilterStep(facetJson, column);
                }
                case "DATE": {
                    return this.createDateFilterStep(facetJson, column);
                }
                case "EXPLICIT": {
                    return this.createExplicitFilterStep(facetJson);
                }
            }
        }
        return null;
    }

    private ScriptStep createDateFilterStep(JsonObject facetJson, String column) {
        FilterAndFlagOnDate.Parameter stepParams = new FilterAndFlagOnDate.Parameter();
        stepParams.columns = Arrays.asList(column);
        String dateFilterType = this.getMandatoryPropertyAsString(facetJson, "dateFilterType");
        stepParams.filterType = Enum.valueOf(FilterAndFlagOnDate.DateFilterType.class, dateFilterType);
        switch (stepParams.filterType) {
            case RANGE: {
                Long maxDate;
                stepParams.timezone_id = this.getPropertyAsString(facetJson, "timezone");
                Long minDate = this.getPropertyAsLong(facetJson, "minValue");
                if (minDate != null) {
                    stepParams.min = ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print(minDate.longValue());
                }
                if ((maxDate = this.getPropertyAsLong(facetJson, "maxValue")) != null) {
                    stepParams.max = ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print(maxDate.longValue());
                }
                stepParams.includeEmptyValues = this.getPropertyAsBoolean(facetJson, "includeEmptyValues", stepParams.min == null && stepParams.max == null);
                if (stepParams.min != null || stepParams.max != null || !stepParams.includeEmptyValues) break;
                return null;
            }
            case RELATIVE: {
                stepParams.option = this.getDateRelativeOption(facetJson);
                boolean areDateFilterOptionsEffective = stepParams.option != null && stepParams.option.isEffective();
                stepParams.includeEmptyValues = this.getPropertyAsBoolean(facetJson, "includeEmptyValues", !areDateFilterOptionsEffective);
                if (!areDateFilterOptionsEffective && stepParams.includeEmptyValues) {
                    return null;
                }
                if (!areDateFilterOptionsEffective) break;
                stepParams.part = Enum.valueOf(ChartFilter.DateFilterPart.class, this.getMandatoryPropertyAsString(facetJson, "dateFilterPart"));
                break;
            }
            case PART: {
                stepParams.part = Enum.valueOf(ChartFilter.DateFilterPart.class, this.getMandatoryPropertyAsString(facetJson, "dateFilterPart"));
                stepParams.values = ExplorationFilterToStepsConverter.getFacetSelectedValues(facetJson);
                if (stepParams.values.isEmpty()) {
                    return null;
                }
                if (stepParams.part == ChartFilter.DateFilterPart.INDIVIDUAL) {
                    stepParams.values = stepParams.values.stream().map(str -> ISODateTimeFormat.date().withZone(DateTimeZone.UTC).print(1000L * Long.parseLong(str))).collect(Collectors.toList());
                    break;
                }
                if (stepParams.part == ChartFilter.DateFilterPart.YEAR || stepParams.part == ChartFilter.DateFilterPart.HOUR_OF_DAY) break;
                stepParams.values = stepParams.values.stream().map(str -> String.valueOf(Integer.parseInt(str) + 1)).collect(Collectors.toList());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled filter type: " + String.valueOf(stepParams.filterType));
            }
        }
        return ProcessorScriptStep.ofType(FilterAndFlagOnDate.META_FILTER).withParams(stepParams);
    }

    private ScriptStep createExplicitFilterStep(JsonObject facetJson) {
        Type explicitConditionsType = new TypeToken<List<ChartFilter.ExplicitCondition>>(){}.getType();
        List explicitConditions = (List)new Gson().fromJson((JsonElement)facetJson.getAsJsonArray("explicitConditions"), explicitConditionsType);
        FilterAndFlagOnExplicitConditions.Parameter stepParams = new FilterAndFlagOnExplicitConditions.Parameter();
        stepParams.explicitConditions = explicitConditions;
        stepParams.columns = explicitConditions.stream().map(explicitCondition -> explicitCondition.column).collect(Collectors.toList());
        stepParams.appliesTo = AppliesToProcessor.AppliesTo.COLUMNS;
        stepParams.action = FilterAndFlagProcessor.Action.REMOVE_ROW;
        return ProcessorScriptStep.ofType(FilterAndFlagOnExplicitConditions.META_FILTER).withParams(stepParams);
    }

    private ChartFilter.DateRelativeOption getDateRelativeOption(JsonObject facetJson) {
        JsonElement relativeOptionEl = facetJson.get("dateFilterRelativeOption");
        if (relativeOptionEl == null || relativeOptionEl.isJsonNull()) {
            return null;
        }
        JsonObject relativeOption = relativeOptionEl.getAsJsonObject();
        ChartFilter.DateRelativeOption result = new ChartFilter.DateRelativeOption();
        result.last = ExplorationFilterToStepsConverter.getPropertyAsInt(relativeOption, "last", 0);
        result.next = ExplorationFilterToStepsConverter.getPropertyAsInt(relativeOption, "next", 0);
        result.isUntilNow = this.getPropertyAsBoolean(relativeOption, "isUntilNow", false);
        result.containsCurrentDatePart = this.getPropertyAsBoolean(relativeOption, "containsCurrentDatePart", false);
        return result;
    }

    private ProcessorScriptStep createNumericalFilterStep(JsonObject facetJson, String column) {
        FilterAndFlagOnNumericalRange.Parameter stepParams = new FilterAndFlagOnNumericalRange.Parameter();
        stepParams.columns = Arrays.asList(column);
        stepParams.min = this.getPropertyAsDouble(facetJson, "minValue");
        stepParams.max = this.getPropertyAsDouble(facetJson, "maxValue");
        stepParams.includeEmptyValues = this.getPropertyAsBoolean(facetJson, "includeEmptyValues", stepParams.min == null && stepParams.max == null);
        if (stepParams.min != null || stepParams.max != null || !stepParams.includeEmptyValues) {
            return ProcessorScriptStep.ofType(FilterAndFlagOnNumericalRange.META_FILTER).withParams(stepParams);
        }
        return null;
    }

    private ScriptStep createAlphanumFilterStep(JsonObject jsonAlphanum, String column) {
        List<String> values;
        String filterType = jsonAlphanum.get("type").getAsString();
        boolean exclude = false;
        Map<String, String> params = switch (filterType) {
            case "alphanum" -> {
                values = this.getPropertyAsStringList(jsonAlphanum, "selectedValues");
                yield this.getParams(jsonAlphanum);
            }
            case "facet" -> {
                if (ExplorationFilterToStepsConverter.checkIsAnExcludedValuesFacet(jsonAlphanum)) {
                    values = ExplorationFilterToStepsConverter.getFacetExcludedValues(jsonAlphanum);
                    exclude = true;
                } else {
                    values = ExplorationFilterToStepsConverter.getFacetSelectedValues(jsonAlphanum);
                }
                yield new HashMap<String, String>();
            }
            default -> throw new IllegalArgumentException("Unhandled filter type: " + filterType);
        };
        if (values.isEmpty()) {
            return null;
        }
        FilterAndFlagOnValue.Parameter stepParams = new FilterAndFlagOnValue.Parameter();
        stepParams.exclude = exclude;
        stepParams.columns = Arrays.asList(column);
        stepParams.values = values;
        stepParams.matchingMode = StringMatchingMode.forName(params.get("mode"), StringMatchingMode.FULL_STRING);
        stepParams.normalizationMode = StringNormalizationMode.forName(params.get("normalization"), StringNormalizationMode.EXACT);
        stepParams.processNullOrEmptyValues = true;
        return ProcessorScriptStep.ofType(FilterAndFlagOnValue.META_FILTER).withParams(stepParams);
    }

    private List<ScriptStep> createValidityFilterStep(JsonObject validityFilterJson) {
        if (!"validity".equals(this.getPropertyAsString(validityFilterJson, "type"))) {
            return null;
        }
        JsonObject params = validityFilterJson.getAsJsonObject("params");
        if (params == null || params.isJsonNull()) {
            return null;
        }
        boolean ok = this.getPropertyAsBoolean(params, "ok", false);
        boolean nok = this.getPropertyAsBoolean(params, "nok", false);
        boolean empty = this.getPropertyAsBoolean(params, "empty", false);
        if (ok && nok && empty) {
            return null;
        }
        if (!(ok || nok || empty)) {
            throw new IllegalArgumentException("All validity types excluded - not allowed");
        }
        String column = this.getPropertyAsString(validityFilterJson, "column");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)column)) {
            throw new IllegalArgumentException("Missing column in validity filter");
        }
        if (ok) {
            AppliesToProcessor.AppliesToParams stepParams;
            ArrayList<ScriptStep> steps = new ArrayList<ScriptStep>();
            if (!nok) {
                stepParams = new FilterAndFlagOnBadType.Parameter();
                stepParams.type = this.getPropertyAsString(params, "type");
                stepParams.action = FilterAndFlagProcessor.Action.REMOVE_ROW;
                stepParams.columns = Arrays.asList(column);
                steps.add(ProcessorScriptStep.ofType(FilterAndFlagOnBadType.META_FILTER).withParams(stepParams));
            }
            if (!empty) {
                stepParams = new RemoveRowsOnEmpty.Parameter();
                ((RemoveRowsOnEmpty.Parameter)stepParams).keep = false;
                ((RemoveRowsOnEmpty.Parameter)stepParams).columns = Arrays.asList(column);
                steps.add(ProcessorScriptStep.ofType(RemoveRowsOnEmpty.META).withParams(stepParams));
            }
            return steps;
        }
        if (!empty) {
            FilterAndFlagOnBadType.Parameter stepParams = new FilterAndFlagOnBadType.Parameter();
            stepParams.type = this.getPropertyAsString(params, "type");
            stepParams.action = FilterAndFlagProcessor.Action.KEEP_ROW;
            stepParams.columns = Arrays.asList(column);
            ProcessorScriptStep filterStep = ProcessorScriptStep.ofType(FilterAndFlagOnBadType.META_FILTER).withParams(stepParams);
            return Arrays.asList(filterStep);
        }
        if (!nok) {
            RemoveRowsOnEmpty.Parameter stepParams = new RemoveRowsOnEmpty.Parameter();
            stepParams.keep = true;
            stepParams.columns = Arrays.asList(column);
            ProcessorScriptStep filterStep = ProcessorScriptStep.ofType(RemoveRowsOnEmpty.META).withParams(stepParams);
            return Arrays.asList(filterStep);
        }
        FilterAndFlagOnBadType.Parameter flagStepParams = new FilterAndFlagOnBadType.Parameter();
        flagStepParams.type = this.getPropertyAsString(params, "type");
        flagStepParams.action = FilterAndFlagProcessor.Action.FLAG;
        flagStepParams.columns = Arrays.asList(column);
        flagStepParams.flagColumn = ExplorationFilterToStepsConverter.newFlagColumnName();
        ProcessorScriptStep flagStep = ProcessorScriptStep.ofType(FilterAndFlagOnBadType.META_FILTER).withParams(flagStepParams);
        FilterAndFlagOnCustomFormulaResult.Parameter stepParams = new FilterAndFlagOnCustomFormulaResult.Parameter();
        String escapedColumnName = column.replace("\\", "\\\\").replace("\"", "\\\"");
        stepParams.expression = String.format("or(strval(\"%s\") == \"\", strval(\"%s\") == \"1\")", escapedColumnName, flagStepParams.flagColumn);
        ProcessorScriptStep filterStep = ProcessorScriptStep.ofType(FilterAndFlagOnCustomFormulaResult.META_FILTER).withParams(stepParams);
        ColumnsSelector.Parameter colRmStepParams = new ColumnsSelector.Parameter();
        colRmStepParams.keep = false;
        colRmStepParams.columns = Arrays.asList(flagStepParams.flagColumn);
        ProcessorScriptStep removeTempColumnStep = ProcessorScriptStep.ofType(ColumnsSelector.META).withParams(colRmStepParams);
        return Arrays.asList(flagStep, filterStep, removeTempColumnStep);
    }

    private Map<String, String> getParams(JsonObject jsonFacet) {
        HashMap<String, String> params = new HashMap<String, String>();
        JsonObject jsonParams = jsonFacet.getAsJsonObject("params");
        if (jsonParams != null) {
            for (Map.Entry entry : jsonParams.entrySet()) {
                String value = ((JsonElement)entry.getValue()).getAsString();
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) continue;
                params.put((String)entry.getKey(), value);
            }
        }
        return params;
    }

    private static boolean checkIsAnExcludedValuesFacet(JsonObject jsonFacet) {
        if (jsonFacet.has("selectedValues")) {
            return false;
        }
        return jsonFacet.has("excludedValues");
    }

    private static List<String> getFacetSelectedValues(JsonObject jsonFacet) {
        return ExplorationFilterToStepsConverter.getFacetValues(jsonFacet, "selectedValues");
    }

    private static List<String> getFacetExcludedValues(JsonObject jsonFacet) {
        return ExplorationFilterToStepsConverter.getFacetValues(jsonFacet, "excludedValues");
    }

    private static List<String> getFacetValues(JsonObject jsonFacet, String valuesMemberName) {
        JsonElement jsonExcludedValues = jsonFacet.get(valuesMemberName);
        if (jsonExcludedValues != null) {
            return jsonExcludedValues.getAsJsonObject().entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).getAsBoolean()).map(entry -> ((String)entry.getKey()).replace("___dku_no_value___", "")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private static int getPropertyAsInt(JsonObject facetJson, String propertyName, int defaultValue) {
        JsonElement value = facetJson.get(propertyName);
        if (value == null || value.isJsonNull()) {
            return defaultValue;
        }
        return value.getAsInt();
    }

    private String getMandatoryPropertyAsString(JsonObject facetJson, String propertyName) {
        String part = this.getPropertyAsString(facetJson, propertyName);
        if (part == null) {
            throw new IllegalArgumentException(String.format("Missing '%s' mandatory property", propertyName));
        }
        return part;
    }

    private String getPropertyAsString(JsonObject facetJson, String propertyName) {
        JsonElement value = facetJson.get(propertyName);
        if (value == null || value.isJsonNull()) {
            return null;
        }
        return value.getAsString();
    }

    private boolean getPropertyAsBoolean(JsonObject facetJson, String propertyName, boolean defaultValue) {
        JsonElement value = facetJson.get(propertyName);
        if (value == null || value.isJsonNull()) {
            return defaultValue;
        }
        return value.getAsBoolean();
    }

    private Long getPropertyAsLong(JsonObject facetJson, String propertyName) {
        JsonElement value = facetJson.get(propertyName);
        if (value == null || value.isJsonNull()) {
            return null;
        }
        return value.getAsLong();
    }

    private long getPropertyAsLong(JsonObject facetJson, String propertyName, long defaultValue) {
        Long result = this.getPropertyAsLong(facetJson, propertyName);
        return result == null ? defaultValue : result;
    }

    private Double getPropertyAsDouble(JsonObject facetJson, String propertyName) {
        JsonElement value = facetJson.get(propertyName);
        if (value == null || value.isJsonNull()) {
            return null;
        }
        return value.getAsDouble();
    }

    private List<String> getPropertyAsStringList(JsonObject jsonAlphanumFilter, String propertyName) {
        ArrayList<String> result = new ArrayList<String>();
        JsonArray jsonSelectedValues = jsonAlphanumFilter.getAsJsonArray(propertyName);
        if (jsonSelectedValues != null) {
            jsonSelectedValues.forEach(v -> result.add(v.getAsString()));
        }
        return result;
    }

    private static String newFlagColumnName() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

