/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.filter.DisplayFilter;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class GlobalSearchFilter
implements DisplayFilter {
    private StringMatchingMode matchingMode;
    private StringNormalizationMode normalizationMode;
    private Pattern compiled;
    private List<String> tokens = new ArrayList<String>();

    public GlobalSearchFilter(String query, StringMatchingMode mode, StringNormalizationMode normalizationMode) {
        this.matchingMode = mode;
        this.normalizationMode = normalizationMode;
        query = normalizationMode.apply(query);
        if (mode == StringMatchingMode.PATTERN) {
            this.compiled = Pattern.compile(query);
            this.tokens.add(query);
        } else if (query.contains("\"")) {
            this.tokens.add(query.replace("\"", ""));
        } else {
            for (String tok : StringUtils.split((String)query, (String)" \t")) {
                this.tokens.add(tok.trim());
            }
        }
    }

    @Override
    public void filter(MemTable table, boolean[] filters) {
        boolean[] match = new boolean[this.tokens.size()];
        for (int i = 0; i < table.rows.size(); ++i) {
            for (int k = 0; k < match.length; ++k) {
                match[k] = false;
            }
            for (MemColumn mc : table.columnsList) {
                String v = table.rows.get(i).get(mc);
                if (v != null && !v.isEmpty()) {
                    v = this.normalizationMode.apply(v);
                    block8: for (int k = 0; k < match.length; ++k) {
                        switch (this.matchingMode) {
                            case FULL_STRING: {
                                int n = k;
                                match[n] = match[n] | this.tokens.get(k).equals(v);
                                continue block8;
                            }
                            case SUBSTRING: {
                                int n = k;
                                match[n] = match[n] | v.contains(this.tokens.get(k));
                                continue block8;
                            }
                            case PATTERN: {
                                int n = k;
                                match[n] = match[n] | this.compiled.matcher(v).find();
                            }
                        }
                    }
                }
                if (GlobalSearchFilter.countTrue(match) != match.length) continue;
                break;
            }
            filters[i] = filters[i] && GlobalSearchFilter.countTrue(match) == match.length;
        }
    }

    private static int countTrue(boolean[] array) {
        int ret = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            ++ret;
        }
        return ret;
    }
}

