/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalysis;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalyzer;
import com.dataiku.dip.shaker.filter.Faceter;
import com.dataiku.dip.shaker.filter.FilterRequest;
import java.util.ArrayList;

public class NumericalFaceter
extends Faceter {
    private NumericalVariableAnalyzer analyzer = new NumericalVariableAnalyzer(10);

    public NumericalFaceter(String column) {
        this.column = column;
    }

    @Override
    protected void observe(MemTable table, Column cd, boolean[] filters) {
        this.analyzer.analyse(table, cd.getName(), filters);
        this.analyzer.niceBounds = false;
        this.analyzer.compute();
    }

    @Override
    public FilterFacet compute() {
        FilterFacet ret = new FilterFacet();
        ret.column = this.column;
        ret.type = FilterRequest.FilterType.NUMERICAL_FACET;
        ret.histogramBars = new ArrayList<FilterFacet.HistogramBar>();
        NumericalVariableAnalysis analysis = this.analyzer.getOut();
        if (analysis == null || analysis.histogramLowerBounds == null) {
            ret.minValue = 0.0;
            ret.maxValue = 0.0;
            return ret;
        }
        ret.minValue = analysis.min;
        ret.maxValue = analysis.max;
        for (int i = 0; i < analysis.histogramLowerBounds.length; ++i) {
            FilterFacet.HistogramBar hb = new FilterFacet.HistogramBar();
            hb.minValue = analysis.histogramLowerBounds[i];
            hb.maxValue = analysis.histogramUpperBounds[i];
            hb.count = analysis.histogram[i];
            ret.histogramBars.add(hb);
        }
        return ret;
    }
}

