/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.shaker.mrimpl.models.ContextType;
import com.dataiku.dip.shaker.mrimpl.models.SerializedThrowableWithContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DiagnosticsHandler {
    public static final String WARNINGS_CONTEXT_DIR = "dku.shaker.warnings";
    private static final DKULogger logger = DKULogger.getLogger(DiagnosticsHandler.class);

    public static void setWarningsContextDirectory(Configuration jobConf, Path dir) {
        Preconditions.checkNotNull((Object)dir);
        jobConf.set(WARNINGS_CONTEXT_DIR, dir.toString());
    }

    public static Path getWarningsContextDirectory(Configuration jobConf) {
        String val = jobConf.get(WARNINGS_CONTEXT_DIR);
        if (!StringUtils.isBlank((String)val)) {
            return new Path(val);
        }
        return null;
    }

    private static <T> void writeObject(FileSystem fs, Path path, T obj) throws IOException {
        if (!fs.isDirectory(path.getParent())) {
            fs.mkdirs(path.getParent());
        }
        try (FSDataOutputStream fileOut = fs.create(path);){
            byte[] content = JSON.prettyAsFile(obj).getBytes(StandardCharsets.UTF_8);
            fileOut.write(content);
        }
    }

    private static <T> T readObject(FileSystem fs, Path path, Class<T> clazz) throws IOException {
        FileStatus status = fs.getFileStatus(path);
        if (status.isFile()) {
            try (FSDataInputStream inputStream = fs.open(path);){
                byte[] content = new byte[(int)status.getLen()];
                inputStream.readFully(content);
                String strContent = new String(content, StandardCharsets.UTF_8);
                Object object = JSON.parse((String)strContent, clazz);
                return (T)object;
            }
        }
        throw new IOException("Not a HDFS file: " + String.valueOf(path));
    }

    public static void saveFatalError(ContextType type, Throwable t, TaskAttemptContext taskAttemptContext) throws IOException {
        logger.error((Object)("Caught a fatal exception : [" + t.getClass().getSimpleName() + "] " + t.getMessage()));
        try {
            SerializedThrowableWithContext stwc = new SerializedThrowableWithContext(type, taskAttemptContext, t);
            Configuration conf = taskAttemptContext.getConfiguration();
            String taskId = taskAttemptContext.getTaskAttemptID().toString();
            Path warningsDir = DiagnosticsHandler.getWarningsContextDirectory(conf);
            if (warningsDir != null) {
                String thisFilename;
                Path errorFilePath;
                FileSystem fs = warningsDir.getFileSystem(conf);
                int cnt = 0;
                while (fs.isFile(errorFilePath = new Path(warningsDir, thisFilename = "." + type.getId() + "_" + taskId + "_" + cnt + ".error"))) {
                    ++cnt;
                }
                DiagnosticsHandler.writeObject(fs, errorFilePath, stwc);
            } else {
                logger.warn((Object)("[" + type.getId() + "] Warning output directory is not defined"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("[" + type.getId() + "] Error when trying to store errors"), (Throwable)e);
        }
    }

    public static void saveWarningsContext(ContextType type, TaskAttemptContext taskAttemptContext, WarningsContext warningsContext) throws IOException {
        block5: {
            warningsContext.flushLogging();
            if (warningsContext.getTotalCount() > 0) {
                logger.info((Object)("[" + type.getId() + "] Saving warnings context for task attempt: " + String.valueOf(taskAttemptContext.getTaskAttemptID())));
                try {
                    Configuration conf = taskAttemptContext.getConfiguration();
                    String taskId = taskAttemptContext.getTaskAttemptID().toString();
                    WarningsContext.SerializedWarnings serializedWarnings = warningsContext.getOutput();
                    Path warningsDir = DiagnosticsHandler.getWarningsContextDirectory(conf);
                    if (warningsDir != null) {
                        FileSystem fs = warningsDir.getFileSystem(conf);
                        String thisFilename = "." + type.getId() + "_" + taskId + ".warn";
                        Path warningFilePath = new Path(warningsDir, thisFilename);
                        DiagnosticsHandler.writeObject(fs, warningFilePath, serializedWarnings);
                        logger.info((Object)("[" + type.getId() + "] Wrote output warnings into " + String.valueOf(warningFilePath)));
                        break block5;
                    }
                    logger.warn((Object)("[" + type.getId() + "] Warning output directory is not defined"));
                }
                catch (Exception e) {
                    logger.error((Object)("[" + type.getId() + "] Error when trying to store warnings"), (Throwable)e);
                }
            } else {
                logger.info((Object)("[" + type.getId() + "] No warning issued"));
            }
        }
    }

    public static WarningsContext extractMergedWarnings(String rootPathURI, List<SimpleKeyValue> fsExtraConf, Path warningsDirectory) throws IOException {
        WarningsContext wc = new WarningsContext();
        FileSystem fs = HadoopLoader.getFS(rootPathURI, fsExtraConf);
        if (fs.isDirectory(warningsDirectory)) {
            for (FileStatus fileStatus : fs.listStatus(warningsDirectory)) {
                if (fileStatus.isDirectory() || !fileStatus.getPath().getName().endsWith(".warn")) continue;
                logger.info((Object)("Found a warning file : " + String.valueOf(fileStatus.getPath())));
                WarningsContext.SerializedWarnings serializedWarnings = DiagnosticsHandler.readObject(fs, fileStatus.getPath(), WarningsContext.SerializedWarnings.class);
                wc.merge(serializedWarnings);
                fs.delete(fileStatus.getPath(), false);
            }
        } else {
            logger.warn((Object)("The HDFS path " + String.valueOf(warningsDirectory) + " should be a directory ! "));
        }
        return wc;
    }

    public static List<SerializedThrowableWithContext> extractErrors(String rootPathURI, List<SimpleKeyValue> fsExtraConf, Path warningsDirectory) throws IOException {
        ArrayList<SerializedThrowableWithContext> sts = new ArrayList<SerializedThrowableWithContext>();
        FileSystem fs = HadoopLoader.getFS(rootPathURI, fsExtraConf);
        if (fs.isDirectory(warningsDirectory)) {
            for (FileStatus fileStatus : fs.listStatus(warningsDirectory)) {
                if (fileStatus.isDirectory() || !fileStatus.getPath().getName().endsWith(".error")) continue;
                logger.info((Object)("Found an error file : " + String.valueOf(fileStatus.getPath())));
                SerializedThrowableWithContext stwc = DiagnosticsHandler.readObject(fs, fileStatus.getPath(), SerializedThrowableWithContext.class);
                sts.add(stwc);
                fs.delete(fileStatus.getPath(), false);
            }
        } else {
            logger.warn((Object)("The HDFS path " + String.valueOf(warningsDirectory) + " should be a directory ! "));
        }
        return sts;
    }
}

