/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.input.formats.parquet.DSSParquetInputFormat;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class ParquetInputFormatAdapter
extends FileInputFormat<Void, RowWithFactories> {
    private final ColumnFactory columnFactory;
    private final RowFactory rowFactory;
    private final DSSParquetInputFormat inputFormat;
    private final WarningsContext warningsContext;

    public ParquetInputFormatAdapter(ColumnFactory cf, RowFactory rf, DatasetConfig inputConf, WarningsContext warningsContext) {
        ParquetFormatConfig parquetConfig = (ParquetFormatConfig)inputConf.dataset.getFormatParams();
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
        this.rowFactory = rf;
        this.columnFactory = cf;
        this.inputFormat = new DSSParquetInputFormat(this.columnFactory, this.rowFactory, parquetConfig.representsNullFields, parquetConfig.parquetFlavor, inputConf.dataset.getSchema(), parquetConfig.readTemporalMode);
    }

    public RecordReader<Void, RowWithFactories> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        RecordReader<Void, Row> parquetReader = this.inputFormat.createRecordReader(inputSplit, taskAttemptContext);
        return new InternalReader(parquetReader);
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        return this.inputFormat.getSplits(job);
    }

    private class InternalReader
    extends RecordReader<Void, RowWithFactories> {
        private final RecordReader<Void, Row> recordReader;

        public InternalReader(RecordReader<Void, Row> recordReader) throws IOException, InterruptedException {
            this.recordReader = recordReader;
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.recordReader.initialize(inputSplit, taskAttemptContext);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.recordReader.nextKeyValue();
        }

        public Void getCurrentKey() throws IOException, InterruptedException {
            return (Void)this.recordReader.getCurrentKey();
        }

        public RowWithFactories getCurrentValue() throws IOException, InterruptedException {
            return new RowWithFactories(ParquetInputFormatAdapter.this.columnFactory, ParquetInputFormatAdapter.this.rowFactory, (Row)this.recordReader.getCurrentValue());
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.recordReader.getProgress();
        }

        public void close() throws IOException {
            this.recordReader.close();
        }
    }
}

