/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.bigdata;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.FastSafePatternMatcher;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;

public class GenerateBigData
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<GenerateBigData, Parameter> META = new ProcessorMeta<GenerateBigData, Parameter>(){

        @Override
        public String getName() {
            return "GenerateBigData";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC, ProcessorTag.RESHAPING});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.GenerateBigData.HELP", "This processor generates Big Data out of small data.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.GenerateBigData.DESCRIPTION", 1.actionVerb("Generate") + " Big Data")).withBoundedMandInt("expansionFactor", this.translate(language, "SHAKER.PROCESSOR.GenerateBigData.DESCRIPTION.EXPANSION_FACTOR", "Expansion Factor"), 1, 1000000);
        }

        @Override
        public GenerateBigData build(Parameter parameter) {
            return new GenerateBigData(parameter.expansionFactor);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            return previousRecipeLineage;
        }
    };
    private static final FastSafePatternMatcher NUMBER_MATCHER = new FastSafePatternMatcher("[0-9]+");
    private static final FastSafePatternMatcher WORD_MATCHER = new FastSafePatternMatcher("\\b[A-Za-z0-9-]+\\b");
    private static final Random RANDOM = new Random();
    private final int expansionFactor;
    private final ColumnTrackers stringTrackers = new ColumnTrackers();
    private final ColumnTrackers intTrackers = new ColumnTrackers();
    private List<Column> columns;

    public GenerateBigData(int expansionFactor) {
        this.expansionFactor = expansionFactor;
    }

    public void init() throws Exception {
    }

    public String turnNumbers(String column, String value) {
        if (value == null) {
            return null;
        }
        Matcher m = NUMBER_MATCHER.getMatcher(value);
        StringBuffer buffer = new StringBuffer();
        ColumnTracker tracker = this.intTrackers.get(column);
        int pos = 0;
        while (m.find()) {
            int length = m.end() - m.start();
            if (length <= 4) {
                m.appendReplacement(buffer, tracker.getRandomPick(m.group(), pos));
            } else {
                m.appendReplacement(buffer, Integer.toString(RANDOM.nextInt((int)Math.pow(10.0, length))));
            }
            ++pos;
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    public String turnWords(String column, String value) {
        if (value == null) {
            return null;
        }
        ColumnTracker tracker = this.stringTrackers.get(column);
        Matcher m = WORD_MATCHER.getMatcher(value);
        StringBuffer buffer = new StringBuffer();
        int pos = 0;
        while (m.find()) {
            String word = m.group();
            String replacement = tracker.getRandomPick(word, pos);
            ++pos;
            m.appendReplacement(buffer, replacement);
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    public String transformValue(String column, String value) {
        value = this.turnNumbers(column, value);
        value = this.turnWords(column, value);
        return value;
    }

    public void processRow(Row row) throws Exception {
        this.getProcessorOutput().emitRow(row);
        List<Column> columns = this.getColumns();
        for (int i = 0; i < this.expansionFactor - 1; ++i) {
            Row nr = this.getRf().row();
            for (Column c2 : columns) {
                String value = row.get(c2);
                nr.put(c2, this.transformValue(c2.getName(), value));
            }
            this.getProcessorOutput().emitRow(nr);
        }
    }

    public void postProcess() throws Exception {
        this.getProcessorOutput().lastRowEmitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Column> getColumns() {
        if (this.columns == null) {
            GenerateBigData generateBigData = this;
            synchronized (generateBigData) {
                this.columns = new ArrayList<Column>();
                for (Column c2 : this.getCf().columns()) {
                    this.columns.add(c2);
                }
            }
        }
        return this.columns;
    }

    private static class ColumnTrackers
    extends ThreadLocal<HashMap<String, ColumnTracker>> {
        private ColumnTrackers() {
        }

        @Override
        public HashMap<String, ColumnTracker> get() {
            HashMap t = (HashMap)super.get();
            if (t == null) {
                t = new HashMap();
                super.set(t);
            }
            return t;
        }

        public ColumnTracker get(String column) {
            ColumnTracker tracker = (ColumnTracker)((HashMap)this.get()).get(column);
            if (tracker == null) {
                tracker = new ColumnTracker();
                ((HashMap)this.get()).put(column, tracker);
            }
            return tracker;
        }
    }

    private static class ColumnTracker {
        ArrayList<ArrayList<String>> positions = new ArrayList();

        private ColumnTracker() {
        }

        protected String getRandomPick(String previousValue, int position) {
            while (position >= this.positions.size()) {
                this.positions.add(new ArrayList());
            }
            List possibles = this.positions.get(position);
            String n = possibles.size() == 0 ? previousValue : (String)possibles.get(RANDOM.nextInt(possibles.size()));
            if (possibles.size() < 10 || RANDOM.nextBoolean()) {
                possibles.add(previousValue);
                if (possibles.size() > 10) {
                    possibles.remove(RANDOM.nextInt(possibles.size()));
                }
            }
            return n;
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public int expansionFactor;

        public void validate() throws IllegalArgumentException {
        }
    }
}

