/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.shaker.processors.geo.Geocoder;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.StatusLine;
import com.dataiku.dss.shadelib.org.apache.http.client.HttpClient;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.InputStreamEntity;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GeocoderBing
extends Geocoder {
    final int posId = 0;
    final int posQuery = 1;
    final int posLat = 2;
    final int posLon = 3;
    HttpClient client;

    private GeocoderBing() {
    }

    public static GeocoderBing getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    protected int getLimit() {
        return 15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createJob(LinkedHashSet<String> queries) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("Bing Spatial Data Services, 2.0\n");
        sb.append("Id,GeocodeRequest/Query,GeocodeResponse/Point/Latitude,GeocodeResponse/Point/Longitude\n");
        int i = 0;
        for (String q : queries) {
            sb.append(i + ",\"" + q + "\",,\n");
            ++i;
        }
        String csvQueries = sb.toString();
        String contentType = "text/plain; charset=UTF8";
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme("http").setHost("spatial.virtualearth.net").setPath("/REST/v1/dataflows/geocode").addParameter("input", "csv").addParameter("key", this.apiKey);
        URI uri = uriBuilder.build();
        logger.debug((Object)("URI bing job creation: " + uri.toString()));
        HttpPost httppost = new HttpPost(uri);
        logger.debug((Object)("QUERY " + csvQueries));
        ByteArrayInputStream batchStream = new ByteArrayInputStream(csvQueries.getBytes(StandardCharsets.UTF_8));
        InputStreamEntity batchFile = new InputStreamEntity((InputStream)batchStream, -1L);
        httppost.setEntity((HttpEntity)batchFile);
        httppost.setHeader("Content-Type", contentType);
        HttpResponse response = this.client.execute((HttpUriRequest)httppost);
        try {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 201) {
                if (statusLine.getStatusCode() == 503) {
                    throw new Exception("Bing API error: " + statusLine.getStatusCode() + ": " + statusLine.getReasonPhrase() + ". Number of pending geocode dataflow jobs is exceeded.");
                }
                throw new Exception("Bing API error: " + statusLine.getStatusCode() + ": " + statusLine.getReasonPhrase() + ": " + new String(IOUtils.toByteArray((InputStream)response.getEntity().getContent()), "utf8"));
            }
            logger.info((Object)"Bing job created successfully");
            Header[] dataflowJobLocation = response.getHeaders("Location");
            if (dataflowJobLocation == null) {
                throw new Exception("The 'Location' header is missing from the HTTP response when creating a geocode job.");
            }
            String string = dataflowJobLocation[0].getValue();
            return string;
        }
        finally {
            httppost.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadDetails checkStatus(String dataflowJobLocation) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        DownloadDetails statusDetails = new DownloadDetails();
        statusDetails.jobStatus = "Pending";
        URI uri = new URI(dataflowJobLocation + "?key=" + this.apiKey + "&output=json");
        HttpGet httpget = new HttpGet(uri);
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpget);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                DownloadDetails downloadDetails = null;
                return downloadDetails;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                logger.error((Object)"Bing API error : empty response");
                DownloadDetails downloadDetails = null;
                return downloadDetails;
            }
            InputStreamReader reader = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8);
            String read = IOUtils.toString((Reader)reader);
            JSONObject json = new JSONObject(read);
            statusDetails.jobStatus = json.getString("statusDescription");
            JSONArray links = json.getJSONArray("resourceSets").getJSONObject(0).getJSONArray("resources").getJSONObject(0).getJSONArray("links");
            for (int i = 0; i < links.length(); ++i) {
                if (links.getJSONObject(i).getString("role").equals("output") && links.getJSONObject(i).getString("name").equals("succeeded")) {
                    statusDetails.succeededlink = links.getJSONObject(i).getString("url");
                }
                if (!links.getJSONObject(i).getString("role").equals("output") || !links.getJSONObject(i).getString("name").equals("failed")) continue;
                statusDetails.failedlink = links.getJSONObject(i).getString("url");
            }
            DownloadDetails downloadDetails = statusDetails;
            return downloadDetails;
        }
        finally {
            httpget.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Geocoder.Coord> fetchResults(DownloadDetails dd, int size) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        URI uri = new URI(dd.succeededlink + "?key=" + this.apiKey);
        logger.info((Object)("URI fetch results:" + uri.toString()));
        HttpGet httpget = new HttpGet(uri);
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpget);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new Exception("An HTTP error status code was encountered when checking job status.");
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                logger.error((Object)"Bing API error : empty response");
                List<Geocoder.Coord> list = null;
                return list;
            }
            InputStreamLineReader isReader = new InputStreamLineReader(entity.getContent(), "utf-8");
            RFC4180CSVParser reader = new RFC4180CSVParser((LineReader)isReader, ',');
            ArrayList<String> line = new ArrayList<String>();
            Geocoder.Coord[] res = new Geocoder.Coord[size];
            reader.next(line);
            reader.next(line);
            while (reader.next(line)) {
                Geocoder.Coord c2;
                logger.info((Object)("LINE " + JSON.log(line)));
                res[Integer.parseInt((String)((String)line.get((int)0)))] = c2 = new Geocoder.Coord(Double.parseDouble((String)line.get(2)), Double.parseDouble((String)line.get(3)), null);
            }
            for (int i = 0; i < size; ++i) {
                if (res[i] != null) continue;
                res[i] = new Geocoder.Coord();
            }
            List<Geocoder.Coord> list = Arrays.asList(res);
            return list;
        }
        finally {
            httpget.releaseConnection();
        }
    }

    @Override
    public List<Geocoder.Coord> callAPI(LinkedHashSet<String> queries) throws Exception {
        if (this.client == null) {
            DefaultHttpClient defaultClient = new DefaultHttpClient();
            defaultClient.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
            this.client = defaultClient;
        }
        logger.info((Object)("MapQuest geocoding API call for a batch of " + queries.size() + " queries."));
        List<Geocoder.Coord> res = null;
        String url = this.createJob(queries);
        logger.info((Object)("Url bing job status : " + url));
        DownloadDetails dd = this.checkStatus(url);
        while (dd == null || dd.succeededlink == null && dd.failedlink == null) {
            logger.info((Object)"Checking status ...");
            DKUtils.unsafeSleep((long)1000L);
            dd = this.checkStatus(url);
            logger.info((Object)("STATUS " + JSON.log((Object)dd)));
        }
        if (dd.jobStatus.equals("Aborted")) {
            logger.error((Object)"Job has been aborted");
        }
        res = this.fetchResults(dd, queries.size());
        this.fillCache(queries, res);
        return res;
    }

    private static class SingletonHolder {
        private static final GeocoderBing instance = new GeocoderBing();

        private SingletonHolder() {
        }
    }

    static class DownloadDetails {
        public String jobStatus;
        public String succeededlink;
        public String failedlink;

        DownloadDetails() {
        }
    }
}

