/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.join;

import com.BoxOfC.LevenshteinAutomaton.LevenshteinAutomaton;
import com.BoxOfC.MDAG.MDAG;
import com.dataiku.dip.shaker.processors.join.FuzzySearchEngine;
import com.dataiku.dip.shaker.processors.join.MemoryEquiJoiner;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutomatonSearchEngine
extends FuzzySearchEngine {
    private int cacheHitCount = 0;
    private List<String> fuzzyWords = new ArrayList<String>();
    private MDAG fuzzyMDAG;
    private Map<String, String> simplificationDict = new HashMap<String, String>();
    private Cache<String, String> cache = CacheBuilder.newBuilder().maximumSize(1000L).softValues().build();
    private static Logger logger = Logger.getLogger((String)"dku.shaker.fuzzy_join");

    public AutomatonSearchEngine(MemoryEquiJoiner.Parameter params) {
        super(params);
    }

    @Override
    public void populate(String w) {
        String simplified = this.simplify(w);
        this.fuzzyWords.add(simplified);
        this.simplificationDict.put(simplified, w);
    }

    @Override
    public void endPopulating() {
        if (this.fuzzyWords.size() == 0) {
            logger.warn((Object)"Empty fuzzy dictionary: no fuzzy search");
            this.fuzzyWords = null;
            return;
        }
        logger.info((Object)"Fuzzy join : building automaton");
        this.fuzzyMDAG = new MDAG(this.fuzzyWords);
        this.fuzzyMDAG.simplify();
        this.fuzzyWords = null;
        logger.info((Object)"Fuzzy join : automaton built");
    }

    private String getClosest(List<String> results, String query, int threshold) {
        int minD = threshold + 1;
        String res = null;
        for (String s : results) {
            int d = LevenshteinAutomaton.computeEditDistance((String)query, (String)s);
            if (d == 0) {
                return s;
            }
            if (d >= minD) continue;
            minD = d;
            res = s;
        }
        return res;
    }

    @Override
    public String search(String s) {
        String unsimplified = this.simplificationDict.get(s = this.simplify(s));
        if (unsimplified != null) {
            return unsimplified;
        }
        if (this.fuzzyMDAG == null) {
            return null;
        }
        String cacheMatch = (String)this.cache.getIfPresent((Object)s);
        if (cacheMatch != null) {
            ++this.cacheHitCount;
            return cacheMatch;
        }
        LinkedList res = LevenshteinAutomaton.tableFuzzySearch((int)this.threshold, (String)s, (MDAG)this.fuzzyMDAG);
        if (res.size() == 0) {
            return null;
        }
        String fuzzyMatch = this.getClosest(res, s, this.threshold);
        String originalResult = this.simplificationDict.get(fuzzyMatch);
        this.cache.put((Object)s, (Object)originalResult);
        return originalResult;
    }
}

