/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Transpose
extends SingleInputSingleOutputRowProcessor
implements Processor {
    Column col;
    String column;
    public static final ProcessorMeta<Transpose, Parameter> META = new ProcessorMeta<Transpose, Parameter>(){

        @Override
        public String getName() {
            return "Transpose";
        }

        @Override
        public String getDocPage() {
            return "transpose";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.Transpose.DESCRIPTION", 1.actionVerb("Transpose") + " rows to columns")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSOR.Transpose.DESCRIPTION.COLUMN", "Transpose column"));
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.Transpose.HELP", "This processor turns rows to columns. It is limited currently to 100 rows as input (and columns as output)");
        }

        @Override
        public Transpose build(Parameter parameter) throws Exception {
            return new Transpose(parameter.column);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            RecipeLineage updatedRecipeLineage = new RecipeLineage(previousRecipeLineage);
            updatedRecipeLineage.setUncertain(true);
            return updatedRecipeLineage;
        }
    };
    Set<String> colNames = new HashSet<String>();
    ArrayList<Row> output = new ArrayList();
    ArrayList<Boolean> toOutput = new ArrayList();
    int pos = 0;
    protected List<Column> columns;

    Transpose(String column) {
        this.column = column;
    }

    public void init() throws Exception {
        this.col = this.getCf().column(this.column, Processor.ProcessorRole.INPUT_COLUMN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Column> getColumns() {
        if (this.columns == null) {
            Transpose transpose = this;
            synchronized (transpose) {
                this.columns = new ArrayList<Column>();
                for (Column c2 : this.getCf().columns()) {
                    if (c2 == this.col) continue;
                    this.columns.add(c2);
                }
            }
        }
        return this.columns;
    }

    public void processRow(Row row) throws Exception {
        int i = 0;
        if (this.pos > 100) {
            return;
        }
        String newColName = row.get(this.col);
        if (newColName == null || newColName.length() == 0) {
            newColName = Integer.toString(this.pos);
        }
        this.colNames.add(newColName);
        Column outCol = this.getCf().column(newColName, Processor.ProcessorRole.OUTPUT_COLUMN);
        for (Column c2 : this.getColumns()) {
            Row r;
            if (i >= this.output.size()) {
                r = this.getRf().row();
                r.put(this.col, c2.getName());
                this.output.add(r);
                this.toOutput.add(false);
            }
            r = this.output.get(i);
            String value = row.get(c2);
            if (value != null && value.length() > 0) {
                r.put(outCol, value);
                this.toOutput.set(i, true);
            }
            ++i;
        }
        row.delete();
        ++this.pos;
    }

    public void postProcess() throws Exception {
        for (Column col : this.getColumns()) {
            if (this.colNames.contains(col.getName())) continue;
            this.getCf().deleteColumn(col.getName());
        }
        int i = 0;
        for (Row r : this.output) {
            if (this.toOutput.get(i).booleanValue()) {
                this.getProcessorOutput().emitRow(r);
            }
            ++i;
        }
        this.getProcessorOutput().lastRowEmitted();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;

        public void validate() throws IllegalArgumentException {
        }
    }
}

