/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.HashSet;
import java.util.Set;

abstract class UnfoldProcessor
extends SingleRowProcessor
implements Processor {
    Set<String> createdColumns = new HashSet<String>();
    static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.json");

    UnfoldProcessor() {
    }

    void enrichCreatedColumns(Iterable<String> observations, UnfoldParameter parameter) throws Exception {
        if (parameter.overflowAction == OverflowAction.KEEP) {
            return;
        }
        for (String observation : observations) {
            if (!this.enrichCreatedColumns(observation, parameter)) break;
        }
    }

    boolean enrichCreatedColumns(String observation, UnfoldParameter parameter) throws Exception {
        if (parameter.overflowAction == OverflowAction.KEEP || this.createdColumns.contains(observation)) {
            return true;
        }
        if (this.createdColumns.size() >= parameter.limit) {
            if (parameter.overflowAction == OverflowAction.CLIP) {
                return false;
            }
            if (parameter.overflowAction == OverflowAction.WARNING) {
                this.warningsContext.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_NBCOLS, "Too many columns are being created", logger);
            }
            if (parameter.overflowAction == OverflowAction.ERROR) {
                throw new TooManyColumnsException(parameter.limit);
            }
        }
        this.createdColumns.add(observation);
        return true;
    }

    static ProcessorDesc addColumnLimitationsDesc(String language, ProcessorDesc processorDesc) {
        TranslationService sts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return processorDesc.withParam(ParamDesc.advancedSelect("overflowAction", sts.translateNoContext(language, "SHAKER.PROCESSOR.UnfoldProcessor.DESCRIPTION.OVERFLOW_ACTION", "Overflow action", new Object[0]), sts.translateNoContext(language, "SHAKER.PROCESSOR.UnfoldProcessor.DESCRIPTION.OVERFLOW_BEHAVIOR", "Behavior when max nb. columns is reached", new Object[0]), OverflowAction.class).withDefaultValue(OverflowAction.ERROR)).withUnboundedMandInt("limit", sts.translateNoContext(language, "SHAKER.PROCESSOR.UnfoldProcessor.DESCRIPTION.OVERFLOW_LIMIT", "Max nb. columns to create", new Object[0]));
    }

    static abstract class UnfoldParameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        OverflowAction overflowAction = OverflowAction.ERROR;
        int limit = 100;

        UnfoldParameter() {
        }
    }

    public static enum OverflowAction implements Labelled
    {
        KEEP("Keep all columns"),
        WARNING("Add warnings"),
        ERROR("Raise an error"),
        CLIP("Clip further data");

        private final String label;

        private OverflowAction(String label) {
            this.label = label;
        }

        @Override
        public String getLabel() {
            return this.label;
        }
    }

    static class TooManyColumnsException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -1L;

        TooManyColumnsException(int limit) {
            super("Too many columns are being created. The maximum number of columns that can be created is " + limit + ".");
        }
    }
}

