/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.transform.FindReplace;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ColumnRenamer
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<ColumnRenamer, Parameter> META = new ProcessorMeta<ColumnRenamer, Parameter>(){

        @Override
        public String getName() {
            return "ColumnRenamer";
        }

        @Override
        public String getDocPage() {
            return "column-rename";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ColumnRenamer.HELP", "Rename one or more columns.\nTo rename columns in bulk, edit renamings in *Raw text edit*. Separate each column and its new name by a horizontal tab.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ColumnRenamer.DESCRIPTION", 1.actionVerb("Rename") + " columns"), false);
        }

        @Override
        public Object selfReport(Parameter p) {
            JsonObject out = new JsonObject();
            out.addProperty("nbRenamings", (Number)p.renamings.size());
            return out;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL);
        }

        @Override
        public ColumnRenamer build(Parameter parameter) {
            return new ColumnRenamer(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.transform.ColumnRenamerNS";
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Parameter renamingParam = (Parameter)pss.params;
                Set<String> inputColumns = previousDatasetPairLineage.getOutputColumns();
                for (FindReplace.Substitution renaming : renamingParam.renamings) {
                    if (!inputColumns.contains(renaming.from) || Objects.equals(renaming.from, renaming.to)) continue;
                    updatedDatasetPairLineage.removeRelationsOnColumn(renaming.to);
                    updatedDatasetPairLineage.addFactorizedColumnRelations(renaming.from, renaming.to);
                    updatedDatasetPairLineage.removeRelationsOnColumn(renaming.from);
                    inputColumns.add(renaming.to);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final Parameter parameter;
    private List<Column> inCD = new ArrayList<Column>();
    private List<Column> outCD = new ArrayList<Column>();
    private Set<String> columnsToDelete = new HashSet<String>();

    public ColumnRenamer(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        for (FindReplace.Substitution subst : this.parameter.renamings) {
            if (StringUtils.isBlank((String)subst.from)) {
                throw ErrorContext.iae((String)"Invalid column renaming: missing source column name");
            }
            if (StringUtils.isBlank((String)subst.to)) {
                throw ErrorContext.iae((String)"Invalid column renaming: missing target column name");
            }
            this.inCD.add(this.getColumnFactory().column(subst.from, Processor.ProcessorRole.INPUT_COLUMN));
            this.outCD.add(this.getColumnFactory().columnAfter(subst.from, subst.to, Processor.ProcessorRole.OUTPUT_COLUMN));
            this.columnsToDelete.add(subst.from);
            this.columnsToDelete.remove(subst.to);
        }
    }

    public void processRow(Row row) {
        for (int i = 0; i < this.parameter.renamings.size(); ++i) {
            if (this.inCD.get(i) == this.outCD.get(i)) continue;
            String inVal = row.get(this.inCD.get(i));
            if (inVal != null) {
                row.put(this.outCD.get(i), inVal);
            }
            row.delete(this.inCD.get(i));
        }
    }

    public void postProcess() {
        this.columnsToDelete.forEach(columnToDelete -> this.getColumnFactory().deleteColumn(columnToDelete));
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public List<FindReplace.Substitution> renamings = new ArrayList<FindReplace.Substitution>();

        public void validate() throws IllegalArgumentException {
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter params;

        private SQLTranslator(Parameter params) {
            this.params = params;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            ArrayList<String> allNames = new ArrayList<String>();
            for (FindReplace.Substitution subst : this.params.renamings) {
                if (StringUtils.isBlank((String)subst.from)) {
                    throw new IllegalArgumentException("Invalid column renaming: missing source column name");
                }
                if (StringUtils.isBlank((String)subst.to)) {
                    throw new IllegalArgumentException("Invalid column renaming: missing target column name");
                }
                allNames.add(subst.from);
                allNames.add(subst.to);
            }
            if (chain.isAnyCreatedOrModifiedByCurrentQuery(allNames)) {
                chain = chain.makeSubquery();
            }
            ArrayList renamingsFromEnd = Lists.newArrayList(this.params.renamings);
            Collections.reverse(renamingsFromEnd);
            HashMap fromTo = Maps.newHashMap();
            for (FindReplace.Substitution subst : renamingsFromEnd) {
                if (StringUtils.equals((String)subst.from, (String)subst.to)) continue;
                fromTo.put(subst.from, fromTo.getOrDefault(subst.to, subst.to));
            }
            HashMap effectiveRenames = Maps.newHashMap();
            for (FindReplace.Substitution subst : this.params.renamings) {
                if (StringUtils.equals((String)subst.from, (String)subst.to)) continue;
                String to = fromTo.getOrDefault(subst.to, subst.to);
                SchemaColumn targetColumn = chain.getCurrentColumn(to);
                if (effectiveRenames.containsKey(subst.from)) {
                    if (targetColumn != null) continue;
                    chain.select(new ExpressionBuilder.ExpressionBuilderFactory().nullValue(Type.STRING, 1000).castToString(1000), subst.to);
                    chain.addColumn(new SchemaColumn(subst.to, Type.STRING));
                    continue;
                }
                effectiveRenames.put(subst.from, subst.to);
                Optional<SchemaColumn> inputColumn = chain.getInputColumn(subst.from);
                if (inputColumn.isPresent()) {
                    if (targetColumn == null) {
                        SchemaColumn inCol = (SchemaColumn)JSON.deepCopy((Object)((SchemaColumn)inputColumn.get()));
                        chain.replaceSelect(subst.from, chain.col(subst.from), to);
                        inCol.setName(to);
                        chain.replaceColumn(subst.from, inCol);
                        continue;
                    }
                    if (StringUtils.equals((String)targetColumn.getName(), (String)((SchemaColumn)inputColumn.get()).getName())) continue;
                    SchemaColumn merged = chain.getMandatoryCurrentColumn(to);
                    chain.coalesceAndCastSelect(to, chain.col(subst.from), to, merged.getType(), merged.getMaxLength());
                    chain.deleteColumn(subst.from);
                    chain.deleteSelect(subst.from);
                    continue;
                }
                if (targetColumn != null) continue;
                chain.select(new ExpressionBuilder.ExpressionBuilderFactory().nullValue(Type.STRING, 1000).castToString(1000), subst.to);
                chain.addColumn(new SchemaColumn(subst.to, Type.STRING));
            }
            return chain;
        }
    }
}

