/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.JSON;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;

public class JSONFlattener
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<JSONFlattener, Parameter> META = new ProcessorMeta<JSONFlattener, Parameter>(){

        @Override
        public String getName() {
            return "JSONFlattener";
        }

        @Override
        public String getDocPage() {
            return "object-unnest-json";
        }

        @Override
        public Category getCategory() {
            return Category.WEB;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING, ProcessorTag.SPLIT, ProcessorTag.COMPLEX});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.JSONFlattener.HELP", "Unnest, or flatten, JSON objects or arrays. By default, arrays are kept untouched. \n\n# Example\n\nThe following JSON, *jsoncol = {\"firstname\": \"a\", \"lastname\": \"b\", \"details\": { \"uid\": 237, \"comment\": \" a comment\"}*,  unnested to 1 level of depth yields: \n\n* *jsoncol_firstname = a*\n\n* *jsoncol_lastname = b*\n\n* *jsoncol_details = {\"uid\": 237, \u201ccomment\u201d: \u201ca comment\u201d}*\n\n# Options\n\n**Input column**\n\nColumn containing a JSON object or array.\n\n**Maximum depth**\n\nLimit the depth at which the processor stops unnesting the JSON object or array. \n\n**Flatten arrays** \n\nBy default, this processor does not flatten arrays when unnesting JSON. If the column contains a JSON array nested *within* a JSON object, the JSON array will be preserved as a single column. If the column contains a JSON array at the top level, the processor will do nothing. \n\n<u>*Note:*</u> \n   Be aware that unnesting large arrays by selecting this option can lead to high memory and CPU consumption. \n\n**Convert null to empty cell**\n\nConvert a null value in a JSON property \u2014 flattened as a cell with the string \"null\" in it \u2014 to an empty cell. \n\n**Prefix output columns**\n\nPrefix output column names with the input column name.\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.JSONFlattener.DESCRIPTION", 1.actionVerb("Unnest") + " object (flatten JSON)"), true).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.INPUT_COLUMN", "Input column")).withParam(ParamDesc.intP("maxDepth", this.translate(language, "SHAKER.PROCESSOR.JSONFlattener.DESCRIPTION.MAX_DEPTH", "Maximum depth"), "Maximum depth", 10).withMandatory(true)).withParam(ParamDesc.booleanP("flattenArrays", this.translate(language, "SHAKER.PROCESSOR.JSONFlattener.DESCRIPTION.FLATTEN_ARRAYS", "Flatten arrays")).withMandatory(false)).withParam(ParamDesc.booleanP("nullAsEmpty", this.translate(language, "SHAKER.PROCESSOR.JSONFlattener.DESCRIPTION.NULL_AS_EMPTY", "Convert null to empty cell")).withMandatory(false)).withParam(ParamDesc.booleanP("prefixOutputs", this.translate(language, "SHAKER.PROCESSOR.JSONFlattener.DESCRIPTION.PREFIX_OUTPUTS", "Prefix output columns")).withMandatory(false)).withParam(ParamDesc.string("separator", this.translate(language, "SHAKER.PROCESSOR.JSONFlattener.DESCRIPTION.SEPARATOR", "Separator"), "Separator between hierarchical levels in output column names", "_").withMandatory(false));
        }

        @Override
        public Object selfReport(Parameter p) {
            return JSON.deepCopyExcept((Object)p, (String[])new String[]{"inCol"});
        }

        @Override
        public JSONFlattener build(Parameter parameter) {
            return new JSONFlattener(parameter);
        }
    };
    private Parameter params;
    private ObjectMapper mapper;
    private Column inCol;
    private String previouslyWroteColumn;

    public JSONFlattener(Parameter params) {
        this.params = params;
        this.mapper = new ObjectMapper();
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public void init() throws Exception {
        this.inCol = this.getColumnFactory().column(this.params.inCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.previouslyWroteColumn = this.params.inCol;
    }

    private void flatten(Row row, JsonNode node, String path, int depth) throws JsonProcessingException {
        block8: {
            String prefix;
            block10: {
                String separator;
                block9: {
                    block7: {
                        String string = separator = this.params.separator == null ? "" : this.params.separator;
                        if (!node.isValueNode()) break block7;
                        Column col = this.getColumnFactory().columnAfter(this.previouslyWroteColumn, path, Processor.ProcessorRole.OUTPUT_COLUMN);
                        if (this.params.nullAsEmpty && node.isNull()) {
                            row.put(col, null);
                        } else {
                            row.put(col, node.asText());
                        }
                        this.previouslyWroteColumn = path;
                        break block8;
                    }
                    if (depth != this.params.maxDepth) break block9;
                    Column col = this.getColumnFactory().columnAfter(this.previouslyWroteColumn, path, Processor.ProcessorRole.OUTPUT_COLUMN);
                    row.put(col, this.mapper.writeValueAsString((Object)node));
                    this.previouslyWroteColumn = path;
                    break block8;
                }
                prefix = path + ("".equals(path) ? "" : separator);
                if (!node.isArray()) break block10;
                if (this.params.flattenArrays) {
                    for (int i = 0; i < node.size(); ++i) {
                        if (i > 0) {
                            this.getColumnFactory().columnAfter(prefix + (i - 1), prefix + i, Processor.ProcessorRole.OUTPUT_COLUMN);
                        }
                        this.flatten(row, node.get(i), prefix + i, depth + 1);
                    }
                } else {
                    Column col = this.getColumnFactory().column(path, Processor.ProcessorRole.OUTPUT_COLUMN);
                    row.put(col, this.mapper.writeValueAsString((Object)node));
                }
                break block8;
            }
            if (!node.isObject()) break block8;
            Iterator fields = node.fieldNames();
            while (fields.hasNext()) {
                String name = (String)fields.next();
                this.flatten(row, node.get(name), prefix + name, depth + 1);
            }
        }
    }

    public void processRow(Row row) throws Exception {
        String val = row.get(this.inCol);
        if (val != null && !val.isEmpty()) {
            try {
                JsonNode node = this.mapper.readTree(val);
                this.flatten(row, node, this.params.prefixOutputs ? this.params.inCol : "", 0);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String inCol;
        int maxDepth;
        boolean flattenArrays = false;
        boolean prefixOutputs = true;
        String separator = "_";
        boolean nullAsEmpty = true;

        public void validate() throws IllegalArgumentException {
        }
    }
}

