/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import java.util.Set;

public class TypeSetter
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<TypeSetter, Parameter> META = new ProcessorMeta<TypeSetter, Parameter>(){

        @Override
        public String getName() {
            return "TypeSetter";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.TypeSetter.HELP", "This processor forces the meaning of a column to one of the supported DSS data meanings.\n\nThis overrides the auto-detection of the meaning by DSS.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.TypeSetter.DESCRIPTION", "Change column data meaning"), false).doNotDisplayInLibrary();
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return JSON.deepCopyExcept((Object)parameter, (String[])new String[]{"column"});
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            return previousRecipeLineage;
        }

        @Override
        public TypeSetter build(Parameter parameter) {
            String dataTypeName = "com.dataiku.dip.shaker.types." + parameter.type;
            try {
                MeaningDetector dataType = (MeaningDetector)Class.forName(dataTypeName).newInstance();
                return new TypeSetter(parameter.column, dataType);
            }
            catch (Exception e) {
                throw ErrorContext.iae((String)("Failed to load " + dataTypeName), (Exception)e);
            }
        }
    };
    private final String column;
    private final MeaningDetector type;
    private Column col;

    public TypeSetter(String column, MeaningDetector type) {
        this.column = column;
        this.type = type;
    }

    public void init() {
    }

    public void processRow(Row row) throws Exception {
        if (this.col == null) {
            this.col = this.getCf().column(this.column, Processor.ProcessorRole.INPUT_COLUMN);
            if (this.col instanceof MemColumn) {
                ((MemColumn)this.col).forceType(this.type);
            }
        }
        this.getProcessorOutput().emitRow(row);
    }

    public void postProcess() throws Exception {
        this.getProcessorOutput().lastRowEmitted();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;
        public String type;

        public void validate() throws IllegalArgumentException {
        }
    }
}

