/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.udf.AbstractPythonUDF;
import com.dataiku.dip.shaker.processors.udf.ImpersonablePythonUDFKernel;
import com.dataiku.dip.shaker.processors.udf.MetaWithRemoteCodeEnv;
import com.dataiku.dip.shaker.processors.udf.PythonParameter;
import com.dataiku.dip.shaker.processors.udf.PythonUDFModeHandler;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.python.util.PythonInterpreter;

public class PythonUDF
extends AbstractPythonUDF {
    public static final ProcessorMeta<PythonUDF, PythonParameter> META = new PythonUDFMeta(){

        @Override
        public String getName() {
            return "PythonUDF";
        }

        @Override
        public String getDocPage() {
            return "python-custom";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CUSTOM});
        }

        @Override
        public Class<PythonParameter> stepParamClass() {
            return PythonParameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.PythonUDF.HELP", "Execute a custom Python function for each row and easily perform complex computations in a Prepare script.\n\n# Options\n\n**Mode**\n\nSelect one of three modes for the Python function to run. Each option creates a block of starter code to edit with custom logic. You can choose between non-vectorized or vectorized processing if you use a real Python process.\n* Cell: produce a new cell for each row.\n\t* Non-vectorized: The function receives the data for a row, and must return a single value for each row which is used as the value of the output column.\n\t* Vectorized: The function receives the input batch of rows as a pandas Dataframe, and must return a pandas Series of the same number of records, which will be used as the values of the output column.\n* Row: return a row for each row.\n\t* Non-vectorized: The function receives the data for a row as a Python dict, and can modify in place all the values of the row. The function returns a Python dictionary. All columns and values of the input rows are replaced by the keys and values of the dictionary.\n\t* Vectorized: The function receives the input batch of rows as a pandas Dataframe, and must return a pandas Dataframe of the same number of records, which will be used as the values of the output batch of rows (of the same length).\n* Rows: produce a list of rows for each row.\n\t* Non-vectorized: The function receives the data for a row, and can output an arbitrary number of output rows. The function returns an iterable list of rows. The input row is deleted and replaced by all rows returned by the function (so you can have 1 \u2192 N processing).\n\t* Vectorized: The function receives the input batch of rows as a pandas Dataframe, and must return an indexed dictionary of vectors, either built by modifying the \u2018rows\u2019 or by returning a pandas DataFrame.\n\n**Error Column**\nCreate a new column that will be filled with any error messages raised from the Python code.\n\n**Stop on first error**\nStops the processor execution if an error is raised.\n\n**Pass data as unicode**\nRead data as unicode.\n\n**Use a real Python process (instead of Jython)**\n\nChange to Python instead of Jython, a reimplementation of Python in Java, and allow vectorized operation to process rows in batches using the Pandas library.\n* Selection behavior: Choose an environment: Use DSS builtin env, Inherit project default or Select an environment.\n* Used input columns: Add one or more columns to use as input for faster processing.\n* Vectorized processing: When selected the input will change from a python dict to a Pandas Dataframe. This provides much improved performance and is strongly recommended when using a real Python process. Operates based on the Cell, Row and Rows options above using Pandas dataframes.\n\n# Note\nThe Python function is executed by Jython, which supports only Python 2 and for which only the standard Python library is available. To use Python libraries, use the real Python process or a separate Python recipe. When using the real Python process, you can use all normal Python packages and the code defined in <a target=\"_blank\" href=\"https://doc.dataiku.com/dss/latest/python/reusing-code.html\">libraries</a>.\n\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.PythonUDF.DESCRIPTION", "Python function")).withParam(ParamDesc.string("mode", this.translate(language, "SHAKER.PROCESSOR.PythonUDF.DESCRIPTION.MODE", "XX"), "XX", "CELL")).withBoolDefaultTrue("stopOnError", this.translate(language, "SHAKER.PROCESSOR.PythonUDF.DESCRIPTION.STOP_ON_ERROR", "Stop On First Error"), "Stop on First Error").withBoolDefaultTrue("usePythonUnicode", this.translate(language, "SHAKER.PROCESSOR.PythonUDF.DESCRIPTION.USE_PYTHON_UNICODE", "Pass cells as unicode"), "Needed if cell values use characters outside the ASCII range").withBoolDefaultTrue("useKernel", this.translate(language, "SHAKER.PROCESSOR.PythonUDF.DESCRIPTION.USE_KERNEL", "Use Python kernel"), "Run UDF in a python process instead of jython").withBoolDefaultTrue("vectorize", this.translate(language, "SHAKER.PROCESSOR.PythonUDF.DESCRIPTION.VECTORIZE", "Vectorize"), "Communicate to python kernel via vectors of values instead of values for a single row at a time").withParam("vectorSize", "int", false, false, this.translate(language, "SHAKER.PROCESSOR.PythonUDF.DESCRIPTION.VECTOR_SIZE", "Vector size")).withParam("sourceColumns", "columns", false, true, this.translate(language, "SHAKER.PROCESSOR.PythonUDF.DESCRIPTION.SOURCE_COLUMNS", "Source columns"));
        }

        @Override
        public Object selfReport(PythonParameter p) {
            JsonObject out = new JsonObject();
            out.addProperty("stopOnError", Boolean.valueOf(p.stopOnError));
            out.addProperty("usePythonUnicode", Boolean.valueOf(p.usePythonUnicode));
            out.addProperty("mode", p.mode.name());
            return out;
        }

        @Override
        public PythonUDF build(PythonParameter parameter) throws Exception {
            return new PythonUDF(this, parameter, parameter.mode.build(parameter));
        }

        @Override
        public StepParams expandParams(StepParams params, VariablesContext vc) {
            PythonParameter pythonParams = (PythonParameter)params;
            Map variables = vc.getAllVariables();
            pythonParams.variablesDefinition.putAll(variables);
            return pythonParams;
        }

        @Override
        public CodeEnvModel.EnvLang getEnvLang() {
            return CodeEnvModel.EnvLang.PYTHON;
        }
    };
    protected final PythonParameter parameter;

    public PythonUDF(PythonUDFMeta meta, PythonParameter parameter, PythonUDFModeHandler modeHandler) {
        super(meta, parameter.usePythonUnicode, parameter.stopOnError, parameter.useKernel, parameter.sourceColumnsPattern, parameter.sourceColumnsList, parameter.vectorize, parameter.vectorSize, parameter.variablesDefinition, parameter.mode.entryPointName(), modeHandler);
        this.parameter = parameter;
    }

    @Override
    public String getPythonSourceCode() {
        return this.parameter.pythonSourceCode;
    }

    @Override
    public String getCodeEnvName(MetaWithRemoteCodeEnv meta, String projectKey) throws IOException {
        return this.parameter.getCodeEnvName(meta, projectKey);
    }

    @Override
    public void initInterpreter(PythonInterpreter interpreter) {
    }

    @Override
    public void initKernel(ImpersonablePythonUDFKernel.PythonCommand command) {
    }

    public static abstract class PythonUDFMeta
    extends ProcessorMeta<PythonUDF, PythonParameter>
    implements MetaWithSelectableCodeEnv,
    MetaWithRemoteCodeEnv {
    }
}

